/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.attributeImportance;

import java.awt.Dimension;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;
import javax.datamining.attributeimportance.AttributeImportanceModel;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.LocalXMLDataSource;
import oracle.dmt.dm4j.browser.table.Dm4jSortableTwoDModel;
import oracle.dss.graph.Graph;
import oracle.dss.graph.O1TickLabel;
import oracle.dss.util.DataSource;

public class RankTableModel
extends Dm4jSortableTwoDModel {
    private String[] m_attributes = null;
    private double[] m_importances = null;
    private int m_attrCount = 100;
    public static String ATTRIBUTE_NAME = "ATTRIBUTE_NAME";
    public static String ATTRIBUTE_RANK = "ATTRIBUTE_RANK";
    public static String ATTRIBUTE_IMPORTANCE_VALUE = "ATTRIBUTE_IMPORTANCE_VALUE";
    private static String AIMODELDETAILTBLPREFIX = "DM$P9";
    private static String QUERY_AI_DETAIL_START_11G = "SELECT nvl2(attribute_subname,  attribute_name || '.' || attribute_subname, attribute_name) attribute_name, ";
    private static String QUERY_AI_DETAIL_START = "SELECT attribute_name, ";
    private static String QUERY_AI_DETAIL_END = "ATTRIBUTE_IMPORTANCE_VALUE, ATTRIBUTE_RANK from {0} where rownum <= {1} order by {2} {3}";

    private static String getQueryStart() {
        return BrowserFrame.is11Server() ? QUERY_AI_DETAIL_START_11G : QUERY_AI_DETAIL_START;
    }

    public void load(Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Object object, String string, boolean bl, Graph graph, int n) {
        AttributeImportanceModel attributeImportanceModel = (AttributeImportanceModel)object;
        String string2 = AIMODELDETAILTBLPREFIX + attributeImportanceModel.getName();
        this.m_attrCount = n;
        int n2 = this.getRowCount();
        if (n2 > 0) {
            this.removeRows(0, n2);
            this.removeColumns(0, 3);
        }
        this.addRows(0, n);
        this.addColumns(0, 3);
        StringBuffer stringBuffer = new StringBuffer(RankTableModel.getQueryStart());
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            Object[] objectArray = new Object[]{string2, this.m_attrCount + "", string, bl ? "asc" : "desc"};
            stringBuffer.append(MessageFormat.format(QUERY_AI_DETAIL_END, objectArray));
            connection = DM4JConnectionManager.getDbConnection();
            statement = connection.prepareStatement(stringBuffer.toString());
            resultSet = statement.executeQuery();
            n2 = 0;
            int n3 = 0;
            String[] stringArray = null;
            double[] dArray = null;
            stringArray = new String[this.m_attrCount];
            dArray = new double[this.m_attrCount];
            while (resultSet.next()) {
                String string3 = resultSet.getString(ATTRIBUTE_NAME);
                int n4 = resultSet.getInt(ATTRIBUTE_RANK);
                double d = resultSet.getDouble(ATTRIBUTE_IMPORTANCE_VALUE);
                stringArray[n2] = string3;
                dArray[n2] = d;
                n3 = 0;
                this.setData(n3++, n2, string3);
                this.setData(n3++, n2, new Integer(n4));
                this.setData(n3++, n2, new Double(d));
                ++n2;
            }
            if (n2 < n) {
                this.removeRows(n2, n - n2);
            }
            this.m_attributes = new String[n2];
            this.m_importances = new double[n2];
            System.arraycopy(stringArray, 0, this.m_attributes, 0, n2);
            System.arraycopy(dArray, 0, this.m_importances, 0, n2);
            this.loadGraph(graph, this.m_attributes, this.m_importances);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void loadGraph(Graph graph, String[] stringArray, double[] dArray) throws Exception {
        if (graph != null) {
            int n;
            Object[][] objectArray = null;
            Object[] objectArray2 = null;
            Object[] objectArray3 = null;
            int n2 = stringArray.length;
            objectArray = new Object[n2][1];
            objectArray2 = new Object[n2];
            objectArray3 = new Object[]{DM4JResourceUtilities.getUIString("AI_RANK_ATTR_IMPORTANCE")};
            for (n = 0; n < n2; ++n) {
                objectArray2[n] = stringArray[n] + "";
                objectArray[n][0] = new Double(dArray[n]);
            }
            graph.getTitle().setVisible(false);
            graph.getO1Title().setText(DM4JResourceUtilities.getUIString("AI_RANK_ATTR_NAME"));
            graph.getY1Title().setText(DM4JResourceUtilities.getUIString("AI_RANK_ATTR_IMPORTANCE"));
            graph.getPFJ().setDisplay(graph.getPFJ().getLegendArea(), false);
            graph.setScrollbarPresenceGroups(1);
            graph.setDataRowShownAsASeries(true);
            graph.setDataSource((DataSource)new LocalXMLDataSource(objectArray2, objectArray3, objectArray));
            graph.setAutoLayout(1);
            O1TickLabel o1TickLabel = graph.getO1TickLabel();
            o1TickLabel.setTickLabelSkipMode(0);
            n = 800;
            int n3 = 400;
            if (stringArray.length * 15 > 400) {
                n3 = stringArray.length * 15;
                n = 1100;
                graph.setFitToContainer(false);
                graph.setImageSize(new Dimension(n, n3));
            } else {
                graph.setFitToContainer(true);
                graph.setImageSize(new Dimension(n, n3));
            }
            graph.setVisible(true);
        }
    }
}

