/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.attributeImportance;

import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.datamining.attributeimportance.AttributeImportanceModel;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.viewer.attributeImportance.RankTableModel;
import oracle.dmt.dm4j.browser.worker.LoadAIAttributesWorker;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.browser.worker.listener.AIAttributesLoadedListener;
import oracle.dss.graph.Graph;

public final class RankTable
extends Dm4jSpreadTable
implements AIAttributesLoadedListener {
    int[] m_colSortOrders = null;
    int m_curSortCol;
    String[] m_columnNames = new String[]{DM4JResourceUtilities.getUIString("AI_RANK_ATTR_NAME"), DM4JResourceUtilities.getUIString("AI_RANK_ATTR_RANK"), DM4JResourceUtilities.getUIString("AI_RANK_ATTR_IMPORTANCE")};
    String[] m_sortColumns = new String[]{RankTableModel.ATTRIBUTE_NAME, RankTableModel.ATTRIBUTE_RANK, RankTableModel.ATTRIBUTE_IMPORTANCE_VALUE};
    int[] m_colWidths = new int[]{50, 25, 25};
    RankTableModel m_tableModel;
    Graph m_histogram;
    int m_attrCount;

    public RankTable(Object object) {
        super(object);
        this.setColumnNames(this.m_columnNames);
        Grid grid = this.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 1, 0);
        grid.setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
        try {
            this.displayLoadingStatus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_colSortOrders = new int[this.m_columnNames.length];
        this.m_colSortOrders[0] = 0;
        this.m_colSortOrders[1] = 0;
        this.m_colSortOrders[2] = 2;
        this.m_curSortCol = 2;
    }

    public void load(Graph graph, int n) throws Exception {
        this.load(this.m_sortColumns[this.m_curSortCol], this.m_colSortOrders[this.m_curSortCol] == 1, graph, n);
    }

    public void displayLoadingStatus() throws Exception {
        super.displayLoadingStatus();
    }

    public void load(String string, boolean bl, Graph graph, int n) throws Exception {
        this.displayLoadingStatus();
        this.setColumnWidths(this.m_colWidths, true);
        this.m_histogram = graph;
        this.m_attrCount = n;
        AttributeImportanceModel attributeImportanceModel = (AttributeImportanceModel)this.getDataItem();
        if (null == attributeImportanceModel) {
            throw new Exception("Cannot load data. MiningModel not supplied");
        }
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        LoadAIAttributesWorker loadAIAttributesWorker = (LoadAIAttributesWorker)workerThreadManager.getLoadAIAttributesWorker(attributeImportanceModel, string, bl, graph, n);
        loadAIAttributesWorker.addAIAttributesLoadedListener(this);
        loadAIAttributesWorker.start();
    }

    public void attributesLoaded(EventObject eventObject) {
        this.setVerticalSeparatorsVisible(true);
        this.m_tableModel = (RankTableModel)((Object)eventObject.getSource());
        this.setModels((TwoDModel)this.m_tableModel, this.getColModel(), null);
        Header header = this.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setItemInputHandler((HeaderItemInputHandler)new SortHandler(this));
        header.setCanMoveItems(false);
        try {
            this.setColumnWidths(this.m_colWidths, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Grid grid = this.getGrid();
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance(false, 10, 10));
        grid.setColumnPainter(2, (Painter)dM4JTruncatingNumberFormatPainter);
    }

    private class SortHandler
    implements HeaderItemInputHandler {
        RankTable m_rankTable = null;

        public SortHandler(RankTable rankTable2) {
            this.m_rankTable = rankTable2;
        }

        public void mousePressed(MouseEvent mouseEvent, Header header, int n) {
            int n2 = n;
            try {
                int n3 = RankTable.this.m_colSortOrders[n2];
                if (n3 == -1) {
                    return;
                }
                if (n3 == 0) {
                    n3 = RankTable.this.m_colSortOrders[RankTable.this.m_curSortCol] == 1 ? 2 : 1;
                } else if (n3 == 1) {
                    n3 = 2;
                } else if (n3 == 2) {
                    n3 = 1;
                }
                RankTable.this.m_colSortOrders[n2] = n3;
                RankTable.this.m_curSortCol = n2;
                RankTable.this.load(RankTable.this.m_sortColumns[n2], n3 == 1, RankTable.this.m_histogram, RankTable.this.m_attrCount);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void mouseClicked(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseDragged(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseEntered(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseExited(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseMoved(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseReleased(MouseEvent mouseEvent, Header header, int n) {
        }
    }
}

