/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.attributeImportance;

import java.awt.EventQueue;
import javax.datamining.MiningObject;
import javax.datamining.attributeimportance.AttributeImportanceModel;
import javax.datamining.resource.Connection;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.BrowseResultsListPanel;
import oracle.dmt.dm4j.browser.viewer.LoadingStatusPanel;
import oracle.dmt.dm4j.browser.viewer.ModelViewer;
import oracle.dmt.dm4j.browser.viewer.attributeImportance.AttributeImportanceRankingPanel;
import oracle.dmt.dm4j.browser.viewer.attributeImportance.AttributeImportanceSettingsPanel;
import oracle.dmt.dm4j.browser.viewer.results.build.BuildTaskPanel;
import oracle.dmt.jdm.jdmresult.OraMiningBuildResult;

public class AttributeImportanceViewer
extends ModelViewer {
    static int SETTING_TAB = 0;
    static int RANK_TAB = 1;
    static int RESULT_TAB = 2;
    static int TASK_TAB = 3;
    int[] m_tabIndex;
    AttributeImportanceSettingsPanel m_attributeImportanceSettingsPanel;
    AttributeImportanceRankingPanel m_attributeImportanceRankingPanel;
    BrowseResultsListPanel m_browseResultsListPanel;
    BuildTaskPanel m_buildTaskPanel;
    OraMiningBuildResult m_buldTask;

    public AttributeImportanceViewer(LeafNodeData leafNodeData, Connection connection, int n) throws Exception {
        super(leafNodeData, connection, n);
        MiningObject miningObject = leafNodeData.getOdmObject();
        this.setMinimumSize(BrowserFrame.m_prefRightPaneSize);
    }

    protected String getHelpId() {
        int n = this.getSelectedIndex();
        GriddedPanel griddedPanel = (GriddedPanel)this.getComponentAt(n);
        return griddedPanel.getHelpId();
    }

    protected void loadViewer(LeafNodeData leafNodeData, int n) throws Exception {
        AttributeImportanceModel attributeImportanceModel = (AttributeImportanceModel)leafNodeData.getOdmObject();
        int n2 = 0;
        this.m_tabIndex = new int[4];
        this.addTab(DM4JResourceUtilities.getUIString("AI_MODEL_RANKING"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("AI_MODEL_RANKING"));
        this.m_tabIndex[n2++] = RANK_TAB;
        this.addTab(DM4JResourceUtilities.getUIString("COMMON_SETTINGS"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("COMMON_SETTINGS"));
        this.m_tabIndex[n2++] = SETTING_TAB;
        this.addTab(DM4JResourceUtilities.getUIString("RESULT_TASK_TAB"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("RESULT_TASK_TAB"));
        this.m_tabIndex[n2++] = TASK_TAB;
        this.showTab(n);
        this.setSelectedIndex(n);
    }

    protected void showTab(int n) {
        Thread thread = new Thread(new LoadTab(n));
        thread.setPriority(5);
        thread.start();
    }

    class LoadTab
    implements Runnable {
        int tabIndex;
        GriddedPanel panel;

        public LoadTab(int n) {
            this.tabIndex = n;
        }

        public void run() {
            try {
                AttributeImportanceModel attributeImportanceModel = (AttributeImportanceModel)AttributeImportanceViewer.this.m_node.getOdmObject();
                this.panel = null;
                if (AttributeImportanceViewer.this.m_tabIndex[this.tabIndex] == SETTING_TAB) {
                    if (AttributeImportanceViewer.this.m_attributeImportanceSettingsPanel == null) {
                        AttributeImportanceViewer.this.m_attributeImportanceSettingsPanel = new AttributeImportanceSettingsPanel(attributeImportanceModel);
                    }
                    this.panel = AttributeImportanceViewer.this.m_attributeImportanceSettingsPanel;
                } else if (AttributeImportanceViewer.this.m_tabIndex[this.tabIndex] == RANK_TAB) {
                    if (AttributeImportanceViewer.this.m_attributeImportanceRankingPanel == null) {
                        AttributeImportanceViewer.this.m_attributeImportanceRankingPanel = new AttributeImportanceRankingPanel(AttributeImportanceViewer.this.m_node);
                    }
                    this.panel = AttributeImportanceViewer.this.m_attributeImportanceRankingPanel;
                } else if (AttributeImportanceViewer.this.m_tabIndex[this.tabIndex] == TASK_TAB) {
                    if (AttributeImportanceViewer.this.m_buildTaskPanel == null) {
                        AttributeImportanceViewer.this.m_buildTaskPanel = new BuildTaskPanel(attributeImportanceModel.getName());
                    }
                    this.panel = AttributeImportanceViewer.this.m_buildTaskPanel;
                }
                Runnable runnable = new Runnable(){

                    public void run() {
                        AttributeImportanceViewer.this.setComponentAt(LoadTab.this.tabIndex, LoadTab.this.panel);
                    }
                };
                EventQueue.invokeLater(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

