/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.attributeImportance;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.datamining.attributeimportance.AttributeImportanceModel;
import javax.datamining.attributeimportance.AttributeImportanceSettings;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.AttributeTable;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.viewer.attributeImportance.AttributeImportanceViewer;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.jdm.base.OraBuildSettings;

public class AttributeImportanceSettingsPanel
extends GriddedPanel {
    JLabel m_modelType = new JLabel();
    JLabel m_targetAttr = new JLabel();
    JLabel m_algorithm = new JLabel();
    JLabel m_automaticDataPreparation = new JLabel();
    JScrollPane m_attribPanel = new JScrollPane();
    AttributeTable m_attribTable = null;
    AttributeImportanceSettings m_settings = null;
    AttributeImportanceModel m_model = null;

    public AttributeImportanceSettingsPanel(AttributeImportanceModel attributeImportanceModel) {
        this.m_model = attributeImportanceModel;
        this.m_settings = (AttributeImportanceSettings)this.m_model.getBuildSettings();
        try {
            this.jbInit();
            this.runTimePanelLoad();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        Container container = this.getParent();
        if (container instanceof AttributeImportanceViewer) {
            return "ATTRIBUTE_IMPORTANCE_MODEL";
        }
        return "ATTRIBUTE_IMPORTANCE_SETTING";
    }

    private void jbInit() throws Exception {
        JLabel jLabel;
        int n = 0;
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(DM4JResourceUtilities.getUIString("COMMON_TYPE"));
        this.m_modelType.setText(DM4JResourceUtilities.getUIString("AI_SETTING_AI"));
        this.addComponent(jLabel2, TOPLABELITEMINSETS, n, 0);
        this.addComponent(this.m_modelType, TOPVALUEITEMINSETS, n++, 1);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(DM4JResourceUtilities.getUIString("AI_SETTING_ALGORITHM"));
        this.addComponent(jLabel3, MIDLABELITEMINSETS, n, 0);
        this.addComponent(this.m_algorithm, MIDVALUEITEMINSETS, n++, 1);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(DM4JResourceUtilities.getUIString("COMMON_TARGET"));
        this.addComponent(jLabel4, MIDLABELITEMINSETS, n, 0);
        this.addComponent(this.m_targetAttr, MIDVALUEITEMINSETS, n++, 1);
        if (BrowserFrame.is11Server()) {
            jLabel = new JLabel();
            jLabel.setText(DM4JResourceUtilities.getUIString("AUTOMATIC_DATA_PREPARATION"));
            this.addComponent(jLabel, MIDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_automaticDataPreparation, MIDVALUEITEMINSETS, n++, 1);
        }
        jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("COMMON_ATTRIBUTES"));
        jLabel.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_ATTRIBUTES"));
        this.addAnchoredComponent(jLabel, TOPLABELITEMINSETS, n, 0, 1, 1, 16);
        this.m_attribTable = new AttributeTable(this.m_model);
        JButton jButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        jButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        this.addAnchoredComponent(jButton, MIDLABELITEMINSETS, n++, 1, 1, 1, 14);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                    ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
                    if (!exportDialog.isCancelled()) {
                        exportDialog.export(AttributeImportanceSettingsPanel.this.m_attribTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.m_attribPanel.getViewport().add((Component)((Object)this.m_attribTable));
        jLabel.setLabelFor((Component)((Object)this.m_attribTable));
        this.m_attribPanel.setPreferredSize(null);
        this.addFilledComponent(this.m_attribPanel, MIDLABELITEMINSETS, n, 0, 2, 2, 1);
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
        this.m_attribTable.getGrid().setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
        Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(this.m_attribTable);
    }

    private void runTimePanelLoad() throws Exception {
        this.m_attribTable.load();
        if (BrowserFrame.is11Server()) {
            String string = ((OraBuildSettings)((Object)this.m_settings)).useAutomatedDataPreparations() ? DM4JResourceUtilities.getUIString("COMMON_YES") : DM4JResourceUtilities.getUIString("COMMON_NO");
            this.m_automaticDataPreparation.setText(string);
        }
        this.m_algorithm.setText(this.m_settings.getAlgorithmSettings().getMiningAlgorithm().name());
        this.m_targetAttr.setText(this.m_settings.getTargetAttributeName());
    }
}

