/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.association;

import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.datamining.association.AssociationModel;
import javax.datamining.association.AssociationRule;
import javax.datamining.association.RuleProperty;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.viewer.association.RulesTableModel;
import oracle.dmt.dm4j.browser.worker.LoadAssocRulesWorker;
import oracle.dmt.dm4j.browser.worker.SortAssocRulesWorker;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.browser.worker.listener.AssocRulesLoadedListener;

public final class RulesTable
extends Dm4jSpreadTable
implements AssocRulesLoadedListener {
    int m_rows = 100;
    Double m_minSupport;
    Double m_minConfidence;
    String _realAttributeName;
    int[] m_colSortOrders = null;
    int m_curSortOrder = 2;
    String[] m_columnNames = new String[]{DM4JResourceUtilities.getUIString("ASSOC_RULE_RULE_ID"), DM4JResourceUtilities.getUIString("ASSOC_RULE_IF_STMT"), DM4JResourceUtilities.getUIString("ASSOC_RULE_THEN_STMT"), DM4JResourceUtilities.getUIString("COMMON_RULES_CONFIDENCE"), DM4JResourceUtilities.getUIString("COMMON_RULES_SUPPORT")};
    int[] m_colWidths = new int[]{10, 35, 27, 14, 14};
    RulesTableModel m_tableModel;
    String[] m_betweenAttrs = null;
    String[] m_andAttrs = null;

    public RulesTable(Object object) {
        super(object);
        this.setColumnNames(this.m_columnNames);
        Grid grid = this.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 1, 0);
        grid.setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
        this.m_colSortOrders = new int[this.m_columnNames.length];
        this.m_colSortOrders[0] = 0;
        this.m_colSortOrders[1] = 0;
        this.m_colSortOrders[2] = 0;
        this.m_colSortOrders[3] = 0;
        this.m_colSortOrders[4] = 0;
    }

    public void load() throws Exception {
        this.load(this.m_rows, null, null, null);
    }

    public void load(int n, String[] stringArray, String[] stringArray2, String string) throws Exception {
        this.m_colSortOrders[3] = this.m_curSortOrder;
        this._realAttributeName = string;
        this.load(n, stringArray, stringArray2, 3, this.m_curSortOrder == 1, string);
    }

    public void displayLoadingStatus() throws Exception {
        super.displayLoadingStatus();
    }

    private void displaySortingStatus() throws Exception {
        if (null == this.getColModel()) {
            throw new Exception("call setColumnNames prior to calling displayLoadingStatus");
        }
        SortStatusGridModel sortStatusGridModel = new SortStatusGridModel();
        this.setModels((TwoDModel)sortStatusGridModel, this.getColModel(), null);
        this.setVerticalSeparatorsVisible(false);
    }

    public void setColumnWidths() {
        try {
            this.setColumnWidths(this.m_colWidths, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void load(int n, String[] stringArray, String[] stringArray2, int n2, boolean bl, String string) throws Exception {
        Object object;
        this._realAttributeName = string;
        this.m_rows = n;
        this.m_betweenAttrs = stringArray;
        this.m_andAttrs = stringArray2;
        this.setColumnWidths(this.m_colWidths, true);
        AssociationModel associationModel = (AssociationModel)this.getDataItem();
        if (null == associationModel) {
            throw new Exception("Cannot load data. MiningModel not supplied");
        }
        try {
            object = new TwoDSelection(-1, true);
            this.setSelection((TwoDSelection)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = WorkerThreadManager.getInstance();
        LoadAssocRulesWorker loadAssocRulesWorker = (LoadAssocRulesWorker)((WorkerThreadManager)object).getLoadAssocRulesWorker(associationModel, n, this.m_minSupport, this.m_minConfidence, stringArray, stringArray2, n2, bl, string);
        loadAssocRulesWorker.addAssocRulesLoadedListener(this);
        loadAssocRulesWorker.start();
    }

    public void rulesLoaded(EventObject eventObject) {
        Object object;
        this.setVerticalSeparatorsVisible(true);
        this.m_tableModel = (RulesTableModel)((Object)eventObject.getSource());
        this.setModels((TwoDModel)this.m_tableModel, this.getColModel(), null);
        Header header = this.getColumnHeader();
        header.setEnabled(true);
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setItemInputHandler((HeaderItemInputHandler)new SortHandler(this.m_tableModel));
        header.setCanMoveItems(false);
        try {
            this.setColumnWidths(this.m_colWidths, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.m_tableModel.getRowCount() != 0) {
            object = new TwoDSelection(0, true);
            try {
                this.setSelection((TwoDSelection)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance(false, 4, 4));
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance(false, 4, 4));
        this.getGrid().setColumnPainter(3, (Painter)object);
        this.getGrid().setColumnPainter(4, (Painter)dM4JTruncatingNumberFormatPainter);
    }

    public AssociationRule getMiningRule(int n) {
        return this.m_tableModel.getMiningRule(n);
    }

    public RuleProperty[] getSortCriteria() {
        return this.m_tableModel != null ? this.m_tableModel.getSortCriteria() : null;
    }

    public void sortRules(int n, Double d, Double d2, String[] stringArray, String[] stringArray2, RuleProperty[] rulePropertyArray, Boolean[] booleanArray, String string) {
        if (rulePropertyArray[0].equals(RuleProperty.confidence)) {
            int n2 = 3;
        } else if (rulePropertyArray[0].equals(RuleProperty.support)) {
            int n3 = 4;
        } else {
            int n4 = -1;
        }
        try {
            this._realAttributeName = string;
            this.m_rows = n;
            this.m_betweenAttrs = stringArray;
            this.m_andAttrs = stringArray2;
            this.m_minSupport = d;
            this.m_minConfidence = d2;
            this.setColumnWidths(this.m_colWidths, true);
            AssociationModel associationModel = (AssociationModel)this.getDataItem();
            if (null == associationModel) {
                throw new Exception("Cannot load data. MiningModel not supplied");
            }
            Header header = this.getColumnHeader();
            header.setEnabled(false);
            WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
            SortAssocRulesWorker sortAssocRulesWorker = (SortAssocRulesWorker)workerThreadManager.getSortAssocRulesWorker(associationModel, n, d, d2, stringArray, stringArray2, rulePropertyArray, booleanArray, string);
            sortAssocRulesWorker.addAssocRulesLoadedListener(this);
            sortAssocRulesWorker.start();
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    private class SortHandler
    implements HeaderItemInputHandler {
        public SortHandler(SortableTwoDModel sortableTwoDModel) {
        }

        public void mousePressed(MouseEvent mouseEvent, Header header, int n) {
            try {
                int n2 = RulesTable.this.m_colSortOrders[n];
                if (n2 == -1) {
                    return;
                }
                if (n2 == 0) {
                    n2 = RulesTable.this.m_curSortOrder;
                } else if (n2 == 1) {
                    n2 = 2;
                } else if (n2 == 2) {
                    n2 = 1;
                }
                RulesTable.this.m_colSortOrders[n] = n2;
                RulesTable.this.m_curSortOrder = n2;
                RulesTable.this.displaySortingStatus();
                RulesTable.this.load(RulesTable.this.m_rows, RulesTable.this.m_betweenAttrs, RulesTable.this.m_andAttrs, n, n2 == 1, RulesTable.this._realAttributeName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void mouseClicked(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseDragged(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseEntered(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseExited(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseMoved(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseReleased(MouseEvent mouseEvent, Header header, int n) {
        }
    }

    private class SortStatusGridModel
    extends SortableTwoDModel {
        public SortStatusGridModel() {
            this.addRows(0, 1);
            this.addColumns(0, RulesTable.this.getColModel().getItemCount());
            this.setData(0, 0, new String(DM4JResourceUtilities.getUIString("COMMON_SORTING_PROGRESS")));
        }
    }
}

