/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.association;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.datamining.Enum;
import javax.datamining.JDMException;
import javax.datamining.MiningFunction;
import javax.datamining.SortOrder;
import javax.datamining.association.AssociationModel;
import javax.datamining.association.RuleComponentOption;
import javax.datamining.association.RuleProperty;
import javax.datamining.association.RulesFilter;
import javax.datamining.base.ModelDetail;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.viewer.association.ODMrOraAssociationRule;
import oracle.dmt.dm4j.browser.viewer.association.ODMrOraItemset;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.jdm.base.OraModel;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.transform.binning.OraBinningTransform;
import oracle.dmt.jdm.transform.binning.OraBinningTransformImpl;

public class ODMrOraAssociationModel
extends OraModel
implements AssociationModel {
    private Vector m_itemsets = new Vector();
    private Collection m_rules = null;
    private boolean m_isUnbinning = false;
    private Integer m_maxRuleLength;
    private HashSet m_items = null;
    private int m_numberOfItemsets;
    private double m_minConfidence;
    private double m_maxConfidence;
    private double m_minSupport;
    private double m_maxSupport;
    private Hashtable m_htTransparencyTables;
    private static String QRY_AR_NUM_ITEMSETS = "SELECT count(*) number_of_itemsets FROM TABLE( dbms_data_mining.get_frequent_itemsets(?) )";
    private static String QRY_AR_GET_ITEMSETS = "SELECT t.itemset_id itemset_id, t.support support, t.number_of_items itemset_size, i.column_value item FROM TABLE( dbms_data_mining.get_frequent_itemsets(?) ) t, TABLE(t.items) i ORDER BY support desc, itemset_id asc, column_value asc, number_of_items asc ";
    private static String QRY_AR_GET_ALL_RULES_START = "SELECT t.rule_id rule_id, t.rule_support rule_support, t.rule_confidence rule_confidence, ante.attribute_name ante_attr, ante.conditional_operator ante_op, NVL(ante.attribute_str_value , ante.attribute_num_value ) ante_val, cons.attribute_name cons_attr, cons.conditional_operator cons_op, NVL(cons.attribute_str_value, cons.attribute_num_value) cons_val, ante.attribute_support ante_support, cons.attribute_support cons_support, ante.attribute_confidence ante_conf, cons.attribute_confidence cons_conf, t.number_of_items rule_length ";
    private static String QRY_AR_GET_ALL_RULES_START_11G = "SELECT t.rule_id rule_id, t.rule_support rule_support, t.rule_confidence rule_confidence, concat(ante.attribute_name,concat('.',ante.attribute_subname)) ante_attr, ante.conditional_operator ante_op, NVL(ante.attribute_str_value , ante.attribute_num_value ) ante_val, concat(cons.attribute_name,concat('.',cons.attribute_subname)) cons_attr, cons.conditional_operator cons_op, NVL(cons.attribute_str_value, cons.attribute_num_value) cons_val, ante.attribute_support ante_support, cons.attribute_support cons_support, ante.attribute_confidence ante_conf, cons.attribute_confidence cons_conf, t.number_of_items rule_length ";
    private static String QRY_AR_GET_ALL_RULES_END = "FROM TABLE( dbms_data_mining.get_association_rules({0}) ) t, TABLE(t.antecedent) ante, TABLE(t.consequent) cons ";
    private static String QRY_AR_GET_ALL_RULES_WITH_LOOKUP = "SELECT t.rule_id rule_id, t.rule_support rule_support, t.rule_confidence rule_confidence, NVL(ante_lookup." + ActivityUtils.LOOKUP_VIEW_VALUE + " , ante_lookup." + ActivityUtils.LOOKUP_VIEW_KEY + ") ante_attr, " + "ante.conditional_operator ante_op, " + "NVL(ante.attribute_str_value , ante.attribute_num_value ) ante_val, " + "NVL(cons_lookup." + ActivityUtils.LOOKUP_VIEW_VALUE + ", cons_lookup." + ActivityUtils.LOOKUP_VIEW_KEY + ") cons_attr, " + "cons.conditional_operator cons_op, " + "NVL(cons.attribute_str_value, cons.attribute_num_value) cons_val, " + "ante.attribute_support ante_support, " + "cons.attribute_support cons_support, " + "ante.attribute_confidence ante_conf, " + "cons.attribute_confidence cons_conf, " + "t.number_of_items rule_length " + "FROM TABLE( dbms_data_mining.get_association_rules({0}) ) t, " + "TABLE(t.antecedent) ante, " + "TABLE(t.consequent) cons, " + "{1} ante_lookup,  " + "{1} cons_lookup " + "where " + "ante_lookup." + ActivityUtils.LOOKUP_VIEW_KEY + "(+) = ante.attribute_name " + "and " + "cons_lookup." + ActivityUtils.LOOKUP_VIEW_KEY + "(+) = cons.attribute_name ";
    private static String QRY_AR_GET_ALL_RULES_WITH_LOOKUP_11G = "SELECT t.rule_id rule_id, t.rule_support rule_support, t.rule_confidence rule_confidence, NVL(ante_lookup." + ActivityUtils.LOOKUP_VIEW_VALUE + " , ante_lookup." + ActivityUtils.LOOKUP_VIEW_KEY + ") ante_attr, " + "ante.conditional_operator ante_op, " + "NVL(ante.attribute_str_value , ante.attribute_num_value ) ante_val, " + "NVL(cons_lookup." + ActivityUtils.LOOKUP_VIEW_VALUE + ", cons_lookup." + ActivityUtils.LOOKUP_VIEW_KEY + ") cons_attr, " + "cons.conditional_operator cons_op, " + "NVL(cons.attribute_str_value, cons.attribute_num_value) cons_val, " + "ante.attribute_support ante_support, " + "cons.attribute_support cons_support, " + "ante.attribute_confidence ante_conf, " + "cons.attribute_confidence cons_conf, " + "t.number_of_items rule_length " + "FROM TABLE( dbms_data_mining.get_association_rules({0}) ) t, " + "TABLE(t.antecedent) ante, " + "TABLE(t.consequent) cons, " + "{1} ante_lookup,  " + "{1} cons_lookup " + "where " + "ante_lookup." + ActivityUtils.LOOKUP_VIEW_KEY + "(+) = ante.attribute_subname " + "and " + "cons_lookup." + ActivityUtils.LOOKUP_VIEW_KEY + "(+) = cons.attribute_subname ";
    private static String QRY_AR_GET_ALL_RULES_WITH_UNBINNING = "WITH  label_view as ( {0} ), rules as ( SELECT * FROM TABLE( dbms_data_mining.get_association_rules({1}) ) ),  ante_pred as (    SELECT rules.rule_id rule_id,  rules.rule_support rule_support,  rules.rule_confidence rule_confidence,  ante.attribute_name ante_attr,   ante.conditional_operator ante_op,   NVL( l.label, NVL(ante.attribute_str_value , ante.attribute_num_value )) ante_val,   ante.attribute_support ante_support,  ante.attribute_confidence ante_conf,  rules.number_of_items rule_length    FROM rules,    TABLE(rules.antecedent) ante,    label_view l    WHERE    ante.attribute_name = l.col (+) AND    (NVL(ANTE.attribute_str_value, ANTE.attribute_num_value) = l.bin (+))    ) SELECT ante.*, cons.attribute_name cons_attr,    cons.conditional_operator cons_op,    NVL( l.label, NVL(cons.attribute_str_value ,cons.attribute_num_value )) cons_val,    cons.attribute_support cons_support,    cons.attribute_confidence cons_conf FROM rules,    TABLE(rules.consequent) cons,    ANTE_PRED ante,    label_view l  WHERE      rules.rule_id=ante.rule_id (+) AND    cons.attribute_name = l.col (+) AND    (NVL(CONS.attribute_str_value, CONS.attribute_num_value) = l.bin (+) ) ";
    private static String QRY_AR_GET_MAX_RULE_LENGTH = "SELECT max(cardinality(antecedent))+1 max_rule_length FROM TABLE( dbms_data_mining.get_association_rules(?) )";
    private static String ORDER_BY_RULE_ID = "ORDER BY rule_id desc ";
    private static String QRY_AR_GET_ITEMS = "SELECT distinct i.column_value item FROM TABLE( dbms_data_mining.get_frequent_itemsets(?) ) t, TABLE(t.items) i";
    private static String QRY_AR_MODEL_CONSTANTS = "SELECT max(rule_confidence) max_confidence, min(rule_confidence) min_confidence, max(rule_support) max_support, min(rule_support) min_support FROM TABLE( dbms_data_mining.get_association_rules(?) )";
    private static String QRY_GET_KEYS = "SELECT KEY FROM {0} WHERE VALUE IN ({1})";
    private static final String _DM_ITEM = "DM_ITEM('<attribute_name>','<attribute_subname>', null, null )\n";

    public ODMrOraAssociationModel(OraConnection oraConnection, String string) throws JDMException {
        super(oraConnection, string, MiningFunction.association);
    }

    public ModelDetail getModelDetail() {
        return null;
    }

    public int getMaxTransactionSize() {
        return 0;
    }

    public Double getAverageTransactionSize() {
        return new Double(0.0);
    }

    public long getNumberOfTransactions() {
        return 0L;
    }

    public int getMinAbsoluteSupport() {
        return 0;
    }

    public int getMaxAbsoluteSupport() {
        return 0;
    }

    public Double getMinConfidence() {
        this.loadSupportConfidence();
        return new Double(this.m_minConfidence * 100.0);
    }

    public Double getMaxConfidence() {
        this.loadSupportConfidence();
        return new Double(this.m_maxConfidence * 100.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSupportConfidence() {
        if (this.m_maxSupport > 0.0) {
            return;
        }
        Connection connection = null;
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            callableStatement = connection.prepareCall(QRY_AR_MODEL_CONSTANTS);
            callableStatement.setString(1, this.getName());
            resultSet = callableStatement.executeQuery();
            if (resultSet.next()) {
                this.m_maxConfidence = resultSet.getDouble("MAX_CONFIDENCE");
                this.m_minConfidence = resultSet.getDouble("MIN_CONFIDENCE");
                this.m_maxSupport = resultSet.getDouble("MAX_SUPPORT");
                this.m_minSupport = resultSet.getDouble("MIN_SUPPORT");
            }
        }
        catch (Exception exception) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (callableStatement != null) {
                try {
                    callableStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public Collection getRules11G(RulesFilter rulesFilter, String string, int n, boolean bl) throws JDMException {
        Object[] objectArray;
        if (rulesFilter == null) {
            throw new JDMException();
        }
        int n2 = rulesFilter.getMaxNumberOfRules();
        Double d = rulesFilter.getMinValue(RuleProperty.confidence);
        Double d2 = rulesFilter.getMinValue(RuleProperty.support);
        Double d3 = rulesFilter.getMinValue(RuleProperty.length);
        Double d4 = rulesFilter.getMaxValue(RuleProperty.length);
        RuleProperty[] rulePropertyArray = rulesFilter.getOrderingConditions();
        String string2 = "null";
        if (rulePropertyArray != null) {
            string2 = "";
            for (int i = 0; i < rulePropertyArray.length; ++i) {
                objectArray = rulesFilter.getOrderingCondition(rulePropertyArray[i]);
                if (i > 0) {
                    string2 = string2 + ", ";
                }
                if (rulePropertyArray[i].equals(RuleProperty.support)) {
                    string2 = string2 + "'RULE_SUPPORT ";
                } else if (rulePropertyArray[i].equals(RuleProperty.confidence)) {
                    string2 = string2 + "'RULE_CONFIDENCE ";
                } else if (rulePropertyArray[i].equals(RuleProperty.length)) {
                    string2 = string2 + "'NUMBER_OF_ITEMS ";
                }
                string2 = objectArray.equals(SortOrder.ascending) ? string2 + "ASC'" : string2 + "DESC'";
            }
            string2 = "DMSYS.ORA_MINING_VARCHAR2_NT(" + string2 + ")";
        }
        Object[] objectArray2 = rulesFilter.getItems(RuleComponentOption.antecedent, true);
        objectArray = rulesFilter.getItems(RuleComponentOption.consequent, true);
        String string3 = "null";
        if (objectArray2 != null && objectArray2.length > 0) {
            string3 = this.getKeys11G(objectArray2, string);
        }
        String string4 = "null";
        if (objectArray != null && objectArray.length > 0) {
            string4 = this.getKeys11G(objectArray, string);
        }
        String string5 = "";
        int n3 = 1;
        if (objectArray != null) {
            n3 = 6;
            string5 = "?,?,null,?,?,?,?," + string2 + "," + string3 + "," + string4;
        } else if (objectArray2 != null) {
            n3 = 6;
            string5 = "?,?,null,?,?,?,?," + string2 + "," + string3;
        } else if (rulePropertyArray != null) {
            n3 = 6;
            string5 = "?,?,null,?,?,?,?," + string2;
        } else if (d4 != null) {
            n3 = 6;
            string5 = "?,?,null,?,?,?,?";
        } else if (d3 != null) {
            n3 = 5;
            string5 = "?,?,null,?,?,?";
        } else if (d2 != null) {
            n3 = 4;
            string5 = "?,?,null,?,?";
        } else if (d != null) {
            n3 = 3;
            string5 = "?,?,null,?";
        } else if (n2 > 0) {
            n3 = 2;
            string5 = "?,?";
        }
        String string6 = this.getRulesQuery(string5);
        StringBuffer stringBuffer = new StringBuffer();
        if (n != -1) {
            String string7 = null;
            if (n == 0) {
                string7 = "rule_id";
            } else if (n == 1) {
                string7 = "ante_attr";
            } else if (n == 2) {
                string7 = "cons_attr";
            } else if (n == 3) {
                string7 = "rule_confidence";
            } else if (n == 4) {
                string7 = "rule_support";
            }
            stringBuffer.append("SELECT * FROM (\n");
            stringBuffer.append(string6);
            stringBuffer.append("\n) ORDER BY ");
            stringBuffer.append(string7 + " " + (bl ? " ASC " : " DESC "));
        } else {
            stringBuffer.append(string6);
        }
        return this.getRules(stringBuffer.toString(), rulesFilter, n3);
    }

    public Collection getRules(RulesFilter rulesFilter) {
        return null;
    }

    public Collection getRules(RulesFilter rulesFilter, int n, boolean bl) throws JDMException {
        Object object;
        if (rulesFilter == null) {
            throw new JDMException();
        }
        int n2 = rulesFilter.getMaxNumberOfRules();
        Double d = rulesFilter.getMinValue(RuleProperty.confidence);
        Double d2 = rulesFilter.getMinValue(RuleProperty.support);
        Double d3 = rulesFilter.getMinValue(RuleProperty.length);
        Double d4 = rulesFilter.getMaxValue(RuleProperty.length);
        RuleProperty[] rulePropertyArray = rulesFilter.getOrderingConditions();
        String string = "null";
        if (rulePropertyArray != null) {
            string = "";
            for (int i = 0; i < rulePropertyArray.length; ++i) {
                object = rulesFilter.getOrderingCondition(rulePropertyArray[i]);
                if (i > 0) {
                    string = string + ", ";
                }
                if (rulePropertyArray[i].equals(RuleProperty.support)) {
                    string = string + "'RULE_SUPPORT ";
                } else if (rulePropertyArray[i].equals(RuleProperty.confidence)) {
                    string = string + "'RULE_CONFIDENCE ";
                } else if (rulePropertyArray[i].equals(RuleProperty.length)) {
                    string = string + "'NUMBER_OF_ITEMS ";
                }
                string = ((Enum)object).equals(SortOrder.ascending) ? string + "ASC'" : string + "DESC'";
            }
            string = "DMSYS.ORA_MINING_VARCHAR2_NT(" + string + ")";
        }
        Object[] objectArray = rulesFilter.getItems(RuleComponentOption.antecedent, true);
        object = rulesFilter.getItems(RuleComponentOption.consequent, true);
        String string2 = "null";
        if (objectArray != null && objectArray.length > 0) {
            string2 = "'" + objectArray[0].toString() + "'";
            for (int i = 1; i < objectArray.length; ++i) {
                String string3 = objectArray[i].toString();
                string3 = DM4JStringUtils.processQuotedName(string3);
                string3 = DM4JStringUtils.trimDoubleQuotes(string3);
                string2 = string2 + ", '" + string3 + "'";
            }
            string2 = this.getKeys(string2);
        }
        String string4 = "null";
        if (object != null && ((Object[])object).length > 0) {
            string4 = "'" + object[0].toString() + "'";
            for (int i = 1; i < ((Object)object).length; ++i) {
                String string5 = object[i].toString();
                string5 = DM4JStringUtils.processQuotedName(string5);
                string5 = DM4JStringUtils.trimDoubleQuotes(string5);
                string4 = string4 + ", '" + string5 + "'";
            }
            string4 = this.getKeys(string4);
        }
        String string6 = "";
        int n3 = 1;
        if (object != null) {
            n3 = 6;
            string6 = "?,?,null,?,?,?,?," + string + "," + string2 + "," + string4;
        } else if (objectArray != null) {
            n3 = 6;
            string6 = "?,?,null,?,?,?,?," + string + "," + string2;
        } else if (rulePropertyArray != null) {
            n3 = 6;
            string6 = "?,?,null,?,?,?,?," + string;
        } else if (d4 != null) {
            n3 = 6;
            string6 = "?,?,null,?,?,?,?";
        } else if (d3 != null) {
            n3 = 5;
            string6 = "?,?,null,?,?,?";
        } else if (d2 != null) {
            n3 = 4;
            string6 = "?,?,null,?,?";
        } else if (d != null) {
            n3 = 3;
            string6 = "?,?,null,?";
        } else if (n2 > 0) {
            n3 = 2;
            string6 = "?,?";
        }
        String string7 = this.getRulesQuery(string6);
        StringBuffer stringBuffer = new StringBuffer();
        if (n != -1) {
            String string8 = null;
            if (n == 0) {
                string8 = "rule_id";
            } else if (n == 1) {
                string8 = "ante_attr";
            } else if (n == 2) {
                string8 = "cons_attr";
            } else if (n == 3) {
                string8 = "rule_confidence";
            } else if (n == 4) {
                string8 = "rule_support";
            }
            stringBuffer.append("SELECT * FROM (\n");
            stringBuffer.append(string7);
            stringBuffer.append("\n) ORDER BY ");
            stringBuffer.append(string8 + " " + (bl ? " ASC " : " DESC "));
        } else {
            stringBuffer.append(string7);
        }
        return this.getRules(stringBuffer.toString(), rulesFilter, n3);
    }

    private String getRulesQuery(String string) {
        String string2 = null;
        String string3 = this.getLookupTable();
        if (this.m_buildTransform != null) {
            try {
                OraBinningTransform oraBinningTransform = (OraBinningTransform)this.m_buildTransform;
                String string4 = oraBinningTransform.getNumericalBinTable();
                String string5 = oraBinningTransform.getCategoricalBinTable();
                String string6 = OraBinningTransformImpl.getUnbinningClause(string5, string4);
                string2 = MessageFormat.format(QRY_AR_GET_ALL_RULES_WITH_UNBINNING, string6, string);
                this.m_isUnbinning = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (string3 != null) {
            string2 = MessageFormat.format(BrowserFrame.is11Server() ? QRY_AR_GET_ALL_RULES_WITH_LOOKUP_11G : QRY_AR_GET_ALL_RULES_WITH_LOOKUP, string, string3);
        } else {
            StringBuffer stringBuffer = new StringBuffer(BrowserFrame.is11Server() ? QRY_AR_GET_ALL_RULES_START_11G : QRY_AR_GET_ALL_RULES_START);
            String string7 = MessageFormat.format(QRY_AR_GET_ALL_RULES_END, string);
            stringBuffer.append(string7);
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getRules(String string, RulesFilter rulesFilter, int n) throws JDMException {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Vector<ODMrOraAssociationRule> vector = new Vector<ODMrOraAssociationRule>();
        Hashtable<Integer, ODMrOraAssociationRule> hashtable = new Hashtable<Integer, ODMrOraAssociationRule>();
        try {
            double d;
            connection = DM4JConnectionManager.getDbConnection();
            int n2 = 0;
            Double d2 = null;
            Double d3 = null;
            Double d4 = null;
            Double d5 = null;
            Double d6 = null;
            Double d7 = null;
            if (rulesFilter != null) {
                n2 = rulesFilter.getMaxNumberOfRules();
                d2 = rulesFilter.getMaxValue(RuleProperty.confidence);
                d3 = rulesFilter.getMinValue(RuleProperty.confidence);
                d4 = rulesFilter.getMaxValue(RuleProperty.support);
                d5 = rulesFilter.getMinValue(RuleProperty.support);
                d6 = rulesFilter.getMaxValue(RuleProperty.length);
                d7 = rulesFilter.getMinValue(RuleProperty.length);
            }
            boolean bl = d2 != null && d2 < 100.0 || d4 != null && d4 < 100.0;
            statement = connection.prepareStatement(string);
            int n3 = 1;
            statement.setString(n3++, this.getName());
            if (n >= n3) {
                if (n2 == 0) {
                    statement.setNull(n3++, 0);
                } else {
                    statement.setInt(n3++, n2);
                }
            }
            if (n >= n3) {
                if (d3 == null) {
                    statement.setNull(n3++, 0);
                } else {
                    d = d3 / 100.0;
                    statement.setDouble(n3++, d);
                }
            }
            if (n >= n3) {
                if (d5 == null) {
                    statement.setNull(n3++, 0);
                } else {
                    d = d5 / 100.0;
                    statement.setDouble(n3++, d);
                }
            }
            if (n >= n3) {
                if (d7 == null) {
                    statement.setNull(n3++, 0);
                } else {
                    statement.setInt(n3++, d7.intValue());
                }
            }
            if (n >= n3) {
                if (d6 == null) {
                    statement.setNull(n3++, 0);
                } else {
                    statement.setInt(n3++, d6.intValue());
                }
            }
            resultSet = statement.executeQuery();
            ODMrOraAssociationRule oDMrOraAssociationRule = null;
            ODMrOraItemset oDMrOraItemset = null;
            while (resultSet.next()) {
                String string2;
                String string3;
                String string4;
                String string5;
                boolean bl2 = false;
                int n4 = resultSet.getInt("rule_id");
                double d8 = resultSet.getDouble("rule_support");
                double d9 = resultSet.getDouble("rule_confidence");
                oDMrOraAssociationRule = (ODMrOraAssociationRule)hashtable.get(n4);
                if (oDMrOraAssociationRule == null) {
                    oDMrOraAssociationRule = new ODMrOraAssociationRule(this.getConnection(), n4, d8, d9);
                    string5 = resultSet.getString("cons_attr");
                    string4 = resultSet.getString("cons_op");
                    string3 = resultSet.getString("cons_val");
                    string2 = string5 + string4 + string3;
                    ODMrOraItemset oDMrOraItemset2 = new ODMrOraItemset(this.getConnection());
                    oDMrOraItemset2.addItem(string2);
                    oDMrOraAssociationRule.setConsequent(oDMrOraItemset2);
                    oDMrOraItemset = new ODMrOraItemset(this.getConnection());
                    oDMrOraAssociationRule.setAntecedent(oDMrOraItemset);
                    bl2 = true;
                }
                string5 = resultSet.getString("ante_attr");
                string4 = resultSet.getString("ante_op");
                string3 = resultSet.getString("ante_val");
                string2 = string5 + string4 + string3;
                oDMrOraItemset.addItem(string2);
                if (!bl2) continue;
                if (bl) {
                    if (d2 != null) {
                        boolean bl3 = bl2 = d9 <= d2 / 100.0;
                    }
                    if (bl2 && d4 != null) {
                        boolean bl4 = bl2 = d8 <= d4 / 100.0;
                    }
                }
                if (!bl2) continue;
                vector.addElement(oDMrOraAssociationRule);
                hashtable.put(n4, oDMrOraAssociationRule);
            }
        }
        catch (Exception exception) {
            this.createException(OraJDMBundleKeys.JDM_GENERIC_ERROR, null, exception, "2007", new Object[]{this.getName()});
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return vector;
    }

    public Collection getRules() throws JDMException {
        if (this.m_rules == null) {
            this.m_rules = this.getRules(this.getRulesQuery("?") + ORDER_BY_RULE_ID, null, 1);
        }
        return this.m_rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getItems() throws JDMException {
        if (this.m_items != null) {
            return this.m_items;
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            preparedStatement = connection.prepareStatement(QRY_AR_GET_ITEMS);
            preparedStatement.setString(1, this.getName());
            resultSet = preparedStatement.executeQuery();
            this.m_items = new HashSet();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                this.m_items.add(string);
            }
        }
        catch (Exception exception) {
            this.createException(OraJDMBundleKeys.JDM_GENERIC_ERROR, null, exception, "2008", new Object[]{this.getName()});
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return this.m_items;
    }

    public Collection getItemsets(int n) throws JDMException {
        this.getValidationHandler().validateNumber(n, 1, "itemsetSize");
        if (this.m_itemsets.isEmpty()) {
            this.getItemsets(QRY_AR_GET_ITEMSETS);
        }
        Vector<ODMrOraItemset> vector = new Vector<ODMrOraItemset>();
        for (int i = 0; i < this.m_itemsets.size(); ++i) {
            ODMrOraItemset oDMrOraItemset = (ODMrOraItemset)this.m_itemsets.elementAt(i);
            if (oDMrOraItemset.getSize() != n) continue;
            vector.add(oDMrOraItemset);
        }
        return vector;
    }

    public Collection getItemsets() throws JDMException {
        if (this.m_itemsets.isEmpty()) {
            this.getItemsets(QRY_AR_GET_ITEMSETS);
        }
        return this.m_itemsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getItemsets(String string) throws JDMException {
        Connection connection = null;
        OraConnection oraConnection = this.getConnection();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, this.getName());
            resultSet = preparedStatement.executeQuery();
            int n = -1;
            int n2 = 0;
            ODMrOraItemset oDMrOraItemset = null;
            while (resultSet.next()) {
                int n3 = resultSet.getInt(1);
                double d = resultSet.getDouble(2);
                int n4 = resultSet.getInt(3);
                String string2 = resultSet.getString(4);
                if (n2 == 0) {
                    oDMrOraItemset = new ODMrOraItemset(oraConnection);
                    oDMrOraItemset.setItemsetId(n3);
                    oDMrOraItemset.setSupport(d);
                    this.m_itemsets.add(oDMrOraItemset);
                    n2 = n4;
                }
                oDMrOraItemset.addItem(string2);
                --n2;
            }
        }
        catch (Exception exception) {
            this.createException(OraJDMBundleKeys.JDM_GENERIC_ERROR, null, exception, "2008", new Object[]{this.getName()});
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxRuleLength() {
        if (this.m_maxRuleLength != null) {
            return this.m_maxRuleLength;
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            preparedStatement = connection.prepareStatement(QRY_AR_GET_MAX_RULE_LENGTH);
            preparedStatement.setString(1, this.getName());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                if (!resultSet.wasNull()) {
                    this.m_maxRuleLength = new Integer(n);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.m_maxRuleLength = null;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return this.m_maxRuleLength != null ? this.m_maxRuleLength : 0;
    }

    public int getNumberOfItems() {
        int n = 0;
        try {
            Collection collection = this.getItems();
            n = collection.size();
        }
        catch (Exception exception) {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, exception, "2008", new Object[]{this.getName()});
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfItemsets() {
        Connection connection = null;
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            callableStatement = connection.prepareCall(QRY_AR_NUM_ITEMSETS);
            callableStatement.setString(1, this.getName());
            resultSet = callableStatement.executeQuery();
            if (resultSet.next()) {
                this.m_numberOfItemsets = resultSet.getInt("NUMBER_OF_ITEMSETS");
            }
        }
        catch (Exception exception) {
            this.m_numberOfItemsets = 0;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (callableStatement != null) {
                try {
                    callableStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return this.m_numberOfItemsets;
    }

    public String getLookupTable() {
        String string = null;
        try {
            if (this.m_htTransparencyTables == null) {
                this.m_htTransparencyTables = new Hashtable();
                DMEMetadata dMEMetadata = DMEMetadata.getInstance();
                dMEMetadata.getTransparencyTables(this.getDatabaseConnection(), null, this.getName(), this.m_htTransparencyTables);
            }
            if (this.m_htTransparencyTables != null) {
                string = (String)this.m_htTransparencyTables.get("XMAP");
            }
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getKeys(String string) {
        String string2 = this.getLookupTable();
        if (string2 == null) {
            return "DMSYS.ORA_MINING_VARCHAR2_NT(" + string + ")";
        }
        Vector<Integer> vector = null;
        String string3 = MessageFormat.format(QRY_GET_KEYS, string2, string);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                int n = resultSet.getInt(1);
                if (vector == null) {
                    vector = new Vector<Integer>();
                }
                vector.add(new Integer(n));
            }
        }
        catch (Exception exception) {
            vector = null;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        if (vector == null || vector.isEmpty()) {
            return "DMSYS.ORA_MINING_VARCHAR2_NT(" + string + ")";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            String string4 = vector.elementAt(i).toString();
            stringBuffer.append("'" + string4 + "'");
            if (i >= vector.size() - 1) continue;
            stringBuffer.append(",");
        }
        String string5 = "DMSYS.ORA_MINING_VARCHAR2_NT(" + stringBuffer.toString() + ")";
        return string5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getKeys11G(Object[] objectArray, String string) {
        StringBuffer stringBuffer = new StringBuffer("DM_ITEMS(\n");
        String string2 = this.getLookupTable();
        if (string2 != null) {
            String string3;
            StringBuffer stringBuffer2 = new StringBuffer("'" + DM4JStringUtils.escapeSingleQuotesForSQL(objectArray[0].toString()) + "'");
            for (int i = 1; i < objectArray.length; ++i) {
                string3 = DM4JStringUtils.escapeSingleQuotesForSQL(objectArray[i].toString());
                string3 = DM4JStringUtils.processQuotedName(string3);
                string3 = DM4JStringUtils.trimDoubleQuotes(string3);
                stringBuffer2.append(", '" + string3 + "'");
            }
            Vector<Integer> vector = null;
            string3 = MessageFormat.format(QRY_GET_KEYS, string2, stringBuffer2.toString());
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                connection = DM4JConnectionManager.getDbConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string3);
                while (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    if (vector == null) {
                        vector = new Vector<Integer>();
                    }
                    vector.add(new Integer(n));
                }
            }
            catch (Exception exception) {
                vector = null;
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            if (vector != null && !vector.isEmpty()) {
                for (int i = 0; i < vector.size(); ++i) {
                    String string4 = vector.elementAt(i).toString();
                    String string5 = DM4JStringUtils.getReplacedString(_DM_ITEM, "<attribute_name>", string);
                    string5 = DM4JStringUtils.getReplacedString(string5, "<attribute_subname>", string4);
                    stringBuffer.append(string5);
                    if (i >= vector.size() - 1) continue;
                    stringBuffer.append(",");
                }
            } else {
                stringBuffer.append("null");
            }
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                String string6 = objectArray[i].toString();
                int n = string6.indexOf(string + ".");
                String string7 = n != -1 ? string6.substring(string.length() + 1) : string6;
                string7 = DM4JStringUtils.escapeSingleQuotesForSQL(string7);
                String string8 = DM4JStringUtils.getReplacedString(_DM_ITEM, "<attribute_name>", string);
                string8 = DM4JStringUtils.getReplacedString(string8, "<attribute_subname>", string7);
                stringBuffer.append(string8);
                if (i >= objectArray.length - 1) continue;
                stringBuffer.append(",");
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

