/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.association;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.datamining.association.AssociationModel;
import javax.datamining.association.AssociationRule;
import javax.datamining.association.Itemset;
import javax.datamining.association.RuleProperty;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.dmt.dm4j.DM4JAccessibilityUtils;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.association.ODMrOraAssociationModel;
import oracle.dmt.dm4j.browser.viewer.association.RulesTable;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.browser.viewer.sort.SortDialog;

public class AssociationRulesPanel
extends GriddedPanel
implements VetoableChangeListener {
    AssociationModel m_model = null;
    JLabel m_totalRule = new JLabel();
    JButton m_sortButton = new JButton();
    JButton m_exportButton;
    RulesTable m_rulesTable = null;
    JTextArea m_ruleDetail = new JTextArea();
    JScrollPane m_rulesScrollPane = new JScrollPane();
    private Vector m_consequentItems;
    private Vector m_antecedentItems;
    private String _realAttributeName;
    String[] m_attrList = null;
    static final String ALLRULES = DM4JResourceUtilities.getUIString("ASSOC_RULE_ALL_RULES");
    static final int MAXNUMRULE = 100;
    private Integer m_numberOfRules;
    private Double m_minSupport;
    private Double m_minConfidence;
    private boolean m_bSupportEnabled = true;
    private boolean m_bConfidenceEnabled = true;
    private Boolean[] m_sortOrder;
    private Object[] m_selectedAttributeBetween;
    private Object[] m_selectedAttributeAnd;

    public AssociationRulesPanel(LeafNodeData leafNodeData) {
        this.m_model = (AssociationModel)leafNodeData.getOdmObject();
        try {
            this.jbInit();
            this.runTimePanelLoad(leafNodeData);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        return "ASSOCIATION_RULES_MODEL";
    }

    private void jbInit() throws Exception {
        int n = 1;
        JLabel jLabel = new JLabel(DM4JResourceUtilities.getUIString("ASSOC_RULE_STATISTICS"));
        this.addAnchoredComponent(jLabel, TOPLABELITEMINSETS, n, 0, 2, 1, 18);
        this.m_sortButton.setText(DM4JResourceUtilities.getUIString("ASSOC_RULE_GET_RULES"));
        this.m_sortButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("ASSOC_RULE_GET_RULES"));
        this.addAnchoredComponent(this.m_sortButton, TOPLABELITEMINSETS, n++, 6, 1, 1, 12);
        this.m_sortButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AssociationRulesPanel.this.btnSort_actionPerformed(actionEvent);
            }
        });
        JLabel jLabel2 = new JLabel(DM4JResourceUtilities.getUIString("ASSOC_RULE_TOTAL_RULES"));
        this.addAnchoredComponent(jLabel2, MIDINDENTEDLABELITEMINSETS, n, 0, 1, 1, 18);
        this.addAnchoredComponent(this.m_totalRule, MIDVALUEITEMINSETS, n++, 1, 1, 1, 18);
        JLabel jLabel3 = new JLabel(DM4JResourceUtilities.getUIString("ASSOC_RULE_RULES"));
        jLabel3.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("ASSOC_RULE_RULES"));
        this.addAnchoredComponent(jLabel3, TOPLABELITEMINSETS, n, 0, 1, 1, 16);
        this.m_rulesTable = new RulesTable(this.m_model);
        this.m_exportButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        this.m_exportButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        this.m_exportButton.setEnabled(false);
        this.addAnchoredComponent(this.m_exportButton, MIDLABELITEMINSETS, n++, 6, 1, 1, 12);
        this.m_exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
                    if (!exportDialog.isCancelled()) {
                        exportDialog.export(AssociationRulesPanel.this.m_rulesTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.m_rulesScrollPane.getViewport().add((Component)((Object)this.m_rulesTable));
        jLabel3.setLabelFor((Component)((Object)this.m_rulesTable));
        this.m_rulesScrollPane.setPreferredSize(null);
        this.addFilledComponent(this.m_rulesScrollPane, MIDLABELITEMINSETS, n, 0, 7, 2, 1);
        n += 2;
        JLabel jLabel4 = new JLabel(DM4JResourceUtilities.getUIString("ASSOC_RULE_RULE_DETAIL"));
        jLabel4.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("ASSOC_RULE_RULE_DETAIL"));
        this.addFilledComponent(jLabel4, TOPLABELITEMINSETS, n++, 0, 1, 1, 2);
        this.m_ruleDetail.setEditable(false);
        this.m_ruleDetail.setLineWrap(true);
        this.m_ruleDetail.setWrapStyleWord(true);
        DM4JAccessibilityUtils.setAccessibleName(this.m_ruleDetail, DM4JResourceUtilities.getUIString("ASSOC_RULE_RULE_DETAIL"));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.m_ruleDetail);
        jLabel4.setLabelFor(jScrollPane);
        this.addFilledComponent(jScrollPane, MIDLABELITEMINSETS, n, 0, 7, 2, 1);
        JButton[] jButtonArray = new JButton[]{this.m_sortButton};
        DM4JResourceUtilities.setPreferredSize(jButtonArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnSort_actionPerformed(ActionEvent actionEvent) {
        try {
            RuleProperty[] rulePropertyArray = this.m_rulesTable.getSortCriteria();
            Cursor cursor = this.getCursor();
            JFrame jFrame = BrowserUtils.getParentFrame(this);
            try {
                jFrame.setCursor(Cursor.getPredefinedCursor(3));
                this.calcItems();
            }
            finally {
                jFrame.setCursor(cursor);
            }
            SortDialog sortDialog = new SortDialog(jFrame, this.m_model, this.m_numberOfRules, this.m_minSupport, this.m_minConfidence, this.m_bSupportEnabled, this.m_bConfidenceEnabled, this.m_selectedAttributeBetween, this.m_selectedAttributeAnd, SortDialog.AR, DM4JResourceUtilities.getUIString("SORT_GET_RULES_DIALOG_TITLE"), rulePropertyArray, this.m_sortOrder, this.m_antecedentItems, this.m_consequentItems, this._realAttributeName);
            if (!sortDialog.isCancelled()) {
                RuleProperty[] rulePropertyArray2 = sortDialog.getSortCriteria();
                this.m_numberOfRules = new Integer(sortDialog.getNumberofRules());
                this.m_bSupportEnabled = sortDialog.isMinSupport();
                this.m_bConfidenceEnabled = sortDialog.isMinConfidence();
                this.m_minSupport = this.m_bSupportEnabled ? new Double(sortDialog.getMinSupport()) : null;
                this.m_minConfidence = this.m_bConfidenceEnabled ? new Double(sortDialog.getMinConfidence()) : null;
                this.m_sortOrder = sortDialog.getSortCriteriaOrder();
                this.m_ruleDetail.setText(null);
                this.m_selectedAttributeBetween = sortDialog.getAttributeBetween();
                String[] stringArray = null;
                if (this.m_selectedAttributeBetween != null) {
                    if (this.m_selectedAttributeBetween.length == this.m_antecedentItems.size()) {
                        this.m_selectedAttributeBetween = null;
                    } else {
                        stringArray = new String[this.m_selectedAttributeBetween.length];
                        System.arraycopy(this.m_selectedAttributeBetween, 0, stringArray, 0, this.m_selectedAttributeBetween.length);
                    }
                }
                this.m_selectedAttributeAnd = sortDialog.getAttributeAnd();
                String[] stringArray2 = null;
                if (this.m_selectedAttributeAnd != null) {
                    if (this.m_selectedAttributeAnd.length == this.m_consequentItems.size()) {
                        this.m_selectedAttributeAnd = null;
                    } else {
                        stringArray2 = new String[this.m_selectedAttributeAnd.length];
                        System.arraycopy(this.m_selectedAttributeAnd, 0, stringArray2, 0, this.m_selectedAttributeAnd.length);
                    }
                }
                this.m_rulesTable.displayLoadingStatus();
                Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(this.m_rulesTable);
                this.m_rulesTable.sortRules(this.m_numberOfRules, this.m_minSupport, this.m_minConfidence, stringArray, stringArray2, rulePropertyArray2, this.m_sortOrder, this._realAttributeName);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void runTimePanelLoad(LeafNodeData leafNodeData) throws Exception {
        String string;
        String string2 = "";
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            string = "SELECT count(*) total_count FROM DM$P0" + this.m_model.getName().toUpperCase();
            connection = DM4JConnectionManager.getDbConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            int n = 0;
            resultSet.next();
            n = resultSet.getInt("total_count");
            string2 = String.valueOf(n);
            this.m_totalRule.setText(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        this.m_rulesTable.setColumnWidths();
        string = this.m_rulesTable.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
        string.setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
        generalGridSelectionManager.addVetoableChangeListener((VetoableChangeListener)this);
        if (this.getRulesCount() > 0) {
            this.m_sortButton.setEnabled(true);
        } else {
            this.m_sortButton.setEnabled(false);
        }
    }

    private void calcItems() throws Exception {
        if (this.m_consequentItems != null && this.m_antecedentItems != null) {
            return;
        }
        String string = null;
        Statement statement = null;
        ResultSet resultSet = null;
        this.m_consequentItems = new Vector(1000, 1000);
        this.m_antecedentItems = new Vector(1000, 1000);
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            String string2 = null;
            if (this.m_model instanceof ODMrOraAssociationModel) {
                string2 = ((ODMrOraAssociationModel)this.m_model).getLookupTable();
            }
            string = string2 == null ? (BrowserFrame.is11Server() ? "SELECT attribute_name real_attrname, NVL2(attribute_subname, attribute_name || '.' || attribute_subname, attribute_name) attribute_name from \nDM$P2" + this.m_model.getName().toUpperCase() + " P2, " + "\nDM$P3" + this.m_model.getName().toUpperCase() + " P3, " + "\nDM$P4" + this.m_model.getName().toUpperCase() + " P4  " + "\nWHERE number_of_items=1 and" + "\nP3.ITEMSET_ID= P4.ITEMSET_ID and" + "\nP2.ITEM_ID = P4.ITEM_ID" + "\nand attribute_name is not null " + "\nORDER BY attribute_name ASC" : "SELECT attribute_name from \nDM$P2" + this.m_model.getName().toUpperCase() + " P2, " + "\nDM$P3" + this.m_model.getName().toUpperCase() + " P3, " + "\nDM$P4" + this.m_model.getName().toUpperCase() + " P4  " + "\nWHERE number_of_items=1 and" + "\nP3.ITEMSET_ID= P4.ITEMSET_ID and" + "\nP2.ITEM_ID = P4.ITEM_ID" + "\nand attribute_name is not null " + "\nORDER BY attribute_name ASC") : (BrowserFrame.is11Server() ? "select ids.attribute_name real_attrname, NVL(cons_lookup.VALUE, ids.attribute_subname) attribute_name \nfrom \n(SELECT attribute_name, attribute_subname \nfrom DM$P2" + this.m_model.getName().toUpperCase() + " P2, " + "\nDM$P3" + this.m_model.getName().toUpperCase() + " P3, " + "\nDM$P4" + this.m_model.getName().toUpperCase() + "  P4 " + "WHERE number_of_items=1 and \n" + "P3.ITEMSET_ID= P4.ITEMSET_ID and \n" + "P2.ITEM_ID = P4.ITEM_ID" + "\nand attribute_name is not null " + "\nORDER BY attribute_subname ASC) ids, \n" + string2 + " cons_lookup" + "\nwhere ids.attribute_subname = cons_lookup.KEY(+)" : "select \nNVL(cons_lookup.VALUE, ids.attribute_name) attribute_name \nfrom \n(SELECT attribute_name \nfrom DM$P2" + this.m_model.getName().toUpperCase() + " P2, " + "\nDM$P3" + this.m_model.getName().toUpperCase() + " P3, " + "\nDM$P4" + this.m_model.getName().toUpperCase() + "  P4 " + "WHERE number_of_items=1 and \n" + "P3.ITEMSET_ID= P4.ITEMSET_ID and \n" + "P2.ITEM_ID = P4.ITEM_ID" + "\nand attribute_name is not null " + "\nORDER BY attribute_name ASC) ids, \n" + string2 + " cons_lookup" + "\nwhere ids.attribute_name = cons_lookup.KEY(+)");
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                String string3 = resultSet.getString("attribute_name");
                this.m_consequentItems.add(string3);
                this.m_antecedentItems.add(string3);
                if (!BrowserFrame.is11Server() || this._realAttributeName != null) continue;
                this._realAttributeName = resultSet.getString("real_attrname");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void setDetailText(int n) {
        AssociationRule associationRule = null;
        if (n < 0) {
            this.m_ruleDetail.setText(null);
            return;
        }
        try {
            associationRule = this.m_rulesTable.getMiningRule(n);
        }
        catch (Exception exception) {
            this.m_ruleDetail.setText(null);
            return;
        }
        if (associationRule != null) {
            String string = "IF\n";
            String string2 = "";
            Itemset itemset = associationRule.getAntecedent();
            Object[] objectArray = itemset.getItems();
            if (objectArray == null) {
                return;
            }
            for (int i = 0; i < objectArray.length; ++i) {
                string2 = string2 == "" ? string2 + objectArray[i].toString() : string2 + " AND " + objectArray[i].toString();
            }
            string = string + string2;
            string = string + "\n\n";
            string = string + "THEN\n";
            String string3 = "";
            Itemset itemset2 = associationRule.getConsequent();
            Object[] objectArray2 = itemset2.getItems();
            if (objectArray2 == null) {
                return;
            }
            for (int i = 0; i < objectArray2.length; ++i) {
                string3 = string3 == "" ? string3 + objectArray2[i].toString() : string3 + " AND " + objectArray2[i].toString();
            }
            string = string + string3;
            string = string + "\n\n";
            string = string + DM4JResourceUtilities.getUIString("COMMON_RULES_CONFIDENCE") + "=" + this.toPercent(associationRule.getConfidence());
            string = string + "\n";
            string = string + DM4JResourceUtilities.getUIString("COMMON_RULES_SUPPORT") + "=" + this.toPercent(associationRule.getSupport());
            this.m_ruleDetail.setText(string);
        }
    }

    private double toPercent(double d) {
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.setScale(2, 4);
        return bigDecimal.doubleValue();
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        TwoDSelection twoDSelection = (TwoDSelection)propertyChangeEvent.getOldValue();
        TwoDSelection twoDSelection2 = (TwoDSelection)propertyChangeEvent.getNewValue();
        this.m_exportButton.setEnabled(false);
        int n = twoDSelection2.getRowSelection().getSelectedItemCount();
        if (n > 1) {
            this.m_ruleDetail.setText(null);
            this.m_exportButton.setEnabled(true);
            return;
        }
        int n2 = twoDSelection2.getSingleRow();
        int n3 = twoDSelection.getSingleRow();
        if (n2 >= 0 && n2 != n3) {
            this.setDetailText(n2);
            this.m_exportButton.setEnabled(true);
        }
        if (n2 == -1) {
            this.m_ruleDetail.setText(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRulesCount() {
        int n = 0;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            String string = "SELECT count(*) as total_count FROM DM$P0<modelName> ";
            string = BrowserUtils.getReplacedString(string, "<modelName>", this.m_model.getName().toUpperCase());
            statement = connection.prepareStatement(string);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return n;
    }
}

