/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.activity;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JNumberTextField;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.steps.SampleStepOptions;
import oracle.dmt.dm4j.activity.wizard.AdvancedSettingsDialog;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.CaseCountDataSource;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;

public class SamplePanel
extends JPanel {
    private static int WIDTH = 450;
    private static int HEIGHT = 400;
    int tInd = 5;
    int lInd = 10;
    int bInd = 0;
    int rInd = 10;
    int wPad = 0;
    int hPad = 0;
    int l2Ind = 24;
    int bInstInd = 10;
    int tGroupInd = 10;
    int rowLength = 60;
    SampleStepOptions m_state;
    DM4JDialog m_parentDialog;
    GridBagLayout gridBagLayout = new GridBagLayout();
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JButton butRestore = new JButton();
    JLabel lblTotalNumberOfCases = new JLabel();
    JLabel lblTotalCaseCountValue = new JLabel();
    JButton butTotalCaseCountValue = new JButton();
    JLabel lblRandomSamplingType = new JLabel();
    JRadioButton radioRandomType = new JRadioButton();
    JRadioButton radioStratifiedType = new JRadioButton();
    JLabel lblCreateAs = new JLabel();
    JRadioButton radioTable = new JRadioButton();
    JRadioButton radioView = new JRadioButton();
    JPanel pnlSamplingSettings = new JPanel(new GridLayout(2, 2));
    JRadioButton radioNumberOfCases = new JRadioButton(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_NUMBER_OF_CASES"));
    DM4JNumberTextField fldNumberOfCases = new DM4JNumberTextField();
    JRadioButton radioPercentageOfCases = new JRadioButton(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_PERCENTAGE_OF_CASES"));
    DM4JNumberTextField fldPercentageOfCases = new DM4JNumberTextField();
    JLabel lblRandomNumberSeed = new JLabel();
    DM4JNumberTextField fldRandomNumberSeed = new DM4JNumberTextField();
    JLabel lblEqualDistribution = new JLabel();
    JRadioButton radioEqualDistributionYes = new JRadioButton();
    JRadioButton radioEqualDistributionNo = new JRadioButton();
    JLabel lblFiller = new JLabel();
    boolean m_ignoreModelBuildTypeEvent = false;
    boolean m_disable = false;
    AbstractActivity m_activity = null;
    SampleStepOptions m_copyState = null;

    public SamplePanel(DM4JDialog dM4JDialog, BrowserContext browserContext) throws Exception {
        this(dM4JDialog, browserContext, false);
    }

    public SamplePanel(DM4JDialog dM4JDialog, BrowserContext browserContext, boolean bl) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_activity = browserContext.getActivity();
        this.m_state = (SampleStepOptions)browserContext.getOptions();
        this.m_disable = bl;
        this.m_copyState = new SampleStepOptions(this.m_state);
        this.jbInit();
    }

    private void jbInit() throws Exception {
        Serializable serializable;
        this.setLayout(this.gridBagLayout);
        int n = 0;
        int n2 = 0;
        n2 = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_STEP_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.mlblStepDescription.setPreferredColumns(this.rowLength);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.add((Component)this.mlblStepDescription, new GridBagConstraints(n2, n, 3, 1, 1.0, 0.0, 17, 1, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        if (!this.m_disable) {
            this.butRestore.setText(ResourceUtilities.getUILabel("RESTORE_BUTTON"));
            this.butRestore.setMnemonic(ResourceUtilities.getUIMnemonic("RESTORE_BUTTON"));
            this.butRestore.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SamplePanel.this.butRestore_actionPerformed(actionEvent);
                }
            });
            this.m_parentDialog.addCustomButton(this.butRestore);
        }
        ++n;
        n2 = 0;
        this.lblTotalNumberOfCases.setText(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_TOTAL_NUMBER_OF_CASES"));
        this.lblTotalNumberOfCases.setLabelFor(this.lblTotalCaseCountValue);
        this.add((Component)this.lblTotalNumberOfCases, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 1;
        if (this.m_activity.getCaseCount() == 0) {
            serializable = new JPanel(new FlowLayout());
            this.lblTotalCaseCountValue.setLocale(Locale.getDefault());
            ((Container)serializable).add(this.lblTotalCaseCountValue);
            this.butTotalCaseCountValue = new JButton(ResourceUtilities.getUILabel("GET_CASE_COUNT"));
            this.butTotalCaseCountValue.setMnemonic(ResourceUtilities.getUIMnemonic("GET_CASE_COUNT"));
            this.butTotalCaseCountValue.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SamplePanel.this.butTotalCaseCountValue_actionPerformed(actionEvent);
                }
            });
            ((Container)serializable).add(this.butTotalCaseCountValue);
            this.add((Component)serializable, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        } else {
            this.add((Component)this.lblTotalCaseCountValue, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        }
        this.lblRandomSamplingType = new JLabel(ResourceUtilities.getUILabel("SAMPLE_TYPE"));
        this.radioRandomType = new JRadioButton(ResourceUtilities.getUILabel("SAMPLE_RANDOM"));
        this.radioRandomType.setMnemonic(ResourceUtilities.getUIMnemonic("SAMPLE_RANDOM"));
        this.radioRandomType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SamplePanel.this.radioRandomType_actionPerformed(actionEvent);
            }
        });
        this.radioStratifiedType = new JRadioButton(ResourceUtilities.getUILabel("SAMPLE_STRATIFIED"));
        this.radioStratifiedType.setMnemonic(ResourceUtilities.getUIMnemonic("SAMPLE_STRATIFIED"));
        this.radioStratifiedType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SamplePanel.this.radioStratifiedType_actionPerformed(actionEvent);
            }
        });
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this.radioRandomType);
        ((ButtonGroup)serializable).add(this.radioStratifiedType);
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.radioRandomType);
        jPanel.add(this.radioStratifiedType);
        ++n;
        n2 = 0;
        this.add((Component)this.lblRandomSamplingType, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 1;
        this.add((Component)jPanel, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        this.lblCreateAs = new JLabel(ResourceUtilities.getUILabel("VIEW_NAME_CREATE"));
        this.radioTable = new JRadioButton(ResourceUtilities.getUILabel("VIEW_NAME_CREATE_TABLE"));
        this.radioView = new JRadioButton(ResourceUtilities.getUILabel("VIEW_NAME_CREATE_VIEW"));
        this.radioTable.setMnemonic(ResourceUtilities.getUIMnemonic("VIEW_NAME_CREATE_TABLE"));
        this.radioView.setMnemonic(ResourceUtilities.getUIMnemonic("VIEW_NAME_CREATE_VIEW"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radioTable);
        buttonGroup.add(this.radioView);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(this.radioTable);
        jPanel2.add(this.radioView);
        ++n;
        n2 = 0;
        this.add((Component)this.lblCreateAs, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 1;
        this.add((Component)jPanel2, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 0;
        this.pnlSamplingSettings.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_BOX_TITLE")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.add((Component)this.pnlSamplingSettings, new GridBagConstraints(n2, n, 2, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        this.radioNumberOfCases.setMnemonic(ResourceUtilities.getUIMnemonic("SAMPLE_SETTINGS_NUMBER_OF_CASES"));
        this.radioNumberOfCases.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SamplePanel.this.radioPercentageOfCases_actionPerformed(actionEvent);
            }
        });
        this.radioPercentageOfCases.setMnemonic(ResourceUtilities.getUIMnemonic("SAMPLE_SETTINGS_PERCENTAGE_OF_CASES"));
        this.radioPercentageOfCases.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SamplePanel.this.radioPercentageOfCases_actionPerformed(actionEvent);
            }
        });
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.radioNumberOfCases);
        buttonGroup2.add(this.radioPercentageOfCases);
        this.pnlSamplingSettings.add(this.radioNumberOfCases);
        this.fldNumberOfCases.setLocale(Locale.getDefault());
        this.fldNumberOfCases.setDataType(Long.TYPE);
        this.fldNumberOfCases.setSigned(false);
        this.pnlSamplingSettings.add((Component)((Object)this.fldNumberOfCases));
        this.pnlSamplingSettings.add(this.radioPercentageOfCases);
        this.fldPercentageOfCases.setLocale(Locale.getDefault());
        this.fldPercentageOfCases.setDataType(Double.TYPE);
        this.fldPercentageOfCases.setSigned(false);
        this.pnlSamplingSettings.add((Component)((Object)this.fldPercentageOfCases));
        ++n;
        n2 = 0;
        this.lblRandomNumberSeed = new JLabel(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_RANDOM_NUMBER_SEED"));
        this.lblRandomNumberSeed.setLabelFor((Component)((Object)this.fldRandomNumberSeed));
        this.lblRandomNumberSeed.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("SAMPLE_SETTINGS_RANDOM_NUMBER_SEED"));
        this.add((Component)this.lblRandomNumberSeed, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 1;
        this.fldRandomNumberSeed.setLocale(Locale.getDefault());
        this.fldRandomNumberSeed.setDataType(Integer.TYPE);
        this.fldRandomNumberSeed.setSigned(false);
        this.add((Component)((Object)this.fldRandomNumberSeed), new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        this.lblEqualDistribution = new JLabel(ResourceUtilities.getUILabel("STRATIFIED_EQUAL_DSTRIBUTION"));
        this.radioEqualDistributionYes = new JRadioButton(ResourceUtilities.getUILabel("YES"));
        this.radioEqualDistributionNo = new JRadioButton(ResourceUtilities.getUILabel("NO"));
        this.radioEqualDistributionYes.setMnemonic(ResourceUtilities.getUIMnemonic("YES"));
        this.radioEqualDistributionNo.setMnemonic(ResourceUtilities.getUIMnemonic("NO"));
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.radioEqualDistributionYes);
        buttonGroup3.add(this.radioEqualDistributionNo);
        JPanel jPanel3 = new JPanel(new FlowLayout());
        jPanel3.add(this.radioEqualDistributionYes);
        jPanel3.add(this.radioEqualDistributionNo);
        ++n;
        n2 = 0;
        this.add((Component)this.lblEqualDistribution, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 1;
        this.add((Component)jPanel3, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 0;
        ++n;
        this.add((Component)this.lblFiller, new GridBagConstraints(n2, n, 3, 1, 1.0, 1.0, 17, 1, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        JComponent[] jComponentArray = new JComponent[]{this.fldNumberOfCases, this.fldPercentageOfCases, this.fldRandomNumberSeed};
        ResourceUtilities.setTextBoxSize(jComponentArray, 70, 20);
        if (!(this.m_parentDialog instanceof AdvancedSettingsDialog)) {
            this.addOKHelpCancelListeners();
        }
        this.loadState();
    }

    public void loadState() {
        this.setSampleSettings();
    }

    protected void setSampleSettings() {
        int n = this.m_activity.getCaseCount();
        if (n == 0) {
            this.lblTotalCaseCountValue.setText(ResourceUtilities.getUILabel("UNKNOWN_VALUE"));
        } else {
            this.lblTotalCaseCountValue.setText(n + "");
            this.butTotalCaseCountValue.setVisible(false);
        }
        if (this.m_state.isRandomSampling()) {
            this.radioRandomType.setSelected(true);
        } else {
            this.radioStratifiedType.setSelected(true);
        }
        if (this.m_state.isCreateTable()) {
            this.radioTable.setSelected(true);
        } else {
            this.radioView.setSelected(true);
        }
        if (this.m_state.isSampleByNumberOfCases()) {
            this.radioNumberOfCases.setSelected(true);
        } else {
            this.radioPercentageOfCases.setSelected(true);
        }
        Long l = this.m_state.getSampleNumOfCases();
        Double d = this.m_state.getSamplePercentage();
        if (n > 0) {
            if (l == null || l.intValue() == 0) {
                this.m_state.setSampleNumOfCases(new Long((long)((double)n * d / 100.0)));
            } else if (l.intValue() > n) {
                this.m_state.setSampleNumOfCases(new Long(n));
            }
            if (d == null) {
                this.m_state.setSamplePercentage(new Double(Math.min(100, l.intValue() / n * 100)));
            }
        }
        this.fldPercentageOfCases.setEnabled(!this.m_state.isSampleByNumberOfCases());
        this.fldPercentageOfCases.setNumber(d);
        this.fldNumberOfCases.setNumber(this.m_state.getSampleNumOfCases());
        this.fldNumberOfCases.setEnabled(this.m_state.isSampleByNumberOfCases());
        this.fldRandomNumberSeed.setNumber(this.m_state.getRandomSeed());
        if (this.m_state.isEqualDistribution()) {
            this.radioEqualDistributionYes.setSelected(true);
        } else {
            this.radioEqualDistributionNo.setSelected(true);
        }
        if (this.m_state.isRandomSampling()) {
            this.lblEqualDistribution.setVisible(false);
            this.radioEqualDistributionYes.setVisible(false);
            this.radioEqualDistributionNo.setVisible(false);
        } else {
            this.lblEqualDistribution.setVisible(true);
            this.radioEqualDistributionYes.setVisible(true);
            this.radioEqualDistributionNo.setVisible(true);
        }
        this.radioStratifiedType.setEnabled(this.m_state.isStratifiedAllowed());
    }

    public void processUserInput() {
        this.m_state.setRandomSampling(this.radioRandomType.isSelected());
        this.m_state.setCreateTable(this.radioTable.isSelected());
        this.m_state.setSampleByNumberOfCases(this.radioNumberOfCases.isSelected());
        this.m_state.setSampleNumOfCases((Long)this.fldNumberOfCases.getNumber());
        this.m_state.setSamplePercentage((Double)this.fldPercentageOfCases.getNumber());
        this.m_state.setRandomSeed((Integer)this.fldRandomNumberSeed.getNumber());
        this.m_state.setEqualDistribution(this.radioEqualDistributionYes.isSelected());
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SamplePanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                this.processUserInput();
                this.m_state.validate(vector);
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
            }
            catch (Exception exception) {}
        } else if ("cancel" == string) {
            this.m_state.restoreSettings(this.m_copyState);
        }
    }

    protected void butRestore_actionPerformed(ActionEvent actionEvent) {
        this.m_state.init(this.m_copyState.getActivityType());
        this.setSampleSettings();
    }

    protected void butTotalCaseCountValue_actionPerformed(ActionEvent actionEvent) {
        class TargetValuesThread
        extends LongRunningProcess {
            TargetValuesThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Connection connection = null;
                try {
                    connection = DM4JConnectionManager.getDbConnection();
                    CaseCountDataSource caseCountDataSource = null;
                    caseCountDataSource = new CaseCountDataSource(connection, SamplePanel.this.m_activity.getCaseTable().getSchema(), SamplePanel.this.m_activity.getCaseTable().getName());
                    caseCountDataSource.run();
                    int n = caseCountDataSource.getCaseCount();
                    SamplePanel.this.m_activity.setCaseCount(n);
                    SamplePanel.this.m_state.setCaseCount(n);
                }
                catch (Exception exception) {
                    this.setException(exception);
                }
                finally {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {}
                    this.getProgressBar().setDoneStatus();
                }
            }
        }
        TargetValuesThread targetValuesThread = new TargetValuesThread();
        ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getActivityUIString("TARGET_VALUE_EXTRACT_DIALOG_TITLE"), targetValuesThread, true);
        targetValuesThread.setProgressBar(progressBar);
        progressBar.start(DM4JResourceUtilities.getActivityUIString("TARGET_VALUE_EXTRACT_DESCRIPTION"), null);
        this.setSampleSettings();
    }

    protected void radioStratifiedType_actionPerformed(ActionEvent actionEvent) {
        if (this.radioStratifiedType.isSelected()) {
            this.m_state.setRandomSampling(false);
        } else {
            this.m_state.setRandomSampling(true);
        }
        this.setSampleSettings();
    }

    protected void radioRandomType_actionPerformed(ActionEvent actionEvent) {
        if (this.radioRandomType.isSelected()) {
            this.m_state.setRandomSampling(true);
        } else {
            this.m_state.setRandomSampling(false);
        }
        this.setSampleSettings();
    }

    protected void radioPercentageOfCases_actionPerformed(ActionEvent actionEvent) {
        int n = this.m_activity.getCaseCount();
        if (this.radioPercentageOfCases.isSelected()) {
            Long l = (Long)this.fldNumberOfCases.getNumber();
            Double d = new Double((double)l.intValue() / (double)n * 100.0);
            this.fldPercentageOfCases.setEnabled(true);
            this.fldPercentageOfCases.setNumber(d);
            this.fldNumberOfCases.setEnabled(false);
        } else {
            Double d = (Double)this.fldPercentageOfCases.getNumber();
            Long l = new Long((long)((double)n * d / 100.0));
            this.fldNumberOfCases.setEnabled(true);
            this.fldNumberOfCases.setNumber(l);
            this.fldPercentageOfCases.setEnabled(false);
        }
    }
}

