/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.activity;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.LinkedHashSet;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.HyperlinkButtonDataSource;
import oracle.dmt.dm4j.browser.viewer.activity.OutputDataViewerFrame;
import oracle.dmt.dm4j.browser.viewer.activity.RelatedTablesPickerFrame;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;

public class RelatedTablesPickerPanel
extends JScrollPane {
    private AbstractActivity m_activity = null;
    private RelatedTablesPickerFrame m_frame;

    public RelatedTablesPickerPanel(AbstractActivity abstractActivity, RelatedTablesPickerFrame relatedTablesPickerFrame) {
        this.m_frame = relatedTablesPickerFrame;
        this.m_activity = abstractActivity;
        this.jbinit();
    }

    private void jbinit() {
        RelatedTablesPickerPanelInternal relatedTablesPickerPanelInternal = new RelatedTablesPickerPanelInternal(this.m_frame);
        this.getViewport().add(relatedTablesPickerPanelInternal);
    }

    class RelatedTablesPickerPanelInternal
    extends GriddedPanel {
        JLabel m_instructionslbl = new JLabel();
        JLabel m_stepNamelbl = new JLabel();
        JLabel m_stepValuelbl = new JLabel();
        JLabel m_activityNamelbl = new JLabel();
        JLabel m_activityValuelbl = new JLabel();
        JLabel m_caseTableNamelbl = new JLabel();
        JLabel m_caseTestTableNamelbl = new JLabel();
        JLabel m_caseExplainTableNamelbl = new JLabel();
        JLabel m_caseMappingTableNamelbl = new JLabel();
        JLabel m_filler = new JLabel();
        RelatedTablesPickerFrame m_frame;
        static final String DOUBLE_QUOTE = "\"";

        public RelatedTablesPickerPanelInternal(RelatedTablesPickerFrame relatedTablesPickerFrame) {
            try {
                this.m_frame = relatedTablesPickerFrame;
                this.jbInit();
                this.runTimePanelLoad();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void jbInit() throws Exception {
            int n = 1;
            n = this.addRelatedTables(n);
            this.addFilledComponent(this.m_filler, TOPLABELITEMINSETS, n, 1, 2, 2, 1);
        }

        private int addRelatedTables(int n) {
            LinkedHashSet linkedHashSet = RelatedTablesPickerPanel.this.m_activity.getTables();
            if (linkedHashSet.size() > 0) {
                JLabel jLabel = new JLabel();
                jLabel.setText("Additional Tables:");
                this.addComponent(jLabel, TOPLABELITEMINSETS, n++, 1, 2, 1);
                Table table = RelatedTablesPickerPanel.this.m_activity.getCaseTable();
                for (Table table2 : linkedHashSet) {
                    if (table2.equals(table)) continue;
                    HyperlinkButtonDataSource hyperlinkButtonDataSource = this.createHyperlinkButtonDataSource(table2.getSchema(), table2.getName());
                    this.addComponent(hyperlinkButtonDataSource, MIDINDENTEDLABELITEMINSETS, n++, 2);
                }
            }
            return n;
        }

        private HyperlinkButtonDataSource createHyperlinkButtonDataSource(String string, String string2) {
            HyperlinkButtonDataSource hyperlinkButtonDataSource = new HyperlinkButtonDataSource(string, string2);
            hyperlinkButtonDataSource.setText(DOUBLE_QUOTE + string + "\".\"" + string2 + DOUBLE_QUOTE);
            hyperlinkButtonDataSource.setActive(true);
            hyperlinkButtonDataSource.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RelatedTablesPickerPanelInternal.this.selectOutputData_actionPerformed(actionEvent);
                }
            });
            return hyperlinkButtonDataSource;
        }

        private void runTimePanelLoad() throws Exception {
        }

        private void selectOutputData_actionPerformed(ActionEvent actionEvent) {
            try {
                final HyperlinkButtonDataSource hyperlinkButtonDataSource = (HyperlinkButtonDataSource)actionEvent.getSource();
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Connection connection = null;
                        try {
                            connection = DM4JConnectionManager.getDbConnection();
                            if (DatabaseMetadata.isTable(connection, hyperlinkButtonDataSource.getSchemaName(), hyperlinkButtonDataSource.getTableName())) {
                                hyperlinkButtonDataSource.setIsView(false);
                            } else {
                                hyperlinkButtonDataSource.setIsView(true);
                            }
                            OutputDataViewerFrame outputDataViewerFrame = new OutputDataViewerFrame(hyperlinkButtonDataSource);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        finally {
                            try {
                                connection.close();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                };
                Thread thread = new Thread(runnable);
                thread.setPriority(5);
                thread.start();
                this.m_frame.dispose();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

