/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.activity;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.activity.steps.ROCThresholdSelectionStepOptions;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ClassificationTestMetricsViewer;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ROCPanel;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;

public class ROCThresholdSelectionPanel
extends ROCPanel {
    ROCThresholdSelectionStepOptions m_state;
    DM4JDialog m_parentDialog;
    ROCThresholdSelectionStepOptions m_copyState = null;
    GriddedPanel m_descriptionPanel;
    JPanel m_selectedThresoldPanel;
    JLabel m_selectedThresoldValue = new JLabel();
    private JButton m_clear;

    public ROCThresholdSelectionPanel(ClassificationTestMetricsViewer classificationTestMetricsViewer, DM4JDialog dM4JDialog, ROCThresholdSelectionStepOptions rOCThresholdSelectionStepOptions) throws Exception {
        super(classificationTestMetricsViewer);
        super.setThresholdSelectionPanel(this);
        this.m_parentDialog = dM4JDialog;
        this.m_state = rOCThresholdSelectionStepOptions;
        this.m_copyState = new ROCThresholdSelectionStepOptions(rOCThresholdSelectionStepOptions);
        this.jbInit();
        this.addOKHelpCancelListeners();
        this.loadState();
    }

    private void jbInit() throws Exception {
        int n = 5;
        int n2 = 10;
        int n3 = 0;
        int n4 = 10;
        int n5 = 0;
        int n6 = 0;
        int n7 = 24;
        int n8 = 10;
        int n9 = 10;
        int n10 = 60;
        int n11 = 0;
        int n12 = 0;
        MultiLineLabel multiLineLabel = new MultiLineLabel();
        multiLineLabel.setText(DM4JResourceUtilities.getUIString("ROC_THRESHOLD_SELECTION_DESCRIPTION"));
        multiLineLabel.setPreferredRows(2);
        multiLineLabel.setMinimumRows(2);
        multiLineLabel.setPreferredColumns(n10);
        multiLineLabel.setTextWrapper(WordWrapper.getTextWrapper());
        this.m_descriptionPanel = new GriddedPanel();
        this.m_descriptionPanel.add((Component)multiLineLabel, new GridBagConstraints(n12, n11, 2, 1, 1.0, 0.0, 17, 1, new Insets(n, n2, n3, n4), n5, n6));
        n11 = 0;
        n12 = 0;
        this.m_selectedThresoldPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(DM4JResourceUtilities.getUIString("ACTIVITY_CURRENT_SELECTED_ROC_THRESHOLD"));
        this.m_selectedThresoldValue = new JLabel(this.getSelectedThresholdValue() + "");
        this.m_clear = new JButton(DM4JResourceUtilities.getUIString("COMMON_CLEAR"));
        this.m_clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ROCThresholdSelectionPanel.this.setSelectedThresholdValue(null);
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        Dimension dimension = new Dimension(60, 20);
        this.m_selectedThresoldValue.setMinimumSize(dimension);
        jPanel.add(jLabel);
        jPanel.add(this.m_selectedThresoldValue);
        jPanel.add(this.m_clear);
        this.m_selectedThresoldPanel.add((Component)jPanel, "East");
    }

    protected void loadState() {
        this.setROCThresholdSettings();
    }

    protected void setROCThresholdSettings() {
        if (this.m_state.getThresholdValue() != null) {
            this.setSelectedThresholdValue(this.m_state.getThresholdValue());
        }
    }

    protected void processUserInput() {
        this.m_state.setThresholdValue(this.getSelectedThresholdValue());
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ROCThresholdSelectionPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                this.processUserInput();
                this.m_state.validate(vector);
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
            }
            catch (Exception exception) {}
        } else if ("cancel" == string) {
            this.m_state.restoreSettings(this.m_copyState);
        }
    }

    protected void butRestore_actionPerformed(ActionEvent actionEvent) {
        this.m_state.init(this.m_copyState.getActivityType());
        this.setROCThresholdSettings();
    }

    public Double getSelectedThresholdValue() {
        return super.getSelectedThresholdValue();
    }

    public SortableTwoDModel getCostMatrixTableModel() {
        return super.getCostMatrixTableModel();
    }

    public ArrayOneDModel getColModel() {
        return super.getColModel();
    }

    public void setSelectedThresholdValue(Double d) {
        super.setSelectedThresholdValue(d);
        this.updateSelectedThresholdValue(d);
    }

    public void updateSelectedThresholdValue(Double d) {
        if (this.m_selectedThresoldValue != null) {
            if (d == null) {
                this.m_selectedThresoldValue.setText("None");
            } else {
                this.m_selectedThresoldValue.setText(d.toString());
            }
        }
    }

    public JPanel getDescriptionPanel() {
        return this.m_descriptionPanel;
    }

    public JPanel getSelectedThresoldPanel() {
        return this.m_selectedThresoldPanel;
    }
}

