/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.activity;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.datamining.data.AttributeDataType;
import javax.datamining.data.CategoryProperty;
import javax.datamining.data.CategorySet;
import javax.datamining.data.CategorySetFactory;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.classification.CostMatrix;
import javax.datamining.supervised.classification.CostMatrixFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.activity.steps.ROCThresholdSelectionStepOptions;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.activity.ROCThresholdSelectionPanel;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ClassificationTestMetricsViewer;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class ROCThresholdSelectionDialog
extends DM4JDialog {
    static int WIDTH = 800;
    static int HEIGHT = 800;
    private ROCThresholdSelectionStepOptions m_state;
    private JPanel m_rocPanel;
    private ROCThresholdSelectionPanel m_panel;
    private JDialog m_parentDialog;
    private JButton m_noThreshold;
    private ROCThresholdSelectionDialog m_dialog;
    private static String s_errorText;
    private static ProgressBar s_progressDlg;

    public ROCThresholdSelectionDialog(JDialog jDialog, ROCThresholdSelectionStepOptions rOCThresholdSelectionStepOptions, boolean bl) throws Exception {
        this((Dialog)jDialog, BrowserUtils.getActivityBundleInstance().getStringNoMnemonic("OPTION_SELECTION_ROC_THRESHOLD_DLG_TITLE"), 7);
        this.m_noThreshold = new JButton(DM4JResourceUtilities.getUIString("ACTIVITY_CLEAR_ROCTHRESHOLD"));
        this.m_noThreshold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ROCThresholdSelectionDialog.this.m_panel.setSelectedThresholdValue(null);
                ROCThresholdSelectionDialog.this.m_parentDialog.setVisible(false);
            }
        });
        if (bl) {
            this.setCancelButtonText(ResourceUtilities.getUILabel("CLOSE_BUTTON"));
            this.setOKButtonEnabled(false);
        }
        this.m_state = rOCThresholdSelectionStepOptions;
        this.m_parentDialog = jDialog;
        this.m_dialog = this;
        this.createPanel();
        DialogUtilities.displayDialog((DM4JDialog)this, this.m_rocPanel, new Dimension(WIDTH, HEIGHT), "dm4j_activity_selection_roc_threshold_html");
    }

    public ROCThresholdSelectionDialog(Dialog dialog, String string, int n) {
        super(dialog, string, n);
    }

    public Double getSelectedThresholdValue() {
        if (this.m_panel != null) {
            return this.m_panel.getSelectedThresholdValue();
        }
        return null;
    }

    public String createThresholdCostMatrix(String string) {
        String string2 = null;
        if (this.m_panel != null) {
            try {
                string2 = this.createCostMatrix(string, this.m_panel.getCostMatrixTableModel(), this.m_panel.getColModel());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createCostMatrix(String string, SortableTwoDModel sortableTwoDModel, ArrayOneDModel arrayOneDModel) throws Exception {
        java.sql.Connection connection = null;
        Connection connection2 = null;
        String string2 = string;
        try {
            String string3;
            if (sortableTwoDModel != null && arrayOneDModel != null) {
                connection = DM4JConnectionManager.getDbConnection();
                connection2 = DM4JConnectionManager.getConnection();
                string3 = DM4JStringUtils.trimDoubleQuotes(this.m_state.getTestMetricsName());
                if (string2 == null) {
                    string2 = ValidationUtil.createUniqueJDMObjectName(ValidationUtil.createNonQuotedCompliantName(string3), connection, "_C");
                }
                CostMatrixFactory costMatrixFactory = (CostMatrixFactory)connection2.getFactory("javax.datamining.supervised.classification.CostMatrix");
                CategorySetFactory categorySetFactory = (CategorySetFactory)connection2.getFactory("javax.datamining.data.CategorySet");
                CategorySet categorySet = null;
                if (arrayOneDModel.getItemCount() > 0) {
                    Object object = arrayOneDModel.getData(0);
                    categorySet = object instanceof Integer ? categorySetFactory.create(AttributeDataType.integerType) : (object instanceof String ? categorySetFactory.create(AttributeDataType.stringType) : (object instanceof Double || object instanceof Float ? categorySetFactory.create(AttributeDataType.doubleType) : categorySetFactory.create(AttributeDataType.stringType)));
                }
                for (int i = 0; i < arrayOneDModel.getItemCount(); ++i) {
                    categorySet.addCategory(arrayOneDModel.getData(i), CategoryProperty.valid);
                }
                CostMatrix costMatrix = costMatrixFactory.create(categorySet);
                for (int i = 0; i < arrayOneDModel.getItemCount(); ++i) {
                    for (int j = 0; j < arrayOneDModel.getItemCount(); ++j) {
                        costMatrix.setValue(arrayOneDModel.getData(i), arrayOneDModel.getData(j), (Double)sortableTwoDModel.getData(j, i));
                    }
                }
                connection2.saveObject(string2, costMatrix, true);
            }
            string3 = string2;
            return string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string4 = null;
            return string4;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (connection2 != null) {
                    connection2.close();
                }
            }
            catch (Exception exception) {
                string2 = null;
                exception.printStackTrace();
            }
        }
    }

    private void createPanel() {
        final DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                s_errorText = null;
                try {
                    try {
                        Connection connection = DM4JConnectionManager.getConnection();
                        LeafNodeData leafNodeData = new LeafNodeData(ROCThresholdSelectionDialog.this.m_state.getTestMetricsName(), "TEST_METRIC_RESULT");
                        leafNodeData.loadOdmObject(connection);
                        ClassificationTestMetricsViewer classificationTestMetricsViewer = new ClassificationTestMetricsViewer(leafNodeData, connection, -1);
                        long l = System.currentTimeMillis() / 1000L;
                        long l2 = 0L;
                        long l3 = 60L;
                        while (classificationTestMetricsViewer.getROCName() == null && (l2 = System.currentTimeMillis() / 1000L) - l < l3) {
                        }
                        ROCThresholdSelectionDialog.this.m_panel = new ROCThresholdSelectionPanel(classificationTestMetricsViewer, ROCThresholdSelectionDialog.this.m_dialog, ROCThresholdSelectionDialog.this.m_state);
                        ROCThresholdSelectionDialog.this.m_rocPanel = new JPanel(new BorderLayout());
                        ROCThresholdSelectionDialog.this.m_rocPanel.add((Component)ROCThresholdSelectionDialog.this.m_panel.getDescriptionPanel(), "North");
                        ROCThresholdSelectionDialog.this.m_rocPanel.add((Component)ROCThresholdSelectionDialog.this.m_panel, "Center");
                        ROCThresholdSelectionDialog.this.m_rocPanel.add((Component)ROCThresholdSelectionDialog.this.m_panel.getSelectedThresoldPanel(), "South");
                    }
                    catch (Exception exception) {
                        throw new Exception(dM4JListResourceBundle.getString("ERROR_LOAD_OBJECT"));
                    }
                }
                catch (Exception exception) {
                    s_errorText = exception.getLocalizedMessage();
                }
                finally {
                    s_progressDlg.setDoneStatus();
                }
            }
        };
        s_progressDlg = new ProgressBar(BrowserFrame.getMainFrame(), dM4JListResourceBundle.getString("ROC_THRESHOLD_SELECTION_PROGRESS_NAME"), runnable, true);
        s_progressDlg.start(dM4JListResourceBundle.getString("ROC_THRESHOLD_SELECTION_PROGRESS_TITLE"), "");
        s_progressDlg.waitUntilDone();
        if (s_errorText != null) {
            JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), s_errorText, DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
        }
    }
}

