/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.activity;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JNumberTextField;
import oracle.dmt.dm4j.activity.steps.OClusterBuildStepOptions;
import oracle.dmt.dm4j.activity.wizard.AdvancedSettingsDialog;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;

public class OClusterPanel
extends JPanel {
    OClusterBuildStepOptions m_state;
    DM4JDialog m_parentDialog;
    GridBagLayout gridBagLayout = new GridBagLayout();
    MultiLineLabel mlblStepDescription_1 = new MultiLineLabel();
    MultiLineLabel mlblStepDescription_2 = new MultiLineLabel();
    JButton butRestore = new JButton();
    JLabel lblOClusterMaxNumberOfClusters = new JLabel();
    DM4JNumberTextField txtOClusterMaxNumberOfClusters = new DM4JNumberTextField();
    JLabel lblSensitivityHint1 = new JLabel();
    DM4JNumberTextField txtSensitivity = new DM4JNumberTextField();
    JLabel lblSensitivity = new JLabel();
    JLabel lblMaximumBufferSizeHint1 = new JLabel();
    DM4JNumberTextField txtMaximumBufferSize = new DM4JNumberTextField();
    JLabel lblMaximumBufferSize = new JLabel();
    JLabel lblFiller = new JLabel();
    Double priorSensitivity;
    Long priorMaximumBufferSize;
    Integer priorOClusterMaxNumberOfClusters;
    boolean m_disable = false;
    OClusterBuildStepOptions m_copyState = null;

    public OClusterPanel(DM4JDialog dM4JDialog, OClusterBuildStepOptions oClusterBuildStepOptions) throws Exception {
        this(dM4JDialog, oClusterBuildStepOptions, false);
    }

    public OClusterPanel(DM4JDialog dM4JDialog, OClusterBuildStepOptions oClusterBuildStepOptions, boolean bl) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = oClusterBuildStepOptions;
        this.m_disable = bl;
        this.m_copyState = new OClusterBuildStepOptions(oClusterBuildStepOptions);
        this.jbInit();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout);
        int n = 0;
        int n2 = 0;
        int n3 = 5;
        int n4 = 10;
        int n5 = 0;
        int n6 = 10;
        int n7 = 0;
        int n8 = 0;
        int n9 = 24;
        int n10 = 10;
        int n11 = 10;
        int n12 = 60;
        n2 = 0;
        this.mlblStepDescription_1.setText(ResourceUtilities.getUILabel("ALGO_OCLUSTER_DESCRIPTION_1"));
        this.mlblStepDescription_1.setPreferredRows(2);
        this.mlblStepDescription_1.setMinimumRows(2);
        this.mlblStepDescription_1.setPreferredColumns(n12);
        this.mlblStepDescription_1.setTextWrapper(WordWrapper.getTextWrapper());
        this.add((Component)this.mlblStepDescription_1, new GridBagConstraints(n2, n, 2, 1, 1.0, 0.0, 17, 1, new Insets(n3, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.mlblStepDescription_2.setText(ResourceUtilities.getUILabel("ALGO_OCLUSTER_DESCRIPTION_2"));
        this.mlblStepDescription_2.setPreferredRows(2);
        this.mlblStepDescription_2.setMinimumRows(2);
        this.mlblStepDescription_2.setPreferredColumns(n12);
        this.mlblStepDescription_2.setTextWrapper(WordWrapper.getTextWrapper());
        this.add((Component)this.mlblStepDescription_2, new GridBagConstraints(n2, n, 2, 1, 1.0, 0.0, 17, 1, new Insets(n3, n4, n5, n6), n7, n8));
        if (!this.m_disable) {
            this.butRestore.setText(ResourceUtilities.getUILabel("RESTORE_BUTTON"));
            this.butRestore.setMnemonic(ResourceUtilities.getUIMnemonic("RESTORE_BUTTON"));
            this.butRestore.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OClusterPanel.this.butRestore_actionPerformed(actionEvent);
                }
            });
            this.m_parentDialog.addCustomButton(this.butRestore);
        }
        ++n;
        this.lblOClusterMaxNumberOfClusters.setText(ResourceUtilities.getUILabel("OCLUSTER_MAX_NUMBER_CLUSTERS"));
        this.lblOClusterMaxNumberOfClusters.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("OCLUSTER_MAX_NUMBER_CLUSTERS"));
        this.lblOClusterMaxNumberOfClusters.setLabelFor((Component)((Object)this.txtOClusterMaxNumberOfClusters));
        this.add((Component)this.lblOClusterMaxNumberOfClusters, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        this.txtOClusterMaxNumberOfClusters.setLocale(Locale.getDefault());
        this.txtOClusterMaxNumberOfClusters.setDataType(Integer.TYPE);
        this.txtOClusterMaxNumberOfClusters.setSigned(false);
        this.add((Component)((Object)this.txtOClusterMaxNumberOfClusters), new GridBagConstraints(++n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.lblSensitivity.setText(ResourceUtilities.getUILabel("ALGO_OCLUSTER_SENSITIVITY"));
        this.lblSensitivity.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("ALGO_OCLUSTER_SENSITIVITY"));
        this.lblSensitivity.setLabelFor((Component)((Object)this.txtSensitivity));
        this.add((Component)this.lblSensitivity, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n2;
        this.txtSensitivity.setLocale(Locale.getDefault());
        this.txtSensitivity.setDecimal(true, 9);
        this.txtSensitivity.setDataType(Double.class);
        this.txtSensitivity.setSigned(false);
        this.add((Component)((Object)this.txtSensitivity), new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n;
        n2 = 1;
        this.lblSensitivityHint1.setText(ResourceUtilities.getUILabel("ALGO_OCLUSTER_SENSITIVITY_HINT1"));
        this.txtSensitivity.getAccessibleContext().setAccessibleDescription(this.lblSensitivityHint1.getText());
        this.add((Component)this.lblSensitivityHint1, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.lblMaximumBufferSize.setText(ResourceUtilities.getUILabel("ALGO_OCLUSTER_MAXIMUM_BUFFER_SIZE"));
        this.lblMaximumBufferSize.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("ALGO_OCLUSTER_MAXIMUM_BUFFER_SIZE"));
        this.lblMaximumBufferSize.setLabelFor((Component)((Object)this.txtMaximumBufferSize));
        this.add((Component)this.lblMaximumBufferSize, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n2;
        this.txtMaximumBufferSize.setLocale(Locale.getDefault());
        this.txtMaximumBufferSize.setDataType(Long.TYPE);
        this.txtMaximumBufferSize.setSigned(false);
        this.add((Component)((Object)this.txtMaximumBufferSize), new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n;
        n2 = 1;
        this.lblMaximumBufferSizeHint1.setText(ResourceUtilities.getUILabel("ALGO_OCLUSTER_MAXIMUM_BUFFER_SIZE_HINT"));
        this.txtMaximumBufferSize.getAccessibleContext().setAccessibleDescription(this.lblMaximumBufferSizeHint1.getText());
        this.add((Component)this.lblMaximumBufferSizeHint1, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, n4, n5, n6), n7, n8));
        n2 = 0;
        ++n;
        this.add((Component)this.lblFiller, new GridBagConstraints(n2, n, 2, 1, 1.0, 1.0, 17, 1, new Insets(n3, n4, n5, n6), n7, n8));
        JComponent[] jComponentArray = new JComponent[]{this.txtOClusterMaxNumberOfClusters, this.txtSensitivity, this.txtMaximumBufferSize};
        ResourceUtilities.setTextBoxSize(jComponentArray, 60, 20);
        if (!(this.m_parentDialog instanceof AdvancedSettingsDialog)) {
            this.addOKHelpCancelListeners();
        }
        this.savePriorState();
        this.init();
    }

    protected void init() {
        this.setSettings();
        this.savePriorState();
    }

    protected void setSettings() {
        this.txtSensitivity.setNumber(this.m_state.getSensitivity());
        this.txtMaximumBufferSize.setNumber(this.m_state.getMaximumBufferSize());
        this.txtOClusterMaxNumberOfClusters.setNumber(this.m_state.getOclusterNumberOfClusters());
    }

    protected void savePriorState() {
        this.priorSensitivity = this.m_state.getSensitivity();
        this.priorMaximumBufferSize = this.m_state.getMaximumBufferSize();
        this.priorOClusterMaxNumberOfClusters = this.m_state.getOclusterNumberOfClusters();
    }

    protected void restorePriorState() {
        this.m_state.setSensitivity(this.priorSensitivity);
        this.m_state.setMaximumBufferSize(this.priorMaximumBufferSize);
        this.m_state.setOclusterNumberOfClusters(this.priorOClusterMaxNumberOfClusters);
    }

    public void processUserInput() {
        this.m_state.setSensitivity((Double)this.txtSensitivity.getNumber());
        this.m_state.setMaximumBufferSize((Long)this.txtMaximumBufferSize.getNumber());
        this.m_state.setOclusterNumberOfClusters((Integer)this.txtOClusterMaxNumberOfClusters.getNumber());
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OClusterPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                this.processUserInput();
                this.m_state.validate(vector);
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
            }
            catch (Exception exception) {
                DialogUtilities.createSystemErrorDialog(BrowserFrame.getMainFrame(), exception);
                this.restorePriorState();
            }
        } else if ("cancel" == string) {
            this.restorePriorState();
        }
    }

    protected void butRestore_actionPerformed(ActionEvent actionEvent) {
        this.m_state.init(null);
        this.setSettings();
    }
}

