/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.activity;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.activity.steps.NormalizeStepOptions;
import oracle.dmt.dm4j.activity.wizard.AdvancedSettingsDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;

public class NormalizePanel
extends JPanel {
    private static int WIDTH = 450;
    private static int HEIGHT = 400;
    int tInd = 5;
    int lInd = 10;
    int bInd = 0;
    int rInd = 10;
    int wPad = 0;
    int hPad = 0;
    int l2Ind = 24;
    int bInstInd = 10;
    int tGroupInd = 10;
    int rowLength = 60;
    NormalizeStepOptions m_state;
    DM4JDialog m_parentDialog;
    GridBagLayout gridBagLayout = new GridBagLayout();
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JButton butRestore = new JButton();
    JLabel lblTotalNumberOfCases = new JLabel();
    JLabel lblTotalCaseCountValue = new JLabel();
    ButtonGroup m_nonSparseChoices = new ButtonGroup();
    ButtonGroup m_sparseChoices = new ButtonGroup();
    JLabel lblNonSparseSchemes = new JLabel();
    JLabel lblSparseSchemes = new JLabel();
    JRadioButton m_minMax = new JRadioButton();
    JLabel lblmin = new JLabel();
    JLabel lblmax = new JLabel();
    NumberTextField txtMinValue = new NumberTextField();
    NumberTextField txtMaxValue = new NumberTextField();
    JLabel lblzScore = new JLabel();
    JRadioButton m_zScore = new JRadioButton();
    JLabel lblLinScale = new JLabel();
    JRadioButton m_linScale = new JRadioButton();
    JLabel lblFiller = new JLabel();
    boolean m_disable = false;
    NormalizeStepOptions m_copyState = null;

    public NormalizePanel(DM4JDialog dM4JDialog, NormalizeStepOptions normalizeStepOptions) throws Exception {
        this(dM4JDialog, normalizeStepOptions, false);
    }

    public NormalizePanel(DM4JDialog dM4JDialog, NormalizeStepOptions normalizeStepOptions, boolean bl) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = normalizeStepOptions;
        this.m_disable = bl;
        this.m_copyState = new NormalizeStepOptions(normalizeStepOptions);
        this.jbInit();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout);
        int n = 0;
        int n2 = 0;
        n2 = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("NORMALIZE_SETTINGS_STEP_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.mlblStepDescription.setPreferredColumns(this.rowLength);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.add((Component)this.mlblStepDescription, new GridBagConstraints(n2, n, 3, 1, 1.0, 0.0, 17, 1, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        if (!this.m_disable) {
            this.butRestore.setText(ResourceUtilities.getUILabel("RESTORE_BUTTON"));
            this.butRestore.setMnemonic(ResourceUtilities.getUIMnemonic("RESTORE_BUTTON"));
            this.butRestore.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NormalizePanel.this.butRestore_actionPerformed(actionEvent);
                }
            });
            this.m_parentDialog.addCustomButton(this.butRestore);
        }
        this.m_minMax.setText(ResourceUtilities.getUILabel("NORMALIZATION_MINMAX_OPTION"));
        this.m_minMax.setMnemonic(ResourceUtilities.getUIMnemonic("NORMALIZATION_MINMAX_OPTION"));
        this.txtMinValue.setLocale(Locale.getDefault());
        this.txtMinValue.setDataType(Double.TYPE);
        this.txtMinValue.setNumber((Number)new Float(0.0));
        this.lblmin.setText(ResourceUtilities.getUILabel("MIN"));
        this.lblmin.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("MIN"));
        this.lblmin.setLabelFor((Component)this.txtMinValue);
        this.txtMaxValue.setLocale(Locale.getDefault());
        this.txtMaxValue.setDataType(Double.TYPE);
        this.txtMaxValue.setNumber((Number)new Float(0.0));
        this.lblmax.setText(ResourceUtilities.getUILabel("MAX"));
        this.lblmax.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("MAX"));
        this.lblmax.setLabelFor((Component)this.txtMaxValue);
        this.m_zScore.setText(ResourceUtilities.getUILabel("NORMALIZATION_ZSCORE_OPTION"));
        this.m_zScore.setMnemonic(ResourceUtilities.getUIMnemonic("NORMALIZATION_ZSCORE_OPTION"));
        this.m_linScale.setText(ResourceUtilities.getUILabel("NORMALIZATION_LINSCALE_OPTION"));
        this.m_linScale.setMnemonic(ResourceUtilities.getUIMnemonic("NORMALIZATION_LINSCALE_OPTION"));
        this.m_nonSparseChoices.add(this.m_minMax);
        this.m_nonSparseChoices.add(this.m_zScore);
        this.m_sparseChoices.add(this.m_linScale);
        ++n;
        n2 = 0;
        this.lblNonSparseSchemes.setText(ResourceUtilities.getUILabel("NORMALIZATION_NONSPARSE_SCHEMES"));
        this.add((Component)this.lblNonSparseSchemes, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.lblmin);
        jPanel.add((Component)this.txtMinValue);
        jPanel.add(this.lblmax);
        jPanel.add((Component)this.txtMaxValue);
        ++n;
        n2 = 0;
        this.add((Component)this.m_minMax, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd, this.lInd + this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 1;
        this.add((Component)jPanel, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd, this.lInd + this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 0;
        this.add((Component)this.m_zScore, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd, this.lInd + this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 0;
        this.lblSparseSchemes.setText(ResourceUtilities.getUILabel("NORMALIZATION_SPARSE_SCHEMES"));
        this.add((Component)this.lblSparseSchemes, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 0;
        this.add((Component)this.m_linScale, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd, this.lInd + this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 0;
        ++n;
        this.add((Component)this.lblFiller, new GridBagConstraints(n2, n, 3, 1, 1.0, 1.0, 17, 1, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        JComponent[] jComponentArray = new JComponent[]{this.txtMinValue, this.txtMaxValue};
        ResourceUtilities.setTextBoxSize(jComponentArray, 70, 20);
        if (!(this.m_parentDialog instanceof AdvancedSettingsDialog)) {
            this.addOKHelpCancelListeners();
        }
        this.loadState();
    }

    protected void loadState() {
        this.setNormalizeSettings();
    }

    protected void setNormalizeSettings() {
        this.lblTotalCaseCountValue.setText(this.m_state.getCaseCount() + "");
        if (this.m_state.isMinMaxScheme()) {
            this.m_minMax.setSelected(true);
        } else {
            this.m_zScore.setSelected(true);
        }
        if (this.m_state.isLinScaleScheme()) {
            this.m_linScale.setSelected(true);
        }
        this.txtMinValue.setNumber((Number)new Float(this.m_state.getMinValue()));
        this.txtMaxValue.setNumber((Number)new Float(this.m_state.getMaxValue()));
    }

    public void processUserInput() {
        if (this.m_minMax.isSelected()) {
            this.m_state.setMinMaxScheme(true);
        } else {
            this.m_state.setMinMaxScheme(false);
        }
        if (this.m_linScale.isSelected()) {
            this.m_state.setLinScaleScheme(true);
        }
        if (this.txtMinValue.getNumber() != null) {
            this.m_state.setMinValue(this.txtMinValue.getNumber().floatValue());
        }
        if (this.txtMaxValue.getNumber() != null) {
            this.m_state.setMaxValue(this.txtMaxValue.getNumber().floatValue());
        }
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NormalizePanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                this.processUserInput();
                this.m_state.validate(vector);
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
            }
            catch (Exception exception) {}
        } else if ("cancel" == string) {
            this.m_state.restoreSettings(this.m_copyState);
        }
    }

    protected void butRestore_actionPerformed(ActionEvent actionEvent) {
        this.m_state.init(this.m_copyState.getActivityType());
        this.setNormalizeSettings();
    }
}

