/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.activity;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.ClassificationTestMetricStepOptions;
import oracle.dmt.dm4j.activity.steps.NaiveBayesBuildStepOptions;
import oracle.dmt.dm4j.activity.steps.TestMetricStep;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.viewer.activity.NaiveBayesAlgoPanel;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;

public class NaiveBayesPanel
extends JTabbedPane {
    int tInd = 5;
    int lInd = 10;
    int bInd = 0;
    int rInd = 10;
    int wPad = 0;
    int hPad = 0;
    int l2Ind = 24;
    int bInstInd = 10;
    int tGroupInd = 10;
    int rowLength = 60;
    NaiveBayesBuildStepOptions m_state;
    DM4JDialog m_parentDialog;
    GridBagLayout gridBagLayout = new GridBagLayout();
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblAccuracyType = new JLabel();
    JRadioButton optMaxOverallAccuracy = new JRadioButton();
    JRadioButton optMaxAverageAccuracy = new JRadioButton();
    ButtonGroup groupAccuracy = new ButtonGroup();
    JLabel lblTargetType = new JLabel();
    JRadioButton optTargetMulticase = new JRadioButton();
    JRadioButton optTargetBinary = new JRadioButton();
    ButtonGroup groupTarget = new ButtonGroup();
    JLabel lblTargetValue = new JLabel();
    JComboBox comboTargetValue = new JComboBox();
    JLabel lblSelectedTargetValue = new JLabel();
    DefaultComboBoxModel targetValueModel;
    JButton butRestore = new JButton();
    JLabel lblFiller = new JLabel();
    boolean m_ignoreTargetValueComboEvent = false;
    AbstractActivity m_activity = null;
    NaiveBayesBuildStepOptions m_copyState = null;
    boolean m_disable = false;
    boolean m_advance = false;
    NaiveBayesAlgoPanel m_algorithmPanel = null;

    public NaiveBayesPanel(DM4JDialog dM4JDialog, BrowserContext browserContext, boolean bl) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_activity = browserContext.getActivity();
        this.m_state = (NaiveBayesBuildStepOptions)browserContext.getOptions();
        this.m_advance = browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_ADVANCED);
        this.m_disable = bl;
        this.m_copyState = new NaiveBayesBuildStepOptions(this.m_state);
        this.jbInit();
    }

    private void jbInit() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getActivityBundleInstance();
        this.m_algorithmPanel = new NaiveBayesAlgoPanel(this.m_parentDialog, this.m_state, this.m_disable);
        JComponent jComponent = this.makeGeneralTab();
        this.addTab(dM4JListResourceBundle.getStringNoMnemonic("OPTION_GENERAL_TAB_TITLE"), null, jComponent, dM4JListResourceBundle.getStringNoMnemonic("OPTION_GENERAL_TAB_TITLE"));
        this.addTab(dM4JListResourceBundle.getStringNoMnemonic("OPTION_ALGORITHM_TAB_TITLE"), null, this.m_algorithmPanel, dM4JListResourceBundle.getStringNoMnemonic("OPTION_ALGORITHM_TAB_TITLE"));
        this.setSelectedIndex(0);
        if (!this.m_disable) {
            this.butRestore.setText(ResourceUtilities.getUILabel("RESTORE_BUTTON"));
            this.butRestore.setMnemonic(ResourceUtilities.getUIMnemonic("RESTORE_BUTTON"));
            this.butRestore.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NaiveBayesPanel.this.butRestore_actionPerformed(actionEvent);
                }
            });
            this.m_parentDialog.addCustomButton(this.butRestore);
        }
        this.addOKHelpCancelListeners();
    }

    private JComponent makeGeneralTab() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getActivityBundleInstance();
        GriddedPanel griddedPanel = new GriddedPanel();
        int n = 0;
        int n2 = 0;
        if (!this.m_advance) {
            this.lblTargetValue.setText(dM4JListResourceBundle.getStringNoMnemonic("TARGET_VALUE_TARGET_SELECTION"));
            this.lblTargetValue.setDisplayedMnemonic(dM4JListResourceBundle.getMnemonic("TARGET_VALUE_TARGET_SELECTION"));
            this.lblTargetValue.setLabelFor(this.comboTargetValue);
            griddedPanel.add((Component)this.lblTargetValue, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
            n2 = 1;
            griddedPanel.add((Component)this.comboTargetValue, new GridBagConstraints(n2, n, 2, 1, 0.0, 0.0, 18, 0, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
            ++n;
        }
        n2 = 0;
        this.lblAccuracyType.setText(dM4JListResourceBundle.getStringNoMnemonic("TARGET_VALUE_ACCURACY_TYPE"));
        this.lblAccuracyType.setDisplayedMnemonic(dM4JListResourceBundle.getMnemonic("TARGET_VALUE_ACCURACY_TYPE"));
        griddedPanel.add((Component)this.lblAccuracyType, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 0;
        this.optMaxAverageAccuracy.setText(dM4JListResourceBundle.getStringNoMnemonic("TARGET_VALUE_AVERAGE_ACCURACY"));
        this.groupAccuracy.add(this.optMaxAverageAccuracy);
        this.optMaxAverageAccuracy.setMnemonic(dM4JListResourceBundle.getMnemonic("TARGET_VALUE_AVERAGE_ACCURACY"));
        this.optMaxAverageAccuracy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NaiveBayesPanel.this.optAccuracy_actionPerformed(actionEvent);
            }
        });
        griddedPanel.add((Component)this.optMaxAverageAccuracy, new GridBagConstraints(n2, n, 3, 1, 0.0, 0.0, 18, 0, new Insets(this.tInd, this.lInd + this.l2Ind, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 0;
        this.optMaxOverallAccuracy.setText(dM4JListResourceBundle.getStringNoMnemonic("TARGET_VALUE_OVERALL_ACCURACY"));
        this.groupAccuracy.add(this.optMaxOverallAccuracy);
        this.optMaxOverallAccuracy.setMnemonic(dM4JListResourceBundle.getMnemonic("TARGET_VALUE_OVERALL_ACCURACY"));
        this.optMaxOverallAccuracy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NaiveBayesPanel.this.optAccuracy_actionPerformed(actionEvent);
            }
        });
        griddedPanel.add((Component)this.optMaxOverallAccuracy, new GridBagConstraints(n2, n, 3, 1, 0.0, 0.0, 18, 0, new Insets(this.tInd, this.lInd + this.l2Ind, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 0;
        this.lblFiller = new JLabel();
        griddedPanel.add((Component)this.lblFiller, new GridBagConstraints(n2, ++n, 3, 3, 1.0, 1.0, 18, 1, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        JComponent[] jComponentArray = new JComponent[]{this.comboTargetValue};
        ResourceUtilities.setTextBoxSize(jComponentArray, 120, 20);
        this.loadState();
        return griddedPanel;
    }

    protected void loadState() {
        this.loadTargetValueCombo();
        this.setTargetSettings();
        this.m_algorithmPanel.loadState();
    }

    protected void setTargetSettings() {
        boolean bl = this.m_state.isCurWeightedScore();
        this.optMaxOverallAccuracy.setSelected(!bl);
        this.optMaxAverageAccuracy.setSelected(bl);
        boolean bl2 = this.m_state.isCurBinaryClass();
        this.optTargetMulticase.setSelected(!bl2);
        this.comboTargetValue.setEnabled(bl2);
        this.optTargetBinary.setSelected(bl2);
        this.comboTargetValue.setSelectedItem(this.m_state.getCurTargetValue());
    }

    protected void processUserInput() {
        boolean bl = this.optMaxAverageAccuracy.isSelected();
        boolean bl2 = this.optTargetBinary.isSelected();
        String string = (String)this.comboTargetValue.getSelectedItem();
        this.m_state.setCurWeightedScore(bl);
        this.m_state.setCurBinaryClass(bl2);
        this.m_state.setCurTargetValue(string);
        this.m_algorithmPanel.processUserInput();
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NaiveBayesPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                this.processUserInput();
                this.m_state.validate(vector);
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
            }
            catch (Exception exception) {}
        } else if ("cancel" == string) {
            this.m_state.restoreSettings(this.m_copyState);
        }
    }

    protected void butRestore_actionPerformed(ActionEvent actionEvent) {
        this.m_state.restoreToDefaultSettings(this.m_activity);
        this.setTargetSettings();
        this.m_algorithmPanel.butRestore_actionPerformed(actionEvent);
    }

    protected void optAccuracy_actionPerformed(ActionEvent actionEvent) {
        boolean bl = !this.optMaxOverallAccuracy.isSelected();
        this.m_state.setCurWeightedScore(bl);
        TestMetricStep testMetricStep = this.m_activity.findTestMetricStep();
        if (testMetricStep != null) {
            ClassificationTestMetricStepOptions classificationTestMetricStepOptions = (ClassificationTestMetricStepOptions)testMetricStep.getStepOptions();
            classificationTestMetricStepOptions.initTargetValues(ActivityType.NAIVE_BAYES, classificationTestMetricStepOptions.getTargetPrior(), classificationTestMetricStepOptions.getCurTargetValue(), classificationTestMetricStepOptions.getCurCostMatrix(), bl);
            classificationTestMetricStepOptions.initOptions(ActivityType.NAIVE_BAYES, classificationTestMetricStepOptions.getCurTargetValue());
            this.m_activity.setUseTestCostMatrix(bl);
        }
    }

    protected void optTarget_actionPerformed(ActionEvent actionEvent) {
        if (this.optTargetMulticase.isSelected()) {
            this.m_state.setCurBinaryClass(false);
            this.comboTargetValue.setEnabled(false);
        } else {
            this.m_state.setCurBinaryClass(true);
            this.comboTargetValue.setEnabled(true);
        }
    }

    protected void loadTargetValueCombo() {
        this.m_ignoreTargetValueComboEvent = true;
        this.targetValueModel = new DefaultComboBoxModel<Object>(this.m_activity.getTargetPriors().keySet().toArray());
        this.targetValueModel.setSelectedItem(this.m_state.getCurTargetValue());
        this.comboTargetValue.setModel(this.targetValueModel);
        this.comboTargetValue.setSelectedItem(this.m_state.getCurTargetValue());
        this.m_ignoreTargetValueComboEvent = false;
    }
}

