/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.activity;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.datamining.algorithm.kmeans.ClusteringDistanceFunction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JNumberTextField;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.steps.KMeansBuildStepOptions;
import oracle.dmt.dm4j.activity.wizard.AdvancedSettingsDialog;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.jdm.algorithm.kmeans.OraClusteringDistanceFunction;
import oracle.dmt.jdm.algorithm.kmeans.OraSplitCriterion;

public class KMeansPanel
extends JPanel {
    KMeansBuildStepOptions m_state;
    DM4JDialog m_parentDialog;
    GridBagLayout gridBagLayout = new GridBagLayout();
    MultiLineLabel mlblStepDescription_1 = new MultiLineLabel();
    MultiLineLabel mlblStepDescription_2 = new MultiLineLabel();
    JButton butRestore = new JButton();
    JLabel lblKMeansMaxNumberOfClusters = new JLabel();
    DM4JNumberTextField txtKMeansMaxNumberOfClusters = new DM4JNumberTextField();
    JLabel lblMinimumErrorToleranceHint1 = new JLabel();
    DM4JNumberTextField txtMinimumErrorTolerance = new DM4JNumberTextField();
    JLabel lblMinimumErrorTolerance = new JLabel();
    JLabel lblMaximumIterationsHint1 = new JLabel();
    DM4JNumberTextField txtMaximumIterations = new DM4JNumberTextField();
    JLabel lblMaximumIterations = new JLabel();
    JLabel lblDistanceFunction = new JLabel();
    JComboBox comboDistanceFunction = new JComboBox();
    boolean m_ignoreDistanceFunctionEvent = false;
    DefaultComboBoxModel m_distanceFunctionModel;
    JLabel lblSplitCriterion = new JLabel();
    JComboBox comboSplitCriterion = new JComboBox();
    boolean m_ignoreSplitCriterionEvent = false;
    DefaultComboBoxModel m_splitCriterionModel;
    JLabel lblMinimumSupportHint1 = new JLabel();
    DM4JNumberTextField txtMinimumSupport = new DM4JNumberTextField();
    JLabel lblMinimumSupport = new JLabel();
    JLabel lblNumberOfBinsHint1 = new JLabel();
    DM4JNumberTextField txtNumberOfBins = new DM4JNumberTextField();
    JLabel lblNumberOfBins = new JLabel();
    JLabel lblBlockGrowthHint = new JLabel();
    DM4JNumberTextField txtBlockGrowth = new DM4JNumberTextField();
    JLabel lblBlockGrowth = new JLabel();
    JLabel lblFiller = new JLabel();
    AbstractActivity m_activity = null;
    boolean m_disable = false;
    KMeansBuildStepOptions m_copyState = null;

    public KMeansPanel(DM4JDialog dM4JDialog, BrowserContext browserContext) throws Exception {
        this(dM4JDialog, browserContext, false);
    }

    public KMeansPanel(DM4JDialog dM4JDialog, BrowserContext browserContext, boolean bl) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_activity = browserContext.getActivity();
        this.m_state = (KMeansBuildStepOptions)browserContext.getOptions();
        this.m_disable = bl;
        this.m_copyState = new KMeansBuildStepOptions(this.m_state);
        this.jbInit();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout);
        int n = 0;
        int n2 = 0;
        int n3 = 5;
        int n4 = 10;
        int n5 = 0;
        int n6 = 10;
        int n7 = 0;
        int n8 = 0;
        int n9 = 24;
        int n10 = 10;
        int n11 = 10;
        int n12 = 60;
        n2 = 0;
        this.mlblStepDescription_1.setText(ResourceUtilities.getUILabel("ALGORITHM_STEP_DESCRIPTION"));
        this.mlblStepDescription_1.setPreferredRows(2);
        this.mlblStepDescription_1.setMinimumRows(2);
        this.mlblStepDescription_1.setPreferredColumns(n12);
        this.mlblStepDescription_1.setTextWrapper(WordWrapper.getTextWrapper());
        this.add((Component)this.mlblStepDescription_1, new GridBagConstraints(n2, n, 2, 1, 1.0, 0.0, 17, 1, new Insets(n3, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.mlblStepDescription_2.setText(ResourceUtilities.getUILabel("ALGO_KMEANS_DESCRIPTION"));
        this.mlblStepDescription_2.setPreferredRows(2);
        this.mlblStepDescription_2.setMinimumRows(2);
        this.mlblStepDescription_2.setPreferredColumns(n12);
        this.mlblStepDescription_2.setTextWrapper(WordWrapper.getTextWrapper());
        this.add((Component)this.mlblStepDescription_2, new GridBagConstraints(n2, n, 2, 1, 1.0, 0.0, 17, 1, new Insets(n3, n4, n5, n6), n7, n8));
        if (!this.m_disable) {
            this.butRestore.setText(ResourceUtilities.getUILabel("RESTORE_BUTTON"));
            this.butRestore.setMnemonic(ResourceUtilities.getUIMnemonic("RESTORE_BUTTON"));
            this.butRestore.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KMeansPanel.this.butRestore_actionPerformed(actionEvent);
                }
            });
            this.m_parentDialog.addCustomButton(this.butRestore);
        }
        ++n;
        this.lblKMeansMaxNumberOfClusters.setText(ResourceUtilities.getUILabel("KMEANS_NUMBER_CLUSTERS"));
        this.lblKMeansMaxNumberOfClusters.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("KMEANS_NUMBER_CLUSTERS"));
        this.lblKMeansMaxNumberOfClusters.setLabelFor((Component)((Object)this.txtKMeansMaxNumberOfClusters));
        this.add((Component)this.lblKMeansMaxNumberOfClusters, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        this.txtKMeansMaxNumberOfClusters.setLocale(Locale.getDefault());
        this.txtKMeansMaxNumberOfClusters.setDataType(Integer.TYPE);
        this.txtKMeansMaxNumberOfClusters.setSigned(false);
        this.add((Component)((Object)this.txtKMeansMaxNumberOfClusters), new GridBagConstraints(++n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.lblDistanceFunction.setText(ResourceUtilities.getUILabel("ALGO_KMEANS_DISTANCE_FUNCTION"));
        this.lblDistanceFunction.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("ALGO_KMEANS_DISTANCE_FUNCTION"));
        this.lblDistanceFunction.setLabelFor(this.comboDistanceFunction);
        this.add((Component)this.lblDistanceFunction, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        n2 = 1;
        this.loadDistanceFunctionCombo();
        this.comboDistanceFunction.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KMeansPanel.this.comboDistanceFunction_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.comboDistanceFunction, new GridBagConstraints(n2, n, 2, 1, 1.0, 0.0, 17, 0, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.lblSplitCriterion.setText(ResourceUtilities.getUILabel("ALGO_KMEANS_SPLIT_CRITERION"));
        this.lblSplitCriterion.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("ALGO_KMEANS_SPLIT_CRITERION"));
        this.lblSplitCriterion.setLabelFor(this.comboSplitCriterion);
        this.add((Component)this.lblSplitCriterion, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        n2 = 1;
        this.loadSplitCriterionCombo();
        this.comboSplitCriterion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KMeansPanel.this.comboSplitCriterion_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.comboSplitCriterion, new GridBagConstraints(n2, n, 2, 1, 1.0, 0.0, 17, 0, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.lblMinimumErrorTolerance.setText(ResourceUtilities.getUILabel("ALGO_KMEANS_MINIMUM_ERROR_TOLERANCE"));
        this.lblMinimumErrorTolerance.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("ALGO_KMEANS_MINIMUM_ERROR_TOLERANCE"));
        this.lblMinimumErrorTolerance.setLabelFor((Component)((Object)this.txtMinimumErrorTolerance));
        this.add((Component)this.lblMinimumErrorTolerance, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n2;
        this.txtMinimumErrorTolerance.setLocale(Locale.getDefault());
        this.txtMinimumErrorTolerance.setDecimal(true, 9);
        this.txtMinimumErrorTolerance.setDataType(Double.class);
        this.txtMinimumErrorTolerance.setSigned(false);
        this.add((Component)((Object)this.txtMinimumErrorTolerance), new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n;
        n2 = 1;
        this.lblMinimumErrorToleranceHint1.setText(ResourceUtilities.getUILabel("ALGO_KMEANS_MINIMUM_ERROR_TOLERANCE_HINT1"));
        this.txtMinimumErrorTolerance.getAccessibleContext().setAccessibleDescription(this.lblMinimumErrorToleranceHint1.getText());
        this.add((Component)this.lblMinimumErrorToleranceHint1, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.lblMaximumIterations.setText(ResourceUtilities.getUILabel("ALGO_KMEANS_MAXIMUM_ITERATIONS"));
        this.lblMaximumIterations.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("ALGO_KMEANS_MAXIMUM_ITERATIONS"));
        this.lblMaximumIterations.setLabelFor((Component)((Object)this.txtMaximumIterations));
        this.add((Component)this.lblMaximumIterations, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n2;
        this.txtMaximumIterations.setLocale(Locale.getDefault());
        this.txtMaximumIterations.setDataType(Integer.TYPE);
        this.txtMaximumIterations.setSigned(false);
        this.add((Component)((Object)this.txtMaximumIterations), new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n;
        n2 = 1;
        this.lblMaximumIterationsHint1.setText(ResourceUtilities.getUILabel("ALGO_KMEANS_MAXIMUM_ITERATIONS_HINT1"));
        this.txtMaximumIterations.getAccessibleContext().setAccessibleDescription(this.lblMaximumIterationsHint1.getText());
        this.add((Component)this.lblMaximumIterationsHint1, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.lblMinimumSupport.setText(ResourceUtilities.getUILabel("ALGO_KMEANS_MINIMUM_SUPPORT"));
        this.lblMinimumSupport.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("ALGO_KMEANS_MINIMUM_SUPPORT"));
        this.lblMinimumSupport.setLabelFor((Component)((Object)this.txtMinimumSupport));
        this.add((Component)this.lblMinimumSupport, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n2;
        this.txtMinimumSupport.setLocale(Locale.getDefault());
        this.txtMinimumSupport.setDecimal(true, 9);
        this.txtMinimumSupport.setDataType(Double.class);
        this.txtMinimumSupport.setSigned(false);
        this.add((Component)((Object)this.txtMinimumSupport), new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n;
        n2 = 1;
        this.lblMinimumSupportHint1.setText(ResourceUtilities.getUILabel("ALGO_KMEANS_MINIMUM_SUPPORT_HINT"));
        this.txtMinimumSupport.getAccessibleContext().setAccessibleDescription(this.lblMinimumSupportHint1.getText());
        this.add((Component)this.lblMinimumSupportHint1, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.lblNumberOfBins.setText(ResourceUtilities.getUILabel("ALGO_KMEANS_NUMBER_OF_BINS"));
        this.lblNumberOfBins.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("ALGO_KMEANS_NUMBER_OF_BINS"));
        this.lblNumberOfBins.setLabelFor((Component)((Object)this.txtNumberOfBins));
        this.add((Component)this.lblNumberOfBins, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n2;
        this.txtNumberOfBins.setLocale(Locale.getDefault());
        this.txtNumberOfBins.setDataType(Integer.TYPE);
        this.txtNumberOfBins.setSigned(false);
        this.add((Component)((Object)this.txtNumberOfBins), new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n;
        n2 = 1;
        this.lblNumberOfBinsHint1.setText(ResourceUtilities.getUILabel("ALGO_KMEANS_NUMBER_OF_BINS_HINT"));
        this.txtNumberOfBins.getAccessibleContext().setAccessibleDescription(this.lblNumberOfBinsHint1.getText());
        this.add((Component)this.lblNumberOfBinsHint1, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.lblBlockGrowth.setText(ResourceUtilities.getUILabel("ALGO_KMEANS_BLOCK_GROWTH"));
        this.lblBlockGrowth.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("ALGO_KMEANS_BLOCK_GROWTH"));
        this.lblBlockGrowth.setLabelFor((Component)((Object)this.txtBlockGrowth));
        this.add((Component)this.lblBlockGrowth, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n2;
        this.txtBlockGrowth.setLocale(Locale.getDefault());
        this.txtBlockGrowth.setDataType(Integer.TYPE);
        this.txtBlockGrowth.setSigned(false);
        this.add((Component)((Object)this.txtBlockGrowth), new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n;
        n2 = 1;
        this.lblBlockGrowthHint.setText(ResourceUtilities.getUILabel("ALGO_KMEANS_BLOCK_GROWTH_HINT"));
        this.txtBlockGrowth.getAccessibleContext().setAccessibleDescription(this.lblBlockGrowthHint.getText());
        this.add((Component)this.lblBlockGrowthHint, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, n4, n5, n6), n7, n8));
        n2 = 0;
        ++n;
        this.add((Component)this.lblFiller, new GridBagConstraints(n2, n, 2, 1, 1.0, 1.0, 17, 1, new Insets(n3, n4, n5, n6), n7, n8));
        JComponent[] jComponentArray = new JComponent[]{this.txtKMeansMaxNumberOfClusters, this.txtMinimumErrorTolerance, this.txtMaximumIterations, this.txtMinimumSupport, this.txtNumberOfBins, this.txtBlockGrowth};
        ResourceUtilities.setTextBoxSize(jComponentArray, 60, 20);
        if (!(this.m_parentDialog instanceof AdvancedSettingsDialog)) {
            this.addOKHelpCancelListeners();
        }
        this.init();
    }

    protected void init() {
        this.setSettings();
    }

    protected void setSettings() {
        this.m_ignoreDistanceFunctionEvent = true;
        this.m_ignoreSplitCriterionEvent = true;
        this.txtKMeansMaxNumberOfClusters.setNumber(this.m_state.getKmeansNumberOfClusters());
        this.txtMinimumErrorTolerance.setNumber(this.m_state.getMinimumErrorTolerance());
        this.txtMaximumIterations.setNumber(this.m_state.getMaximumIterations());
        if (this.m_state.getDistanceFunction().equals(ClusteringDistanceFunction.euclidean)) {
            this.comboDistanceFunction.setSelectedItem("Euclidean");
        } else if (this.m_state.getDistanceFunction().equals(OraClusteringDistanceFunction.cosine)) {
            this.comboDistanceFunction.setSelectedItem("Cosine");
        }
        if (this.m_state.getSplitCriterion().equals(OraSplitCriterion.clusterSize)) {
            this.comboSplitCriterion.setSelectedItem("Size");
        } else if (this.m_state.getSplitCriterion().equals(OraSplitCriterion.clusterVariance)) {
            this.comboSplitCriterion.setSelectedItem("Variance");
        }
        this.txtMinimumSupport.setNumber(this.m_state.getMinimumSupportPercentage());
        this.txtNumberOfBins.setNumber(this.m_state.getNumberOfBins());
        this.txtBlockGrowth.setNumber(this.m_state.getBlockGrowth());
        this.m_ignoreDistanceFunctionEvent = false;
        this.m_ignoreSplitCriterionEvent = false;
    }

    public void processUserInput() {
        this.m_state.setKmeansNumberOfClusters((Integer)this.txtKMeansMaxNumberOfClusters.getNumber());
        this.m_state.setMinimumErrorTolerance((Double)this.txtMinimumErrorTolerance.getNumber());
        this.m_state.setMaximumIterations((Integer)this.txtMaximumIterations.getNumber());
        this.m_state.setMinimumSupportPercentage((Double)this.txtMinimumSupport.getNumber());
        this.m_state.setNumberOfBins((Integer)this.txtNumberOfBins.getNumber());
        this.m_state.setBlockGrowth((Integer)this.txtBlockGrowth.getNumber());
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KMeansPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                this.processUserInput();
                this.m_state.validate(vector);
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
            }
            catch (Exception exception) {}
        } else if ("cancel" == string) {
            this.m_state.restoreSettings(this.m_copyState);
        }
    }

    protected void butRestore_actionPerformed(ActionEvent actionEvent) {
        this.m_state.restoreToDefaultSettings(this.m_activity);
        this.setSettings();
    }

    protected void loadSplitCriterionCombo() {
        this.m_ignoreSplitCriterionEvent = true;
        this.m_splitCriterionModel = new DefaultComboBoxModel(this.m_state.getAvailableSplitCriterionNames());
        this.comboSplitCriterion.setModel(this.m_splitCriterionModel);
        this.comboSplitCriterion.setSelectedIndex(0);
        this.m_ignoreSplitCriterionEvent = false;
    }

    protected void comboSplitCriterion_actionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.m_ignoreSplitCriterionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                if (string.compareTo("Size") == 0) {
                    this.m_state.setSplitCriterion(OraSplitCriterion.clusterSize);
                } else if (string.compareTo("Variance") == 0) {
                    this.m_state.setSplitCriterion(OraSplitCriterion.clusterVariance);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void loadDistanceFunctionCombo() {
        this.m_ignoreDistanceFunctionEvent = true;
        this.m_distanceFunctionModel = new DefaultComboBoxModel(this.m_state.getAvailableDistanceFunctionNames());
        this.comboDistanceFunction.setModel(this.m_distanceFunctionModel);
        this.comboDistanceFunction.setSelectedIndex(0);
        this.m_ignoreDistanceFunctionEvent = false;
    }

    protected void comboDistanceFunction_actionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.m_ignoreDistanceFunctionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                if (string.compareTo("Euclidean") == 0) {
                    this.m_state.setDistanceFunction(ClusteringDistanceFunction.euclidean);
                } else if (string.compareTo("Cosine") == 0) {
                    this.m_state.setDistanceFunction(OraClusteringDistanceFunction.cosine);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

