/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.activity;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.activity.steps.DiscretizationStepOptions;
import oracle.dmt.dm4j.activity.wizard.AdvancedSettingsDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;

public class DiscretizePanel
extends JPanel {
    int tInd = 5;
    int lInd = 10;
    int bInd = 0;
    int rInd = 10;
    int wPad = 0;
    int hPad = 0;
    int l2Ind = 24;
    int bInstInd = 10;
    int tGroupInd = 10;
    int rowLength = 60;
    DiscretizationStepOptions m_state;
    DM4JDialog m_parentDialog;
    GridBagLayout gridBagLayout = new GridBagLayout();
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JButton butRestore = new JButton();
    JLabel lblTotalNumberOfCases = new JLabel();
    JLabel lblTotalCaseCountValue = new JLabel();
    static String QUANTILE_BINNING = ResourceUtilities.getUILabel("QUANTILE_BINNING_STRATEGY_DIALOG_DESCRIPTION");
    static String EQUAL_WIDTH_BINNING = ResourceUtilities.getUILabel("EQUAL_WIDTH_BINNING_STRATEGY_DIALOG_DESCRIPTION");
    static String TOPN_BINNING = ResourceUtilities.getUILabel("TOPN_BINNING_STRATEGY_DIALOG_DESCRIPTION");
    static String NONE = ResourceUtilities.getUILabel("NONE");
    JLabel lblNumericalStrategy = new JLabel();
    JComboBox numericalComboStrategy = new JComboBox();
    JLabel lblCategoricalStrategy = new JLabel();
    JComboBox categoricalComboStrategy = new JComboBox();
    JLabel lblFiller = new JLabel();
    boolean m_disable = false;
    DiscretizationStepOptions m_copyState = null;

    public DiscretizePanel(DM4JDialog dM4JDialog, DiscretizationStepOptions discretizationStepOptions) throws Exception {
        this(dM4JDialog, discretizationStepOptions, false);
    }

    public DiscretizePanel(DM4JDialog dM4JDialog, DiscretizationStepOptions discretizationStepOptions, boolean bl) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = discretizationStepOptions;
        this.m_disable = bl;
        this.m_copyState = new DiscretizationStepOptions(discretizationStepOptions);
        this.jbInit();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout);
        int n = 0;
        int n2 = 0;
        n2 = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_DIALOG_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.mlblStepDescription.setPreferredColumns(this.rowLength);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.add((Component)this.mlblStepDescription, new GridBagConstraints(n2, n, 3, 1, 1.0, 0.0, 17, 1, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        if (!this.m_disable) {
            this.butRestore.setText(ResourceUtilities.getUILabel("RESTORE_BUTTON"));
            this.butRestore.setMnemonic(ResourceUtilities.getUIMnemonic("RESTORE_BUTTON"));
            this.butRestore.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DiscretizePanel.this.butRestore_actionPerformed(actionEvent);
                }
            });
            this.m_parentDialog.addCustomButton(this.butRestore);
        }
        this.lblNumericalStrategy = new JLabel(ResourceUtilities.getUILabel("DISCRETIZE_NUMERICAL_STRATEGY"));
        this.lblNumericalStrategy.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("DISCRETIZE_NUMERICAL_STRATEGY"));
        this.lblNumericalStrategy.setLabelFor(this.numericalComboStrategy);
        String[] stringArray = new String[]{QUANTILE_BINNING, EQUAL_WIDTH_BINNING, NONE};
        this.numericalComboStrategy = new JComboBox<String>(stringArray);
        ++n;
        n2 = 0;
        this.add((Component)this.lblNumericalStrategy, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 1;
        this.add((Component)this.numericalComboStrategy, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        this.lblCategoricalStrategy = new JLabel(ResourceUtilities.getUILabel("DISCRETIZE_CATEGORICAL_STRATEGY"));
        this.lblCategoricalStrategy.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("DISCRETIZE_CATEGORICAL_STRATEGY"));
        this.lblCategoricalStrategy.setLabelFor(this.numericalComboStrategy);
        String[] stringArray2 = new String[]{TOPN_BINNING, NONE};
        this.categoricalComboStrategy = new JComboBox<String>(stringArray2);
        ++n;
        n2 = 0;
        this.add((Component)this.lblCategoricalStrategy, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 1;
        this.add((Component)this.categoricalComboStrategy, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 0;
        ++n;
        this.add((Component)this.lblFiller, new GridBagConstraints(n2, n, 3, 1, 1.0, 1.0, 17, 1, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        if (!(this.m_parentDialog instanceof AdvancedSettingsDialog)) {
            this.addOKHelpCancelListeners();
        }
        this.loadState();
    }

    protected void loadState() {
        this.setDiscretizeSettings();
    }

    private void numericalComboStrategy_actionPerformed(ActionEvent actionEvent) {
    }

    private void categoricalComboStrategy_actionPerformed(ActionEvent actionEvent) {
    }

    protected void setDiscretizeSettings() {
        this.lblTotalCaseCountValue.setText(this.m_state.getCaseCount() + "");
        String string = this.m_state.getNumericalDiscretizeTreatment();
        this.numericalComboStrategy.setSelectedItem(string);
        String string2 = this.m_state.getCategoricalDiscretizeTreatment();
        this.categoricalComboStrategy.setSelectedItem(string2);
        this.numericalComboStrategy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiscretizePanel.this.numericalComboStrategy_actionPerformed(actionEvent);
            }
        });
        this.categoricalComboStrategy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiscretizePanel.this.categoricalComboStrategy_actionPerformed(actionEvent);
            }
        });
    }

    public void processUserInput() {
        this.m_state.setNumericalDiscretizeTreatment(this.numericalComboStrategy.getSelectedItem().toString());
        this.m_state.setCategoricalDiscretizeTreatment(this.categoricalComboStrategy.getSelectedItem().toString());
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiscretizePanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                this.processUserInput();
                this.m_state.validate(vector);
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
            }
            catch (Exception exception) {}
        } else if ("cancel" == string) {
            this.m_state.restoreSettings(this.m_copyState);
        }
    }

    protected void butRestore_actionPerformed(ActionEvent actionEvent) {
        this.m_state.init(this.m_copyState.getActivityType());
        this.setDiscretizeSettings();
    }
}

