/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.activity;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.ComplexAppearanceManager;
import oracle.bali.ewt.grid.NumberInputHandler;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderDataToolTipManager;
import oracle.bali.ewt.header.HeaderToolTipManager;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.table.TableEditListener;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.util.ImmInsets;
import oracle.dmt.dm4j.DM4JNumberTextField;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.activity.steps.ClassificationTestMetricStepOptions;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.datasources.TargetValueCostMatrixDataSource;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.table.ComponentSpreadTable;

public class CostMatrixSettingsPanel
extends GriddedPanel {
    DM4JDialog m_parentDialog;
    ClassificationTestMetricStepOptions m_state;
    GridBagLayout gridBagLayout = new GridBagLayout();
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblTargetValue = new JLabel();
    JComboBox comboTargetValue = new JComboBox();
    JLabel lblSelectedTargetValue = new JLabel();
    DefaultComboBoxModel targetValueModel;
    MultiLineLabel mlblWeightingDescription = new MultiLineLabel();
    JRadioButton optFalsePositive = new JRadioButton();
    JRadioButton optFalseNegative = new JRadioButton();
    ButtonGroup groupFalse = new ButtonGroup();
    JLabel lblWeight = new JLabel();
    DM4JNumberTextField txtWeight = new DM4JNumberTextField();
    JLabel lblWeightHint = new JLabel();
    JLabel lblMatrixHint = new JLabel();
    JLabel lblGridName = new JLabel();
    JButton butApply = new JButton();
    JButton butRestore = new JButton();
    JScrollPane paneSpread = new JScrollPane();
    ComponentSpreadTable spreadTable = new ComponentSpreadTable(null);
    IncludeAction includeAction = new IncludeAction();
    JLabel lblFiller = new JLabel();
    JLabel lblFiller2 = new JLabel();
    boolean m_ignoreTargetValueComboEvent = false;
    private TargetValueCostMatrixDataSource m_oldCostMatrix = null;
    private TargetValueCostMatrixDataSource m_curCostMatrix = null;
    private TargetValueCostMatrixDataSource m_prevCostMatrix = null;

    public CostMatrixSettingsPanel(DM4JDialog dM4JDialog, ClassificationTestMetricStepOptions classificationTestMetricStepOptions) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = classificationTestMetricStepOptions;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout);
        int n = 0;
        int n2 = 0;
        int n3 = 5;
        int n4 = 5;
        int n5 = 10;
        int n6 = 0;
        int n7 = 10;
        int n8 = 0;
        int n9 = 0;
        int n10 = 24;
        int n11 = 10;
        int n12 = 10;
        int n13 = 60;
        n2 = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("COST_MATRIX_SETTINGS_DIALOG_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.add((Component)this.mlblStepDescription, new GridBagConstraints(n2, n, n3, 1, 0.0, 0.0, 17, 1, new Insets(n4, n5, n6, n7), n8, n9));
        ++n;
        n2 = 0;
        this.lblTargetValue.setText(ResourceUtilities.getUILabel("COST_MATRIX_TARGET_VALUE"));
        this.lblTargetValue.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("COST_MATRIX_TARGET_VALUE"));
        this.lblTargetValue.setLabelFor(this.comboTargetValue);
        this.add((Component)this.lblTargetValue, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n4 + n12, n5, n6, n7), n8, n9));
        n2 = 1;
        this.comboTargetValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CostMatrixSettingsPanel.this.comboTargetValue_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.comboTargetValue, new GridBagConstraints(n2, n, n3 - n2, 1, 1.0, 0.0, 17, 2, new Insets(n4 + n12, n5, n6, n7), n8, n9));
        ++n;
        n2 = 0;
        this.mlblWeightingDescription.setText(ResourceUtilities.getUILabel("COST_MATRIX_WEIGHTING_DESCRIPTION"));
        this.mlblWeightingDescription.setPreferredRows(2);
        this.mlblWeightingDescription.setMinimumRows(2);
        this.mlblWeightingDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.add((Component)this.mlblWeightingDescription, new GridBagConstraints(n2, n, n3, 1, 0.5, 0.0, 17, 1, new Insets(n4 + n12 + n12, n5, n6, n7), n8, n9));
        ++n;
        n2 = 0;
        this.optFalsePositive.setText(ResourceUtilities.getUILabel("COST_MATRIX_FP_DEFINITION"));
        this.groupFalse.add(this.optFalsePositive);
        this.optFalsePositive.setMnemonic(ResourceUtilities.getUIMnemonic("COST_MATRIX_FP_DEFINITION"));
        this.optFalsePositive.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CostMatrixSettingsPanel.this.optFalse_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.optFalsePositive, new GridBagConstraints(n2, n, n3, 1, 0.0, 0.0, 17, 0, new Insets(n4, n5 + n10, n6, n7), n8, n9));
        ++n;
        n2 = 0;
        this.optFalseNegative.setText(ResourceUtilities.getUILabel("COST_MATRIX_FN_DEFINITION"));
        this.groupFalse.add(this.optFalseNegative);
        this.optFalseNegative.setMnemonic(ResourceUtilities.getUIMnemonic("COST_MATRIX_FN_DEFINITION"));
        this.optFalseNegative.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CostMatrixSettingsPanel.this.optFalse_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.optFalseNegative, new GridBagConstraints(n2, n, n3, 1, 0.0, 0.0, 17, 0, new Insets(n4, n5 + n10, n6, n7), n8, n9));
        ++n;
        n2 = 0;
        this.lblWeight.setText(ResourceUtilities.getUILabel("COST_MATRIX_WEIGHT"));
        this.lblWeight.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("COST_MATRIX_WEIGHT"));
        this.lblWeight.setLabelFor((Component)((Object)this.txtWeight));
        this.add((Component)this.lblWeight, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n4, n5 + n10, n6, n7), n8, n9));
        n2 = 1;
        this.txtWeight.setLocale(Locale.getDefault());
        this.txtWeight.setDecimal(true, 8);
        this.txtWeight.setDataType(Double.class);
        this.txtWeight.setSigned(false);
        this.add((Component)((Object)this.txtWeight), new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n4, n5, n6, n7), n8, n9));
        ++n;
        n2 = 1;
        this.lblWeightHint.setText(ResourceUtilities.getUILabel("COST_MATRIX_WEIGHT_HINT"));
        this.txtWeight.getAccessibleContext().setAccessibleDescription(this.lblWeightHint.getText());
        this.add((Component)this.lblWeightHint, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, n5, n6, n7), n8, n9));
        ++n;
        n2 = 0;
        this.lblGridName.setText(ResourceUtilities.getUILabel("COST_MATRIX_WEIGHTS_TABLE"));
        this.addAnchoredComponent(this.lblGridName, new Insets(0, n5, n6, n7), n, 0, 3, 1, 16);
        this.lblGridName.setLabelFor(this.paneSpread);
        this.paneSpread.setToolTipText(this.lblGridName.getText());
        n2 = 3;
        this.butApply.setText(ResourceUtilities.getUILabel("COST_MATRIX_WEIGHT_APPLY"));
        this.butApply.setMnemonic(ResourceUtilities.getUIMnemonic("COST_MATRIX_WEIGHT_APPLY"));
        this.butApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CostMatrixSettingsPanel.this.butApply_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.butApply, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 13, 0, new Insets(n4, n5, n6, n7), n8, n9));
        n2 = 4;
        this.butRestore.setText(ResourceUtilities.getUILabel("RESTORE_BUTTON"));
        this.butRestore.setMnemonic(ResourceUtilities.getUIMnemonic("RESTORE_BUTTON"));
        this.butRestore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CostMatrixSettingsPanel.this.butRestore_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.butRestore, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 13, 0, new Insets(n4, n5, n6, n7), n8, n9));
        ++n;
        n2 = 0;
        this.paneSpread.getViewport().add((Component)((Object)this.spreadTable), null);
        this.paneSpread.setPreferredSize(null);
        this.add((Component)this.paneSpread, new GridBagConstraints(n2, n, n3, 5, 1.0, 1.0, 17, 1, new Insets(n4, n5, n6, n7), n8, n9));
        n2 = 0;
        this.lblMatrixHint.setText(ResourceUtilities.getUILabel("COST_MATRIX_MATRIX_NOTE"));
        this.paneSpread.getAccessibleContext().setAccessibleDescription(this.lblMatrixHint.getText());
        this.add((Component)this.lblMatrixHint, new GridBagConstraints(n2, n += 5, n3, 1, 0.0, 0.0, 18, 1, new Insets(0, n5, n6, n7), n8, n9));
        JButton[] jButtonArray = new JButton[]{this.butApply, this.butRestore};
        ResourceUtilities.setPreferredSize(jButtonArray, 100, 25);
        JComponent[] jComponentArray = new JComponent[]{this.txtWeight};
        ResourceUtilities.setTextBoxSize(jComponentArray, 60, 20);
        this.addOKHelpCancelListeners();
        this.init();
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CostMatrixSettingsPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                this.m_state.validate(vector);
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                boolean bl = DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
                if (!dM4JEvent.isCancelled()) {
                    this.spreadTable.removeEditListener(this.includeAction);
                }
                if (bl) {
                    this.m_state.setCostMatrixDS(this.m_curCostMatrix);
                }
            }
            catch (Exception exception) {}
        } else if ("cancel" == string) {
            this.spreadTable.removeEditListener(this.includeAction);
        }
    }

    protected void setSpread() throws Exception {
        Appearance appearance;
        TargetValueCostMatrixDataSource targetValueCostMatrixDataSource = this.m_state.getCostMatrixDS();
        this.m_curCostMatrix = new TargetValueCostMatrixDataSource((Vector)null);
        this.m_curCostMatrix.clone(targetValueCostMatrixDataSource);
        this.m_oldCostMatrix = new TargetValueCostMatrixDataSource((Vector)null);
        this.m_oldCostMatrix.clone(targetValueCostMatrixDataSource);
        this.m_prevCostMatrix = new TargetValueCostMatrixDataSource((Vector)null);
        this.m_prevCostMatrix.clone(targetValueCostMatrixDataSource);
        this.spreadTable.setModels((TwoDModel)this.m_curCostMatrix, this.m_curCostMatrix.getColumnDataSource(), this.m_curCostMatrix.getColumnDataSource());
        DM4JNumberTextField dM4JNumberTextField = new DM4JNumberTextField();
        dM4JNumberTextField.setLocale(Locale.getDefault());
        dM4JNumberTextField.setDataType(Double.class);
        dM4JNumberTextField.setDecimal(true, 4);
        dM4JNumberTextField.setSigned(false);
        this.spreadTable.getGrid().setDefaultInputHandler((CellInputHandler)new NumberInputHandler((NumberTextField)dM4JNumberTextField));
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance(false, 4));
        this.spreadTable.getGrid().setDefaultPainter((Painter)dM4JTruncatingNumberFormatPainter);
        this.spreadTable.addEditListener(this.includeAction);
        SortableTwoDModel sortableTwoDModel = (SortableTwoDModel)this.spreadTable.getGrid().getModel();
        int n = sortableTwoDModel.getColumnCount();
        ComplexAppearanceManager complexAppearanceManager = new ComplexAppearanceManager();
        this.spreadTable.getGrid().setAppearanceManager((AppearanceManager)complexAppearanceManager);
        for (int i = 0; i < n; ++i) {
            appearance = complexAppearanceManager.getCellAppearance(i, i);
            appearance.setBackground(new Color(173, 178, 206));
            appearance.setForeground(Color.black);
            complexAppearanceManager.setCellAppearance(i, i, appearance);
        }
        Header header = this.spreadTable.getColumnHeader();
        header.setToolTipManager((HeaderToolTipManager)new ToolTipHeader(this.spreadTable.getColModel()));
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setCanMoveItems(false);
        appearance = this.spreadTable.getRowHeader();
        appearance.setToolTipManager((HeaderToolTipManager)new ToolTipHeader(this.spreadTable.getColModel()));
        int n2 = 0;
        Dimension dimension = null;
        Painter painter = this.spreadTable.getRowHeader().getDefaultPainter();
        for (int i = 0; i < this.spreadTable.getRowHeader().getItemCount(); ++i) {
            int n3 = 0;
            PaintContext paintContext = this.spreadTable.getRowHeader().getItemPaintContext(i);
            dimension = painter.getPreferredSize(paintContext);
            Appearance appearance2 = this.spreadTable.getRowHeader().getItemAppearance(i);
            ImmInsets immInsets = appearance2.getInsets();
            dimension.width += (n3 += 2 * (immInsets.left + immInsets.right));
            if (dimension.width <= n2) continue;
            n2 = dimension.width;
        }
        this.spreadTable.setRowHeaderWidth(n2);
    }

    protected void butApply_actionPerformed(ActionEvent actionEvent) {
        try {
            String string = (String)this.comboTargetValue.getSelectedItem();
            Double d = (Double)this.txtWeight.getNumber();
            if (d == null) {
                DialogUtilities.createUIErrorDialog(this.m_parentDialog, "ERR_COST_MATRIX_WEIGHT_EMPTY");
                return;
            }
            if (d < 0.0) {
                DialogUtilities.createUIErrorDialog(this.m_parentDialog, "ERR_COST_MATRIX_COST_OUT_OF_RANGE");
                return;
            }
            TargetValueCostMatrixDataSource targetValueCostMatrixDataSource = this.m_state.getCostMatrixDS();
            ArrayOneDModel arrayOneDModel = targetValueCostMatrixDataSource.getColumnDataSource();
            int n = arrayOneDModel.getItemCount();
            int n2 = 0;
            for (n2 = 0; n2 < n && ((String)arrayOneDModel.getData(n2)).compareTo(string) != 0; ++n2) {
            }
            SortableTwoDModel sortableTwoDModel = (SortableTwoDModel)this.spreadTable.getGrid().getModel();
            if (this.optFalsePositive.isSelected()) {
                for (int i = 0; i < n; ++i) {
                    if (i == n2) continue;
                    sortableTwoDModel.setData(n2, i, (Object)d);
                    this.m_prevCostMatrix.setData(n2, i, d);
                }
            } else if (this.optFalseNegative.isSelected()) {
                for (int i = 0; i < n; ++i) {
                    if (i == n2) continue;
                    sortableTwoDModel.setData(i, n2, (Object)d);
                    this.m_prevCostMatrix.setData(i, n2, d);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void butRestore_actionPerformed(ActionEvent actionEvent) {
        try {
            SortableTwoDModel sortableTwoDModel = (SortableTwoDModel)this.spreadTable.getGrid().getModel();
            int n = sortableTwoDModel.getColumnCount();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    sortableTwoDModel.setData(j, i, this.m_oldCostMatrix.getData(j, i));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void optFalse_actionPerformed(ActionEvent actionEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void comboTargetValue_actionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.m_ignoreTargetValueComboEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                this.m_state.setCurTargetValue(string);
            }
        }
        catch (Exception exception) {}
    }

    public void init() throws Exception {
        this.loadTargetValueCombo();
        this.loadDefaultValues();
        this.setSpread();
    }

    protected void loadDefaultValues() {
        boolean bl = false;
        bl = true;
        this.optFalsePositive.setSelected(bl);
        this.optFalseNegative.setSelected(!bl);
        this.txtWeight.setNumber(new Double(1.0));
    }

    protected void loadTargetValueCombo() {
        this.m_ignoreTargetValueComboEvent = true;
        this.targetValueModel = new DefaultComboBoxModel<Object>(this.m_state.getTargetPrior().keySet().toArray());
        this.targetValueModel.setSelectedItem(this.m_state.getCurTargetValue());
        this.comboTargetValue.setModel(this.targetValueModel);
        this.comboTargetValue.setSelectedItem(this.m_state.getCurTargetValue());
        this.m_ignoreTargetValueComboEvent = false;
    }

    class ToolTipHeader
    extends HeaderDataToolTipManager {
        ArrayOneDModel m_tips;

        ToolTipHeader(ArrayOneDModel arrayOneDModel) {
            this.m_tips = arrayOneDModel;
        }

        public String getItemToolTipValue(Header header, int n) {
            return (String)this.m_tips.getData(n);
        }
    }

    class IncludeAction
    implements TableEditListener {
        IncludeAction() {
        }

        public void cellEditing(TableEvent tableEvent) {
            if (tableEvent instanceof Cancelable && tableEvent.getColumn() == tableEvent.getRow()) {
                ((Cancelable)tableEvent).cancel();
            }
        }

        public void cellEdited(TableEvent tableEvent) {
            int n;
            int n2;
            SortableTwoDModel sortableTwoDModel = (SortableTwoDModel)CostMatrixSettingsPanel.this.spreadTable.getGrid().getModel();
            Double d = (Double)sortableTwoDModel.getData(n2 = tableEvent.getColumn(), n = tableEvent.getRow());
            if (d < 0.0) {
                DialogUtilities.createUIErrorDialog(CostMatrixSettingsPanel.this.m_parentDialog, "ERR_COST_MATRIX_COST_OUT_OF_RANGE");
                sortableTwoDModel.setData(n2, n, CostMatrixSettingsPanel.this.m_prevCostMatrix.getData(n2, n));
                if (tableEvent instanceof Cancelable) {
                    ((Cancelable)tableEvent).cancel();
                }
            } else {
                CostMatrixSettingsPanel.this.m_prevCostMatrix.setData(n2, n, d);
            }
        }
    }
}

