/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.activity;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import oracle.bali.ewt.grid.BooleanInputHandler;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.CheckPainter;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.grid.ProxyInputHandler;
import oracle.bali.ewt.grid.ProxyPainter;
import oracle.bali.ewt.grid.TextFieldInputHandler;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.WrappingTextPainter;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.StringComparator;
import oracle.dmt.dm4j.DM4JNumberTextField;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.activity.steps.ApplyStepOptions;
import oracle.dmt.dm4j.activity.steps.ClassificationApplyStepOptions;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.datasources.ClassificationTargetSource;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.table.ComponentSpreadTable;
import oracle.dmt.dm4j.wizard.table.SortInputHandler;

public class ClassificationApplyOptionsPanel
extends GriddedPanel {
    ClassificationApplyStepOptions m_state;
    DM4JDialog m_parentDialog;
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblTargetName = new JLabel();
    JLabel lblTargetNameValue = new JLabel();
    JRadioButton optProbablePrediction = new JRadioButton();
    JRadioButton optSpecificPredictionValues = new JRadioButton();
    JRadioButton optTopNPredictions = new JRadioButton();
    ButtonGroup groupApplyOptions = new ButtonGroup();
    JScrollPane paneSpread = new JScrollPane();
    ComponentSpreadTable spreadTable = new ComponentSpreadTable(null);
    JLabel lblTopNValue = new JLabel();
    DM4JNumberTextField txtTopNValue = new DM4JNumberTextField();
    private int[] m_colWidths = new int[]{10, 45, 45};
    JLabel lblFiller = new JLabel();
    ClassificationTargetSource m_targetValuesDataSource = null;
    ClassificationApplyStepOptions m_copyState = null;
    boolean m_disable = false;

    public ClassificationApplyOptionsPanel(DM4JDialog dM4JDialog, ApplyStepOptions applyStepOptions, boolean bl) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = (ClassificationApplyStepOptions)applyStepOptions;
        this.m_disable = bl;
        this.m_copyState = new ClassificationApplyStepOptions(this.m_state);
        this.m_targetValuesDataSource = this.m_state.getTargetValuesDataSource();
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 5;
        int n4 = 10;
        int n5 = 0;
        int n6 = 10;
        int n7 = 0;
        int n8 = 0;
        int n9 = 24;
        int n10 = 10;
        int n11 = 10;
        int n12 = 60;
        n2 = 0;
        this.mlblStepDescription.setText(BrowserUtils.getActivityBundleInstance().getString("APPLY_OPTIONS_STEP_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.mlblStepDescription.setPreferredColumns(n12);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.add((Component)this.mlblStepDescription, new GridBagConstraints(n2, n, 3, 1, 1.0, 0.0, 17, 1, new Insets(n3, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.lblTargetName.setText(ResourceUtilities.getUILabel("APPLY_OPTION_TARGET_NAME"));
        this.lblTargetName.setLabelFor(this.lblTargetNameValue);
        this.add((Component)this.lblTargetName, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3 + n11, n4 + n9, n5, n6), n7, n8));
        n2 = 1;
        this.add((Component)this.lblTargetNameValue, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.optProbablePrediction.setText(ResourceUtilities.getUILabel("APPLY_OPTION_PROBABLE_OPTION"));
        this.optProbablePrediction.setMnemonic(ResourceUtilities.getUIMnemonic("APPLY_OPTION_PROBABLE_OPTION"));
        this.groupApplyOptions.add(this.optProbablePrediction);
        this.optProbablePrediction.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassificationApplyOptionsPanel.this.optApplyOptions_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.optProbablePrediction, new GridBagConstraints(n2, n, 2, 1, 0.0, 0.0, 17, 0, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.optSpecificPredictionValues.setText(ResourceUtilities.getUILabel("APPLY_OPTION_SPECIFIC_OPTION"));
        this.optSpecificPredictionValues.setMnemonic(ResourceUtilities.getUIMnemonic("APPLY_OPTION_SPECIFIC_OPTION"));
        this.groupApplyOptions.add(this.optSpecificPredictionValues);
        this.optSpecificPredictionValues.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassificationApplyOptionsPanel.this.optApplyOptions_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.optSpecificPredictionValues, new GridBagConstraints(n2, n, 2, 1, 0.0, 0.0, 17, 0, new Insets(n3, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.paneSpread.getViewport().add((Component)((Object)this.spreadTable), null);
        this.add((Component)this.paneSpread, new GridBagConstraints(n2, n, 2, 1, 1.0, 1.0, 17, 1, new Insets(n3, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.optTopNPredictions.setText(ResourceUtilities.getUILabel("APPLY_OPTION_TOPN_OPTION"));
        this.optTopNPredictions.setMnemonic(ResourceUtilities.getUIMnemonic("APPLY_OPTION_TOPN_OPTION"));
        this.groupApplyOptions.add(this.optTopNPredictions);
        this.optTopNPredictions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassificationApplyOptionsPanel.this.optApplyOptions_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.optTopNPredictions, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n4, n5, n6), n7, n8));
        n2 = 1;
        this.txtTopNValue.setLocale(Locale.getDefault());
        this.txtTopNValue.setDataType(Integer.TYPE);
        this.txtTopNValue.setSigned(false);
        this.add((Component)((Object)this.txtTopNValue), new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3, n4, n5, n6), n7, n8));
        this.loadState();
    }

    protected void optApplyOptions_actionPerformed(ActionEvent actionEvent) {
        if (this.optProbablePrediction.isSelected()) {
            this.enableMostProbablePredication();
            this.m_state.setCurApplyOption(ClassificationApplyStepOptions.PROBABLE_TARGET);
        } else if (this.optSpecificPredictionValues.isSelected()) {
            this.enableSelectedPredications();
            this.m_state.setCurApplyOption(ClassificationApplyStepOptions.SPECIFIC_TARGETS);
        } else if (this.optTopNPredictions.isSelected()) {
            this.enableTopN();
            this.m_state.setCurApplyOption(ClassificationApplyStepOptions.TOPN_TARGETS);
        }
    }

    protected void enableMostProbablePredication() {
        this.spreadTable.setEnabled(false);
        this.txtTopNValue.setEnabled(false);
    }

    protected void enableTopN() {
        this.spreadTable.setEnabled(false);
        this.txtTopNValue.setEnabled(true);
    }

    protected void enableSelectedPredications() {
        this.spreadTable.setEnabled(true);
        this.txtTopNValue.setEnabled(false);
    }

    protected void setClassificationSpread() throws Exception {
        this.spreadTable.setModels2((TwoDModel)this.m_targetValuesDataSource, this.m_targetValuesDataSource.getColumnDataSource(), null);
        this.spreadTable.setColumnWidths(this.m_colWidths, true);
        this.spreadTable.getGrid().setColumnPainter(0, CheckPainter.getPainter());
        this.spreadTable.getGrid().setColumnCellInputHandler(0, BooleanInputHandler.getCellInputHandler());
        CustomProxyPainter customProxyPainter = new CustomProxyPainter();
        this.spreadTable.getGrid().setColumnPainter(2, (Painter)customProxyPainter);
        CustomProxyInputHandler customProxyInputHandler = new CustomProxyInputHandler();
        this.spreadTable.getGrid().setColumnCellInputHandler(2, (CellInputHandler)customProxyInputHandler);
        Header header = this.spreadTable.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setCanMoveItems(false);
        header.setItemInputHandler((HeaderItemInputHandler)new SortInputHandler(this.m_targetValuesDataSource));
        this.m_targetValuesDataSource.setColumnComparator(0, (Comparator)new StringComparator(Collator.getInstance()));
        this.m_targetValuesDataSource.setColumnComparator(1, (Comparator)new StringComparator(Collator.getInstance()));
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 1);
        this.spreadTable.getGrid().setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
    }

    protected void loadState() throws Exception {
        this.setClassificationSpread();
        this.setOptionSettings();
    }

    protected void setOptionSettings() throws Exception {
        this.lblTargetNameValue.setText(DM4JNumericFormat.format(this.m_targetValuesDataSource.getRowCount()));
        if (this.m_state.getCurApplyOption().compareTo(ClassificationApplyStepOptions.PROBABLE_TARGET) == 0) {
            this.optProbablePrediction.setSelected(true);
            this.enableMostProbablePredication();
        } else if (this.m_state.getCurApplyOption().compareTo(ClassificationApplyStepOptions.TOPN_TARGETS) == 0) {
            this.optTopNPredictions.setSelected(true);
            this.enableTopN();
        } else if (this.m_state.getCurApplyOption().compareTo(ClassificationApplyStepOptions.SPECIFIC_TARGETS) == 0) {
            this.optSpecificPredictionValues.setSelected(true);
            this.enableSelectedPredications();
        }
        this.txtTopNValue.setNumber(this.m_state.getCurNumberOfTopNPredictions());
    }

    protected void resetClassificationSpread() throws Exception {
        Vector vector = this.m_state.getCurPredictions();
        HashMap hashMap = this.m_state.getCurPredictionColumns();
        for (int i = 0; i < this.m_targetValuesDataSource.getRowCount(); ++i) {
            Object object = this.m_targetValuesDataSource.getData(1, i);
            this.m_targetValuesDataSource.setData(0, i, new Boolean(vector.contains(object)));
            this.m_targetValuesDataSource.setData(2, i, hashMap.get(object));
        }
    }

    public void processUserInput() {
        boolean bl = this.optProbablePrediction.isSelected();
        boolean bl2 = this.optSpecificPredictionValues.isSelected();
        boolean bl3 = this.optTopNPredictions.isSelected();
        this.m_state.setCurApplyOption(bl ? ClassificationApplyStepOptions.PROBABLE_TARGET : (bl3 ? ClassificationApplyStepOptions.TOPN_TARGETS : ClassificationApplyStepOptions.SPECIFIC_TARGETS));
        this.m_state.setCurNumberOfTopNPredictions((Integer)this.txtTopNValue.getNumber());
        this.m_state.setCurPredictionColumns(this.m_targetValuesDataSource.getTargetPredictionColumns(false));
        this.m_state.setCurPredictions(this.m_targetValuesDataSource.getIncludedTargetValues(true));
    }

    void butRestore_actionPerformed(ActionEvent actionEvent) {
        try {
            this.setOptionSettings();
            this.resetClassificationSpread();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class AliasInputHandler
    extends TextFieldInputHandler {
        private AliasInputHandler() {
        }

        public Object commitEdit(Grid grid, int n, int n2) {
            JTextField jTextField = (JTextField)this.getEditControl(grid, n, n2);
            String string = jTextField.getText();
            ClassificationTargetSource classificationTargetSource = ClassificationApplyOptionsPanel.this.m_state.getTargetValuesDataSource();
            String string2 = classificationTargetSource.setTargetPredictionAtIndex(n2, string);
            return string2;
        }
    }

    private class CustomProxyInputHandler
    extends ProxyInputHandler {
        private CellInputHandler _aliasInputHandler;

        public CustomProxyInputHandler() {
            this._aliasInputHandler = new AliasInputHandler();
        }

        public CellInputHandler getCellInputHandler(Grid grid, int n, int n2) {
            return this._aliasInputHandler;
        }
    }

    private class CustomProxyPainter
    extends ProxyPainter {
        private Painter _textFieldPainter = new WrappingTextPainter();

        public Painter getPainter(Grid grid, int n, int n2) {
            return this._textFieldPainter;
        }
    }
}

