/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.activity;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.sql.Connection;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dmt.dm4j.DM4JAccessibilityUtils;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JSimpleDialog;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.AbstractApplyActivity;
import oracle.dmt.dm4j.activity.AbstractTestActivity;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.steps.AbstractStep;
import oracle.dmt.dm4j.activity.steps.BuildStep;
import oracle.dmt.dm4j.activity.steps.SplitStep;
import oracle.dmt.dm4j.activity.task.ActivityTask;
import oracle.dmt.dm4j.activity.task.ActivityTaskManager;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.HyperlinkButton;
import oracle.dmt.dm4j.browser.HyperlinkButtonDataSource;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.browser.SwingWorkerBasic;
import oracle.dmt.dm4j.browser.viewer.activity.ActivityIconManager;
import oracle.dmt.dm4j.browser.viewer.activity.ActivityStepPanel;
import oracle.dmt.dm4j.browser.viewer.activity.ActivityTable;
import oracle.dmt.dm4j.browser.viewer.activity.OutputDataPickerFrame;
import oracle.dmt.dm4j.browser.viewer.activity.OutputDataViewerFrame;
import oracle.dmt.dm4j.browser.viewer.activity.RelatedTablesPickerFrame;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;

public class ActivityViewer
extends GriddedPanel {
    private ActivityTable _tableSteps = null;
    private JTextField _txtCommentField = null;
    private AbstractActivity _activity = null;
    private JButton _btnStartActivity = new JButton();
    private JProgressBar _progressBar = new JProgressBar(0, 100);
    private JLabel _progressText = new JLabel();
    private boolean _caseTableIsView = false;
    private Thread _monitorThread = null;
    private StopActivity _stopWorker = null;
    private int _lastStepUpdated;

    public ActivityViewer(DefaultMutableTreeNode defaultMutableTreeNode, AbstractActivity abstractActivity, int n) throws Exception {
        try {
            this._activity = abstractActivity;
            this.resetLastStepUpdated();
            this.jbInit();
            this.startActivityTaskMonitor(abstractActivity);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void jbInit() throws Exception {
        JComponent jComponent;
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        Object object;
        Serializable serializable4;
        Object object2;
        String string = this._activity.getTitle() + " - " + this._activity.getName();
        DM4JAccessibilityUtils.setAccessibleName(this, string);
        int n = 0;
        GriddedPanel griddedPanel = new GriddedPanel();
        int n2 = 0;
        JLabel jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("COMMON_NAME"));
        griddedPanel.addFilledComponent(jLabel, TOPLABELITEMINSETS, n2, 0, 1, 1, 0);
        JTextField jTextField = new JTextField();
        jTextField.setEditable(false);
        jTextField.setBorder(new EmptyBorder(0, 0, 0, 0));
        jTextField.setText(this._activity.getName());
        griddedPanel.addFilledComponent(jTextField, TOPVALUEITEMINSETS, n2++, 1, 2, 1, 2);
        Font font = jLabel.getFont();
        Font font2 = new Font(font.getName(), font.getStyle(), font.getSize() + 4);
        jLabel.setFont(font2);
        jTextField.setFont(font2);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(DM4JResourceUtilities.getUIString("COMMON_TYPE"));
        griddedPanel.addFilledComponent(jLabel2, TOPLABELITEMINSETS, n2, 0, 1, 1, 0);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(this._activity.getTitle());
        griddedPanel.addFilledComponent(jLabel3, TOPVALUEITEMINSETS, n2++, 1, 2, 1, 2);
        if (this._activity instanceof AbstractApplyActivity && (object2 = ((AbstractApplyActivity)this._activity).getSourceActivityName()) != null) {
            serializable4 = new JLabel();
            ((JLabel)serializable4).setText(DM4JResourceUtilities.getUIString("ACTIVITY_SOURCE_ACTIVITY_NAME"));
            griddedPanel.addAnchoredComponent((JComponent)serializable4, MIDLABELITEMINSETS, n2, 0, 1, 1, 17);
            object = new HyperlinkButton();
            ((HyperlinkButton)object).setText((String)object2);
            griddedPanel.addAnchoredComponent((JComponent)object, new Insets(0, 0, 0, 0), n2++, 1, 2, 1, 17);
            ((AbstractButton)object).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ActivityViewer.this.buttonBuildActivity_actionPerformed(actionEvent);
                }
            });
        }
        object2 = new JLabel();
        serializable4 = null;
        if (!ActivityUtils.isAssociationRules(this._activity.getType())) {
            ((JLabel)object2).setText(DM4JResourceUtilities.getUIString("ACTIVITY_CASE_TABLE"));
            serializable4 = this._activity.getCaseTable();
        } else {
            ((JLabel)object2).setText(DM4JResourceUtilities.getUIString("ACTIVITY_INPUT_TABLE"));
            object = this._activity.getTables().iterator();
            while (object.hasNext() && ((Table)(serializable4 = (Table)object.next())).equals(this._activity.getCaseTable())) {
            }
        }
        griddedPanel.addAnchoredComponent((JComponent)object2, MIDLABELITEMINSETS, n2, 0, 1, 1, 17);
        object = new HyperlinkButton();
        ((HyperlinkButton)object).setText(((Table)serializable4).getSchema() + "." + ((Table)serializable4).getName());
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            this._caseTableIsView = !DatabaseMetadata.isTable(connection, ((Table)serializable4).getSchema(), ((Table)serializable4).getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        griddedPanel.addAnchoredComponent((JComponent)object, new Insets(0, 0, 0, 0), n2++, 1, 2, 1, 17);
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActivityViewer.this.buttonCaseTable_actionPerformed(actionEvent);
            }
        });
        if (!ActivityUtils.isAssociationRules(this._activity.getType())) {
            serializable3 = new JLabel();
            ((JLabel)serializable3).setText(DM4JResourceUtilities.getUIString("ACTIVITY_UID"));
            griddedPanel.addFilledComponent((JComponent)serializable3, MIDLABELITEMINSETS, n2, 0, 1, 1, 0);
            serializable2 = new JTextField();
            ((JTextComponent)serializable2).setEditable(false);
            ((JComponent)serializable2).setBorder(new EmptyBorder(0, 0, 0, 0));
            serializable = this._activity.getUniqueIdentifier();
            if (serializable != null) {
                ((JTextComponent)serializable2).setText(((Column)serializable).getName());
            } else {
                ((JTextComponent)serializable2).setText(DM4JResourceUtilities.getUIString("ACTIVITY_AUTO_UID"));
            }
            griddedPanel.addFilledComponent((JComponent)serializable2, MIDVALUEITEMINSETS, n2++, 1, 2, 1, 2);
        }
        if ((serializable3 = this._activity.getTargetColumn()) != null) {
            serializable2 = this._activity.getTargetTable();
            serializable = new JLabel();
            ((JLabel)serializable).setText(DM4JResourceUtilities.getUIString("ACTIVITY_TARGET"));
            griddedPanel.addFilledComponent((JComponent)serializable, MIDLABELITEMINSETS, n2, 0, 1, 1, 0);
            jComponent = new JTextField();
            ((JTextComponent)jComponent).setEditable(false);
            jComponent.setBorder(new EmptyBorder(0, 0, 0, 0));
            ((JTextComponent)jComponent).setText(((Table)serializable2).getSchema() + "." + ((Table)serializable2).getName() + "." + ((Column)serializable3).getAlias());
            griddedPanel.addFilledComponent(jComponent, MIDVALUEITEMINSETS, n2++, 1, 2, 1, 2);
        }
        serializable2 = this._activity.getTables();
        if (!ActivityUtils.isAssociationRules(this._activity.getType()) && serializable2 != null && ((HashSet)serializable2).size() > 1) {
            serializable = new JLabel();
            ((JLabel)serializable).setText(DM4JResourceUtilities.getUIString("ACTIVITY_ADDL_TABLES"));
            griddedPanel.addAnchoredComponent((JComponent)serializable, MIDLABELITEMINSETS, n2, 0, 1, 1, 17);
            jComponent = new HyperlinkButton();
            ((HyperlinkButton)jComponent).setText(DM4JResourceUtilities.getUIString("ACTIVITY_LIST_ADDL_TABLES"));
            jComponent.setVisible(true);
            ((HyperlinkButton)jComponent).setActive(true);
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ActivityViewer.this.buttonRelatedTables_actionPerformed(actionEvent);
                }
            });
            griddedPanel.addAnchoredComponent(jComponent, MIDVALUEITEMINSETS, n2++, 1, 2, 1, 17);
        }
        serializable = new JLabel(DM4JResourceUtilities.getActivityUIString("ACTIVITY_COMMENTS"));
        griddedPanel.addFilledComponent((JComponent)serializable, GriddedPanel.MIDLABELITEMINSETS, n2, 0, 1, 1, 0);
        this._txtCommentField = new JTextField();
        this._txtCommentField.setEditable(false);
        this._txtCommentField.setText(this._activity.getComment());
        griddedPanel.addFilledComponent(this._txtCommentField, MIDVALUEITEMINSETS, n2, 1, 2, 1, 2);
        ((JLabel)serializable).setLabelFor(this._txtCommentField);
        jComponent = new HyperlinkButton();
        ((HyperlinkButton)jComponent).setText(DM4JResourceUtilities.getActivityUIString("ACTIVITY_EDIT_COMMENTS"));
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActivityViewer.this.doEditComment();
            }
        });
        griddedPanel.addFilledComponent(jComponent, new Insets(0, 5, 0, 5), n2++, 4, 1, 1, 0);
        HyperlinkButton hyperlinkButton = new HyperlinkButton();
        hyperlinkButton.setText(DM4JResourceUtilities.getUIString("ACTIVITY_STEP_ACTIVITYDATA"));
        hyperlinkButton.setVisible(true);
        hyperlinkButton.setIconTextGap(2);
        hyperlinkButton.setActive(true);
        ActivityIconManager activityIconManager = ActivityIconManager.getInstance();
        hyperlinkButton.setIcon(activityIconManager.getIcon("OUTPUT_DATA"));
        griddedPanel.addAnchoredComponent(hyperlinkButton, new Insets(2, 0, 0, 5), n2++, 0, 1, 1, 17);
        hyperlinkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActivityViewer.this.buttonActivityData_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(griddedPanel, GriddedPanel.LASTINGROUP, n++, 0, 4, 1, 1);
        this.addAnchoredComponent(new JLabel(DM4JResourceUtilities.getActivityUIString("ACTIVITY_STEPS")), GriddedPanel.MIDLABELITEMINSETS, n, 0, 1, 1, 16);
        this._progressBar.setVisible(false);
        this._progressBar.setStringPainted(true);
        this._progressBar.setMinimumSize(new Dimension(300, 20));
        this.addAnchoredComponent(this._progressBar, MIDLABELITEMINSETS, n, 1, 1, 1, 13);
        this._progressText.setVisible(false);
        this.addAnchoredComponent(this._progressText, MIDLABELITEMINSETS, n, 2, 1, 1, 13);
        this._btnStartActivity.setText(DM4JResourceUtilities.getUIString("ACTIVITY_START"));
        this.addAnchoredComponent(this._btnStartActivity, new Insets(0, 5, 2, 10), n++, 3, 1, 1, 13);
        this._btnStartActivity.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                ActivityViewer.this.buttonRunActivity_actionPerformed();
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        this._tableSteps = new ActivityTable(this._activity);
        jScrollPane.getViewport().add(this._tableSteps);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(30);
        this.addFilledComponent(jScrollPane, GriddedPanel.MIDLABELITEMINSETS, n++, 0, 4, 200, 1);
    }

    private void setUIRunning(final ActivityTask activityTask) {
        if (activityTask == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean bl = activityTask.getIsCancelling();
                if (activityTask.getIsRunning()) {
                    ActivityViewer.this._btnStartActivity.setText(DM4JResourceUtilities.getUIString("ACTIVITY_STOP"));
                    ActivityViewer.this._btnStartActivity.setEnabled(!bl);
                    ActivityViewer.this._progressBar.setVisible(true);
                    ActivityViewer.this._progressText.setVisible(true);
                    ActivityViewer.this._progressBar.setValue(activityTask.getProgress());
                    ActivityViewer.this._progressText.setText("(" + activityTask.getStepsCompleted() + DM4JResourceUtilities.getUIString("ACTIVITY_STEP_OF_STEPS") + activityTask.getStepsToRun() + ")");
                    String string = bl ? DM4JResourceUtilities.getActivityUIString("ACTIVITY_CANCELLING") : null;
                    ActivityViewer.this._progressBar.setString(string);
                } else {
                    ActivityViewer.this._progressBar.setVisible(false);
                    ActivityViewer.this._progressText.setVisible(false);
                    ActivityViewer.this._btnStartActivity.setText(DM4JResourceUtilities.getUIString("ACTIVITY_START"));
                    ActivityViewer.this._btnStartActivity.setEnabled(true);
                }
            }
        });
    }

    private void refreshStepsUI() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ActivityViewer.this._tableSteps.refresh();
            }
        });
    }

    private void startActivityTaskMonitor(final AbstractActivity abstractActivity) {
        Thread thread = new Thread("DMR$ActvityViewerMonitor"){

            public void run() {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                ActivityTaskManager activityTaskManager = ActivityTaskManager.getInstance();
                while (true) {
                    ActivityTask activityTask;
                    if ((activityTask = activityTaskManager.getTask(abstractActivity.getName())) != null) {
                        ActivityViewer.this.setUIRunning(activityTask);
                        int n = activityTask.getLastStepRun();
                        if (n >= 0 && n != ActivityViewer.this.getLastStepUpdated()) {
                            ActivityViewer.this.setLastStepUpdated(n);
                        }
                    }
                    try {
                        9.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
        };
        thread.start();
        this._monitorThread = thread;
    }

    private void setLastStepUpdated(int n) {
        this._lastStepUpdated = n;
    }

    private void resetLastStepUpdated() {
        this.setLastStepUpdated(-1);
    }

    private int getLastStepUpdated() {
        return this._lastStepUpdated;
    }

    public void removeNotify() {
        super.removeNotify();
        if (this._monitorThread != null) {
            this._monitorThread.interrupt();
        }
        this._monitorThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEditComment() {
        String string = this._activity.getComment();
        EditCommentPanel editCommentPanel = new EditCommentPanel(string);
        EditCommentDialog editCommentDialog = new EditCommentDialog(BrowserFrame.getMainFrame(), editCommentPanel, DM4JResourceUtilities.getActivityUIString("ACTIVITY_COMMENT_EDIT_TITLE"), null);
        editCommentDialog.setPanel(editCommentPanel);
        editCommentDialog.setSize(300, 200);
        editCommentDialog.setNoHelp();
        editCommentDialog.setVisible(true);
        if (editCommentDialog.isOk()) {
            BrowserFrame browserFrame = BrowserFrame.getMainFrame();
            browserFrame.setCursor(new Cursor(3));
            this._activity.setComment(editCommentPanel.getComment());
            try {
                this._activity.store();
                this._txtCommentField.setText(editCommentPanel.getComment());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getActivityUIString("CANNOT_STORE"), DM4JVersion.getFullBrowserName(), 0);
                exception.printStackTrace();
            }
            finally {
                browserFrame.setCursor(new Cursor(0));
            }
        }
    }

    private void buttonRunActivity_actionPerformed() {
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        ActivityTaskManager activityTaskManager = ActivityTaskManager.getInstance();
        ActivityTask activityTask = activityTaskManager.getTask(this._activity);
        boolean bl = false;
        if (activityTask != null) {
            bl = activityTask.getIsRunning();
        }
        if (!bl) {
            Object object;
            Object object2;
            if ((this._activity instanceof AbstractApplyActivity || this._activity instanceof AbstractTestActivity) && !ActivityViewer.validateModelSignature(this._activity)) {
                return;
            }
            SplitStep splitStep = this._activity.findSplitStep();
            if (splitStep != null && (!splitStep.getIsEnabled() || splitStep.isSkipped(this._activity))) {
                DM4JListResourceBundle dM4JListResourceBundle;
                int n;
                object2 = this._activity.findTestMetricStep();
                object = this._activity.findResidualPlotStep();
                if ((object2 != null && ((AbstractStep)object2).getIsEnabled() && !((AbstractStep)object2).getIsComplete() || object != null && ((AbstractStep)object).getIsEnabled() && !((AbstractStep)object).getIsComplete()) && (n = JOptionPane.showConfirmDialog(browserFrame, (dM4JListResourceBundle = BrowserUtils.getActivityBundleInstance()).getString("NO_SPLIT_PROCEED"), DM4JVersion.getFullBrowserName(), 0)) == 1) {
                    return;
                }
            }
            browserFrame.setCursor(new Cursor(3));
            object2 = new ActivityTask(this._activity);
            if (((ActivityTask)object2).getStepsToRun() > 0) {
                this._btnStartActivity.setEnabled(false);
                this.resetLastStepUpdated();
                object = ActivityTaskManager.getInstance();
                ((ActivityTaskManager)object).start(this._activity);
                this._btnStartActivity.setText(DM4JResourceUtilities.getUIString("ACTIVITY_STOP"));
                BrowserFrame.getMainFrame().showRunningTask(((ActivityTask)object2).getName(), false, false);
            } else {
                JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getActivityUIString("TASK_NO_STEPS_TO_RUN"), DM4JVersion.getFullBrowserName(), 1);
            }
            browserFrame.setCursor(new Cursor(0));
        } else {
            if (JOptionPane.showConfirmDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("ACTIVITY_STOP_PROMPT"), DM4JVersion.getFullBrowserName(), 0, 3) == 1) {
                return;
            }
            browserFrame.setCursor(new Cursor(3));
            this._stopWorker = new StopActivity();
            this._stopWorker.start();
            browserFrame.setCursor(new Cursor(0));
        }
    }

    public static boolean validateModelSignature(AbstractActivity abstractActivity) {
        class ValidateBuildActivityThread
        extends LongRunningProcess {
            private boolean _signatureMatches = false;
            private boolean _modelExists = false;
            private AbstractActivity _buildActivity = null;
            private AbstractApplyActivity _applyActivity = null;

            public ValidateBuildActivityThread(AbstractApplyActivity abstractApplyActivity) {
                this._applyActivity = abstractApplyActivity;
            }

            public AbstractActivity getBuildActivity() {
                return this._buildActivity;
            }

            public boolean getSignatureMatched() {
                return this._signatureMatches;
            }

            public boolean getModelExists() {
                return this._modelExists;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Connection connection = null;
                try {
                    this.getProgressBar().updateProgress(DM4JResourceUtilities.getActivityUIString("ACTIVITY_APPLY_VALIDATING"), "");
                    connection = DM4JConnectionManager.getDbConnection();
                    this._buildActivity = AbstractActivity.restore(this._applyActivity.getSourceActivityName());
                    BuildStep buildStep = this._buildActivity.findBuildStep();
                    String string = buildStep.getModelSignature();
                    String string2 = this._applyActivity.getModelSignature();
                    if (string == null && string2 == null) {
                        this._signatureMatches = true;
                    } else if (string != null && string2 != null && string.equals(string2)) {
                        this._signatureMatches = true;
                    }
                    this._modelExists = buildStep.getOutputMiningName() != null;
                    this.getProgressBar().setDoneStatus();
                }
                catch (Exception exception) {
                    this.setException(exception);
                    this.getProgressBar().setDoneStatus();
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }
        }
        ValidateBuildActivityThread validateBuildActivityThread = new ValidateBuildActivityThread((AbstractApplyActivity)abstractActivity);
        ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("ACTIVITY_CREATION"), validateBuildActivityThread, true);
        validateBuildActivityThread.setProgressBar(progressBar);
        progressBar.start(DM4JResourceUtilities.getUIString("ACTIVITY_CREATE_ACTIVITY"), null);
        if (validateBuildActivityThread.getException() != null) {
            validateBuildActivityThread.getException().printStackTrace();
            return false;
        }
        if (progressBar.hasUserCancelled()) {
            return false;
        }
        if (validateBuildActivityThread.getBuildActivity() == null) {
            JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getActivityUIString("ACTIVITY_APPLY_NOBUILD_ACTIVITY"), DM4JVersion.getFullBrowserName(), 0);
            return false;
        }
        if (!validateBuildActivityThread.getModelExists()) {
            JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getActivityUIString("ACTIVITY_APPLY_NOMINING_MODEL"), DM4JVersion.getFullBrowserName(), 0);
            return false;
        }
        if (!validateBuildActivityThread.getSignatureMatched()) {
            int n = JOptionPane.showConfirmDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getActivityUIString("ACTIVITY_APPLY_MUST_RESYNC"), DM4JVersion.getFullBrowserName(), 0);
            if (n == 1) {
                return false;
            }
            class RefactorActivityThread
            extends LongRunningProcess {
                private AbstractActivity _buildActivity = null;
                private AbstractApplyActivity _applyActivity = null;

                public RefactorActivityThread(AbstractActivity abstractActivity, AbstractApplyActivity abstractApplyActivity) {
                    this._buildActivity = abstractActivity;
                    this._applyActivity = abstractApplyActivity;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Connection connection = null;
                    try {
                        this.getProgressBar().updateProgress(DM4JResourceUtilities.getActivityUIString("ACTIVITY_APPLY_SYNCING_WITH_BUILD"), "");
                        connection = DM4JConnectionManager.getDbConnection();
                        if (!this._applyActivity.resetAllSteps(false)) {
                            throw new Exception(DM4JResourceUtilities.getActivityUIString("ACTIVITY_APPLY_FAILED_RESET"));
                        }
                        this._applyActivity.refactorSteps(this._buildActivity);
                        this.getProgressBar().updateProgress(DM4JResourceUtilities.getActivityUIString("ACTIVITY_APPLY_UPDATING_FROM_BUILD"), "");
                        BuildStep buildStep = this._buildActivity.findBuildStep();
                        this._applyActivity.setModelSignature(buildStep.getModelSignature());
                        this._applyActivity.setModelName(buildStep.getOutputMiningName());
                        this._applyActivity.store();
                        this.getProgressBar().setDoneStatus();
                    }
                    catch (Exception exception) {
                        this.setException(exception);
                        this.getProgressBar().setDoneStatus();
                    }
                    finally {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                }
            }
            RefactorActivityThread refactorActivityThread = new RefactorActivityThread(validateBuildActivityThread.getBuildActivity(), (AbstractApplyActivity)abstractActivity);
            progressBar = new ProgressBar(BrowserFrame.getMainFrame(), "", refactorActivityThread, true);
            refactorActivityThread.setProgressBar(progressBar);
            progressBar.start(DM4JResourceUtilities.getActivityUIString("ACTIVITY_APPLY_SYNCING_WITH_BUILD"), null);
            if (refactorActivityThread.getException() != null) {
                refactorActivityThread.getException().printStackTrace();
                JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getActivityUIString("ACTIVITY_APPLY_FAILED_SYNC"), DM4JVersion.getFullBrowserName(), 0, null);
                return false;
            }
            if (progressBar.hasUserCancelled()) {
                return false;
            }
        }
        return true;
    }

    private void buttonRelatedTables_actionPerformed(ActionEvent actionEvent) {
        HyperlinkButton hyperlinkButton = (HyperlinkButton)actionEvent.getSource();
        if (!hyperlinkButton.isActive()) {
            return;
        }
        RelatedTablesPickerFrame relatedTablesPickerFrame = new RelatedTablesPickerFrame(this._activity, hyperlinkButton);
    }

    private void buttonBuildActivity_actionPerformed(ActionEvent actionEvent) {
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        HyperlinkButton hyperlinkButton = (HyperlinkButton)actionEvent.getSource();
        browserFrame.findComponent(ActivityUtils.mapActivityTypeToItemType(this._activity.getType()), hyperlinkButton.getText(), true);
    }

    private void buttonActivityData_actionPerformed(ActionEvent actionEvent) {
        HyperlinkButton hyperlinkButton = (HyperlinkButton)actionEvent.getSource();
        if (!hyperlinkButton.isActive()) {
            return;
        }
        OutputDataPickerFrame outputDataPickerFrame = new OutputDataPickerFrame(this._activity, (JComponent)hyperlinkButton);
    }

    private void buttonCaseTable_actionPerformed(ActionEvent actionEvent) {
        HyperlinkButton hyperlinkButton = (HyperlinkButton)actionEvent.getSource();
        if (!hyperlinkButton.isActive()) {
            return;
        }
        OutputDataViewerFrame outputDataViewerFrame = new OutputDataViewerFrame(new HyperlinkButtonDataSource(this._activity.getCaseTable().getSchema(), this._activity.getCaseTable().getName(), this._caseTableIsView), this.getActivity());
    }

    private void buttonTargetTable_actionPerformed(ActionEvent actionEvent) {
        HyperlinkButton hyperlinkButton = (HyperlinkButton)actionEvent.getSource();
        if (!hyperlinkButton.isActive()) {
            return;
        }
        OutputDataViewerFrame outputDataViewerFrame = new OutputDataViewerFrame(new HyperlinkButtonDataSource(this._activity.getTargetTable().getSchema(), this._activity.getTargetTable().getName()));
    }

    public AbstractActivity getActivity() {
        return this._activity;
    }

    public ActivityStepPanel getStepPanelFor(AbstractStep abstractStep) {
        ActivityStepPanel activityStepPanel = null;
        for (int i = 0; i < this._tableSteps.getStepCount(); ++i) {
            ActivityStepPanel activityStepPanel2 = this._tableSteps.getStepPanelAt(i);
            AbstractStep abstractStep2 = activityStepPanel2.getStep();
            if (!abstractStep2.getClass().getName().equals(abstractStep.getClass().getName())) continue;
            activityStepPanel = activityStepPanel2;
            break;
        }
        return activityStepPanel;
    }

    class StopActivity
    extends SwingWorkerBasic {
        StopActivity() {
        }

        public Object construct() {
            ActivityViewer.this._btnStartActivity.setEnabled(false);
            ActivityTaskManager activityTaskManager = ActivityTaskManager.getInstance();
            activityTaskManager.stop(ActivityViewer.this._activity.getName());
            ActivityTask activityTask = activityTaskManager.getTask(ActivityViewer.this._activity.getName());
            while (!activityTask.getIsIdle()) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return true;
        }
    }

    class EditCommentPanel
    extends GriddedPanel {
        private JTextArea _commentField = new JTextArea();
        boolean valid = this.doValidation();

        EditCommentPanel(String string) {
            this._commentField.setText(string);
            this._commentField.setLineWrap(true);
            this._commentField.setWrapStyleWord(true);
            this._commentField.setColumns(4000);
            int n = 0;
            JLabel jLabel = new JLabel();
            jLabel.setText(DM4JResourceUtilities.getActivityUIString("ACTIVITY_COMMENT"));
            this.addFilledComponent(jLabel, GriddedPanel.TOPLABELITEMINSETS, n++, 0, 2, 1, 2);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().add(this._commentField);
            this.addFilledComponent(jScrollPane, GriddedPanel.MIDLABELITEMINSETS, n++, 0, 2, 5, 1);
        }

        public boolean doValidation() {
            String string = this._commentField.getText();
            if (string.length() > 200) {
                JOptionPane.showOptionDialog(this, DM4JResourceUtilities.getUIString("ACTIVITY_COMMENT_TOOLONG") + 200, DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
                return false;
            }
            return true;
        }

        public String getComment() {
            return this._commentField.getText();
        }
    }

    class EditCommentDialog
    extends DM4JSimpleDialog {
        public EditCommentDialog(JFrame jFrame, JPanel jPanel, String string, String string2) {
            super((Frame)jFrame, jPanel, string, string2);
        }

        protected void okActionPerformed(ActionEvent actionEvent) {
            EditCommentPanel editCommentPanel = (EditCommentPanel)this.getDialogPanel();
            boolean bl = editCommentPanel.doValidation();
            if (!bl) {
                return;
            }
            super.okActionPerformed(actionEvent);
        }

        protected void cancelActionPerformed(ActionEvent actionEvent) {
            super.cancelActionPerformed(actionEvent);
        }
    }
}

