/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.activity;

import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.steps.AbstractStep;
import oracle.dmt.dm4j.browser.viewer.activity.ActivityStepPanel;

public class ActivityTable
extends JPanel {
    private AbstractActivity _activity;
    private Vector _stepPanels;
    private int _currentSelection;

    public ActivityTable(AbstractActivity abstractActivity) {
        this._activity = abstractActivity;
        this._currentSelection = 0;
        this._stepPanels = new Vector();
        this.jbInit();
    }

    private void jbInit() {
        Vector vector = this._activity.getSteps();
        this.setLayout(new GridLayout(0, 1));
        int n = 0;
        for (AbstractStep abstractStep : vector) {
            ActivityStepPanel activityStepPanel = new ActivityStepPanel(this, abstractStep, this._activity);
            activityStepPanel.setUISelected(n == 0, null);
            this.add(activityStepPanel);
            this._stepPanels.add(activityStepPanel);
            ++n;
        }
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ActivityTable.this.this_keyPressed(keyEvent);
            }
        });
    }

    public void setSelection(ActivityStepPanel activityStepPanel) {
        this.requestFocus();
        for (int i = 0; i < this._stepPanels.size(); ++i) {
            ActivityStepPanel activityStepPanel2 = (ActivityStepPanel)this._stepPanels.get(i);
            if (activityStepPanel != activityStepPanel2) continue;
            this.setSelectedIndex(i);
            break;
        }
    }

    public int getStepPanelIndex(ActivityStepPanel activityStepPanel) {
        int n = -1;
        for (int i = 0; i < this._stepPanels.size(); ++i) {
            ActivityStepPanel activityStepPanel2 = (ActivityStepPanel)this._stepPanels.get(i);
            if (activityStepPanel != activityStepPanel2) continue;
            n = i;
            break;
        }
        return n;
    }

    public ActivityStepPanel getStepPanelAt(int n) {
        return (ActivityStepPanel)this._stepPanels.get(n);
    }

    public int getSelectedIndex() {
        return this._currentSelection;
    }

    public void setSelectedIndex(int n) {
        if (n < this._stepPanels.size() && n >= 0) {
            ActivityStepPanel activityStepPanel = this.getStepPanelAt(this._currentSelection);
            AbstractStep abstractStep = activityStepPanel.getStep();
            activityStepPanel.setUISelected(false, null);
            this.getStepPanelAt(n).setUISelected(true, null);
            this._currentSelection = n;
        }
    }

    public int getStepCount() {
        return this._stepPanels.size();
    }

    private void this_keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 40: {
                this.setSelectedIndex(this._currentSelection + 1);
                break;
            }
            case 38: {
                this.setSelectedIndex(this._currentSelection - 1);
                break;
            }
            case 34: {
                this.setSelectedIndex(this._currentSelection + 4);
                break;
            }
            case 33: {
                this.setSelectedIndex(this._currentSelection - 4);
                break;
            }
            case 36: {
                this.setSelectedIndex(0);
                break;
            }
            case 35: {
                this.setSelectedIndex(this._stepPanels.size() - 1);
            }
        }
        ActivityStepPanel activityStepPanel = this.getStepPanelAt(this._currentSelection);
        JViewport jViewport = (JViewport)this.getParent();
        Point point = activityStepPanel.getLocationOnScreen();
        SwingUtilities.convertPointFromScreen(point, jViewport);
        Rectangle rectangle = activityStepPanel.getBounds();
        rectangle.setLocation(point);
        jViewport.scrollRectToVisible(rectangle);
        keyEvent.consume();
    }

    public void refresh() {
        for (int i = 0; i < this._stepPanels.size(); ++i) {
            ActivityStepPanel activityStepPanel = (ActivityStepPanel)this._stepPanels.get(i);
            activityStepPanel.refreshUI();
            activityStepPanel.setUISelected(this.getSelectedIndex() == i, null);
        }
    }
}

