/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.activity;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.sql.Connection;
import java.text.Format;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JSimpleDialog;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.AbstractApplyActivity;
import oracle.dmt.dm4j.activity.AbstractTestActivity;
import oracle.dmt.dm4j.activity.AdaptiveBayesActivity;
import oracle.dmt.dm4j.activity.AnomalyDetectionActivity;
import oracle.dmt.dm4j.activity.AssociationRulesActivity;
import oracle.dmt.dm4j.activity.AttributeImportanceActivity;
import oracle.dmt.dm4j.activity.DecisionTreeActivity;
import oracle.dmt.dm4j.activity.KMeansActivity;
import oracle.dmt.dm4j.activity.NMFActivity;
import oracle.dmt.dm4j.activity.NaiveBayesActivity;
import oracle.dmt.dm4j.activity.OClusterActivity;
import oracle.dmt.dm4j.activity.SVMClassificationActivity;
import oracle.dmt.dm4j.activity.SVMRegressionActivity;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.activity.steps.AbstractMiningStep;
import oracle.dmt.dm4j.activity.steps.AbstractStep;
import oracle.dmt.dm4j.activity.steps.AbstractTransformationStep;
import oracle.dmt.dm4j.activity.steps.ApplyStep;
import oracle.dmt.dm4j.activity.steps.BuildStep;
import oracle.dmt.dm4j.activity.steps.ClassificationTestMetricStepOptions;
import oracle.dmt.dm4j.activity.steps.ODMrTextStep;
import oracle.dmt.dm4j.activity.steps.ROCThresholdSelectionStepOptions;
import oracle.dmt.dm4j.activity.steps.ResidualPlotStep;
import oracle.dmt.dm4j.activity.steps.TestMetricStep;
import oracle.dmt.dm4j.activity.task.ActivityTask;
import oracle.dmt.dm4j.activity.task.ActivityTaskManager;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.HyperlinkButton;
import oracle.dmt.dm4j.browser.HyperlinkButtonMiningResult;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.activity.ActivityIconManager;
import oracle.dmt.dm4j.browser.viewer.activity.ActivityStepErrorPanel;
import oracle.dmt.dm4j.browser.viewer.activity.ActivityStepWarningPanel;
import oracle.dmt.dm4j.browser.viewer.activity.ActivityTable;
import oracle.dmt.dm4j.browser.viewer.activity.ActivityViewer;
import oracle.dmt.dm4j.browser.viewer.activity.MiningResultViewerFrame;
import oracle.dmt.dm4j.browser.viewer.activity.OutputDataPickerFrame;
import oracle.dmt.dm4j.browser.viewer.activity.ROCThresholdSelectionDialog;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.jdm.resource.OraConnection;

public class ActivityStepPanel
extends JPanel {
    private Thread _monitorThread = null;
    private JLabel _labelTitle = new JLabel();
    private JLabel _labelDescription = new JLabel();
    private JButton _buttonStart = new JButton();
    private JButton _buttonReset = new JButton();
    private JButton _buttonOptions = new JButton();
    private HyperlinkButton _buttonROCThreshold = new HyperlinkButton();
    private AbstractStep _step = null;
    private AbstractActivity _activity = null;
    private ActivityTable _table = null;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private HyperlinkButton _labelOutputData = new HyperlinkButton();
    private HyperlinkButtonMiningResult _labelResults = new HyperlinkButtonMiningResult();
    private JTextField _outputName = new JTextField();
    private JLabel _outputNameLabel = null;
    private Color _unselColor = new Color(255, 255, 255);
    private Color _unselSkippedColor = new Color(200, 200, 200);
    private HyperlinkButton _labelStatus = new HyperlinkButton();
    private int _currentStatus;
    private JCheckBox _enableStep = new JCheckBox();
    private static int index = 0;
    public static final int COMPLETE = index++;
    public static final int FAILED = index++;
    public static final int RUNNING = index++;
    public static final int SKIPPED = index++;
    public static final int INCOMPLETE = index++;
    public static final int CHECKING = index++;
    public static final int DISABLED = index++;

    public ActivityStepPanel(ActivityTable activityTable, AbstractStep abstractStep, AbstractActivity abstractActivity) {
        try {
            this._step = abstractStep;
            this._activity = abstractActivity;
            this._table = activityTable;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ActivityStepPanel.this.this_mouseClicked();
            }
        });
        this._labelTitle.setText("Title");
        Font font = this._labelTitle.getFont();
        this.setMinimumSize(new Dimension(400, 80));
        this.setPreferredSize(new Dimension(400, 112));
        this.setSize(new Dimension(527, 80));
        this._labelTitle.setFont(new Font(font.getName(), font.getStyle(), font.getSize() + 3));
        this._labelDescription.setText("Description");
        this._buttonStart.setText(DM4JResourceUtilities.getActivityUIString("ACTIVITY_START_BTN"));
        this._buttonStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActivityStepPanel.this.buttonStart_actionPerformed();
            }
        });
        this._buttonReset.setText(DM4JResourceUtilities.getActivityUIString("ACTIVITY_RESET_BTN"));
        this._buttonReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActivityStepPanel.this.buttonReset_actionPerformed();
            }
        });
        this._buttonOptions.setText(DM4JResourceUtilities.getUIString("ACTIVITY_STEP_OPTIONS"));
        this._buttonOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActivityStepPanel.this.buttonOptions_actionPerformed();
            }
        });
        this._buttonROCThreshold.setText(DM4JResourceUtilities.getUIString("ACTIVITY_SELECT_ROCTHRESHOLD"));
        this._buttonROCThreshold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActivityStepPanel.this.buttonROCThreshold_actionPerformed();
            }
        });
        boolean bl = this._step instanceof TestMetricStep;
        this._buttonROCThreshold.setVisible(bl);
        this._buttonROCThreshold.setEnabled(false);
        this._labelStatus.setText("tempStatus");
        this._labelStatus.setIconTextGap(5);
        this._labelStatus.setActive(false);
        this._labelStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActivityStepPanel.this.buttonStatus_actionPerformed(actionEvent);
            }
        });
        this._labelOutputData.setText(this.getStepOutputDataDescription());
        this._labelOutputData.setVisible(false);
        this._labelOutputData.setIconTextGap(2);
        ActivityIconManager activityIconManager = ActivityIconManager.getInstance();
        this._labelOutputData.setIcon(activityIconManager.getIcon("OUTPUT_DATA"));
        this._labelOutputData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActivityStepPanel.this.buttonOutputData_actionPerformed(actionEvent);
            }
        });
        this._labelResults.setText(DM4JResourceUtilities.getUIString("ACTIVITY_STEP_RESULT"));
        this._labelResults.setVisible(false);
        this._labelResults.setIconTextGap(2);
        this._labelResults.setIcon(this.getStepResultIcon(activityIconManager));
        this._labelResults.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActivityStepPanel.this.buttonResults_actionPerformed(actionEvent);
            }
        });
        this._outputNameLabel = new JLabel();
        if (this._step instanceof BuildStep) {
            this._outputNameLabel.setText(DM4JResourceUtilities.getUIString("ACTIVITY_MODEL_NAME"));
        } else if (this._step instanceof ApplyStep) {
            this._outputNameLabel.setText(DM4JResourceUtilities.getUIString("ACTIVITY_APPLY_OUTPUT_TABLE_NAME"));
        } else if (this._step instanceof TestMetricStep) {
            this._outputNameLabel.setText(DM4JResourceUtilities.getUIString("ACTIVITY_TEST_RESULT_TABLE_NAME"));
        } else if (this._step instanceof ResidualPlotStep) {
            this._outputNameLabel.setText(DM4JResourceUtilities.getUIString("ACTIVITY_RESIDUAL_RESULT_TABLE_NAME"));
        }
        this._outputNameLabel.setLabelFor(this._outputName);
        this._outputNameLabel.setVisible(false);
        this._outputName.setEditable(false);
        this._outputName.setBorder(new EmptyBorder(0, 0, 0, 0));
        this._outputName.setVisible(false);
        this._outputName.setColumns(27);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2, 5, 0));
        jPanel.add(this._outputNameLabel);
        jPanel.add(this._outputName);
        this.add((Component)this._labelTitle, new GridBagConstraints(1, 0, 3, 1, 100.0, 0.0, 12, 2, new Insets(2, 5, 0, 0), 0, 0));
        this.add((Component)this._labelStatus, new GridBagConstraints(5, 0, 2, 1, 0.0, 0.0, 15, 3, new Insets(2, 0, 0, 0), 0, 0));
        this.add((Component)this._labelDescription, new GridBagConstraints(0, 1, 5, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 11));
        this.add((Component)this._labelOutputData, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(2, 5, 0, 0), 0, 0));
        this.add((Component)this._labelResults, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 5, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 5, 0, 0), 0, 0));
        this.add((Component)this._buttonReset, new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 0, 3, 4), 0, 0));
        this.add((Component)this._buttonStart, new GridBagConstraints(6, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 0, 3, 4), 0, 0));
        this.add((Component)this._buttonOptions, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 0, 3, 4), 0, 0));
        this.add((Component)this._enableStep, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this._buttonROCThreshold, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 0, 3, 4), 0, 0));
        this._labelTitle.setText(this._step.getTitle());
        this._labelDescription.setText(DM4JResourceUtilities.wrapInHTML(this._step.getDescription()));
        AccessibleContext accessibleContext = this.getAccessibleContext();
        accessibleContext.setAccessibleName(this._step.getTitle());
        accessibleContext.setAccessibleDescription(this._step.getDescription());
        this._enableStep.setSelected(this._step.getIsEnabled());
        this._enableStep.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActivityStepPanel.this.enableStep_actionPerformed(actionEvent);
            }
        });
        this._enableStep.setEnabled(!this.isStepImmutable());
        this.refreshUI();
    }

    public void refreshUI() {
        if (this._step.getIsComplete()) {
            if (this._step instanceof AbstractTransformationStep) {
                this.updateStatusLabel(COMPLETE);
                this.updateButtons(!this.isStepImmutable(), false, true);
            } else if (this._step instanceof AbstractMiningStep) {
                this.updateButtons(false, false, false);
                this.updateStatusLabel(CHECKING);
                this.startAsyncStepMonitor((AbstractMiningStep)this._step);
            }
        } else {
            boolean bl = this._step.isSkipped(this._activity);
            boolean bl2 = false;
            if (bl) {
                this.updateStatusLabel(SKIPPED);
            } else {
                bl2 = this._step.hasDataMinerErrors();
                if (bl2) {
                    this.updateStatusLabel(FAILED);
                } else {
                    this.updateStatusLabel(INCOMPLETE);
                }
            }
            this.updateButtons(bl || bl2, !bl, false);
        }
    }

    private int getCurrentStatus() {
        return this._currentStatus;
    }

    private void updateResultsLabel(boolean bl) {
        if (bl) {
            this._labelResults.setVisible(true);
            LeafNodeData leafNodeData = null;
            String string = ((AbstractMiningStep)this._step).getOutputMiningName();
            String string2 = ((AbstractMiningStep)this._step).getOutputMiningType();
            if (string != null && string2 != null && string.length() > 0 && string2.length() > 0) {
                try {
                    leafNodeData = new LeafNodeData(string, string2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this._labelResults.setLeafNodeData(leafNodeData);
            if (this._step instanceof BuildStep) {
                this._outputNameLabel.setVisible(true);
                this._outputName.setVisible(true);
                this._outputName.setText(DM4JStringUtils.trimDoubleQuotes(((BuildStep)this._step).getOutputMiningName()));
            } else if (this._step instanceof ApplyStep) {
                this._outputNameLabel.setVisible(true);
                this._outputName.setVisible(true);
                this._outputName.setText(DM4JStringUtils.trimDoubleQuotes(((ApplyStep)this._step).getOutputMiningName()));
            } else if (this._step instanceof TestMetricStep) {
                this._outputNameLabel.setVisible(true);
                this._outputName.setVisible(true);
                this._outputName.setText(DM4JStringUtils.trimDoubleQuotes(((TestMetricStep)this._step).getOutputMiningName()));
            } else if (this._step instanceof ResidualPlotStep) {
                this._outputNameLabel.setVisible(true);
                this._outputName.setVisible(true);
                this._outputName.setText(DM4JStringUtils.trimDoubleQuotes(((ResidualPlotStep)this._step).getOutputMiningName()));
            } else {
                this._labelResults.setVisible(false);
                this._outputNameLabel.setVisible(false);
                this._outputName.setVisible(false);
            }
        }
    }

    private void updateStatusLabel(int n) {
        ActivityIconManager activityIconManager = ActivityIconManager.getInstance();
        this._currentStatus = n;
        if (n == COMPLETE) {
            this._labelOutputData.setVisible(true);
            if (this._step instanceof ODMrTextStep) {
                this.updateResultsLabel(false);
            } else if (this._step instanceof AbstractMiningStep) {
                this.updateResultsLabel(true);
            }
            if (this._step.hasDataMinerWarnings()) {
                this._labelStatus.setText(DM4JResourceUtilities.getActivityUIString("ACTIVITY_STEP_COMPLETE_WARNING"));
                this._labelStatus.setIcon(activityIconManager.getIcon("WARNING"));
                this._labelStatus.setActive(true);
            } else {
                this._labelStatus.setText(DM4JResourceUtilities.getActivityUIString("ACTIVITY_STEP_COMPLETE"));
                this._labelStatus.setIcon(activityIconManager.getIcon("COMPLETE"));
                this._labelStatus.setActive(false);
            }
        } else if (n == FAILED) {
            this._labelStatus.setText(DM4JResourceUtilities.getActivityUIString("ACTIVITY_STEP_FAILED"));
            this._labelStatus.setIcon(activityIconManager.getIcon("FAILED"));
            this._labelStatus.setActive(true);
            this._labelOutputData.setVisible(false);
            this._labelResults.setVisible(false);
            this._outputNameLabel.setVisible(false);
            this._outputName.setVisible(false);
        } else if (n == RUNNING) {
            this._labelStatus.setText(DM4JResourceUtilities.getActivityUIString("ACTIVITY_STEP_RUNNING"));
            this._labelStatus.setIcon(activityIconManager.getIcon("RUNNING"));
            this._labelStatus.setActive(false);
            this._labelOutputData.setVisible(false);
            this._labelResults.setVisible(false);
            this._outputNameLabel.setVisible(false);
            this._outputName.setVisible(false);
        } else if (n == SKIPPED) {
            this._labelStatus.setText(DM4JResourceUtilities.getActivityUIString("ACTIVITY_STEP_SKIPPED"));
            this._labelStatus.setIcon(activityIconManager.getIcon("SKIPPED"));
            this._labelStatus.setActive(false);
            this._labelOutputData.setVisible(false);
            this._labelResults.setVisible(false);
            this._outputNameLabel.setVisible(false);
            this._outputName.setVisible(false);
        } else if (n == INCOMPLETE) {
            this._labelStatus.setText(" ");
            this._labelStatus.setIcon(null);
            this._labelStatus.setActive(false);
            this._labelOutputData.setVisible(false);
            this._labelResults.setVisible(false);
            this._outputNameLabel.setVisible(false);
            this._outputName.setVisible(false);
        } else if (n == CHECKING) {
            this._labelStatus.setText(DM4JResourceUtilities.getActivityUIString("ACTIVITY_STEP_CHECK"));
            this._labelStatus.setIcon(null);
            this._labelStatus.setActive(false);
            this._labelOutputData.setVisible(false);
            this._labelResults.setVisible(false);
            this._outputNameLabel.setVisible(false);
            this._outputName.setVisible(false);
        } else if (n == DISABLED) {
            this._labelOutputData.setVisible(true);
            if (this._step instanceof ODMrTextStep) {
                this.updateResultsLabel(false);
            } else if (this._step instanceof AbstractMiningStep) {
                this.updateResultsLabel(true);
            }
            if (this._step.hasDataMinerWarnings()) {
                this._labelStatus.setText(DM4JResourceUtilities.getActivityUIString("ACTIVITY_STEP_COMPLETE_WARNING"));
                this._labelStatus.setIcon(activityIconManager.getIcon("WARNING"));
                this._labelStatus.setActive(true);
            } else {
                this._labelStatus.setText(DM4JResourceUtilities.getActivityUIString("ACTIVITY_STEP_DISABLED"));
                this._labelStatus.setIcon(activityIconManager.getIcon("FAILED"));
                this._labelStatus.setActive(false);
            }
        }
        this._labelStatus.setVerticalTextPosition(1);
    }

    private boolean isStepImmutable() {
        return (this._activity instanceof AbstractApplyActivity || this._activity instanceof AbstractTestActivity) && this._step instanceof AbstractTransformationStep;
    }

    private void updateButtons(boolean bl, boolean bl2, boolean bl3) {
        this._buttonReset.setEnabled(bl);
        this._buttonStart.setEnabled(bl2 && this._enableStep.isSelected());
        this._enableStep.setEnabled(bl2);
        this._buttonOptions.setEnabled(!this.isStepImmutable() && this._enableStep.isSelected());
        boolean bl4 = this._step instanceof TestMetricStep;
        if (bl4) {
            Serializable serializable;
            TestMetricStep testMetricStep = (TestMetricStep)this._step;
            Double d = testMetricStep.getThresholdValue();
            if (d != null) {
                serializable = DM4JNumericFormat.getInstance(false, 8);
                String string = ((Format)serializable).format(d);
                this._buttonROCThreshold.setText(DM4JResourceUtilities.getUIString("ACTIVITY_SELECTED_ROCTHRESHOLD") + string);
            } else {
                this._buttonROCThreshold.setText(DM4JResourceUtilities.getUIString("ACTIVITY_SELECT_ROCTHRESHOLD"));
            }
            if (testMetricStep != null && testMetricStep.getStepOptions() instanceof ClassificationTestMetricStepOptions) {
                serializable = (ClassificationTestMetricStepOptions)testMetricStep.getStepOptions();
                if (testMetricStep.getIsComplete() && ((ClassificationTestMetricStepOptions)serializable).isGenROC() && this.getCurrentStatus() == COMPLETE) {
                    this._buttonROCThreshold.setEnabled(true);
                } else {
                    this._buttonROCThreshold.setEnabled(false);
                }
            } else {
                this._buttonROCThreshold.setVisible(false);
            }
        }
    }

    public void startAsyncStepMonitor(final AbstractMiningStep abstractMiningStep) {
        if (abstractMiningStep.getOutputMiningName() == null || abstractMiningStep.getOutputMiningName().length() == 0) {
            return;
        }
        Thread thread = new Thread("DMR$ActvityStepMonitor"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Connection connection = null;
                OraConnection oraConnection = null;
                DMEMetadata dMEMetadata = null;
                try {
                    if (10.interrupted()) {
                        return;
                    }
                    oraConnection = (OraConnection)DM4JConnectionManager.getConnection();
                    connection = oraConnection.getDatabaseConnection();
                    dMEMetadata = DMEMetadata.getInstance();
                    String string = ActivityUtils.mapStepToTaskType(abstractMiningStep);
                    String string2 = abstractMiningStep.getOutputMiningName();
                    if (10.interrupted()) {
                        return;
                    }
                    boolean bl = false;
                    String string3 = null;
                    try {
                        string3 = dMEMetadata.getTaskNameForMiningObject(connection, string, string2);
                        if (null != string3) {
                            bl = true;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (bl) {
                        if (10.interrupted()) {
                            return;
                        }
                        if (dMEMetadata.isTaskSuccessful(connection, string3)) {
                            ActivityStepPanel.this.updateStatus(COMPLETE);
                            return;
                        }
                        if (dMEMetadata.isTaskFailed(connection, string3)) {
                            ActivityStepPanel.this.updateStatus(FAILED);
                            return;
                        }
                        while (dMEMetadata.isTaskRunning(connection, string3)) {
                            ActivityStepPanel.this.updateStatus(RUNNING);
                            10.sleep(1000L);
                            if (!10.interrupted()) continue;
                            return;
                        }
                        if (10.interrupted()) {
                            return;
                        }
                        if (dMEMetadata.isTaskSuccessful(connection, string3)) {
                            ActivityStepPanel.this.updateStatus(COMPLETE);
                            return;
                        }
                        if (dMEMetadata.isTaskFailed(connection, string3)) {
                            ActivityStepPanel.this.updateStatus(FAILED);
                            return;
                        }
                        if (dMEMetadata.isTaskDisabled(connection, string3)) {
                            ActivityStepPanel.this.updateStatus(DISABLED);
                            return;
                        }
                    }
                    if (10.interrupted()) {
                        return;
                    }
                    boolean bl2 = ActivityUtils.miningObjectExists(oraConnection, abstractMiningStep, string2);
                    if (bl2) {
                        ActivityStepPanel.this.updateStatus(COMPLETE);
                        return;
                    }
                    ActivityStepPanel.this.updateStatus(FAILED);
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    if (oraConnection != null) {
                        try {
                            oraConnection.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }
        };
        thread.start();
        this._monitorThread = thread;
    }

    public void updateStatus(final int n) {
        final ActivityStepPanel activityStepPanel = this;
        Runnable runnable = new Runnable(){

            public void run() {
                if (n == RUNNING) {
                    ActivityStepPanel.this.updateStatusLabel(RUNNING);
                } else if (n == COMPLETE) {
                    ActivityStepPanel.this.updateStatusLabel(COMPLETE);
                    ActivityStepPanel.this.updateButtons(!ActivityStepPanel.this.isStepImmutable(), false, true);
                } else if (n == FAILED) {
                    ActivityStepPanel.this.updateStatusLabel(FAILED);
                    ActivityStepPanel.this.updateButtons(true, false, false);
                } else if (n == SKIPPED) {
                    ActivityStepPanel.this.updateStatusLabel(SKIPPED);
                    ActivityStepPanel.this.updateButtons(true, false, false);
                    ActivityStepPanel.this.setUISelected(ActivityStepPanel.this._table.getSelectedIndex() == ActivityStepPanel.this._table.getStepPanelIndex(activityStepPanel), true);
                } else if (n == DISABLED) {
                    ActivityStepPanel.this.updateStatusLabel(DISABLED);
                    ActivityStepPanel.this.updateButtons(!ActivityStepPanel.this.isStepImmutable(), false, true);
                }
            }
        };
        EventQueue.invokeLater(runnable);
    }

    public void removeNotify() {
        super.removeNotify();
        if (this._monitorThread != null) {
            this._monitorThread.interrupt();
        }
        this._monitorThread = null;
    }

    private void this_mouseClicked() {
        this._table.setSelection(this);
    }

    private void buttonStart_actionPerformed() {
        this._table.setSelection(this);
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        ActivityTaskManager activityTaskManager = ActivityTaskManager.getInstance();
        ActivityTask activityTask = activityTaskManager.getTask(this._activity.getName());
        if (activityTask != null && !activityTask.getIsIdle()) {
            JOptionPane.showMessageDialog(browserFrame, DM4JResourceUtilities.getUIString("ACTIVITY_WARN_RUNNING"), DM4JVersion.getFullBrowserName(), 0);
            return;
        }
        if (this._step instanceof ApplyStep && (this._activity instanceof AbstractApplyActivity || this._activity instanceof AbstractTestActivity) && !ActivityViewer.validateModelSignature(this._activity)) {
            return;
        }
        browserFrame.setCursor(new Cursor(3));
        this._buttonStart.setCursor(new Cursor(3));
        this._step.launchWizard(this._activity, true);
        if (this._step.getIsComplete() && this._step instanceof AbstractMiningStep) {
            this.startAsyncStepMonitor((AbstractMiningStep)this._step);
        }
        this._buttonStart.setCursor(new Cursor(0));
        browserFrame.setCursor(new Cursor(0));
        this._table.refresh();
    }

    private void buttonReset_actionPerformed() {
        this._table.setSelection(this);
        ActivityTaskManager activityTaskManager = ActivityTaskManager.getInstance();
        ActivityTask activityTask = activityTaskManager.getTask(this._activity.getName());
        if (activityTask != null && !activityTask.getIsIdle()) {
            JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("ACTIVITY_WARN_RESET_RUNNING"), DM4JVersion.getFullBrowserName(), 0);
            return;
        }
        try {
            if (this._activity.resetSteps(this._step)) {
                this._table.refresh();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void buttonOptions_actionPerformed() {
        this._table.setSelection(this);
        ActivityTaskManager activityTaskManager = ActivityTaskManager.getInstance();
        ActivityTask activityTask = activityTaskManager.getTask(this._activity.getName());
        if (activityTask != null && !activityTask.getIsIdle()) {
            JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("ACTIVITY_WARN_OPTIONS_RUNNING"), DM4JVersion.getFullBrowserName(), 0);
            return;
        }
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        browserFrame.setCursor(new Cursor(3));
        this._buttonStart.setCursor(new Cursor(3));
        this._step.launchOptionsDialog(this._activity);
        this._buttonStart.setCursor(new Cursor(0));
        browserFrame.setCursor(new Cursor(0));
        this._table.refresh();
    }

    private void buttonROCThreshold_actionPerformed() {
        this._table.setSelection(this);
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        browserFrame.setCursor(new Cursor(3));
        this._buttonROCThreshold.setCursor(new Cursor(3));
        try {
            TestMetricStep testMetricStep = (TestMetricStep)this._step;
            ROCThresholdSelectionStepOptions rOCThresholdSelectionStepOptions = new ROCThresholdSelectionStepOptions();
            rOCThresholdSelectionStepOptions.setActivityType(this._activity.getType());
            rOCThresholdSelectionStepOptions.setTestMetricsName(testMetricStep.getOutputMiningName());
            rOCThresholdSelectionStepOptions.setThresholdValue(testMetricStep.getThresholdValue());
            ROCThresholdSelectionDialog rOCThresholdSelectionDialog = new ROCThresholdSelectionDialog(new DM4JDialog(BrowserFrame.getMainFrame()), rOCThresholdSelectionStepOptions, false);
            if (!rOCThresholdSelectionDialog.isCancelled()) {
                Double d = rOCThresholdSelectionDialog.getSelectedThresholdValue();
                String string = rOCThresholdSelectionDialog.createThresholdCostMatrix(testMetricStep.getThresholdCostMatrix());
                testMetricStep.setThresholdValue(d);
                testMetricStep.setThresholdCostMatrix(string);
                class StoreActivity
                extends LongRunningProcess {
                    StoreActivity() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            ActivityStepPanel.this._activity.store();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        finally {
                            this.getProgressBar().setDoneStatus();
                        }
                    }
                }
                StoreActivity storeActivity = new StoreActivity();
                ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("ACTIVITY_STORING"), storeActivity, true, false);
                storeActivity.setProgressBar(progressBar);
                progressBar.start(DM4JResourceUtilities.getUIString("ACTIVITY_STORING"), "");
                this.refreshUI();
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getActivityUIString("CANNOT_STORE"), DM4JVersion.getFullBrowserName(), 0);
            exception.printStackTrace();
        }
        this._buttonROCThreshold.setCursor(new Cursor(0));
        browserFrame.setCursor(new Cursor(0));
    }

    private void buttonOutputData_actionPerformed(ActionEvent actionEvent) {
        HyperlinkButton hyperlinkButton = (HyperlinkButton)actionEvent.getSource();
        if (!hyperlinkButton.isActive()) {
            return;
        }
        OutputDataPickerFrame outputDataPickerFrame = new OutputDataPickerFrame(this._activity, this._step, hyperlinkButton);
    }

    private void buttonResults_actionPerformed(ActionEvent actionEvent) {
        HyperlinkButtonMiningResult hyperlinkButtonMiningResult = (HyperlinkButtonMiningResult)actionEvent.getSource();
        if (!hyperlinkButtonMiningResult.isActive()) {
            return;
        }
        LeafNodeData leafNodeData = null;
        try {
            leafNodeData = new LeafNodeData(((AbstractMiningStep)this._step).getOutputMiningName(), ((AbstractMiningStep)this._step).getOutputMiningType());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        hyperlinkButtonMiningResult.setLeafNodeData(leafNodeData);
        MiningResultViewerFrame miningResultViewerFrame = new MiningResultViewerFrame(hyperlinkButtonMiningResult, this._activity);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buttonStatus_actionPerformed(ActionEvent actionEvent) {
        HyperlinkButton hyperlinkButton;
        block7: {
            hyperlinkButton = (HyperlinkButton)actionEvent.getSource();
            if (!hyperlinkButton.isActive()) {
                return;
            }
            hyperlinkButton.setCursor(Cursor.getPredefinedCursor(3));
            AbstractStep abstractStep = this._step;
            try {
                if (this.getCurrentStatus() == COMPLETE && abstractStep.hasDataMinerWarnings()) {
                    ActivityStepWarningPanel activityStepWarningPanel = new ActivityStepWarningPanel(this._step);
                    DM4JSimpleDialog dM4JSimpleDialog = new DM4JSimpleDialog((Frame)BrowserUtils.getParentFrame(this), (JPanel)activityStepWarningPanel, DM4JResourceUtilities.getActivityUIString("WARNING_DIALOG_TITLE"), null);
                    dM4JSimpleDialog.setCloseDialog();
                    dM4JSimpleDialog.setNoHelp();
                    dM4JSimpleDialog.setSize(new Dimension(550, 400));
                    dM4JSimpleDialog.setVisible(true);
                    if (dM4JSimpleDialog.isOk()) {
                        // empty if block
                    }
                    break block7;
                }
                if (abstractStep.hasDataMinerErrors() || abstractStep.hasDataMinerWarnings() || this.getCurrentStatus() == FAILED) {
                    ActivityStepErrorPanel activityStepErrorPanel = new ActivityStepErrorPanel(abstractStep);
                    DM4JSimpleDialog dM4JSimpleDialog = new DM4JSimpleDialog((Frame)BrowserUtils.getParentFrame(this), (JPanel)activityStepErrorPanel, DM4JResourceUtilities.getActivityUIString("ERROR_DIALOG_TITLE"), null);
                    dM4JSimpleDialog.setCloseDialog();
                    dM4JSimpleDialog.setNoHelp();
                    dM4JSimpleDialog.setSize(new Dimension(550, 400));
                    dM4JSimpleDialog.setVisible(true);
                    if (dM4JSimpleDialog.isOk()) {
                        // empty if block
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        hyperlinkButton.setCursor(Cursor.getPredefinedCursor(12));
    }

    public AbstractStep getStep() {
        return this._step;
    }

    public Icon getStepResultIcon(ActivityIconManager activityIconManager) {
        Icon icon = null;
        icon = this._step instanceof BuildStep ? (this._activity instanceof AdaptiveBayesActivity ? activityIconManager.getIcon("ABN_MODEL") : (this._activity instanceof AnomalyDetectionActivity ? activityIconManager.getIcon("SVM_ONE_CLASS_MODEL") : (this._activity instanceof AssociationRulesActivity ? activityIconManager.getIcon("ASSOCIATION_RULES_MODEL") : (this._activity instanceof AttributeImportanceActivity ? activityIconManager.getIcon("ATTRIBUTE_IMPORTANCE_MODEL") : (this._activity instanceof DecisionTreeActivity ? activityIconManager.getIcon("DT_MODEL") : (this._activity instanceof KMeansActivity ? activityIconManager.getIcon("CLUSTERING_KMEANS_MODEL") : (this._activity instanceof NaiveBayesActivity ? activityIconManager.getIcon("NB_MODEL") : (this._activity instanceof NMFActivity ? activityIconManager.getIcon("NMF_MODEL") : (this._activity instanceof OClusterActivity ? activityIconManager.getIcon("CLUSTERING_OCLUSTER_MODEL") : (this._activity instanceof SVMClassificationActivity ? activityIconManager.getIcon("SVM_CLASSIFICATION_MODEL") : (this._activity instanceof SVMRegressionActivity ? activityIconManager.getIcon("SVM_REGRESSION_MODEL") : activityIconManager.getIcon("")))))))))))) : (this._step instanceof TestMetricStep ? activityIconManager.getIcon("TEST_METRIC_RESULT") : (this._step instanceof ApplyStep ? activityIconManager.getIcon("APPLY_RESULT") : (this._step instanceof ResidualPlotStep ? activityIconManager.getIcon("RESIDUAL_PLOT_RESULT") : activityIconManager.getIcon(""))));
        return icon;
    }

    public String getStepOutputDataDescription() {
        String string = "";
        string = this._step instanceof BuildStep ? DM4JResourceUtilities.getUIString("ACTIVITY_STEP_BUILDDATA") : (this._step instanceof TestMetricStep ? DM4JResourceUtilities.getUIString("ACTIVITY_STEP_TESTDATA") : (this._step instanceof ApplyStep ? DM4JResourceUtilities.getUIString("ACTIVITY_STEP_APPLYDATA") : (this._step instanceof ResidualPlotStep ? DM4JResourceUtilities.getUIString("ACTIVITY_STEP_RESIDUALDATA") : DM4JResourceUtilities.getUIString("ACTIVITY_STEP_OUTPUTDATA"))));
        return string;
    }

    private void enableStep_actionPerformed(ActionEvent actionEvent) {
        JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
        boolean bl = jCheckBox.isSelected();
        this._step.setIsEnabled(bl);
        this._buttonOptions.setEnabled(bl);
        this._buttonStart.setEnabled(bl);
        try {
            BrowserFrame browserFrame = BrowserFrame.getMainFrame();
            browserFrame.setCursor(new Cursor(3));
            this._activity.store();
            browserFrame.setCursor(new Cursor(0));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHyperlinkAction(ActionEvent actionEvent) {
        Serializable serializable;
        HyperlinkButton hyperlinkButton = (HyperlinkButton)actionEvent.getSource();
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        if (!hyperlinkButton.isActive()) {
            return;
        }
        hyperlinkButton.setCursor(Cursor.getPredefinedCursor(3));
        boolean bl = false;
        if (this._step instanceof AbstractTransformationStep) {
            this.findDataSourceInTree();
        } else if (this._step instanceof BuildStep) {
            serializable = (AbstractMiningStep)this._step;
            Connection connection = null;
            String string = null;
            try {
                connection = DM4JConnectionManager.getDbConnection();
                string = BrowserUtils.getModelType(connection, ((AbstractMiningStep)serializable).getOutputMiningName());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            bl = browserFrame.findComponent(string, ((AbstractMiningStep)serializable).getOutputMiningName(), true);
        } else if (this._step instanceof TestMetricStep) {
            serializable = (AbstractMiningStep)this._step;
            bl = browserFrame.findComponent("TEST_METRIC_RESULT", ((AbstractMiningStep)serializable).getOutputMiningName(), true);
        } else if (this._step instanceof ApplyStep) {
            serializable = (AbstractMiningStep)this._step;
            bl = browserFrame.findComponent("APPLY_RESULT", ((AbstractMiningStep)serializable).getOutputMiningName(), true);
        }
        if (bl && !((serializable = BrowserUtils.getParentFrame(hyperlinkButton)) instanceof BrowserFrame)) {
            BrowserFrame.getMainFrame().toFront();
        }
        hyperlinkButton.setCursor(Cursor.getPredefinedCursor(12));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findDataSourceInTree() {
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            String string = this._step.getOutputDataDescriptor().getCaseSchema();
            String string2 = this._step.getOutputDataDescriptor().getCaseTable();
            if (DatabaseMetadata.isTable(connection, string, string2)) {
                browserFrame.findSchemaObject(string, string2, "TABLE");
            } else {
                browserFrame.findSchemaObject(string, string2, "VIEW");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setUISelected(boolean bl, Boolean bl2) {
        Component[] componentArray = this.getComponents();
        Color color = null;
        Color color2 = null;
        color = Color.BLACK;
        if (bl2 == null) {
            bl2 = this._step.isSkipped(this._activity);
        }
        if (bl2.booleanValue()) {
            this.setBackground(this._unselSkippedColor);
            color2 = this._unselSkippedColor;
        } else {
            this.setBackground(this._unselColor);
            color2 = this._unselColor;
        }
        if (bl) {
            this.setBorder(BorderFactory.createEtchedBorder(0, Color.black, Color.gray));
        } else {
            this.setBorder(BorderFactory.createEtchedBorder(1));
        }
        for (int i = 0; i < componentArray.length; ++i) {
            JComponent jComponent;
            Component component = componentArray[i];
            if (component instanceof JLabel || component instanceof HyperlinkButton) {
                jComponent = (JComponent)componentArray[i];
                jComponent.setForeground(color);
                jComponent.setBackground(color2);
                continue;
            }
            if (!(component instanceof JPanel)) continue;
            jComponent = (JPanel)component;
            jComponent.setForeground(color);
            jComponent.setBackground(color2);
            Component[] componentArray2 = jComponent.getComponents();
            for (int j = 0; j < componentArray2.length; ++j) {
                Component component2 = componentArray2[j];
                if (!(component2 instanceof JLabel) && !(component2 instanceof JTextField)) continue;
                JComponent jComponent2 = (JComponent)componentArray2[j];
                jComponent2.setForeground(color);
                jComponent2.setBackground(color2);
            }
        }
    }
}

