/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.activity;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.datamining.ExecutionHandle;
import javax.datamining.ExecutionState;
import javax.datamining.ExecutionStatus;
import javax.datamining.NamedObject;
import javax.datamining.base.Task;
import javax.datamining.resource.Connection;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JSimpleDialog;
import oracle.dmt.dm4j.activity.steps.AbstractMiningStep;
import oracle.dmt.dm4j.activity.steps.AbstractStep;
import oracle.dmt.dm4j.activity.steps.ApplyStep;
import oracle.dmt.dm4j.activity.steps.BuildStep;
import oracle.dmt.dm4j.activity.steps.ODMrTextStep;
import oracle.dmt.dm4j.activity.steps.ResidualPlotStep;
import oracle.dmt.dm4j.activity.steps.TestMetricStep;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.viewer.activity.ActivityStepWarningPanel;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.jdm.resource.OraConnection;

public class ActivityStepErrorPanel
extends GriddedPanel {
    AbstractStep m_step;
    boolean m_failedInUI;
    private Task m_task;
    private Task m_taskObject = null;
    private ExecutionStatus m_taskStatus;
    private ExecutionState m_taskState;
    JLabel lblStep = new JLabel();
    JLabel lblStepName = new JLabel();
    JLabel lblErrorTableHeader = new JLabel();
    JScrollPane scrollPane = new JScrollPane();
    JTextArea textArea = new JTextArea();
    JButton butWarnings = new JButton();
    JFrame m_frame;

    public ActivityStepErrorPanel(AbstractStep abstractStep) throws Exception {
        this.m_step = abstractStep;
        this.m_frame = (JFrame)this.getParent();
        this.setState();
        this.jbInit();
        this.runTimePanelLoad();
    }

    private void setState() {
        this.m_failedInUI = this.m_step.hasDataMinerErrors();
    }

    private String mapStepToTaskType(AbstractStep abstractStep) {
        String string = null;
        if (abstractStep instanceof BuildStep) {
            string = "BUILD";
        } else if (abstractStep instanceof ApplyStep) {
            string = "APPLY";
        } else if (abstractStep instanceof TestMetricStep) {
            string = "TEST";
        } else if (abstractStep instanceof ResidualPlotStep) {
            string = "PLOT";
        } else if (abstractStep instanceof ODMrTextStep) {
            string = "XTEXT";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getServerError() throws Exception {
        Connection connection = null;
        boolean bl = false;
        try {
            connection = DM4JConnectionManager.getConnection();
            java.sql.Connection connection2 = ((OraConnection)connection).getDatabaseConnection();
            DMEMetadata dMEMetadata = DMEMetadata.getInstance();
            String string = this.mapStepToTaskType(this.m_step);
            String string2 = null;
            if (this.m_step instanceof AbstractMiningStep) {
                string2 = dMEMetadata.getTaskNameForMiningObject(connection2, string, ((AbstractMiningStep)this.m_step).getOutputMiningName());
            }
            if (null != string2) {
                bl = true;
                this.m_task = (Task)connection.retrieveObject(DMEMetadata.fixObjectNameWhenLoad(string2), NamedObject.task);
                ExecutionHandle executionHandle = this.m_task.getExecutionHandle();
                this.m_taskStatus = executionHandle.getLatestStatus();
                this.m_taskState = this.m_taskStatus.getState();
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    private void runTimePanelLoad() throws Exception {
        if (this.m_failedInUI) {
            this.textArea.setText(this.m_step.getDataMinerErrorMessage());
            Runnable runnable = new Runnable(){

                public void run() {
                    ActivityStepErrorPanel.this.scrollPane.getViewport().setViewPosition(new Point(0, 0));
                }
            };
            EventQueue.invokeLater(runnable);
        } else {
            this.textArea.setText(DM4JResourceUtilities.getActivityUIString("ERROR_DIALOG_LOADING"));
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        if (ActivityStepErrorPanel.this.getServerError()) {
                            ActivityStepErrorPanel.this.textArea.setText(DM4JResourceUtilities.getActivityUIString("ERROR_DIALOG_TASK_STATE") + "  " + ActivityStepErrorPanel.this.m_taskState.name() + "\n\n" + DM4JResourceUtilities.getActivityUIString("ERROR_DIALOG_TASK_DETAIL") + "  " + "\n\n" + "    " + ActivityStepErrorPanel.this.m_taskStatus.getDescription());
                        } else {
                            ActivityStepErrorPanel.this.textArea.setText(DM4JResourceUtilities.getActivityUIString("ERROR_DIALOG_TASK_LOAD_ERROR"));
                        }
                        Runnable runnable = new Runnable(){

                            public void run() {
                                ActivityStepErrorPanel.this.scrollPane.getViewport().setViewPosition(new Point(0, 0));
                            }
                        };
                        EventQueue.invokeLater(runnable);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.setPriority(5);
            thread.start();
        }
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.lblStep.setText(DM4JResourceUtilities.getActivityUIString("ERROR_DIALOG_STEP_LABEL"));
        this.lblStep.setLabelFor(this.lblStepName);
        this.addAnchoredComponent(this.lblStep, TOPLABELITEMINSETS, n, 0, 1, 1, 18);
        this.lblStepName.setText(this.m_step.getTitle());
        this.addAnchoredComponent(this.lblStepName, TOPVALUEITEMINSETS, n, 1, 1, 1, 18);
        this.lblErrorTableHeader.setText(DM4JResourceUtilities.getActivityUIString("ERROR_DIALOG_ERROR_LABEL"));
        this.lblErrorTableHeader.setLabelFor(this.textArea);
        this.addAnchoredComponent(this.lblErrorTableHeader, TOPLABELITEMINSETS, ++n, 0, 2, 1, 16);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.scrollPane.getViewport().add((Component)this.textArea, null);
        this.addComponent(this.scrollPane, MIDLABELITEMINSETS, ++n, 0, 3, 2, 18, 1);
        ++n;
        if (this.m_step.hasDataMinerWarnings()) {
            this.butWarnings.setText(DM4JResourceUtilities.getActivityUIString("ERROR_DIALOG_WARNING_BUTTON_LABEL"));
            this.addAnchoredComponent(this.butWarnings, TOPLABELITEMINSETS, ++n, 0, 2, 1, 18);
            this.butWarnings.addActionListener(new ActionListener(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                        ActivityStepWarningPanel activityStepWarningPanel = new ActivityStepWarningPanel(ActivityStepErrorPanel.this.m_step);
                        DM4JSimpleDialog dM4JSimpleDialog = new DM4JSimpleDialog((Frame)ActivityStepErrorPanel.this.m_frame, (JPanel)activityStepWarningPanel, DM4JResourceUtilities.getActivityUIString("WARNING_DIALOG_TITLE"), null);
                        dM4JSimpleDialog.setCloseDialog();
                        dM4JSimpleDialog.setNoHelp();
                        dM4JSimpleDialog.setSize(new Dimension(550, 400));
                        dM4JSimpleDialog.setVisible(true);
                        if (dM4JSimpleDialog.isOk()) return;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
    }
}

