/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer;

import java.awt.event.ActionEvent;
import javax.datamining.resource.Connection;
import javax.swing.AbstractAction;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;

public abstract class ModelViewer
extends JTabbedPane {
    protected LeafNodeData m_node;
    protected Connection m_dmeConn = null;

    protected LeafNodeData getNode() {
        return this.m_node;
    }

    public ModelViewer(LeafNodeData leafNodeData, Connection connection, int n) throws Exception {
        this.m_node = leafNodeData;
        this.m_dmeConn = connection;
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ModelViewer.this.getHelpId();
                if (string != null) {
                    BrowserFrame.getCSHManager().showTopic(string);
                }
            }
        };
        this.loadViewer(leafNodeData, n);
        this.addChangeListener(new tabChangeListener());
    }

    public Connection getConnection() {
        return this.m_dmeConn;
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.m_dmeConn != null) {
            try {
                this.m_dmeConn.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected abstract void loadViewer(LeafNodeData var1, int var2) throws Exception;

    protected abstract void showTab(int var1);

    protected String getHelpId() {
        return "dm4j_introduction_html";
    }

    class tabChangeListener
    implements ChangeListener {
        tabChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ModelViewer.this.showTab(((JTabbedPane)changeEvent.getSource()).getSelectedIndex());
        }
    }
}

