/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Map;
import java.util.ResourceBundle;
import javax.datamining.MiningAlgorithm;
import javax.datamining.MiningFunction;
import javax.datamining.base.BuildSettings;
import javax.datamining.supervised.SupervisedModel;
import javax.datamining.supervised.classification.ClassificationSettings;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.TwoDModel;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.Dm4jSortableTwoDModel;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.modeldetail.glm.OraGLMModelDetail;

public class ModelGlobalDetailsPanel
extends GriddedPanel {
    JPanel m_grdPanel = null;
    ClassificationSettings m_classSettings = null;
    BuildSettings m_buildSettings = null;
    SupervisedModel m_model = null;
    String m_diagTableName = null;
    Map m_globalDetails = null;
    MiningFunction m_function = null;
    MiningAlgorithm m_algorithm = null;
    LeafNodeData m_nd = null;
    JScrollPane m_globalDetailsPanel = new JScrollPane();
    GlobalDetailsTable m_globalDetailsTable = null;
    int[] m_colWidths = new int[]{50, 50};
    private JLabel m_targetAttribName = new JLabel();
    static final String[] GLMR_DETAILS = new String[]{"MODEL_DF", "MODEL_SUM_SQUARES", "MODEL_MEAN_SQUARE", "F_VALUE", "MODEL_F_P_VALUE", "ERROR_DF", "ERROR_SUM_SQUARES", "ERROR_MEAN_SQUARE", "CORRECTED_TOTAL_DF", "CORRECTED_TOT_SS", "ROOT_MEAN_SQ", "DEPENDENT_MEAN", "COEFF_VAR", "R_SQ", "ADJUSTED_R_SQUARE", "AIC", "SBIC", "GMSEP", "HOCKING_SP", "J_P", "NUM_PARAMS", "NUM_ROWS", "MODEL_CONVERGED", "VALID_COVARIANCE_MATRIX"};
    static final String[] GLMC_DETAILS = new String[]{"AIC_INTERCEPT", "AIC_MODEL", "SC_INTERCEPT", "SC_MODEL", "NEG2_LL_INTERCEPT", "NEG2_LL_MODEL", "LR_DF", "LR_CHI_SQ", "LR_CHI_SQ_P_VALUE", "PSEUDO_R_SQ_CS", "PSEUDO_R_SQ_N", "PCT_CORRECT", "PCT_INCORRECT", "PCT_TIED", "DEPENDENT_MEAN", "NUM_PARAMS", "NUM_ROWS", "MODEL_CONVERGED", "VALID_COVARIANCE_MATRIX"};

    public ModelGlobalDetailsPanel(LeafNodeData leafNodeData) {
        try {
            this.m_model = (SupervisedModel)leafNodeData.getOdmObject();
            this.m_nd = leafNodeData;
            this.m_buildSettings = this.m_model.getBuildSettings();
            this.m_function = this.m_buildSettings.getMiningFunction();
            this.m_algorithm = this.m_buildSettings.getAlgorithmSettings() == null ? null : this.m_buildSettings.getAlgorithmSettings().getMiningAlgorithm();
            this.m_globalDetails = ((OraGLMModelDetail)this.m_model.getModelDetail()).getGlobalDetails();
            this.m_targetAttribName.setText(this.m_model.getTargetAttributeName());
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        if (MiningFunction.classification.equals(this.m_function) && OraMiningAlgorithm.generalizedLinearModel.equals(this.m_algorithm)) {
            return "GLM_MODEL";
        }
        if (MiningFunction.regression.equals(this.m_function) && OraMiningAlgorithm.generalizedLinearModel.equals(this.m_algorithm)) {
            return "GLM_REGRESSION_MODEL";
        }
        return null;
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.m_globalDetailsTable = new GlobalDetailsTable(null);
        this.m_globalDetailsTable.load();
        this.m_globalDetailsPanel.getViewport().add((Component)((Object)this.m_globalDetailsTable));
        this.m_globalDetailsPanel.setPreferredSize(null);
        Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(this.m_globalDetailsTable);
        JLabel jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("COMMON_TARGET"));
        this.addComponent(jLabel, TOPLABELITEMINSETS, n, 0);
        this.addComponent(this.m_targetAttribName, TOPVALUEITEMINSETS, n++, 1);
        JButton jButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        jButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        this.addAnchoredComponent(jButton, MIDLABELITEMINSETS, n++, 2, 1, 1, 14);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                    ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
                    if (!exportDialog.isCancelled()) {
                        exportDialog.export(ModelGlobalDetailsPanel.this.m_globalDetailsTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.addFilledComponent(this.m_globalDetailsPanel, MIDLABELITEMINSETS, n, 0, 3, 6, 1);
    }

    public void resize() throws Exception {
        this.m_globalDetailsTable.setColumnWidths(this.m_colWidths, true);
    }

    class GlobalDetailsTable
    extends Dm4jSpreadTable {
        ResourceBundle res;
        String[] m_columnNames;

        GlobalDetailsTable(Object object) {
            super(object);
            this.res = BrowserUtils.getBundleInstance();
            this.m_columnNames = new String[]{DM4JResourceUtilities.getUIString("GLM_GLOBAL_METRIC_NAME"), DM4JResourceUtilities.getUIString("GLM_GLOBAL_METRIC_VALUE")};
            Grid grid = this.getGrid();
            GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
            grid.setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
            this.setColumnNames(this.m_columnNames);
            try {
                this.displayLoadingStatus();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void load() throws Exception {
            Dm4jSortableTwoDModel dm4jSortableTwoDModel = new Dm4jSortableTwoDModel(){
                NumberFormat nf = DM4JNumericFormat.getInstance();
                NumberFormat nf_wprecision = DM4JNumericFormat.getInstance(false, 10);

                public void load(Object object) {
                    this.addColumns(0, 2);
                    this.addRows(0, ModelGlobalDetailsPanel.this.m_globalDetails.size());
                    String[] stringArray = MiningFunction.classification.equals(ModelGlobalDetailsPanel.this.m_function) ? GLMC_DETAILS : GLMR_DETAILS;
                    int n = 0;
                    for (int i = 0; i < stringArray.length; ++i) {
                        Object v = ModelGlobalDetailsPanel.this.m_globalDetails.get(stringArray[i]);
                        if (v == null) continue;
                        this.setData(0, n, DM4JResourceUtilities.getUIString(stringArray[i]));
                        if ("MODEL_CONVERGED".equals(stringArray[i]) || "VALID_COVARIANCE_MATRIX".equals(stringArray[i])) {
                            if (((Number)v).intValue() == 0) {
                                this.setData(1, n++, DM4JResourceUtilities.getUIString("COMMON_NO"));
                                continue;
                            }
                            this.setData(1, n++, DM4JResourceUtilities.getUIString("COMMON_YES"));
                            continue;
                        }
                        if (v instanceof Number) {
                            this.setData(1, n++, this.nf_wprecision.format(((Number)v).doubleValue()));
                            continue;
                        }
                        this.setData(1, n++, v);
                    }
                }
            };
            dm4jSortableTwoDModel.load(null);
            this.setVerticalSeparatorsVisible(true);
            this.setModels((TwoDModel)dm4jSortableTwoDModel, this.getColModel(), null);
            Header header = this.getColumnHeader();
            header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
            header.setItemInputHandler(null);
            header.setCanMoveItems(false);
        }
    }
}

