/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer;

import java.awt.Cursor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.activity.task.ActivityTask;
import oracle.dmt.dm4j.activity.task.ActivityTaskManager;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.JLabelAndIconRenderer;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.tree.ContextMenuHelper;
import oracle.dmt.dm4j.browser.tree.node.FolderNodeData;
import oracle.dmt.dm4j.browser.tree.node.JLabelNode;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.tree.node.NodeData;
import oracle.dmt.dm4j.browser.worker.RemoveObjectsWorker;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.browser.worker.listener.ObjectsRemovedListener;

public abstract class ListFolderViewer
extends JTable
implements ObjectsRemovedListener {
    protected FolderNodeData m_node;
    protected String m_folder_type;
    protected Vector m_selectedRows;
    protected String m_schema;

    public ListFolderViewer(FolderNodeData folderNodeData) {
        try {
            this.setDefaultRenderer(JLabel.class, new JLabelAndIconRenderer());
            this.m_node = folderNodeData;
            this.m_folder_type = folderNodeData.getNodeType();
            this.m_schema = folderNodeData.getSchemaName();
            this.loadViewer(folderNodeData);
            final ListFolderViewer listFolderViewer = this;
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class MenuListener
            extends MouseAdapter {
                MenuListener() {
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        ListFolderViewer.this.view_actionPerformed();
                    }
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        this.doPopup(mouseEvent);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        this.doPopup(mouseEvent);
                    }
                }

                private void doPopup(MouseEvent mouseEvent) {
                    if (!BrowserFrame.getMainFrame().checkUIState(1)) {
                        return;
                    }
                    int n = ListFolderViewer.this.getSelectedRow();
                    if (n < 0) {
                        return;
                    }
                    JLabelNode jLabelNode = (JLabelNode)ListFolderViewer.this.getValueAt(n, 0);
                    NodeData nodeData = jLabelNode.getNodeData();
                    if (nodeData instanceof LeafNodeData) {
                        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(nodeData);
                        JPopupMenu jPopupMenu = ContextMenuHelper.createContextMenu(defaultMutableTreeNode, listFolderViewer);
                        jPopupMenu.show(listFolderViewer, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
            MenuListener menuListener = new MenuListener();
            this.addMouseListener(menuListener);
            this.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (!BrowserFrame.getMainFrame().checkUIState(1)) {
                        return;
                    }
                    if (!keyEvent.isConsumed()) {
                        if (keyEvent.getKeyCode() == 127) {
                            int n = ListFolderViewer.this.getSelectedRow();
                            JLabelNode jLabelNode = (JLabelNode)ListFolderViewer.this.getValueAt(n, 0);
                            NodeData nodeData = jLabelNode.getNodeData();
                            BrowserContext browserContext = new BrowserContext(nodeData, LaunchPoint.CONTEXT_MENU);
                            BrowserFrame.getMainFrame().fileDelete_ActionPerformed(browserContext, listFolderViewer);
                            keyEvent.consume();
                        } else if (keyEvent.getKeyCode() == 10) {
                            ListFolderViewer.this.view_actionPerformed();
                            keyEvent.consume();
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected abstract void loadViewer(FolderNodeData var1) throws Exception;

    public abstract void refreshViewer() throws Exception;

    private void view_actionPerformed() {
        if (!BrowserFrame.getMainFrame().checkUIState(1)) {
            return;
        }
        int[] nArray = this.getSelectedRows();
        if (nArray.length != 1) {
            return;
        }
        int n = this.getSelectedRow();
        JLabelNode jLabelNode = (JLabelNode)this.getValueAt(n, 0);
        NodeData nodeData = jLabelNode.getNodeData();
        if (nodeData.getNodeType().equals("TABLES_SCHEMA") || nodeData.getNodeType().equals("VIEWS_SCHEMA")) {
            BrowserFrame.getMainFrame().findTableViewComponent(nodeData.getNodeType(), this.m_schema, true);
        } else if (nodeData.getNodeType().equals("TABLE") || nodeData.getNodeType().equals("VIEW")) {
            BrowserFrame.getMainFrame().findSchemaObject(this.m_schema, nodeData.getName(), nodeData.getNodeType());
        } else {
            BrowserFrame.getMainFrame().findComponent(nodeData.getNodeType(), nodeData.getName(), true);
        }
    }

    public NodeData getNode(int n) {
        JLabelNode jLabelNode = (JLabelNode)this.getValueAt(n, 0);
        NodeData nodeData = jLabelNode.getNodeData();
        return nodeData;
    }

    public void removeNotify() {
        super.removeNotify();
    }

    protected FolderNodeData getNode() {
        return this.m_node;
    }

    public void doDelete(boolean bl, boolean bl2, ListFolderViewer listFolderViewer) {
        int[] nArray = this.getSelectedRows();
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        ActivityTaskManager activityTaskManager = ActivityTaskManager.getInstance();
        boolean bl3 = false;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.getNode(nArray[i]));
            LeafNodeData leafNodeData = (LeafNodeData)defaultMutableTreeNode.getUserObject();
            if (leafNodeData.isActivityObject()) {
                ActivityTask activityTask = activityTaskManager.getTask(leafNodeData.getName());
                if (activityTask != null && activityTask.getIsRunning()) {
                    if (bl3) continue;
                    bl3 = true;
                    String string = "Selected activity is running.";
                    if (nArray.length > 1) {
                        string = "Some selected activities are running and will not be deleted.";
                    }
                    JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), string, DM4JVersion.getFullBrowserName(), 2);
                    continue;
                }
                vector.add(defaultMutableTreeNode);
                continue;
            }
            vector.add(defaultMutableTreeNode);
        }
        if (vector.size() == 0) {
            return;
        }
        this.m_selectedRows = (Vector)vector.clone();
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        RemoveObjectsWorker removeObjectsWorker = (RemoveObjectsWorker)workerThreadManager.getRemoveObjectsWorker(vector, bl, bl2);
        removeObjectsWorker.addRemovedListener(this);
        removeObjectsWorker.addRemovedListener(BrowserFrame.getMainFrame().getNavigatorTree());
        BrowserFrame.getMainFrame().setUIState(4);
        BrowserFrame.getMainFrame().setCursor(new Cursor(3));
        removeObjectsWorker.start();
        removeObjectsWorker.get();
    }

    public void objectsRemoved(EventObject eventObject) {
        int n;
        Vector vector = (Vector)eventObject.getSource();
        Vector<DefaultMutableTreeNode> vector2 = new Vector<DefaultMutableTreeNode>(20);
        for (n = 0; n < this.m_selectedRows.size(); ++n) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_selectedRows.get(n);
            if (vector.contains(defaultMutableTreeNode)) continue;
            vector2.add(defaultMutableTreeNode);
        }
        n = vector2.size();
        int n2 = this.m_selectedRows.size();
        if (n > 0 && n2 > 1) {
            Object[] objectArray = new Object[]{"" + (n2 - n), "" + n};
            String string = MessageFormat.format(DM4JResourceUtilities.getUIString("ERROR_DELETE_NOT_ALL"), objectArray);
            JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), string, DM4JVersion.getFullBrowserName(), 0);
        }
        this.clearSelection();
        try {
            this.refreshViewer();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        BrowserFrame.getMainFrame().removeUIState(4);
        if (BrowserFrame.getMainFrame().checkUIState(1)) {
            BrowserFrame.getMainFrame().setCursor(new Cursor(0));
        }
        this.clearSelection();
    }

    public String getHelpId() {
        return "BROWSER_FOLDER_VIEWERS";
    }
}

