/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.datamining.MiningAlgorithm;
import javax.datamining.base.Model;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.table.Dm4jSortableTwoDModel;
import oracle.dmt.jdm.OraMiningAlgorithm;

public class FilterAttributesTableModel
extends Dm4jSortableTwoDModel {
    private Vector m_attributes = new Vector();
    private int m_totalCnt = 0;
    private boolean m_isSelectedAll = false;
    private Hashtable m_lookupTableMap = null;
    private Hashtable<String, String> m_txColumnMapping = new Hashtable();
    private Model m_model;
    private static String _QUERY_SVM = "select distinct attribute_name, attribute_subname from (\n  SELECT NVL2( a_set.attribute_subname, a_set.attribute_name || '.' || a_set.attribute_subname, a_set.attribute_name) attribute_name,a_set.attribute_subname\n  FROM (SELECT * FROM TABLE(dbms_data_mining.get_model_details_svm(?))) a, TABLE(a.attribute_set) a_set\n  WHERE a_set.attribute_name is not null) \norder by attribute_name";
    private static String _QUERY_NB = "select distinct attribute_name, attribute_subname from (\n  SELECT NVL2( a_set.attribute_subname, a_set.attribute_name || '.' || a_set.attribute_subname, a_set.attribute_name) attribute_name,a_set.attribute_subname\n  FROM (SELECT * FROM TABLE(dbms_data_mining.get_model_details_nb(?))) a, TABLE(a.conditionals) a_set\n  WHERE a_set.attribute_name is not null) \norder by attribute_name";
    private static String _QUERY_NMF = "select distinct attribute_name, attribute_subname from (\n  SELECT NVL2( a_set.attribute_subname, a_set.attribute_name || '.' || a_set.attribute_subname, a_set.attribute_name) attribute_name,a_set.attribute_subname\n  FROM (SELECT * FROM TABLE(dbms_data_mining.get_model_details_nmf(?))) a, TABLE(a.ATTRIBUTE_SET) a_set\n  WHERE a_set.attribute_name is not null) \norder by attribute_name";
    private static String _QUERY_GLM = "select distinct attribute_name, attribute_subname from (\n  SELECT NVL2( a_set.attribute_subname, a_set.attribute_name || '.' || a_set.attribute_subname, a_set.attribute_name) attribute_name,a_set.attribute_subname\n  FROM (SELECT * FROM TABLE(dbms_data_mining.get_model_details_glm(?))) a_set\n  WHERE a_set.attribute_name is not null) \norder by attribute_name";

    public void selectAll(boolean bl) {
        this.m_isSelectedAll = bl;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (bl) {
                this.setData(0, i, Boolean.TRUE);
                continue;
            }
            this.setData(0, i, Boolean.FALSE);
        }
    }

    public boolean isSelectedAll() {
        return this.m_isSelectedAll;
    }

    private void addEmptyRow() {
        this.addRows(0, 1);
        this.addColumns(0, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTable(String string) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            statement = connection.createStatement();
            statement.setFetchSize(1000);
            resultSet = statement.executeQuery(string);
            int n = 0;
            int n2 = 1000;
            this.addRows(n, n2);
            this.addColumns(0, 1);
            while (resultSet.next()) {
                String string2 = resultSet.getString("attribute_name");
                this.setData(0, n, Boolean.TRUE);
                if (this.m_lookupTableMap == null) {
                    this.setData(1, n, string2);
                } else {
                    String string3 = string2;
                    String string4 = string2;
                    string4 = (String)this.m_lookupTableMap.get(string3);
                    if (string4 != null) {
                        this.setData(1, n, string4);
                    } else {
                        this.setData(1, n, string2);
                    }
                }
                this.m_attributes.add(string2);
                if (this.getRowCount() > ++n) continue;
                this.addRows(n, n2);
            }
            int n3 = this.getRowCount() - n;
            if (n3 > 0) {
                this.removeRows(n, n3);
            }
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Exception exception) {
            this.addEmptyRow();
            this.setData(0, 0, DM4JResourceUtilities.getUIString("COMMON_GET_FILTER_ATTRIBUTES_FAILED"));
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void load(Object object) {
        this.load(object, null);
    }

    private String getModelDetailsQry() {
        MiningAlgorithm miningAlgorithm = this.m_model.getMiningAlgorithm();
        if (miningAlgorithm.name().equalsIgnoreCase(MiningAlgorithm.naiveBayes.name())) {
            return _QUERY_NB;
        }
        if (miningAlgorithm.name().equalsIgnoreCase(MiningAlgorithm.svmClassification.name())) {
            return _QUERY_SVM;
        }
        if (miningAlgorithm.name().equalsIgnoreCase(MiningAlgorithm.svmRegression.name())) {
            return _QUERY_SVM;
        }
        if (miningAlgorithm.name().equalsIgnoreCase(OraMiningAlgorithm.nonNegativeMatrixFactorization.name())) {
            return _QUERY_NMF;
        }
        if (miningAlgorithm.name().equalsIgnoreCase(OraMiningAlgorithm.generalizedLinearModel.name())) {
            return _QUERY_GLM;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTable11G(String string) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            statement = connection.prepareStatement(this.getModelDetailsQry());
            statement.setString(1, string);
            resultSet = statement.executeQuery();
            int n = 0;
            int n2 = 1000;
            this.addRows(n, n2);
            this.addColumns(0, 1);
            while (resultSet.next()) {
                String string2 = resultSet.getString("attribute_name");
                String string3 = resultSet.getString("attribute_subname");
                this.setData(0, n, Boolean.TRUE);
                if (this.m_lookupTableMap == null) {
                    this.setData(1, n, string2);
                } else {
                    String string4 = string2;
                    String string5 = string2;
                    if (string3 != null) {
                        int n3;
                        String string6 = (String)this.m_lookupTableMap.get(string3);
                        if (string6 != null && (n3 = string2.lastIndexOf(string3)) != -1) {
                            string5 = string2.substring(0, n3) + string6;
                            String string7 = string2.substring(0, n3) + string3;
                            this.m_txColumnMapping.put(string5, string7);
                        }
                    } else {
                        string5 = (String)this.m_lookupTableMap.get(string4);
                    }
                    if (string5 != null) {
                        this.setData(1, n, string5);
                    } else {
                        this.setData(1, n, string2);
                    }
                }
                this.m_attributes.add(string2);
                if (this.getRowCount() > ++n) continue;
                this.addRows(n, n2);
            }
            int n4 = this.getRowCount() - n;
            if (n4 > 0) {
                this.removeRows(n, n4);
            }
        }
        catch (Exception exception) {
            this.addEmptyRow();
            this.setData(0, 0, DM4JResourceUtilities.getUIString("COMMON_GET_FILTER_ATTRIBUTES_FAILED"));
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
    }

    public void load(Object object, HashMap hashMap) {
        Model model = (Model)object;
        this.addRows(0, 1);
        this.addColumns(0, 1);
        int n = 0;
        try {
            this.m_lookupTableMap = (Hashtable)hashMap.get("COMMON_TEXT_LOOKUP");
            String string = model.getName();
            if (BrowserFrame.is11Server()) {
                this.updateTable11G(string);
            } else {
                String string2 = "select attribute_name from \"DM$P5<model_name>\" ORDER BY attribute_name ASC";
                string2 = BrowserUtils.getReplacedString(string2, "<model_name>", string);
                this.updateTable(string2);
            }
        }
        catch (Exception exception) {
            this.addEmptyRow();
            this.setData(0, n, DM4JResourceUtilities.getUIString("COMMON_GET_FILTER_ATTRIBUTES_FAILED"));
        }
    }

    public void setSelectedAttributes(Vector vector) {
        if (vector != null) {
            Vector<Integer> vector2 = new Vector<Integer>();
            int n = 0;
            block0: for (int i = 0; i < this.m_attributes.size(); ++i) {
                boolean bl = true;
                String string = (String)this.m_attributes.get(i);
                this.setData(n, i, Boolean.FALSE);
                for (int j = 0; j < vector.size(); ++j) {
                    String string2;
                    String string3 = (String)vector.get(j);
                    if (BrowserFrame.is11Server() && (string2 = this.m_txColumnMapping.get(string)) != null && string2.equalsIgnoreCase(string3)) {
                        vector2.add(new Integer(i));
                        continue block0;
                    }
                    if (!string.equalsIgnoreCase(string3)) continue;
                    vector2.add(new Integer(i));
                    continue block0;
                }
            }
            for (Integer n2 : vector2) {
                this.setData(n, n2, Boolean.TRUE);
            }
            this.m_isSelectedAll = this.m_attributes.size() == vector.size();
        }
    }

    public Vector getSelectedAttributes() {
        Vector<String> vector = new Vector<String>();
        if (this.m_attributes != null) {
            int n = 0;
            for (int i = 0; i < this.m_attributes.size(); ++i) {
                String string;
                int n2 = 0;
                Boolean bl = (Boolean)this.getData(n2++, n);
                String string2 = (String)this.getData(n2++, n++);
                if (bl != Boolean.TRUE) continue;
                if (BrowserFrame.is11Server() && (string = this.m_txColumnMapping.get(string2)) != null) {
                    string2 = string;
                }
                vector.add(string2);
            }
        }
        if (vector.size() == 0) {
            vector.add("");
        }
        return vector;
    }

    public void setModel(Object object) {
        assert (!(object instanceof Model));
        this.m_model = (Model)object;
    }
}

