/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.tree;

import java.awt.Cursor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Vector;
import javax.datamining.base.Model;
import javax.datamining.clustering.ClusteringModel;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.SupervisedModel;
import javax.datamining.supervised.regression.RegressionModel;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.activity.task.ActivityTask;
import oracle.dmt.dm4j.activity.task.ActivityTaskManager;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.tree.FindTreeNodeException;
import oracle.dmt.dm4j.browser.tree.NavigationAction;
import oracle.dmt.dm4j.browser.tree.NavigatorCellRenderer;
import oracle.dmt.dm4j.browser.tree.NavigatorSelectionModel;
import oracle.dmt.dm4j.browser.tree.NodeFoundListener;
import oracle.dmt.dm4j.browser.tree.SchemaNodeFoundListener;
import oracle.dmt.dm4j.browser.tree.node.FolderNodeData;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.tree.node.NodeData;
import oracle.dmt.dm4j.browser.viewer.ListFolderViewer;
import oracle.dmt.dm4j.browser.viewer.activity.ActivityViewer;
import oracle.dmt.dm4j.browser.viewer.table.TableViewer;
import oracle.dmt.dm4j.browser.worker.LoadActivityDetailWorker;
import oracle.dmt.dm4j.browser.worker.LoadActivityFolderWorker;
import oracle.dmt.dm4j.browser.worker.LoadDiscoObjectsFolderWorker;
import oracle.dmt.dm4j.browser.worker.LoadModelFolderWorker;
import oracle.dmt.dm4j.browser.worker.LoadObjectDetailWorker;
import oracle.dmt.dm4j.browser.worker.LoadObjectsWorker;
import oracle.dmt.dm4j.browser.worker.LoadResultFolderWorker;
import oracle.dmt.dm4j.browser.worker.LoadSchemaObjectDetailWorker;
import oracle.dmt.dm4j.browser.worker.LoadStaticFolderWorker;
import oracle.dmt.dm4j.browser.worker.LoadTablesFolderWorker;
import oracle.dmt.dm4j.browser.worker.RemoveObjectsWorker;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.browser.worker.listener.ActivityDetailLoadedListener;
import oracle.dmt.dm4j.browser.worker.listener.FolderLoadedListener;
import oracle.dmt.dm4j.browser.worker.listener.ObjectDetailLoadedListener;
import oracle.dmt.dm4j.browser.worker.listener.ObjectsLoadedListener;
import oracle.dmt.dm4j.browser.worker.listener.ObjectsRefreshedListener;
import oracle.dmt.dm4j.browser.worker.listener.ObjectsRemovedListener;
import oracle.dmt.dm4j.browser.worker.listener.SchemaObjectDetailLoadedListener;
import oracle.dmt.jdm.featureextraction.OraFeatureExtractionModel;

public class NavigatorTree
extends JTree
implements TreeExpansionListener,
TreeSelectionListener,
TreeWillExpandListener,
ObjectsLoadedListener,
ObjectsRemovedListener,
ObjectsRefreshedListener,
ObjectDetailLoadedListener,
SchemaObjectDetailLoadedListener,
ActivityDetailLoadedListener,
NodeFoundListener,
SchemaNodeFoundListener,
FolderLoadedListener {
    private DefaultTreeModel m_model = null;
    private NavigatorSelectionModel m_selection = null;
    private BrowserFrame m_mainFrame;
    private String m_navigatorType = BROWSER;
    private Model m_miningModel = null;
    private TreePath[] m_selectedPaths = null;
    private boolean m_inFocus = true;
    private DefaultMutableTreeNode m_schemasRoot = null;
    private DefaultMutableTreeNode m_discoGWRoot = null;
    private DefaultMutableTreeNode m_modelsRoot = null;
    private DefaultMutableTreeNode m_resultsRoot = null;
    private DefaultMutableTreeNode m_activitiesRoot = null;
    private DefaultMutableTreeNode m_top = null;
    private boolean m_deleting = false;
    public static String BROWSER = "BROWSER";
    public static String RESULTS_BROWSER = "RESULTS_BROWSER";

    public NavigatorTree(Model model) {
        this.m_navigatorType = RESULTS_BROWSER;
        this.m_miningModel = model;
        this.loadResultsNavigatorTree();
        this.addTreeExpansionListener(this);
        this.addTreeWillExpandListener(this);
    }

    public NavigatorTree() {
        this.loadNavigatorTree();
        this.addTreeSelectionListener(this);
        this.addTreeExpansionListener(this);
        this.addTreeWillExpandListener(this);
    }

    private void loadResultsNavigatorTree() {
        try {
            Object object;
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new FolderNodeData(this.m_miningModel.getName(), "RESULTS"));
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_TEST_RESULTS"), "TEST_METRICS_RESULTS"));
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_APPLY_RESULTS"), "APPLY_RESULTS"));
            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_RESIDUAL_PLOT_RESULTS"), "RESIDUAL_PLOT_RESULTS"));
            if (this.m_miningModel instanceof SupervisedModel && (object = ((SupervisedModel)this.m_miningModel).getTargetAttributeName()) != null) {
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(true));
            }
            if (this.m_miningModel instanceof SupervisedModel || this.m_miningModel instanceof ClusteringModel || this.m_miningModel instanceof OraFeatureExtractionModel) {
                defaultMutableTreeNode.add(defaultMutableTreeNode3);
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(true));
            }
            if (this.m_miningModel instanceof RegressionModel) {
                defaultMutableTreeNode.add(defaultMutableTreeNode4);
                defaultMutableTreeNode4.add(new DefaultMutableTreeNode(true));
            }
            this.m_model = new DefaultTreeModel(defaultMutableTreeNode);
            this.m_selection = new NavigatorSelectionModel();
            this.m_selection.setSelectionMode(4);
            this.setModel(this.m_model);
            this.setSelectionModel(this.m_selection);
            this.putClientProperty("JTree.lineStyle", "Angled");
            object = new NavigatorCellRenderer();
            this.setCellRenderer((TreeCellRenderer)object);
            this.setEditable(false);
            this.setRootVisible(false);
            this.setShowsRootHandles(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void loadNavigatorTree() {
        try {
            DefaultMutableTreeNode defaultMutableTreeNode;
            this.m_top = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_CONNECTION"), "CONNECTION"));
            this.m_modelsRoot = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_MODELS"), "MODELS"));
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_ASSOCIATION_RULES_MODELS"), "ASSOCIATION_RULES_MODELS"));
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_ATTRIBUTE_IMPORTANCE_MODELS"), "ATTRIBUTE_IMPORTANCE_MODELS"));
            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_CLASSIFICATION_MODELS"), "CLASSIFICATION_MODELS"));
            DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_REGRESSION_MODELS"), "REGRESSION_MODELS"));
            DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_FEATURE_EXTRACTION_MODELS"), "FEATURE_EXTRACTION_MODELS"));
            DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_CLUSTERING_MODELS"), "CLUSTERING_MODELS"));
            DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_ANOMALY_MODELS"), "ANOMALY_DETECTION_MODELS"));
            this.m_resultsRoot = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_RESULTS"), "RESULTS"));
            DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_TEST_RESULTS"), "TEST_METRICS_RESULTS"));
            DefaultMutableTreeNode defaultMutableTreeNode10 = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_APPLY_RESULTS"), "APPLY_RESULTS"));
            DefaultMutableTreeNode defaultMutableTreeNode11 = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_RESIDUAL_PLOT_RESULTS"), "RESIDUAL_PLOT_RESULTS"));
            DefaultMutableTreeNode defaultMutableTreeNode12 = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_PREDICT_RESULTS"), "PREDICT_RESULTS"));
            DefaultMutableTreeNode defaultMutableTreeNode13 = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_EXPLAIN_RESULTS"), "EXPLAIN_RESULTS"));
            DefaultMutableTreeNode defaultMutableTreeNode14 = new DefaultMutableTreeNode(new LeafNodeData(DM4JResourceUtilities.getUIString("TREE_TASKS"), "TASKS"));
            this.m_schemasRoot = defaultMutableTreeNode = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_SCHEMAS"), "SCHEMAS"));
            this.m_activitiesRoot = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_ACTIVITIES"), "ACTIVITIES"));
            DefaultMutableTreeNode defaultMutableTreeNode15 = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_ASSOCIATION_RULES_MODELS"), "ASSOCIATION_RULES_ACTIVITIES"));
            DefaultMutableTreeNode defaultMutableTreeNode16 = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_ATTRIBUTE_IMPORTANCE_MODELS"), "ATTRIBUTE_IMPORTANCE_ACTIVITIES"));
            DefaultMutableTreeNode defaultMutableTreeNode17 = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_CLASSIFICATION_MODELS"), "CLASSIFICATION_ACTIVITIES"));
            DefaultMutableTreeNode defaultMutableTreeNode18 = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_REGRESSION_MODELS"), "REGRESSION_ACTIVITIES"));
            DefaultMutableTreeNode defaultMutableTreeNode19 = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_FEATURE_EXTRACTION_MODELS"), "FEATURE_EXTRACTION_ACTIVITIES"));
            DefaultMutableTreeNode defaultMutableTreeNode20 = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_CLUSTERING_MODELS"), "CLUSTERING_ACTIVITIES"));
            DefaultMutableTreeNode defaultMutableTreeNode21 = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_ANOMALY_MODELS"), "ANOMALY_DETECTION_ACTIVITIES"));
            this.m_top.add(this.m_activitiesRoot);
            this.m_activitiesRoot.add(defaultMutableTreeNode21);
            defaultMutableTreeNode21.add(new DefaultMutableTreeNode(true));
            this.m_activitiesRoot.add(defaultMutableTreeNode15);
            defaultMutableTreeNode15.add(new DefaultMutableTreeNode(true));
            this.m_activitiesRoot.add(defaultMutableTreeNode16);
            defaultMutableTreeNode16.add(new DefaultMutableTreeNode(true));
            this.m_activitiesRoot.add(defaultMutableTreeNode17);
            defaultMutableTreeNode17.add(new DefaultMutableTreeNode(true));
            this.m_activitiesRoot.add(defaultMutableTreeNode20);
            defaultMutableTreeNode20.add(new DefaultMutableTreeNode(true));
            this.m_activitiesRoot.add(defaultMutableTreeNode19);
            defaultMutableTreeNode19.add(new DefaultMutableTreeNode(true));
            this.m_activitiesRoot.add(defaultMutableTreeNode18);
            defaultMutableTreeNode18.add(new DefaultMutableTreeNode(true));
            if (!BrowserFrame.isDisableDesignFeatures()) {
                this.m_top.add(defaultMutableTreeNode);
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(true));
            }
            DefaultMutableTreeNode defaultMutableTreeNode22 = new DefaultMutableTreeNode(new FolderNodeData(DM4JResourceUtilities.getUIString("TREE_DISCOGW"), "DISCOGW"));
            this.m_top.add(defaultMutableTreeNode22);
            defaultMutableTreeNode22.add(new DefaultMutableTreeNode(true));
            this.m_discoGWRoot = defaultMutableTreeNode22;
            this.m_top.add(this.m_modelsRoot);
            this.m_modelsRoot.add(defaultMutableTreeNode8);
            defaultMutableTreeNode8.add(new DefaultMutableTreeNode(true));
            this.m_modelsRoot.add(defaultMutableTreeNode2);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(true));
            this.m_modelsRoot.add(defaultMutableTreeNode3);
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(true));
            this.m_modelsRoot.add(defaultMutableTreeNode4);
            defaultMutableTreeNode4.add(new DefaultMutableTreeNode(true));
            this.m_modelsRoot.add(defaultMutableTreeNode7);
            defaultMutableTreeNode7.add(new DefaultMutableTreeNode(true));
            this.m_modelsRoot.add(defaultMutableTreeNode6);
            defaultMutableTreeNode6.add(new DefaultMutableTreeNode(true));
            this.m_modelsRoot.add(defaultMutableTreeNode5);
            defaultMutableTreeNode5.add(new DefaultMutableTreeNode(true));
            this.m_top.add(this.m_resultsRoot);
            this.m_resultsRoot.add(defaultMutableTreeNode9);
            defaultMutableTreeNode9.add(new DefaultMutableTreeNode(true));
            this.m_resultsRoot.add(defaultMutableTreeNode11);
            defaultMutableTreeNode11.add(new DefaultMutableTreeNode(true));
            this.m_resultsRoot.add(defaultMutableTreeNode10);
            defaultMutableTreeNode10.add(new DefaultMutableTreeNode(true));
            this.m_resultsRoot.add(defaultMutableTreeNode12);
            defaultMutableTreeNode12.add(new DefaultMutableTreeNode(true));
            this.m_resultsRoot.add(defaultMutableTreeNode13);
            defaultMutableTreeNode13.add(new DefaultMutableTreeNode(true));
            this.m_top.add(defaultMutableTreeNode14);
            this.m_model = new DefaultTreeModel(this.m_top);
            this.m_selection = new NavigatorSelectionModel();
            this.m_selection.setSelectionMode(4);
            this.setModel(this.m_model);
            this.setSelectionModel(this.m_selection);
            this.putClientProperty("JTree.lineStyle", "Angled");
            NavigatorCellRenderer navigatorCellRenderer = new NavigatorCellRenderer();
            this.setCellRenderer(navigatorCellRenderer);
            this.setShowsRootHandles(true);
            this.setEditable(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public DefaultMutableTreeNode getTop() {
        return this.m_top;
    }

    public DefaultMutableTreeNode getModelsRoot() {
        return this.m_modelsRoot;
    }

    public DefaultMutableTreeNode getResultsRoot() {
        return this.m_resultsRoot;
    }

    public DefaultMutableTreeNode getActivitiesRoot() {
        return this.m_activitiesRoot;
    }

    public void setActive(boolean bl) {
        this.m_inFocus = bl;
    }

    public void clearSelectedPaths() {
        this.m_selectedPaths = null;
    }

    public void saveSelectedPaths() {
        this.m_selectedPaths = this.getSelectionPaths();
    }

    public void restoreSelectedPaths() {
        if (this.m_selectedPaths != null) {
            int n;
            Vector<TreePath> vector = new Vector<TreePath>();
            int n2 = this.m_selectedPaths.length;
            for (n = 0; n < n2; ++n) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_selectedPaths[n].getLastPathComponent();
                if (defaultMutableTreeNode.getParent() == null) continue;
                vector.add(this.m_selectedPaths[n]);
            }
            n = vector.size();
            if (n > 0) {
                Object[] objectArray = new TreePath[n];
                vector.copyInto(objectArray);
                this.m_selectedPaths = objectArray;
                this.setSelectionPaths(this.m_selectedPaths);
            }
        } else {
            this.clearSelection();
        }
    }

    public void objectsLoaded(EventObject eventObject) {
        Object object = eventObject.getSource();
        if (object != null) {
            this.m_model.reload((DefaultMutableTreeNode)object);
        }
    }

    public void nodeFound(EventObject eventObject) {
        this.m_mainFrame.removeUIState(4);
        if (this.m_mainFrame.checkUIState(1)) {
            this.m_mainFrame.setCursor(new Cursor(0));
        }
        if (null == eventObject) {
            return;
        }
        if (eventObject.getSource() instanceof FindTreeNodeException) {
            FindTreeNodeException findTreeNodeException = (FindTreeNodeException)eventObject.getSource();
            JOptionPane.showMessageDialog(this.getMainFrame(), findTreeNodeException.getMessage() + " : " + findTreeNodeException.getObjectName(), DM4JVersion.getFullBrowserName(), 0);
            return;
        }
        TreePath treePath = (TreePath)eventObject.getSource();
        this.scrollPathToVisible(treePath);
        TreePath treePath2 = this.getLeadSelectionPath();
        if (null != treePath2) {
            Object object;
            int n = this.getSelectionCount();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath2.getLastPathComponent();
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 == (object = defaultMutableTreeNode2.getUserObject()) && n == 1 && object2 instanceof LeafNodeData) {
                this.loadObjectDetail((LeafNodeData)object2, defaultMutableTreeNode);
            }
        }
        this.setSelectionPath(treePath);
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        FolderNodeData folderNodeData;
        TreePath treePath = treeExpansionEvent.getPath();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode2.getUserObject();
        if (object instanceof FolderNodeData && (folderNodeData = (FolderNodeData)object).isLeafContainer() && (object = (defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getFirstChild()).getUserObject()) instanceof Boolean) {
            WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
            LoadObjectsWorker loadObjectsWorker = (LoadObjectsWorker)workerThreadManager.getLoadObjectsWorker(defaultMutableTreeNode2);
            if (null != this.m_miningModel) {
                loadObjectsWorker.setModelName(this.m_miningModel.getName());
            }
            loadObjectsWorker.addObjectsLoadedListener(this);
            loadObjectsWorker.start();
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public void folderLoaded(EventObject eventObject) {
        ArrayList arrayList = (ArrayList)eventObject.getSource();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)arrayList.get(0);
        ListFolderViewer listFolderViewer = (ListFolderViewer)arrayList.get(1);
        if (listFolderViewer != null) {
            TreePath treePath = this.getSelectionPath();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (this.getSelectionCount() == 1 && defaultMutableTreeNode2 == defaultMutableTreeNode) {
                FolderNodeData folderNodeData = (FolderNodeData)defaultMutableTreeNode.getUserObject();
                this.m_mainFrame.loadListFolderViewer(folderNodeData, listFolderViewer);
            }
        }
    }

    public void objectDetailLoaded(EventObject eventObject) {
        ArrayList arrayList = (ArrayList)eventObject.getSource();
        int n = 0;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)arrayList.get(n++);
        Integer n2 = (Integer)arrayList.get(n++);
        Connection connection = (Connection)arrayList.get(n++);
        if (defaultMutableTreeNode != null) {
            TreePath treePath = this.getSelectionPath();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (this.getSelectionCount() == 1 && defaultMutableTreeNode2 == defaultMutableTreeNode) {
                LeafNodeData leafNodeData = (LeafNodeData)defaultMutableTreeNode.getUserObject();
                this.m_mainFrame.loadViewer(leafNodeData, connection, n2);
            }
        }
    }

    public void schemaObjectDetailLoaded(EventObject eventObject) {
        ArrayList arrayList = (ArrayList)eventObject.getSource();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)arrayList.get(0);
        TableViewer tableViewer = (TableViewer)arrayList.get(1);
        if (tableViewer != null) {
            TreePath treePath = this.getSelectionPath();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (this.getSelectionCount() == 1 && defaultMutableTreeNode2 == defaultMutableTreeNode) {
                LeafNodeData leafNodeData = (LeafNodeData)defaultMutableTreeNode.getUserObject();
                this.m_mainFrame.loadTableViewer(leafNodeData, tableViewer);
            }
        }
    }

    public void activityDetailLoaded(EventObject eventObject) {
        ArrayList arrayList = (ArrayList)eventObject.getSource();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)arrayList.get(0);
        ActivityViewer activityViewer = (ActivityViewer)arrayList.get(1);
        if (defaultMutableTreeNode != null) {
            TreePath treePath = this.getSelectionPath();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (this.getSelectionCount() == 1 && defaultMutableTreeNode2 == defaultMutableTreeNode) {
                LeafNodeData leafNodeData = (LeafNodeData)defaultMutableTreeNode.getUserObject();
                this.m_mainFrame.loadActivityViewer(leafNodeData, activityViewer);
            }
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.m_deleting) {
            return;
        }
        if (!this.m_navigatorType.equals(BROWSER)) {
            return;
        }
        if (treeSelectionEvent.getNewLeadSelectionPath() == null) {
            this.m_mainFrame.loadEmptySelectionViewer();
            return;
        }
        if (!this.m_inFocus) {
            this.m_inFocus = true;
            return;
        }
        TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
        int n = this.getSelectionCount();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (n > 1) {
            this.m_mainFrame.loadMultipleSelectionViewer();
        } else if (n == 1) {
            if (object instanceof FolderNodeData) {
                this.loadFolderDetail((FolderNodeData)object, defaultMutableTreeNode);
            } else if (object instanceof LeafNodeData) {
                this.loadObjectDetail((LeafNodeData)object, defaultMutableTreeNode);
            }
        }
    }

    private void loadFolderDetail(FolderNodeData folderNodeData, DefaultMutableTreeNode defaultMutableTreeNode) {
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)browserFrame.getNavigatorTree().getLastSelectedPathComponent();
        NodeData nodeData = (NodeData)defaultMutableTreeNode2.getUserObject();
        browserFrame.addNavigationHistory(null, nodeData.getName(), nodeData.getNodeType());
        this.m_mainFrame.loadStatusPane();
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        String string = folderNodeData.getNodeType();
        if (string.equals("RESULTS") || string.equals("ACTIVITIES") || string.equals("CONNECTION") || string.equals("SCHEMAS") || string.equals("SCHEMA") || string.equals("MODELS")) {
            LoadStaticFolderWorker loadStaticFolderWorker = (LoadStaticFolderWorker)workerThreadManager.getLoadStaticFolderWorker(defaultMutableTreeNode);
            loadStaticFolderWorker.addStaticFolderLoadedListener(this);
            loadStaticFolderWorker.start();
        } else if (string.equals("ANOMALY_DETECTION_ACTIVITIES") || string.equals("ASSOCIATION_RULES_ACTIVITIES") || string.equals("ATTRIBUTE_IMPORTANCE_ACTIVITIES") || string.equals("CLASSIFICATION_ACTIVITIES") || string.equals("CLUSTERING_ACTIVITIES") || string.equals("FEATURE_EXTRACTION_ACTIVITIES") || string.equals("REGRESSION_ACTIVITIES")) {
            LoadActivityFolderWorker loadActivityFolderWorker = (LoadActivityFolderWorker)workerThreadManager.getLoadActivityFolderWorker(defaultMutableTreeNode);
            loadActivityFolderWorker.addActivityFolderLoadedListener(this);
            loadActivityFolderWorker.start();
        } else if (string.equals("ANOMALY_DETECTION_MODELS") || string.equals("ASSOCIATION_RULES_MODELS") || string.equals("ATTRIBUTE_IMPORTANCE_MODELS") || string.equals("CLASSIFICATION_MODELS") || string.equals("CLUSTERING_MODELS") || string.equals("FEATURE_EXTRACTION_MODELS") || string.equals("REGRESSION_MODELS")) {
            LoadModelFolderWorker loadModelFolderWorker = (LoadModelFolderWorker)workerThreadManager.getModelFolderWorker(defaultMutableTreeNode);
            loadModelFolderWorker.addModelFolderLoadedListener(this);
            loadModelFolderWorker.start();
        } else if (string.equals("APPLY_RESULTS") || string.equals("BUILD_RESULTS") || string.equals("EXPLAIN_RESULTS") || string.equals("PREDICT_RESULTS") || string.equals("RESIDUAL_PLOT_RESULTS") || string.equals("TEST_METRICS_RESULTS")) {
            LoadResultFolderWorker loadResultFolderWorker = (LoadResultFolderWorker)workerThreadManager.getResultFolderWorker(defaultMutableTreeNode);
            loadResultFolderWorker.addResultFolderLoadedListener(this);
            loadResultFolderWorker.start();
        } else if (string.equals("DISCOGW")) {
            LoadDiscoObjectsFolderWorker loadDiscoObjectsFolderWorker = (LoadDiscoObjectsFolderWorker)workerThreadManager.getDiscoObjectsFolderWorker(defaultMutableTreeNode);
            loadDiscoObjectsFolderWorker.addDiscoObjectsFolderLoadedListener(this);
            loadDiscoObjectsFolderWorker.start();
        } else if (string.equals("TABLES_SCHEMA") || string.equals("VIEWS_SCHEMA")) {
            LoadTablesFolderWorker loadTablesFolderWorker = (LoadTablesFolderWorker)workerThreadManager.getTablesFolderWorker(defaultMutableTreeNode);
            loadTablesFolderWorker.addTableFolderLoadedListener(this);
            loadTablesFolderWorker.start();
        } else {
            this.m_mainFrame.loadViewer(folderNodeData, null, 0);
        }
    }

    private void loadObjectDetail(LeafNodeData leafNodeData, DefaultMutableTreeNode defaultMutableTreeNode) {
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        browserFrame.addNavigationHistory(leafNodeData.getSchemaName(), leafNodeData.getName(), leafNodeData.getNodeType());
        NavigationAction navigationAction = browserFrame.getLoadObjectAction(leafNodeData.getName(), leafNodeData.getNodeType());
        int n = 0;
        if (null != navigationAction) {
            n = navigationAction.getTabIndex();
        }
        this.m_mainFrame.loadStatusPane();
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        if (leafNodeData.isSchemaObject()) {
            LoadSchemaObjectDetailWorker loadSchemaObjectDetailWorker = (LoadSchemaObjectDetailWorker)workerThreadManager.getLoadSchemaObjectDetailWorker(defaultMutableTreeNode, n);
            loadSchemaObjectDetailWorker.addSchemaObjectDetailLoadedListener(this);
            loadSchemaObjectDetailWorker.start();
        } else if (leafNodeData.isActivityObject()) {
            LoadActivityDetailWorker loadActivityDetailWorker = (LoadActivityDetailWorker)workerThreadManager.getActivityDetailWorker(defaultMutableTreeNode, n);
            loadActivityDetailWorker.addActivityDetailLoadedListener(this);
            loadActivityDetailWorker.start();
        } else {
            LoadObjectDetailWorker loadObjectDetailWorker = (LoadObjectDetailWorker)workerThreadManager.getLoadObjectDetailWorker(defaultMutableTreeNode, n);
            loadObjectDetailWorker.addObjectDetailLoadedListener(this);
            loadObjectDetailWorker.start();
        }
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        if (!this.m_mainFrame.checkUIState(1)) {
            throw new ExpandVetoException(null);
        }
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        if (!this.m_mainFrame.checkUIState(1)) {
            throw new ExpandVetoException(null);
        }
    }

    public void objectsRemoved(EventObject eventObject) {
        Object object;
        Object object2;
        Vector vector = (Vector)eventObject.getSource();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (this.m_inFocus && this.m_selectedPaths != null) {
            int n;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.m_selectedPaths[0].getLastPathComponent();
            object2 = (NodeData)defaultMutableTreeNode2.getUserObject();
            if (object2 instanceof LeafNodeData) {
                defaultMutableTreeNode = defaultMutableTreeNode2.getPreviousNode();
            }
            object = new Vector();
            int n2 = this.m_selectedPaths.length;
            for (n = 0; n < n2; ++n) {
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.m_selectedPaths[n].getLastPathComponent();
                if (vector.contains(defaultMutableTreeNode2)) continue;
                ((Vector)object).add(this.m_selectedPaths[n]);
            }
            n = ((Vector)object).size();
            if (n > 0) {
                Object[] objectArray = new TreePath[n];
                ((Vector)object).copyInto(objectArray);
                this.m_selectedPaths = objectArray;
                if (n2 > 1) {
                    Object[] objectArray2 = new Object[]{"" + (n2 - n), "" + n};
                    String string = MessageFormat.format(DM4JResourceUtilities.getUIString("ERROR_DELETE_NOT_ALL"), objectArray2);
                    JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), string, DM4JVersion.getFullBrowserName(), 0);
                }
            } else {
                this.clearSelectedPaths();
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            object2 = (DefaultMutableTreeNode)vector.get(i);
            object = (LeafNodeData)((DefaultMutableTreeNode)object2).getUserObject();
            TreePath treePath = null;
            treePath = ((LeafNodeData)object).isObjectType("TABLE") || ((LeafNodeData)object).isObjectType("VIEW") ? FolderNodeData.findSchemaObject(this.m_model, ((NodeData)object).getSchemaName(), ((NodeData)object).getNodeType(), ((NodeData)object).getName(), false) : FolderNodeData.findComponent(this.m_model, ((NodeData)object).getNodeType(), ((NodeData)object).getName(), false);
            if (treePath == null) continue;
            this.m_deleting = true;
            this.m_model.removeNodeFromParent((DefaultMutableTreeNode)treePath.getLastPathComponent());
            this.m_deleting = false;
        }
        this.m_mainFrame.removeUIState(4);
        if (this.m_mainFrame.checkUIState(1)) {
            this.m_mainFrame.setCursor(new Cursor(0));
        }
        if (defaultMutableTreeNode != null) {
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this.setSelectionPath(treePath);
        }
    }

    public void doDelete(boolean bl, boolean bl2) {
        this.saveSelectedPaths();
        TreePath[] treePathArray = this.getSelectionPaths();
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        ActivityTaskManager activityTaskManager = ActivityTaskManager.getInstance();
        boolean bl3 = false;
        int n = treePathArray.length;
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            LeafNodeData leafNodeData = (LeafNodeData)defaultMutableTreeNode.getUserObject();
            if (leafNodeData.isActivityObject()) {
                ActivityTask activityTask = activityTaskManager.getTask(leafNodeData.getName());
                if (activityTask != null && activityTask.getIsRunning()) {
                    if (bl3) continue;
                    bl3 = true;
                    String string = "Selected activity is running.";
                    if (treePathArray.length > 1) {
                        string = "Some selected activities are running and will not be deleted.";
                    }
                    JOptionPane.showMessageDialog(this.getMainFrame(), string, DM4JVersion.getFullBrowserName(), 2);
                    continue;
                }
                vector.add(defaultMutableTreeNode);
                continue;
            }
            vector.add(defaultMutableTreeNode);
        }
        if (vector.size() == 0) {
            return;
        }
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        RemoveObjectsWorker removeObjectsWorker = (RemoveObjectsWorker)workerThreadManager.getRemoveObjectsWorker(vector, bl, bl2);
        removeObjectsWorker.addRemovedListener(this);
        this.m_mainFrame.setUIState(4);
        this.m_mainFrame.setCursor(new Cursor(3));
        removeObjectsWorker.start();
        removeObjectsWorker.get();
    }

    public DefaultMutableTreeNode getSchemasTreeNode() {
        return this.m_schemasRoot;
    }

    public DefaultMutableTreeNode getDiscoGWNode() {
        return this.m_discoGWRoot;
    }

    public void objectsRefreshed(EventObject eventObject) {
        this.m_mainFrame.removeUIState(4);
        if (this.m_mainFrame.checkUIState(1)) {
            this.m_mainFrame.setCursor(new Cursor(0));
        }
        this.restoreSelectedPaths();
    }

    public void setMainFrame(BrowserFrame browserFrame) {
        this.m_mainFrame = browserFrame;
        this.m_selection.setMainFrame(browserFrame);
    }

    public BrowserFrame getMainFrame() {
        return this.m_mainFrame;
    }

    public DefaultTreeModel getTreeModel() {
        return this.m_model;
    }
}

