/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.tree.node.FolderNodeData;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;

public class NavigatorCellRenderer
extends JLabel
implements TreeCellRenderer {
    private Color m_textSelectionColor = UIManager.getColor("Tree.selectionForeground");
    private Color m_textNonSelectionColor = UIManager.getColor("Tree.textForeground");
    private Color m_bkSelectionColor = UIManager.getColor("Tree.selectionBackground");
    private Color m_bkNonSelectionColor = UIManager.getColor("Tree.textBackground");
    private Color m_borderSelectionColor = UIManager.getColor("Tree.selectionBorderColor");
    private boolean m_bSelected;

    public NavigatorCellRenderer() {
        this.setOpaque(false);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 instanceof FolderNodeData) {
            FolderNodeData folderNodeData = (FolderNodeData)object2;
            this.setText(folderNodeData.getName());
            if (bl2) {
                this.setIcon(folderNodeData.getExpandedIcon());
            } else {
                this.setIcon(folderNodeData.getIcon());
            }
            this.setToolTipText(folderNodeData.getName());
        } else if (object2 instanceof LeafNodeData) {
            LeafNodeData leafNodeData = (LeafNodeData)object2;
            this.setText(leafNodeData.getName());
            this.setIcon(leafNodeData.getIcon());
            this.setToolTipText(leafNodeData.getName());
        } else {
            String string = dM4JListResourceBundle.getString("COMMON_LOADING");
            this.setText(string);
            this.setToolTipText(string);
            this.setIcon(null);
        }
        this.setForeground(bl ? this.m_textSelectionColor : this.m_textNonSelectionColor);
        this.setBackground(bl ? this.m_bkSelectionColor : this.m_bkNonSelectionColor);
        this.m_bSelected = bl;
        return this;
    }

    public void paintComponent(Graphics graphics) {
        Color color = this.getBackground();
        Icon icon = this.getIcon();
        graphics.setColor(color);
        int n = 0;
        if (icon != null && this.getText() != null) {
            n = icon.getIconWidth() + this.getIconTextGap();
        }
        graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
        if (this.m_bSelected) {
            graphics.setColor(this.m_borderSelectionColor);
            graphics.drawRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
        }
        super.paintComponent(graphics);
    }
}

