/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.tree;

import java.util.EventObject;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.tree.FindTreeNodeException;
import oracle.dmt.dm4j.browser.tree.NodeFoundListener;
import oracle.dmt.dm4j.browser.tree.node.FolderNodeData;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.ThreadState;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;

public class FindTreeNodeWorker
extends SwingWorker
implements ThreadState {
    private static int s_thread = 0;
    private EventListenerList listenerList = new EventListenerList();
    private DefaultTreeModel m_model;
    private String m_type;
    private String m_node;
    private boolean m_saveNavigation = false;

    public FindTreeNodeWorker(WorkerThreadManager workerThreadManager, DefaultTreeModel defaultTreeModel, String string, String string2, boolean bl) {
        super(workerThreadManager);
        this.m_model = defaultTreeModel;
        this.m_type = string;
        this.m_node = string2;
        this.m_saveNavigation = bl;
    }

    public void addNodeFoundListener(NodeFoundListener nodeFoundListener) {
        this.listenerList.add(NodeFoundListener.class, nodeFoundListener);
    }

    public void removeNodeFoundListener(NodeFoundListener nodeFoundListener) {
        this.listenerList.remove(NodeFoundListener.class, nodeFoundListener);
    }

    public Object construct() {
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        TreePath treePath = null;
        try {
            if (s_thread == 0) {
                this.m_threadManager.setRunningState(16);
            }
            ++s_thread;
            treePath = FolderNodeData.findComponent(this.m_model, this.m_type, this.m_node, true);
        }
        catch (Exception exception) {
            return new FindTreeNodeException("Cannot find object", this.m_node, this.m_type, exception);
        }
        if (treePath != null && !this.m_saveNavigation) {
            browserFrame.addIgnoreNavigationHistory(null, this.m_node, this.m_type);
        }
        if (null != treePath) {
            return treePath;
        }
        return new FindTreeNodeException("Cannot find object", this.m_type, this.m_type);
    }

    public void finished() {
        if (--s_thread == 0) {
            this.m_threadManager.removeRunningState(16);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != NodeFoundListener.class) continue;
            ((NodeFoundListener)objectArray[i + 1]).nodeFound(this.getValue() != null ? new EventObject(this.getValue()) : null);
        }
    }
}

