/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.table;

import java.awt.Container;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Vector;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.NumericOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.share.collection.Range;
import oracle.dmt.dm4j.DM4JResourceUtilities;

public abstract class Dm4jSpreadTable
extends SpreadTable {
    private ArrayOneDModel m_colModel = null;
    private Object m_data = null;
    private String[] m_columnNames = null;
    private int[] m_columnWidths = null;
    private int[] m_columnWidthsPercent = null;
    private boolean m_isWidthsPercent = false;
    private ComponentAdapter m_componentListener = null;
    private boolean m_resize = true;

    public Dm4jSpreadTable(Object object) {
        this.m_data = object;
        Grid grid = this.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(2, 2, 2);
        grid.setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
    }

    private boolean isSizeByPercent() {
        return this.m_isWidthsPercent;
    }

    private void setColumnWidthsPercent(int[] nArray) {
        int n = this.m_colModel.getItemCount();
        JViewport jViewport = (JViewport)this.getParent();
        if (jViewport == null) {
            return;
        }
        int n2 = jViewport.getExtentSize().width;
        this.m_columnWidthsPercent = new int[nArray.length];
        System.arraycopy(nArray, 0, this.m_columnWidthsPercent, 0, nArray.length);
        this.m_columnWidths = new int[nArray.length];
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = (int)((float)n2 / 100.0f * (float)nArray[i]);
            if (i == n - 1) {
                n4 = n2 < n3 + n4 ? n4 : n2 - n3 - this.getColModel().getItemCount();
            }
            n3 += n4;
            this.m_columnWidths[i] = n4;
        }
        this.m_isWidthsPercent = true;
        this.setColumnWidths(this.m_columnWidths);
    }

    public void setColumnWidths(int n) {
        int n2 = this.m_colModel.getItemCount();
        final Dm4jSpreadTable dm4jSpreadTable = this;
        for (int i = 0; i < n2; ++i) {
            this.setColumnWidth(i, n);
        }
        this.m_isWidthsPercent = false;
        this.repaint();
        if (this.getResize()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (null != Dm4jSpreadTable.this.m_componentListener) {
                        Dm4jSpreadTable.this.getGrid().removeComponentListener((ComponentListener)Dm4jSpreadTable.this.m_componentListener);
                        Dm4jSpreadTable.this.m_componentListener = null;
                    }
                    if (Dm4jSpreadTable.this.getResize()) {
                        Dm4jSpreadTable.this.m_componentListener = new Resizer(dm4jSpreadTable);
                        Container container = Dm4jSpreadTable.this.getParent().getParent();
                        container.addComponentListener(Dm4jSpreadTable.this.m_componentListener);
                    }
                }
            });
        }
    }

    public void setColumnWidths(final int[] nArray, final boolean bl) throws Exception {
        if (bl && null != nArray) {
            int n = this.m_colModel.getItemCount();
            if (nArray.length != n) {
                throw new Exception("Number of columns does not match the number of percentage items");
            }
            int n2 = 0;
            for (int i = 0; i < nArray.length; ++i) {
                n2 += nArray[i];
            }
            if (n2 > 100) {
                throw new Exception("Total percentage exceeds 100 percent - check percentages");
            }
        }
        final Dm4jSpreadTable dm4jSpreadTable = this;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (bl && null != nArray) {
                    Dm4jSpreadTable.this.setColumnWidthsPercent(nArray);
                } else {
                    Dm4jSpreadTable.this.setColumnWidths(nArray);
                }
                if (null != Dm4jSpreadTable.this.m_componentListener) {
                    Dm4jSpreadTable.this.getGrid().removeComponentListener((ComponentListener)Dm4jSpreadTable.this.m_componentListener);
                    Dm4jSpreadTable.this.m_componentListener = null;
                }
                Dm4jSpreadTable.this.m_componentListener = new Resizer(dm4jSpreadTable);
                Container container = Dm4jSpreadTable.this.getParent().getParent();
                container.addComponentListener(Dm4jSpreadTable.this.m_componentListener);
            }
        });
    }

    private void setColumnWidths(int[] nArray) {
        block4: {
            block3: {
                this.m_columnWidths = nArray;
                if (null != nArray) break block3;
                int n = this.m_colModel.getItemCount();
                JViewport jViewport = (JViewport)this.getParent();
                if (jViewport == null) break block4;
                int n2 = jViewport.getExtentSize().width;
                if (0 == n2) {
                    return;
                }
                int n3 = n2 / n;
                int n4 = n2 % n;
                for (int i = 0; i < n; ++i) {
                    this.setColumnWidth(i, i == n - 1 ? n3 + n4 - this.getColModel().getItemCount() : n3);
                }
                break block4;
            }
            for (int i = 0; i < nArray.length; ++i) {
                this.setColumnWidth(i, this.m_columnWidths[i]);
            }
        }
    }

    public void setModels(TwoDModel twoDModel, ArrayOneDModel arrayOneDModel, ArrayOneDModel arrayOneDModel2) {
        super.setModels(twoDModel, (OneDModel)arrayOneDModel, (OneDModel)arrayOneDModel2);
        this.m_colModel = arrayOneDModel;
    }

    public void setModels2(TwoDModel twoDModel, ArrayOneDModel arrayOneDModel, NumericOneDModel numericOneDModel) {
        super.setModels(twoDModel, (OneDModel)arrayOneDModel, (OneDModel)numericOneDModel);
        this.m_colModel = arrayOneDModel;
    }

    public void setColumnNames(String[] stringArray) {
        this.m_columnNames = stringArray;
        this.m_colModel = new ArrayOneDModel((Object[])stringArray);
        this.setModels(null, this.m_colModel, null);
    }

    public Vector getSelectedIndexes(TwoDSelection twoDSelection) {
        Vector<Integer> vector = new Vector<Integer>();
        OneDSelection oneDSelection = twoDSelection.getRowSelection();
        Range[] rangeArray = oneDSelection.getRanges();
        if (null == rangeArray) {
            return vector;
        }
        for (int i = 0; i < rangeArray.length; ++i) {
            Range range = rangeArray[i];
            for (int j = range.getLowerLimit(); j <= range.getUpperLimit(); ++j) {
                vector.add(new Integer(j));
            }
        }
        return vector;
    }

    public boolean isMultpleSelection(TwoDSelection twoDSelection) {
        Range range;
        boolean bl = false;
        OneDSelection oneDSelection = twoDSelection.getRowSelection();
        Range[] rangeArray = oneDSelection.getRanges();
        if (null == rangeArray) {
            return false;
        }
        if (rangeArray.length > 1) {
            bl = true;
        } else if (rangeArray.length == 1 && (range = rangeArray[0]).getLowerLimit() != range.getUpperLimit()) {
            bl = true;
        }
        return bl;
    }

    public boolean isEmptySelection(TwoDSelection twoDSelection) {
        boolean bl = false;
        OneDSelection oneDSelection = twoDSelection.getRowSelection();
        Range[] rangeArray = oneDSelection.getRanges();
        return null == rangeArray;
    }

    public ArrayOneDModel getColModel() {
        return this.m_colModel;
    }

    protected void displayLoadingStatus() throws Exception {
        if (null == this.m_colModel) {
            throw new Exception("call setColumnNames prior to calling displayLoadingStatus");
        }
        StatusGridModel statusGridModel = new StatusGridModel();
        this.setModels((TwoDModel)statusGridModel, this.m_colModel, null);
        this.setVerticalSeparatorsVisible(false);
    }

    protected void setDataItem(Object object) {
        this.m_data = object;
    }

    public Object getDataItem() {
        return this.m_data;
    }

    public boolean getResize() {
        return this.m_resize;
    }

    public void setResize(boolean bl) {
        this.m_resize = bl;
    }

    class StatusGridModel
    extends SortableTwoDModel {
        public StatusGridModel() {
            this.addRows(0, 1);
            this.addColumns(0, Dm4jSpreadTable.this.m_colModel.getItemCount());
            this.setData(0, 0, new String(DM4JResourceUtilities.getUIString("COMMON_LOADING")));
        }
    }

    class Resizer
    extends ComponentAdapter {
        private Dm4jSpreadTable _spreadTable;

        public Resizer(Dm4jSpreadTable dm4jSpreadTable2) {
            this._spreadTable = dm4jSpreadTable2;
        }

        public void componentResized(ComponentEvent componentEvent) {
            this._spreadTable.invalidate();
            if (this._spreadTable.isSizeByPercent() && this._spreadTable.getResize()) {
                this._spreadTable.setColumnWidthsPercent(Dm4jSpreadTable.this.m_columnWidthsPercent);
            } else if (this._spreadTable.getResize()) {
                this._spreadTable.setColumnWidths(null);
            }
        }
    }
}

