/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.table;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.Hashtable;
import javax.datamining.MiningAlgorithm;
import javax.datamining.base.BuildSettings;
import javax.datamining.base.Model;
import javax.datamining.data.AttributeDataType;
import javax.datamining.data.AttributeType;
import javax.datamining.data.SignatureAttribute;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.table.Dm4jSortableTwoDModel;
import oracle.dmt.dm4j.browser.viewer.association.ODMrOraAssociationModel;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.jdm.OraMiningAlgorithm;

public class AttributeTableModel
extends Dm4jSortableTwoDModel {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load(Object object) throws Exception {
        Model model = (Model)object;
        BuildSettings buildSettings = model.getBuildSettings();
        String string = DM4JResourceUtilities.getUIString("COMMON_YES");
        String string2 = DM4JResourceUtilities.getUIString("COMMON_NO");
        Hashtable hashtable = DatabaseMetadata.getODMrTextLookupTable(model.getName());
        if (buildSettings.getAlgorithmSettings().getMiningAlgorithm().equals(MiningAlgorithm.svmClassification) || buildSettings.getAlgorithmSettings().getMiningAlgorithm().equals(MiningAlgorithm.svmRegression)) {
            Collection collection = null;
            SignatureAttribute[] signatureAttributeArray = null;
            int n = 0;
            try {
                collection = model.getSignature().getAttributes();
                if (collection != null) {
                    n = collection.size();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n != 0) {
                Object[] objectArray = collection.toArray();
                signatureAttributeArray = new SignatureAttribute[objectArray.length];
                System.arraycopy(objectArray, 0, signatureAttributeArray, 0, objectArray.length);
            }
            this.addRows(0, n);
            this.addColumns(0, 3);
            for (int i = 0; i < n; ++i) {
                String string3;
                String string4;
                int n2 = 0;
                SignatureAttribute signatureAttribute = signatureAttributeArray[i];
                String string5 = signatureAttribute.getName();
                if (hashtable == null) {
                    this.setData(n2++, i, string5);
                } else {
                    string4 = string5;
                    string3 = string5;
                    string3 = (String)hashtable.get(string4);
                    if (string3 != null) {
                        this.setData(n2++, i, string3);
                    } else {
                        this.setData(n2++, i, string5);
                    }
                }
                string4 = BrowserUtils.getOracleDataTypeString(signatureAttribute.getDataType());
                this.setData(n2++, i, string4);
                string3 = BrowserUtils.getAttributeTypeString(signatureAttribute.getAttributeType());
                this.setData(n2++, i, string3);
                Thread.yield();
            }
            return;
        }
        if (buildSettings.getAlgorithmSettings().getMiningAlgorithm().equals(OraMiningAlgorithm.nonNegativeMatrixFactorization)) {
            Collection collection = null;
            SignatureAttribute[] signatureAttributeArray = null;
            int n = 0;
            try {
                collection = model.getSignature().getAttributes();
                if (collection != null) {
                    n = collection.size();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n != 0) {
                Object[] objectArray = collection.toArray();
                signatureAttributeArray = new SignatureAttribute[objectArray.length];
                System.arraycopy(objectArray, 0, signatureAttributeArray, 0, objectArray.length);
            }
            this.addRows(0, n);
            this.addColumns(0, 3);
            for (int i = 0; i < n; ++i) {
                String string6;
                String string7;
                int n3 = 0;
                SignatureAttribute signatureAttribute = signatureAttributeArray[i];
                String string8 = signatureAttribute.getName();
                if (hashtable == null) {
                    this.setData(n3++, i, string8);
                } else {
                    string7 = string8;
                    string6 = string8;
                    string6 = (String)hashtable.get(string7);
                    if (string6 != null) {
                        this.setData(n3++, i, string6);
                    } else {
                        this.setData(n3++, i, string8);
                    }
                }
                string7 = BrowserUtils.getOracleDataTypeString(signatureAttribute.getDataType());
                this.setData(n3++, i, string7);
                string6 = BrowserUtils.getAttributeTypeString(signatureAttribute.getAttributeType());
                this.setData(n3++, i, string6);
                Thread.yield();
            }
            return;
        }
        if (buildSettings.getAlgorithmSettings().getMiningAlgorithm().equals(OraMiningAlgorithm.aprioriAssociationRules)) {
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                String string9 = model instanceof ODMrOraAssociationModel ? ((ODMrOraAssociationModel)model).getLookupTable() : null;
                String string10 = null;
                string10 = string9 == null && !BrowserFrame.is11Server() ? "SELECT attribute_name from \nDM$P2" + model.getName().toUpperCase() + " P2, " + "\nDM$P3" + model.getName().toUpperCase() + " P3, " + "\nDM$P4" + model.getName().toUpperCase() + " P4  " + "\nWHERE number_of_items=1 and" + "\nP3.ITEMSET_ID= P4.ITEMSET_ID and" + "\nP2.ITEM_ID = P4.ITEM_ID" + "\nORDER BY attribute_name ASC" : (string9 == null && BrowserFrame.is11Server() ? "SELECT concat(attribute_name,concat('.', attribute_subname))  as attribute_name from \nDM$P2" + model.getName().toUpperCase() + " P2, " + "\nDM$P3" + model.getName().toUpperCase() + " P3, " + "\nDM$P4" + model.getName().toUpperCase() + " P4  " + "\nWHERE number_of_items=1 and" + "\nP3.ITEMSET_ID= P4.ITEMSET_ID and" + "\nP2.ITEM_ID = P4.ITEM_ID" + "\nORDER BY attribute_name ASC" : (BrowserFrame.is11Server() ? "select \nNVL(cons_lookup.VALUE, ids.attribute_name) attribute_name \nfrom \n(SELECT  concat(attribute_name,concat('.',attribute_subname)) as attribute_name,\n       attribute_subname  \nfrom DM$P2" + model.getName().toUpperCase() + " P2, " + "\nDM$P3" + model.getName().toUpperCase() + " P3, " + "\nDM$P4" + model.getName().toUpperCase() + "  P4 " + "WHERE number_of_items=1 and \n" + "P3.ITEMSET_ID= P4.ITEMSET_ID and \n" + "P2.ITEM_ID = P4.ITEM_ID" + "\nORDER BY attribute_name ASC, attribute_subname ASC) ids, \n" + string9 + " cons_lookup" + "\nwhere ids.attribute_subname  = cons_lookup.KEY(+) \n " + "order by cons_lookup.VALUE" : "select \nNVL(cons_lookup.VALUE, ids.attribute_name) attribute_name \nfrom \n(SELECT attribute_name \nfrom DM$P2" + model.getName().toUpperCase() + " P2, " + "\nDM$P3" + model.getName().toUpperCase() + " P3, " + "\nDM$P4" + model.getName().toUpperCase() + "  P4 " + "WHERE number_of_items=1 and \n" + "P3.ITEMSET_ID= P4.ITEMSET_ID and \n" + "P2.ITEM_ID = P4.ITEM_ID" + "\nORDER BY attribute_name ASC) ids, \n" + string9 + " cons_lookup" + "\nwhere ids.attribute_name = cons_lookup.KEY(+) \n" + "order by cons_lookup.VALUE"));
                connection = DM4JConnectionManager.getDbConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string10);
                int n = 0;
                int n4 = 1000;
                this.addRows(n, n4);
                this.addColumns(0, 1);
                while (resultSet.next()) {
                    String string11 = resultSet.getString("attribute_name");
                    this.setData(0, n, string11);
                    if (this.getRowCount() > ++n) continue;
                    this.addRows(n, n4);
                }
                int n5 = this.getRowCount() - n;
                if (n5 > 0) {
                    this.removeRows(n, n5);
                }
                if (statement != null) {
                    statement.close();
                }
                if (resultSet == null) return;
                resultSet.close();
                return;
            }
            catch (Exception exception) {
                System.out.println("Exception Inside:" + Thread.currentThread().getName());
                throw exception;
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (buildSettings.getAlgorithmSettings().getMiningAlgorithm().equals(OraMiningAlgorithm.minimumDescriptionLength)) {
            Collection collection = null;
            SignatureAttribute[] signatureAttributeArray = null;
            int n = 0;
            try {
                collection = model.getSignature().getAttributes();
                if (collection != null) {
                    n = collection.size();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n != 0) {
                Object[] objectArray = collection.toArray();
                signatureAttributeArray = new SignatureAttribute[objectArray.length];
                System.arraycopy(objectArray, 0, signatureAttributeArray, 0, objectArray.length);
            }
            this.addRows(0, n);
            this.addColumns(0, 1);
            for (int i = 0; i < n; ++i) {
                int n6 = 0;
                SignatureAttribute signatureAttribute = signatureAttributeArray[i];
                String string12 = signatureAttribute.getName();
                this.setData(n6++, i, string12);
                Thread.yield();
            }
            return;
        }
        Collection collection = null;
        SignatureAttribute[] signatureAttributeArray = null;
        int n = 0;
        try {
            collection = model.getSignature().getAttributes();
            if (collection != null) {
                n = collection.size();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n != 0) {
            Object[] objectArray = collection.toArray();
            signatureAttributeArray = new SignatureAttribute[objectArray.length];
            System.arraycopy(objectArray, 0, signatureAttributeArray, 0, objectArray.length);
        }
        this.addRows(0, n);
        this.addColumns(0, 3);
        for (int i = 0; i < n; ++i) {
            String string13;
            Object object2;
            int n7 = 0;
            SignatureAttribute signatureAttribute = signatureAttributeArray[i];
            String string14 = signatureAttribute.getName();
            if (hashtable == null) {
                this.setData(n7++, i, string14);
            } else {
                object2 = string14;
                string13 = string14;
                string13 = (String)hashtable.get(object2);
                if (string13 != null) {
                    this.setData(n7++, i, string13);
                } else {
                    this.setData(n7++, i, string14);
                }
            }
            object2 = signatureAttribute.getDataType();
            string13 = BrowserUtils.getOracleDataTypeString((AttributeDataType)object2);
            this.setData(n7++, i, string13);
            AttributeType attributeType = signatureAttribute.getAttributeType();
            String string15 = BrowserUtils.getAttributeTypeString(attributeType);
            this.setData(n7++, i, string15);
            Thread.yield();
        }
    }
}

