/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.table;

import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.datamining.MiningAlgorithm;
import javax.datamining.base.BuildSettings;
import javax.datamining.base.Model;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.table.AttributeTableModel;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.worker.LoadAttributesWorker;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.browser.worker.listener.AttributesLoadedListener;
import oracle.dmt.jdm.OraMiningAlgorithm;

public final class AttributeTable
extends Dm4jSpreadTable
implements AttributesLoadedListener {
    private LoadAttributesWorker m_worker = null;
    private Model m_model = null;
    private String[] m_columnNames = new String[]{DM4JResourceUtilities.getUIString("ATTRIB_TBL_ATTRIB_NAME"), DM4JResourceUtilities.getUIString("ATTRIB_TBL_DATA_TYPE"), DM4JResourceUtilities.getUIString("ATTRIB_TBL_MINING_TYPE")};
    int[] m_colWidths = new int[]{65, 15, 20};
    private String[] m_ARcolumnNames = new String[]{DM4JResourceUtilities.getUIString("ATTRIB_TBL_ATTRIB_NAME")};
    int[] m_ARcolWidths = new int[]{100};
    private String[] m_AIcolumnNames = new String[]{DM4JResourceUtilities.getUIString("ATTRIB_TBL_ATTRIB_NAME")};
    int[] m_AIcolWidths = new int[]{100};
    private String[] m_SVMcolumnNames = new String[]{DM4JResourceUtilities.getUIString("ATTRIB_TBL_ATTRIB_NAME"), DM4JResourceUtilities.getUIString("ATTRIB_TBL_DATA_TYPE"), DM4JResourceUtilities.getUIString("ATTRIB_TBL_MINING_TYPE")};
    int[] m_SVMcolWidths = new int[]{70, 15, 15};
    private String[] m_NMFcolumnNames = new String[]{DM4JResourceUtilities.getUIString("ATTRIB_TBL_ATTRIB_NAME"), DM4JResourceUtilities.getUIString("ATTRIB_TBL_DATA_TYPE"), DM4JResourceUtilities.getUIString("ATTRIB_TBL_MINING_TYPE")};
    int[] m_NMFcolWidths = new int[]{55, 20, 25};

    public AttributeTable(Object object) {
        super(object);
        BuildSettings buildSettings = ((Model)object).getBuildSettings();
        if (buildSettings.getAlgorithmSettings().getMiningAlgorithm().equals(MiningAlgorithm.svmClassification) || buildSettings.getAlgorithmSettings().getMiningAlgorithm().equals(MiningAlgorithm.svmRegression)) {
            this.m_columnNames = this.m_SVMcolumnNames;
        } else if (buildSettings.getAlgorithmSettings().getMiningAlgorithm().equals(OraMiningAlgorithm.nonNegativeMatrixFactorization)) {
            this.m_columnNames = this.m_NMFcolumnNames;
        } else if (buildSettings.getAlgorithmSettings().getMiningAlgorithm().equals(OraMiningAlgorithm.aprioriAssociationRules)) {
            this.m_columnNames = this.m_ARcolumnNames;
        } else if (buildSettings.getAlgorithmSettings().getMiningAlgorithm().equals(OraMiningAlgorithm.minimumDescriptionLength)) {
            this.m_columnNames = this.m_AIcolumnNames;
        }
        this.setColumnNames(this.m_columnNames);
        Grid grid = this.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 0, 0);
        grid.setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
        try {
            this.displayLoadingStatus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void load() throws Exception {
        Model model;
        this.m_model = model = (Model)this.getDataItem();
        BuildSettings buildSettings = model.getBuildSettings();
        if (null == buildSettings) {
            throw new Exception("Cannot load data. MiningFunctionSettings not supplied");
        }
        if (buildSettings.getAlgorithmSettings().getMiningAlgorithm().equals(MiningAlgorithm.svmClassification) || buildSettings.getAlgorithmSettings().getMiningAlgorithm().equals(MiningAlgorithm.svmRegression)) {
            this.m_colWidths = this.m_SVMcolWidths;
        } else if (buildSettings.getAlgorithmSettings().getMiningAlgorithm().equals(OraMiningAlgorithm.nonNegativeMatrixFactorization)) {
            this.m_colWidths = this.m_NMFcolWidths;
        } else if (buildSettings.getAlgorithmSettings().getMiningAlgorithm().equals(OraMiningAlgorithm.aprioriAssociationRules)) {
            this.m_colWidths = this.m_ARcolWidths;
        } else if (buildSettings.getAlgorithmSettings().getMiningAlgorithm().equals(OraMiningAlgorithm.minimumDescriptionLength)) {
            this.m_colWidths = this.m_AIcolWidths;
        }
        this.setColumnWidths(this.m_colWidths, true);
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        this.m_worker = (LoadAttributesWorker)workerThreadManager.getLoadAttributesWorker(model);
        this.m_worker.addAttributesLoadedListener(this);
        this.m_worker.start();
    }

    public void tableLoaded(EventObject eventObject) {
        this.setVerticalSeparatorsVisible(true);
        AttributeTableModel attributeTableModel = (AttributeTableModel)((Object)eventObject.getSource());
        this.setModels((TwoDModel)attributeTableModel, this.getColModel(), null);
        Header header = this.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setItemInputHandler((HeaderItemInputHandler)new SortHandler(attributeTableModel));
        header.setCanMoveItems(false);
        this.m_worker = null;
        try {
            this.setColumnWidths(this.m_colWidths, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class SortHandler
    implements HeaderItemInputHandler {
        SortableTwoDModel model = null;
        boolean sortOrder = true;
        final boolean ASCENDING = true;
        int sortColIndex = 0;

        public SortHandler(SortableTwoDModel sortableTwoDModel) {
            this.model = sortableTwoDModel;
        }

        public void mouseClicked(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseDragged(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseEntered(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseExited(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseMoved(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mousePressed(MouseEvent mouseEvent, Header header, int n) {
            this.sortColIndex = n;
            this.sortOrder = !this.sortOrder;
            this.model.sort(this.sortColIndex, this.sortOrder);
        }

        public void mouseReleased(MouseEvent mouseEvent, Header header, int n) {
        }
    }
}

