/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.preferences;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.LAFType;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.browser.preferences.PreferencePanel;

public class EnvironmentPanel
extends GriddedPanel
implements PreferencePanel {
    private UserPreferences m_preferences = null;
    private JTextField m_workingDirectory = new JTextField();
    private JTextField m_sqlldrExecutable = new JTextField();
    private JButton m_btnWorkingDirectory = new JButton();
    private JButton m_btnSqlLdrImage = new JButton();
    private JLabel m_lafLabel = new JLabel();
    private JRadioButton m_lafNative = new JRadioButton();
    private JRadioButton m_lafOracle = new JRadioButton();
    private JLabel m_filler = new JLabel();

    public EnvironmentPanel(UserPreferences userPreferences) {
        try {
            this.m_preferences = userPreferences;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        int n = 0;
        this.m_btnWorkingDirectory.setText(DM4JResourceUtilities.getUIString("PREF_ENVIRONMENT_BROWSEWD"));
        this.m_btnWorkingDirectory.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "PREF_ENVIRONMENT_BROWSEWD"));
        this.m_btnSqlLdrImage.setText(DM4JResourceUtilities.getUIString("PREF_ENVIRONMENT_BROWSELDR"));
        this.m_btnSqlLdrImage.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "PREF_ENVIRONMENT_BROWSELDR"));
        JLabel jLabel = new JLabel();
        DM4JResourceUtilities.configureUILabel(jLabel, "PREF_ENVIRONMENT_WD", this.m_workingDirectory, dM4JListResourceBundle);
        JLabel jLabel2 = new JLabel();
        DM4JResourceUtilities.configureUILabel(jLabel2, "PREF_ENVIRONMENT_SQL_LDR", this.m_sqlldrExecutable, dM4JListResourceBundle);
        this.addFilledComponent(jLabel, TOPLABELITEMINSETS, n++, 0, 2, 1, 0);
        this.addFilledComponent(this.m_workingDirectory, MIDLABELITEMINSETS, n, 0, 2, 1, 2);
        this.addFilledComponent(this.m_btnWorkingDirectory, MIDLABELITEMINSETS, n++, 2, 1, 1, 0);
        this.addFilledComponent(jLabel2, TOPLABELITEMINSETS, n++, 0, 2, 1, 0);
        this.addFilledComponent(this.m_sqlldrExecutable, MIDLABELITEMINSETS, n, 0, 2, 1, 2);
        this.addFilledComponent(this.m_btnSqlLdrImage, MIDLABELITEMINSETS, n++, 2, 1, 1, 0);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.m_lafLabel.setText(DM4JResourceUtilities.getUIString("PREF_ENVIRONMENT_LAF_LABEL"));
        this.m_lafNative.setText(DM4JResourceUtilities.getUIString("PREF_ENVIRONMENT_LAF_NATIVE"));
        this.m_lafNative.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "PREF_ENVIRONMENT_LAF_NATIVE"));
        this.m_lafOracle.setText(DM4JResourceUtilities.getUIString("PREF_ENVIRONMENT_LAF_ORACLE"));
        this.m_lafOracle.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "PREF_ENVIRONMENT_LAF_ORACLE"));
        buttonGroup.add(this.m_lafNative);
        buttonGroup.add(this.m_lafOracle);
        this.addFilledComponent(this.m_lafLabel, TOPLABELITEMINSETS, n++, 0, 1, 1, 2);
        this.addFilledComponent(this.m_lafNative, MIDINDENTEDLABELITEMINSETS, n++, 0, 1, 1, 2);
        this.addFilledComponent(this.m_lafOracle, MIDINDENTEDLABELITEMINSETS, n++, 0, 1, 1, 2);
        this.addFilledComponent(this.m_filler, TOPLABELITEMINSETS, n, 0, 2, 2, 1);
        this.m_workingDirectory.setText(this.m_preferences.getWorkingDirectory());
        this.m_sqlldrExecutable.setText(this.m_preferences.getSQLLoaderPath());
        if (0 == this.m_preferences.getLAF().compareToIgnoreCase(LAFType.NATIVE.toString())) {
            this.m_lafNative.setSelected(true);
        } else {
            this.m_lafOracle.setSelected(true);
        }
        this.m_btnWorkingDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setApproveButtonText(DM4JResourceUtilities.getUIString("COMMON_SELECT"));
                jFileChooser.setDialogTitle(DM4JResourceUtilities.getUIString("COMMON_SELECT_DIRECTORY"));
                int n = jFileChooser.showOpenDialog(null);
                if (n == 0) {
                    EnvironmentPanel.this.m_workingDirectory.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.m_btnSqlLdrImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setApproveButtonText(DM4JResourceUtilities.getUIString("COMMON_SELECT"));
                jFileChooser.setDialogTitle(DM4JResourceUtilities.getUIString("COMMON_SELECT_FILE"));
                int n = jFileChooser.showOpenDialog(null);
                if (n == 0) {
                    EnvironmentPanel.this.m_sqlldrExecutable.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
    }

    public void applySettings() throws Exception {
        File file;
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        String string = this.m_workingDirectory.getText();
        String string2 = this.m_sqlldrExecutable.getText();
        File file2 = new File(string);
        if (!file2.exists()) {
            String string3 = DM4JResourceUtilities.getUIString("PREF_WD_NOT_EXIST");
            String string4 = DM4JVersion.getFullBrowserName();
            JOptionPane.showMessageDialog(this, string3, DM4JVersion.getFullBrowserName(), 0);
            throw new Exception(string3);
        }
        if (string2 != null && !string2.equalsIgnoreCase("") && !(file = new File(string2)).exists()) {
            String string5 = DM4JResourceUtilities.getUIString("PREF_SLE_NOT_EXIST");
            String string6 = DM4JVersion.getFullBrowserName();
            JOptionPane.showMessageDialog(this, string5, string6, 0);
            throw new Exception(string5);
        }
        this.m_preferences.setWorkingDirectory(string);
        this.m_preferences.setSQLLoaderPath(string2);
        if (this.m_lafNative.isSelected()) {
            this.m_preferences.setLAF(LAFType.NATIVE.toString());
        } else {
            this.m_preferences.setLAF(LAFType.ORACLE.toString());
        }
    }
}

