/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.preferences;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dmt.dm4j.ConnectionPersistence;
import oracle.dmt.dm4j.ConnectionPersistenceInfo;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.ConnectionEditDialog;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.preferences.PreferencePanel;

public class ConnectionsPanel
extends GriddedPanel
implements PreferencePanel {
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private JList _connList;
    private DefaultListModel _listModel = new DefaultListModel();
    private JLabel jLabelConn = new JLabel();
    private JButton btnEdit = new JButton();
    private JButton btnNew = new JButton();
    private JButton btnDelete = new JButton();
    private JLabel jLabelBlank = new JLabel();

    public ConnectionsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        this.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.jLabelConn.setText(DM4JResourceUtilities.getUIString("PREF_CONNECTIONS_LIST"));
        this.jLabelConn.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "PREF_CONNECTIONS_LIST"));
        this.jLabelConn.setLabelFor(this._connList);
        ConnectionPersistence connectionPersistence = ConnectionPersistence.getInstance();
        ConnectionPersistenceInfo[] connectionPersistenceInfoArray = connectionPersistence.getConnections();
        for (int i = 0; i < connectionPersistenceInfoArray.length; ++i) {
            this._listModel.addElement(connectionPersistenceInfoArray[i]);
        }
        this._connList = new JList();
        this._connList.setModel(this._listModel);
        this._connList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ConnectionsPanel.this.edit_actionPerformed(null);
                }
            }
        });
        this.jLabelConn.setLabelFor(this._connList);
        String string = connectionPersistence.getDefaultConnectionName();
        this.btnNew.setText(DM4JResourceUtilities.getUIString("COMMON_NEW"));
        this.btnNew.setActionCommand(DM4JResourceUtilities.getUIString("COMMON_NEW"));
        this.btnNew.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "COMMON_NEW"));
        this.btnNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionsPanel.this.new_actionPerformed(actionEvent);
            }
        });
        this.btnEdit.setText(DM4JResourceUtilities.getUIString("COMMON_EDIT"));
        this.btnEdit.setActionCommand(DM4JResourceUtilities.getUIString("COMMON_EDIT"));
        this.btnEdit.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "COMMON_EDIT"));
        this.btnEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionsPanel.this.edit_actionPerformed(actionEvent);
            }
        });
        this.btnDelete.setText(DM4JResourceUtilities.getUIString("COMMON_DELETE"));
        this.btnDelete.setActionCommand(DM4JResourceUtilities.getUIString("COMMON_DELETE"));
        this.btnDelete.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "COMMON_DELETE"));
        this.btnDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionsPanel.this.delete_actionPerformed(actionEvent);
            }
        });
        int n = 0;
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this._connList);
        this.addFilledComponent(this.jLabelConn, GriddedPanel.MIDLABELITEMINSETS, n++, 0, 1, 1, 2);
        this.addFilledComponent(jScrollPane, GriddedPanel.MIDVALUEITEMINSETS, n, 0, 4, 3, 1);
        this.addFilledComponent(this.btnNew, new Insets(5, 5, 0, 5), n++, 4, 1, 1, 2);
        this.addFilledComponent(this.btnEdit, new Insets(5, 5, 0, 5), n++, 4, 1, 1, 2);
        this.addFilledComponent(this.btnDelete, new Insets(5, 5, 0, 5), n++, 4, 1, 1, 2);
        this.addFilledComponent(new JLabel(), GriddedPanel.MIDLABELITEMINSETS, n += 2, 2, 2, 1, 1);
    }

    private void delete_actionPerformed(ActionEvent actionEvent) {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        int[] nArray = this._connList.getSelectedIndices();
        String string = null;
        boolean bl = false;
        if (nArray.length == 0) {
            JOptionPane.showMessageDialog(this, DM4JResourceUtilities.getUIString("PREF_CONN_NOSEL_DELETE"), DM4JVersion.getFullBrowserName(), 0, null);
            return;
        }
        if (1 == JOptionPane.showOptionDialog(this, DM4JResourceUtilities.getUIString("PREF_CONNECTIONS_DELETE_CONFIRM"), DM4JVersion.getFullBrowserName(), 0, 3, null, null, null)) {
            return;
        }
        ConnectionPersistence connectionPersistence = ConnectionPersistence.getInstance();
        try {
            string = connectionPersistence.getDefaultConnectionName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Vector<ConnectionPersistenceInfo> vector = new Vector<ConnectionPersistenceInfo>();
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (string != null && string.equals(this._listModel.get(nArray[i]).toString())) {
                bl = true;
            }
            vector.add((ConnectionPersistenceInfo)this._listModel.get(nArray[i]));
            this._listModel.remove(nArray[i]);
        }
        ConnectionPersistenceInfo[] connectionPersistenceInfoArray = new ConnectionPersistenceInfo[this._listModel.size()];
        if (connectionPersistenceInfoArray.length != 0) {
            for (int i = 0; i < connectionPersistenceInfoArray.length; ++i) {
                connectionPersistenceInfoArray[i] = (ConnectionPersistenceInfo)this._listModel.get(i);
            }
            if (bl) {
                string = connectionPersistenceInfoArray[0].getConnectionName();
            }
        } else {
            string = "";
        }
        try {
            connectionPersistence.storeConnections(connectionPersistenceInfoArray, string);
        }
        catch (Exception exception) {
            Container container = this.getParent();
            while (!(container instanceof JDialog)) {
                container = container.getParent();
            }
            JOptionPane.showOptionDialog(this, DM4JResourceUtilities.getUIString("PREF_CONN_ERROR_SAVE"), DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
        }
        try {
            ConnectionPersistence.removeCredentials(vector);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void edit_actionPerformed(ActionEvent actionEvent) {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        int n = this._connList.getSelectedIndex();
        int n2 = this._connList.getSelectedIndices().length;
        if (-1 == n || n2 > 1) {
            JOptionPane.showMessageDialog(this, DM4JResourceUtilities.getUIString("PREF_CONN_NOSEL_EDIT"), DM4JVersion.getFullBrowserName(), 0, null);
            return;
        }
        ConnectionPersistenceInfo connectionPersistenceInfo = (ConnectionPersistenceInfo)this._connList.getSelectedValue();
        ConnectionPersistence connectionPersistence = ConnectionPersistence.getInstance();
        Container container = this.getParent();
        String string = null;
        boolean bl = false;
        try {
            string = connectionPersistence.getDefaultConnectionName();
            if (string != null && string.equals(connectionPersistenceInfo.getConnectionName())) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (!(container instanceof JDialog)) {
            container = container.getParent();
        }
        ConnectionPersistenceInfo[] connectionPersistenceInfoArray = new ConnectionPersistenceInfo[this._listModel.size()];
        for (int i = 0; i < connectionPersistenceInfoArray.length; ++i) {
            connectionPersistenceInfoArray[i] = (ConnectionPersistenceInfo)this._listModel.get(i);
        }
        ConnectionEditDialog connectionEditDialog = new ConnectionEditDialog((Dialog)((JDialog)container), connectionPersistenceInfo, connectionPersistenceInfoArray);
        WindowUtils.centerWindow((Window)connectionEditDialog);
        connectionEditDialog.setVisible(true);
        if (connectionEditDialog.getUserAction() == ConnectionEditDialog.RET_CANCEL) {
            return;
        }
        if (bl) {
            string = connectionPersistenceInfo.getConnectionName();
        }
        try {
            connectionPersistence.storeConnections(connectionPersistenceInfoArray, string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, DM4JResourceUtilities.getUIString("PREF_CONN_ERROR_SAVE"), DM4JVersion.getFullBrowserName(), 0, null);
        }
        this._listModel.set(n, connectionPersistenceInfo);
        this._connList.setSelectedIndex(n);
    }

    private void new_actionPerformed(ActionEvent actionEvent) {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        Container container = this.getParent();
        Object var4_4 = null;
        while (!(container instanceof JDialog)) {
            container = container.getParent();
        }
        ConnectionPersistenceInfo[] connectionPersistenceInfoArray = new ConnectionPersistenceInfo[this._listModel.size()];
        for (int i = 0; i < this._listModel.size(); ++i) {
            connectionPersistenceInfoArray[i] = (ConnectionPersistenceInfo)this._listModel.get(i);
        }
        ConnectionEditDialog connectionEditDialog = new ConnectionEditDialog((Dialog)((JDialog)container), null, connectionPersistenceInfoArray);
        connectionEditDialog.setTitle(DM4JResourceUtilities.getUIString("PREF_CONN_NEW_TITLE"));
        WindowUtils.centerWindow((Window)connectionEditDialog);
        connectionEditDialog.setVisible(true);
        if (connectionEditDialog.getUserAction() == ConnectionEditDialog.RET_CANCEL) {
            return;
        }
        ConnectionPersistenceInfo connectionPersistenceInfo = connectionEditDialog.getConnectionInfo();
        ConnectionPersistence connectionPersistence = ConnectionPersistence.getInstance();
        this._listModel.add(this._listModel.size(), connectionPersistenceInfo);
        connectionPersistenceInfoArray = new ConnectionPersistenceInfo[this._listModel.size()];
        for (int i = 0; i < this._listModel.size(); ++i) {
            connectionPersistenceInfoArray[i] = (ConnectionPersistenceInfo)this._listModel.get(i);
        }
        try {
            connectionPersistence.storeConnections(connectionPersistenceInfoArray, connectionPersistenceInfo.getConnectionName());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, DM4JResourceUtilities.getUIString("PREF_CONN_ERROR_SAVE"), DM4JVersion.getFullBrowserName(), 0, null);
        }
        this._connList.setSelectedIndex(this._listModel.size() - 1);
    }

    private ConnectionPersistenceInfo[] addConnectionItem(ConnectionPersistenceInfo connectionPersistenceInfo) {
        ConnectionPersistenceInfo[] connectionPersistenceInfoArray = new ConnectionPersistenceInfo[this._listModel.size() + 1];
        int n = 0;
        for (n = 0; n < this._listModel.size(); ++n) {
            connectionPersistenceInfoArray[n] = (ConnectionPersistenceInfo)this._listModel.get(n);
        }
        connectionPersistenceInfoArray[n] = connectionPersistenceInfo;
        return connectionPersistenceInfoArray;
    }

    public void applySettings() {
    }
}

