/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.preferences;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.browser.preferences.PreferencePanel;

public class ClusterModelViewerPanel
extends GriddedPanel
implements PreferencePanel {
    private UserPreferences m_preferences = null;
    protected JRadioButton m_userPrecision = new JRadioButton();
    private NumberTextField m_userPrecisionValue = new NumberTextField();
    protected JRadioButton m_maxPrecision = new JRadioButton();
    protected ButtonGroup m_choices = new ButtonGroup();
    private JLabel m_filler = new JLabel();

    public ClusterModelViewerPanel(UserPreferences userPreferences) {
        try {
            this.m_preferences = userPreferences;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        boolean bl = this.m_preferences.getClusterDetailsPrecisionOption();
        GriddedPanel griddedPanel = new GriddedPanel();
        griddedPanel.setBorder(BorderFactory.createTitledBorder(DM4JResourceUtilities.getUIString("PREF_MODEL_VIEW_CL_DETAILS")));
        int n = 0;
        JLabel jLabel = new JLabel(DM4JResourceUtilities.getUIString("PREF_MODEL_VIEW_CL_DETAILS_DESC"));
        griddedPanel.addFilledComponent(jLabel, TOPLABELITEMINSETS, n++, 0, 2, 1, 0);
        this.m_userPrecision.setText(DM4JResourceUtilities.getUIString("PREF_MODEL_VIEW_CL_DETAILS_PREC_SET"));
        this.m_userPrecision.setSelected(bl);
        this.m_choices.add(this.m_userPrecision);
        this.m_userPrecision.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "PREF_MODEL_VIEW_CL_DETAILS_PREC_SET"));
        griddedPanel.addFilledComponent(this.m_userPrecision, COL1_CONTROL, n++, 0, 1, 1, 0);
        this.m_userPrecisionValue.setDataType(Integer.TYPE);
        this.m_userPrecisionValue.setNumber((Number)new Integer(this.m_preferences.getClusterDetailsPrecisionDegree()));
        this.m_userPrecisionValue.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_TIP_POSITIVE_INTEGER"));
        this.m_userPrecisionValue.setSigned(false);
        this.m_userPrecisionValue.setColumns(4);
        JLabel jLabel2 = new JLabel(DM4JResourceUtilities.getUIString("PREF_MODEL_VIEW_CL_DETAILS_PREC_SET_VAL"));
        DM4JResourceUtilities.configureUILabel(jLabel2, "PREF_MODEL_VIEW_CL_DETAILS_PREC_SET_VAL", (Component)this.m_userPrecisionValue, dM4JListResourceBundle);
        griddedPanel.addFilledComponent(jLabel2, COL2_LABEL, n, 0, 1, 1, 0);
        griddedPanel.addFilledComponent((JComponent)this.m_userPrecisionValue, COL2_CONTROL, n++, 1, 1, 1, 0);
        this.m_maxPrecision.setText(DM4JResourceUtilities.getUIString("PREF_MODEL_VIEW_CL_DETAILS_PREC_MAX"));
        this.m_maxPrecision.setSelected(!bl);
        this.m_choices.add(this.m_maxPrecision);
        this.m_maxPrecision.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "PREF_MODEL_VIEW_CL_DETAILS_PREC_MAX"));
        griddedPanel.addFilledComponent(this.m_maxPrecision, COL1_CONTROL, n, 0, 1, 1, 0);
        griddedPanel.addFilledComponent(new JLabel(" "), TOPVALUEITEMINSETS, n++, 2, 1, 1, 2);
        griddedPanel.addFilledComponent(new JLabel(" "), TOPVALUEITEMINSETS, n++, 1, 3, 3, 1);
        this.addFilledComponent(griddedPanel, TOPLABELITEMINSETS, 1, 0, 3, 2, 2);
        this.addFilledComponent(this.m_filler, TOPLABELITEMINSETS, 1, 0, 3, 2, 1);
    }

    public void applySettings() throws Exception {
        int n = -1;
        try {
            Integer n2 = (Integer)this.m_userPrecisionValue.getNumber();
            if (n2 != null) {
                n = n2;
            }
            if (n < 0) {
                throw new Exception("Negative, or blank values not allowed");
            }
            if (n > 39) {
                throw new Exception("Precision level greater than 39 not allowed.");
            }
        }
        catch (Exception exception) {
            String string = DM4JResourceUtilities.getUIString("PREF_MODEL_VIEW_CL_DETAILS_PREC_SET_VAL_ERROR");
            JOptionPane.showMessageDialog(this, string, DM4JVersion.getFullBrowserName(), 0);
            this.m_userPrecisionValue.requestFocus();
            throw new Exception(string);
        }
        this.m_preferences.setClusterDetailsPrecisionOption(this.m_userPrecision.isSelected());
        this.m_preferences.setClusterDetailsPrecisionDegree(n);
    }
}

