/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.disco;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.datamining.resource.Connection;
import javax.swing.JPanel;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JSimpleDialog;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.disco.AI_DGWPanel;
import oracle.dmt.dm4j.browser.disco.ANY_DGWPanel;
import oracle.dmt.dm4j.browser.disco.AP_DGWPanel;
import oracle.dmt.dm4j.browser.disco.AR_DGWPanel;
import oracle.dmt.dm4j.browser.disco.CLU_DGWPanel;
import oracle.dmt.dm4j.browser.disco.CTM_DGWPanel;
import oracle.dmt.dm4j.browser.disco.DGWPanel;
import oracle.dmt.dm4j.browser.disco.DT_DGWPanel;

public class DGWDialog
extends DM4JSimpleDialog {
    private int m_gwObjType = -1;
    public static final int DGW_AI = 1;
    public static final int DGW_AR = 2;
    public static final int DGW_CTM = 3;
    public static final int DGW_CTM_COMPARE = 4;
    public static final int DGW_SCORE_RESULTS = 5;
    public static final int DGW_CLUSTER_RULES = 6;
    public static final int DGW_DT_RULE_PROFILES = 7;
    public static final int DGW_SVMR_DEVIATION = 8;
    public static final int DGW_TABLE = 9;
    public static final int DGW_SVM_SINGLE_CLASS = 10;

    public DGWDialog(Frame frame, JPanel jPanel, String string, String string2, int n) {
        super(frame, jPanel, string, string2);
        this.m_gwObjType = n;
        this.setSize(new Dimension(550, 300));
    }

    public String getHelpTopicId() {
        switch (this.m_gwObjType) {
            case 1: {
                return "dm4j_disco_gate_ai_html";
            }
            case 2: {
                return "dm4j_disco_gate_ar_html";
            }
            case 3: {
                return "dm4j_disco_gate_test_html";
            }
            case 5: {
                return "dm4j_disco_gate_apply_html";
            }
            case 6: {
                return "dm4j_disco_gate_clus_html";
            }
            case 7: {
                return "dm4j_disco_gate_dt_html";
            }
            case 9: {
                return "dm4j_disco_gate_table_html";
            }
        }
        return "dm4j_disco_gate_use_html";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void okActionPerformed(ActionEvent actionEvent) {
        DGWPanel dGWPanel = (DGWPanel)this.getDialogPanel();
        this.setCursor(new Cursor(3));
        boolean bl = this.validate(dGWPanel);
        if (!bl) {
            this.setCursor(new Cursor(0));
            return;
        }
        try {
            Connection connection = DM4JConnectionManager.getConnection();
            if (dGWPanel.execute(connection)) {
                String string = "DISCOGWOBJ";
                BrowserFrame browserFrame = BrowserFrame.getMainFrame();
                browserFrame.findComponent(string, dGWPanel.getGWObjectName(), true);
            }
        }
        catch (Exception exception) {
            this.showError(exception.getLocalizedMessage());
        }
        finally {
            this.setCursor(new Cursor(0));
        }
        super.okActionPerformed(actionEvent);
    }

    private boolean validate(DGWPanel dGWPanel) {
        String string = dGWPanel.validatePanelInputs();
        if (string == null) {
            return true;
        }
        this.showError(string);
        return false;
    }

    public static DGWPanel getDGWPanel(String string, int n, String string2) throws Exception {
        switch (n) {
            case 1: {
                return new AI_DGWPanel(string);
            }
            case 2: {
                return new AR_DGWPanel(string);
            }
            case 3: {
                return new CTM_DGWPanel(string);
            }
            case 4: {
                return null;
            }
            case 5: {
                return new AP_DGWPanel(string);
            }
            case 6: {
                return new CLU_DGWPanel(string);
            }
            case 7: {
                return new DT_DGWPanel(string);
            }
            case 8: {
                return null;
            }
            case 9: {
                return new ANY_DGWPanel(string);
            }
            case 10: {
                return null;
            }
        }
        return null;
    }
}

