/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.disco;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.browser.disco.DGWPanel;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.integrator.disco.report.CTMReport;

public class CTM_DGWPanel
extends DGWPanel {
    private int TOTAL_NUM_OF_TABLES = 3;
    public int CFM_IX = 0;
    public int LFT_IX = 1;
    public int ROC_IX = 2;
    private String m_dialogDescription = "DISCOGWOBJ_CTM_DIALOG_DESCRIPTION";
    private String m_dmObjectLabel = "DISCOGWOBJ_CTM";
    private String[] m_chkBoxLabels = new String[]{"DISCOGWOBJ_CTM_CFM", "DISCOGWOBJ_CTM_LFT", "DISCOGWOBJ_CTM_ROC"};
    private String[] m_gwObjDescsKeys = new String[]{"DISCOGWOBJ_CTM_CFM_DESC", "DISCOGWOBJ_CTM_LFT_DESC", "DISCOGWOBJ_CTM_ROC_DESC"};
    private String[] m_gwObjNamePrefixes = new String[]{"CFM", "LIFT", "ROC"};
    private String[] m_gwObjNameSuffixes = new String[]{"CFM", "LFT", "ROC"};
    private String[] m_dmObjectList = null;
    private String m_cfmTableName = null;
    private String m_lftTableName = null;
    private String m_rocTableName = null;
    private static String CTM_TABLE_SELECT = "SELECT METRIC_NAME, METRIC_VARCHAR_VALUE FROM ";
    private static String CTM_TABLE_WHERE = " WHERE METRIC_NAME LIKE '%TABLE'";
    private static String CFM_TABLE = "CONFUSION_MATRIX_TABLE";
    private static String LFT_TABLE = "LIFT_TABLE";
    private static String ROC_TABLE = "ROC_TABLE";

    public CTM_DGWPanel(String string) throws Exception {
        this.m_dbConn = DM4JConnectionManager.getDbConnection();
        String string2 = string;
        if (string == null) {
            this.loadDMObjectList(this.m_dbConn);
            if (this.m_dmObjectList != null && this.m_dmObjectList.length > 0) {
                string2 = this.m_dmObjectList[0];
            }
        }
        if (string2 != null) {
            this.loadCTMDetails(this.m_dbConn, string2);
        }
        this.m_propMap = new HashMap();
        this.m_propMap.put("A", this.m_dialogDescription);
        this.m_propMap.put("B", new Integer(this.TOTAL_NUM_OF_TABLES));
        this.m_propMap.put("C", this.m_chkBoxLabels);
        this.m_propMap.put("D", this.m_dmObjectLabel);
        this.m_propMap.put("E", string);
        this.m_propMap.put("F", this.m_dmObjectList);
        this.m_propMap.put("G", "Todo..");
        this.m_propMap.put("I", this.m_gwObjDescsKeys);
        this.m_propMap.put("J", new Boolean(true));
        this.m_propMap.put("K", this.m_gwObjNamePrefixes);
        this.m_propMap.put("L", this.m_gwObjNameSuffixes);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCTMDetails(Connection connection, String string) throws SQLException {
        int n = 0;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(CTM_TABLE_SELECT + string + CTM_TABLE_WHERE);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                if (CFM_TABLE.equalsIgnoreCase(resultSet.getString(1))) {
                    ++n;
                    this.m_cfmTableName = resultSet.getString(2);
                    continue;
                }
                if (LFT_TABLE.equalsIgnoreCase(resultSet.getString(1))) {
                    ++n;
                    this.m_lftTableName = resultSet.getString(2);
                    continue;
                }
                if (!ROC_TABLE.equalsIgnoreCase(resultSet.getString(1))) continue;
                ++n;
                this.m_rocTableName = resultSet.getString(2);
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
        this.m_chkBoxLabels = new String[n];
        this.m_gwObjDescsKeys = new String[n];
        this.m_gwObjNameSuffixes = new String[n];
        this.m_gwObjNamePrefixes = new String[n];
        int n2 = 0;
        if (this.m_cfmTableName != null) {
            this.m_chkBoxLabels[n2] = "DISCOGWOBJ_CTM_CFM";
            this.m_gwObjDescsKeys[n2] = "DISCOGWOBJ_CTM_CFM_DESC";
            this.m_gwObjNamePrefixes[n2] = "CFM";
            this.m_gwObjNameSuffixes[n2] = "CFM";
            this.CFM_IX = n2++;
        }
        if (this.m_lftTableName != null) {
            this.m_chkBoxLabels[n2] = "DISCOGWOBJ_CTM_LFT";
            this.m_gwObjDescsKeys[n2] = "DISCOGWOBJ_CTM_LFT_DESC";
            this.m_gwObjNamePrefixes[n2] = "LFT";
            this.m_gwObjNameSuffixes[n2] = "LFT";
            this.LFT_IX = n2++;
        }
        if (this.m_rocTableName != null) {
            this.m_chkBoxLabels[n2] = "DISCOGWOBJ_CTM_ROC";
            this.m_gwObjDescsKeys[n2] = "DISCOGWOBJ_CTM_ROC_DESC";
            this.m_gwObjNamePrefixes[n2] = "ROC";
            this.m_gwObjNameSuffixes[n2] = "ROC";
            this.ROC_IX = n2++;
        }
        this.TOTAL_NUM_OF_TABLES = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDMObjectList(Connection connection) throws SQLException {
        DMEMetadata dMEMetadata = DMEMetadata.getInstance();
        String string = "select r.result_name from dm4j$results r, dm_user_models m where r.type='TEST' and r.model_name=m.name and m.function_name='CLASSIFICATION'";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Vector<String> vector = new Vector<String>();
        try {
            preparedStatement = connection.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                vector.add(resultSet.getString(1));
            }
        }
        finally {
            resultSet.close();
            preparedStatement.close();
        }
        int n = vector.size();
        this.m_dmObjectList = new String[n];
        if (n > 0) {
            System.arraycopy(vector.toArray(), 0, this.m_dmObjectList, 0, n);
        }
    }

    public boolean execute(javax.datamining.resource.Connection connection) throws Exception {
        String string = this.getGWObjectName();
        String string2 = this.getGWObjectDescription();
        String string3 = this.getDMObjectName();
        CTMReport cTMReport = new CTMReport(connection, string3, this.m_cfmTableName, this.m_lftTableName, this.m_rocTableName, this.getGWObjectNames(), this.getGWObjectDescs(), this.getGWObjectTypes(), this.getSelectedGWObjs());
        ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), "Publishing data", cTMReport, true);
        cTMReport.setProgressBar(progressBar);
        progressBar.start("", null);
        if (cTMReport.getException() != null) {
            throw cTMReport.getException();
        }
        return !progressBar.hasUserCancelled();
    }
}

