/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.Hashtable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JSimpleDialog;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.SwingWorkerBasic;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.tree.node.NodeData;
import oracle.dmt.dm4j.datasources.MiningObjects;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;

public class SelectMiningObjectPanel
extends GriddedPanel {
    BrowserContext m_context;
    String m_miningObjectType = null;
    String m_miningObjectName = null;
    MultiLineLabel m_lblDescription = new MultiLineLabel();
    JLabel m_lblMiningObjectType = new JLabel();
    JComboBox cboMiningObjectType = new JComboBox();
    boolean m_ignoreTypeComboEvent = true;
    JLabel m_lblMiningObjectName = new JLabel();
    JComboBox cboMiningObjectName = new JComboBox();
    MiningObjects m_miningObjects = new MiningObjects();
    Hashtable m_types = new Hashtable();
    Hashtable m_typeToCombo = new Hashtable();
    Connection m_conn;
    String m_loadingMessage;
    DM4JSimpleDialog m_dialog;
    JLabel lblFiller = new JLabel();
    boolean m_isLoaded = false;
    private ComboNameLoader m_comboNameLoader;

    public SelectMiningObjectPanel(DM4JSimpleDialog dM4JSimpleDialog, BrowserContext browserContext, String string) throws Exception {
        this.m_dialog = dM4JSimpleDialog;
        this.m_context = browserContext;
        this.m_lblDescription.setText(string);
        this.jbInit();
        this.loadDefaults();
    }

    private void jbInit() throws Exception {
        int n = 0;
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        this.m_lblDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.m_lblDescription.setPreferredRows(2);
        this.m_lblDescription.setMinimumRows(2);
        this.addFilledComponent((JComponent)this.m_lblDescription, TOPLABELITEMINSETS, n, 0, 2, 2, 1);
        this.m_lblMiningObjectType.setText(DM4JResourceUtilities.getUIString("SELECT_OBJECT_TYPE"));
        this.m_lblMiningObjectType.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "SELECT_OBJECT_TYPE"));
        this.m_lblMiningObjectType.setLabelFor(this.cboMiningObjectType);
        this.addFilledComponent(this.m_lblMiningObjectType, MIDEDITLABELITEMINSETS, n += 2, 0, 1, 1, 0);
        this.cboMiningObjectType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectMiningObjectPanel.this.cboMiningObjectType_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this.cboMiningObjectType, MIDEDITVALUEITEMINSETS, n++, 1, 1, 1, 2);
        this.m_lblMiningObjectName.setText(DM4JResourceUtilities.getUIString("SELECT_OBJECT_NAME"));
        this.m_lblMiningObjectName.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "SELECT_OBJECT_NAME"));
        this.m_lblMiningObjectName.setLabelFor(this.cboMiningObjectName);
        this.addFilledComponent(this.m_lblMiningObjectName, MIDEDITLABELITEMINSETS, n, 0, 1, 1, 0);
        this.addFilledComponent(this.cboMiningObjectName, MIDEDITVALUEITEMINSETS, n, 1, 1, 1, 2);
        this.m_loadingMessage = DM4JResourceUtilities.getUIString("COMMON_LOADING");
        this.addFilledComponent(this.lblFiller, COL1_LABEL, n, 0, 2, 2, 1);
    }

    private void loadDefaults() {
        Object object;
        this.loadComboTypes();
        String string = "ASSOCIATION_RULES_MODELS";
        if (this.m_context != null && this.m_context != null && null != (object = this.m_context.getSelectedLeafNode()) && ((LeafNodeData)object).isMiningObject()) {
            this.m_miningObjectType = this.getMappedObjectType(((NodeData)object).getNodeType());
            if (this.m_miningObjectType != null) {
                this.m_miningObjectName = ((NodeData)object).getName();
                string = this.m_miningObjectType;
            }
        }
        object = (String)this.m_typeToCombo.get(string);
        this.m_ignoreTypeComboEvent = true;
        this.cboMiningObjectType.setSelectedItem((String)this.m_typeToCombo.get(string));
        this.m_ignoreTypeComboEvent = false;
        this.loadComboNames(string);
    }

    private String getMappedObjectType(String string) {
        String string2 = null;
        if ("ASSOCIATION_RULES_MODEL".equals(string)) {
            string2 = "ASSOCIATION_RULES_MODELS";
        } else if ("ATTRIBUTE_IMPORTANCE_MODEL".equals(string)) {
            string2 = "ATTRIBUTE_IMPORTANCE_MODELS";
        } else if ("ABN_MODEL".equals(string)) {
            string2 = "CLASSIFICATION_MODELS";
        } else if ("NB_MODEL".equals(string)) {
            string2 = "CLASSIFICATION_MODELS";
        } else if ("SVM_CLASSIFICATION_MODEL".equals(string)) {
            string2 = "CLASSIFICATION_MODELS";
        } else if ("DT_MODEL".equals(string)) {
            string2 = "CLASSIFICATION_MODELS";
        } else if ("CLUSTERING_KMEANS_MODEL".equals(string)) {
            string2 = "CLUSTERING_MODELS";
        } else if ("CLUSTERING_OCLUSTER_MODEL".equals(string)) {
            string2 = "CLUSTERING_MODELS";
        } else if ("NMF_MODEL".equals(string)) {
            string2 = "FEATURE_EXTRACTION_MODELS";
        } else if ("SVM_REGRESSION_MODEL".equals(string)) {
            string2 = "REGRESSION_MODELS";
        } else if ("SVM_ONE_CLASS_MODEL".equals(string)) {
            string2 = "ANOMALY_DETECTION_MODELS";
        } else if ("TEST_RESULT".equals(string)) {
            string2 = "TEST_RESULTS";
        } else if ("APPLY_RESULT".equals(string)) {
            string2 = "APPLY_RESULTS";
        } else if ("RESIDUAL_PLOT_RESULT".equals(string)) {
            string2 = "RESIDUAL_PLOT_RESULTS";
        } else if ("PREDICT_RESULT".equals(string)) {
            string2 = "PREDICT_RESULTS";
        } else if ("EXPLAIN_RESULT".equals(string)) {
            string2 = "EXPLAIN_RESULTS";
        } else if ("LIFT_RESULT".equals(string)) {
            string2 = "LIFT_RESULTS";
        }
        return string2;
    }

    private void loadComboTypes() {
        this.m_ignoreTypeComboEvent = true;
        String string = DM4JResourceUtilities.getUIString("TREE_MODELS");
        String string2 = DM4JResourceUtilities.getUIString("TREE_RESULTS");
        String string3 = ": ";
        String string4 = string + string3 + DM4JResourceUtilities.getUIString("TREE_ASSOCIATION_RULES_MODELS");
        this.m_types.put(string4, "ASSOCIATION_RULES_MODELS");
        this.m_typeToCombo.put("ASSOCIATION_RULES_MODELS", string4);
        this.cboMiningObjectType.addItem(string4);
        string4 = string + string3 + DM4JResourceUtilities.getUIString("TREE_ATTRIBUTE_IMPORTANCE_MODELS");
        this.m_types.put(string4, "ATTRIBUTE_IMPORTANCE_MODELS");
        this.m_typeToCombo.put("ATTRIBUTE_IMPORTANCE_MODELS", string4);
        this.cboMiningObjectType.addItem(string4);
        string4 = string + string3 + DM4JResourceUtilities.getUIString("TREE_CLASSIFICATION_MODELS");
        this.m_types.put(string4, "CLASSIFICATION_MODELS");
        this.m_typeToCombo.put("CLASSIFICATION_MODELS", string4);
        this.cboMiningObjectType.addItem(string4);
        string4 = string + string3 + DM4JResourceUtilities.getUIString("TREE_CLUSTERING_MODELS");
        this.m_types.put(string4, "CLUSTERING_MODELS");
        this.m_typeToCombo.put("CLUSTERING_MODELS", string4);
        this.cboMiningObjectType.addItem(string4);
        string4 = string + string3 + DM4JResourceUtilities.getUIString("TREE_FEATURE_EXTRACTION_MODELS");
        this.m_types.put(string4, "FEATURE_EXTRACTION_MODELS");
        this.m_typeToCombo.put("FEATURE_EXTRACTION_MODELS", string4);
        this.cboMiningObjectType.addItem(string4);
        string4 = string + string3 + DM4JResourceUtilities.getUIString("TREE_REGRESSION_MODELS");
        this.m_types.put(string4, "REGRESSION_MODELS");
        this.m_typeToCombo.put("REGRESSION_MODELS", string4);
        this.cboMiningObjectType.addItem(string4);
        string4 = string + string3 + DM4JResourceUtilities.getUIString("TREE_ANOMALY_MODELS");
        this.m_types.put(string4, "ANOMALY_DETECTION_MODELS");
        this.m_typeToCombo.put("ANOMALY_DETECTION_MODELS", string4);
        this.cboMiningObjectType.addItem(string4);
        string4 = string2 + string3 + DM4JResourceUtilities.getUIString("TREE_TEST_RESULTS");
        this.m_types.put(string4, "TEST_RESULTS");
        this.m_typeToCombo.put("TEST_RESULTS", string4);
        this.cboMiningObjectType.addItem(string4);
        string4 = string2 + string3 + DM4JResourceUtilities.getUIString("TREE_APPLY_RESULTS");
        this.m_types.put(string4, "APPLY_RESULTS");
        this.m_typeToCombo.put("APPLY_RESULTS", string4);
        this.cboMiningObjectType.addItem(string4);
        string4 = string2 + string3 + DM4JResourceUtilities.getUIString("TREE_RESIDUAL_PLOT_RESULTS");
        this.m_types.put(string4, "RESIDUAL_PLOT_RESULTS");
        this.m_typeToCombo.put("RESIDUAL_PLOT_RESULTS", string4);
        this.cboMiningObjectType.addItem(string4);
        string4 = string2 + string3 + DM4JResourceUtilities.getUIString("TREE_PREDICT_RESULTS");
        this.m_types.put(string4, "PREDICT_RESULTS");
        this.m_typeToCombo.put("PREDICT_RESULTS", string4);
        this.cboMiningObjectType.addItem(string4);
        string4 = string2 + string3 + DM4JResourceUtilities.getUIString("TREE_EXPLAIN_RESULTS");
        this.m_types.put(string4, "EXPLAIN_RESULTS");
        this.m_typeToCombo.put("EXPLAIN_RESULTS", string4);
        this.cboMiningObjectType.addItem(string4);
        this.m_ignoreTypeComboEvent = false;
    }

    private void loadComboNames(String string) {
        this.m_isLoaded = false;
        this.cboMiningObjectType.setEnabled(false);
        this.m_dialog.setCursor(new Cursor(3));
        this.m_comboNameLoader = new ComboNameLoader(string);
        this.cboMiningObjectName.removeAllItems();
        this.cboMiningObjectName.addItem(this.m_loadingMessage);
        this.m_comboNameLoader.start();
    }

    private void cboMiningObjectType_actionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.m_ignoreTypeComboEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)((DefaultComboBoxModel)jComboBox.getModel()).getSelectedItem();
                String string2 = (String)jComboBox.getSelectedItem();
                String string3 = (String)this.m_types.get(string2);
                this.loadComboNames(string3);
            }
        }
        catch (Exception exception) {
            DialogUtilities.createSystemErrorDialog(this.m_dialog, exception);
            exception.printStackTrace();
        }
    }

    public boolean isLoaded() {
        return this.m_isLoaded;
    }

    public BrowserContext getGeneratedBrowserContext() {
        LeafNodeData leafNodeData = null;
        BrowserContext browserContext = null;
        try {
            String string = (String)this.cboMiningObjectName.getSelectedItem();
            String string2 = this.getNodeLeafObjectType(string);
            if (string2 != null) {
                leafNodeData = new LeafNodeData(string, string2);
                browserContext = new BrowserContext(leafNodeData, LaunchPoint.MENU);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return browserContext;
    }

    private String getNodeLeafObjectType(String string) {
        LeafNodeData[] leafNodeDataArray = (LeafNodeData[])this.m_comboNameLoader.getValue();
        for (int i = 0; i < leafNodeDataArray.length; ++i) {
            if (!leafNodeDataArray[i].getName().equals(string)) continue;
            return leafNodeDataArray[i].getNodeType();
        }
        return null;
    }

    public String getSelectedMiningObjectType() {
        return (String)this.cboMiningObjectType.getSelectedItem();
    }

    public String getSelectedMiningObjectName() {
        return (String)this.cboMiningObjectName.getSelectedItem();
    }

    public void cancelComboNameLoader() {
        if (this.m_comboNameLoader != null) {
            this.m_comboNameLoader.interrupt();
        }
    }

    private class ComboNameLoader
    extends SwingWorkerBasic {
        LeafNodeData[] itemNodes = null;
        Exception exception = null;
        String m_miningType;
        Connection m_comboConn;

        public ComboNameLoader(String string) {
            this.m_miningType = string;
        }

        public Object construct() {
            try {
                this.m_comboConn = DM4JConnectionManager.getDbConnection();
                this.itemNodes = SelectMiningObjectPanel.this.m_miningObjects.getMiningNodes(this.m_comboConn, this.m_miningType);
            }
            catch (Exception exception) {
                this.exception = exception;
            }
            return this.itemNodes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            try {
                if (this.exception != null) {
                    DialogUtilities.createSystemErrorDialog(SelectMiningObjectPanel.this.m_dialog, this.exception);
                    this.exception.printStackTrace();
                    SelectMiningObjectPanel.this.m_dialog.setVisible(false);
                    SelectMiningObjectPanel.this.m_dialog.dispose();
                } else {
                    this.itemNodes = (LeafNodeData[])this.getValue();
                    SelectMiningObjectPanel.this.cboMiningObjectName.removeAllItems();
                    if (this.itemNodes != null) {
                        for (int i = 0; i < this.itemNodes.length; ++i) {
                            SelectMiningObjectPanel.this.cboMiningObjectName.addItem(this.itemNodes[i].getName());
                        }
                        if (SelectMiningObjectPanel.this.m_miningObjectName != null) {
                            SelectMiningObjectPanel.this.cboMiningObjectName.setSelectedItem(SelectMiningObjectPanel.this.m_miningObjectName);
                        }
                    }
                    SelectMiningObjectPanel.this.m_isLoaded = true;
                }
            }
            catch (Exception exception) {
                DialogUtilities.createSystemErrorDialog(SelectMiningObjectPanel.this.m_dialog, exception);
                exception.printStackTrace();
            }
            finally {
                try {
                    SelectMiningObjectPanel.this.m_dialog.setCursor(new Cursor(0));
                    SelectMiningObjectPanel.this.cboMiningObjectType.setEnabled(true);
                    this.m_comboConn.close();
                }
                catch (Exception exception) {
                    DialogUtilities.createSystemErrorDialog(SelectMiningObjectPanel.this.m_dialog, exception);
                    exception.printStackTrace();
                }
            }
        }
    }
}

