/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser;

import javax.swing.event.EventListenerList;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.CubeDataAccess;
import oracle.dss.util.CubeDataDirector;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAccessAdapter;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataDirectorListener;
import oracle.dss.util.DataMap;
import oracle.dss.util.DataSource;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.RelationalDataAccess;
import oracle.dss.util.RelationalDataDirector;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public class LocalXMLDataSource
extends DataAccessAdapter
implements CubeDataDirector,
CubeDataAccess,
RelationalDataDirector,
RelationalDataAccess,
DataSource {
    protected EventListenerList m_listenerList = new EventListenerList();
    protected DataMap m_dataMap = null;
    protected MetadataMap m_metadataMap = null;
    protected int m_columnCount = 0;
    protected int m_rowCount = 0;
    protected int m_pageCount = 0;
    protected Object[] m_columnLabels = null;
    protected Object[] m_rowLabels = null;
    protected Object[][] m_data = null;

    public LocalXMLDataSource(Object[] objectArray, Object[] objectArray2, Object[][] objectArray3) {
        if (objectArray != null) {
            this.m_columnCount = objectArray.length;
            this.m_columnLabels = objectArray;
        }
        if (objectArray2 != null) {
            this.m_rowCount = objectArray2.length;
            this.m_rowLabels = objectArray2;
        }
        if (objectArray3 != null) {
            this.m_data = objectArray3;
        }
    }

    public CubeDataDirector createCubeDataDirector() {
        return this;
    }

    public RelationalDataDirector createRelationalDataDirector() {
        return this;
    }

    public void addDataDirectorListener(DataDirectorListener dataDirectorListener) {
        if (dataDirectorListener != null) {
            this.m_listenerList.add(DataDirectorListener.class, dataDirectorListener);
            this.fireDataAvailableEvent(new DataAvailableEvent((Object)this, (DataAccess)this));
        }
    }

    public void removeDataDirectorListener(DataDirectorListener dataDirectorListener) {
        if (dataDirectorListener != null) {
            this.m_listenerList.remove(DataDirectorListener.class, dataDirectorListener);
        }
    }

    public DataMap getDataMap() {
        if (this.m_dataMap == null) {
            this.m_dataMap = new DataMap(new String[]{"dataUnformatted"});
        }
        return this.m_dataMap;
    }

    public int getEdgeCount() {
        return 3;
    }

    public int getEdgeExtent(int n) throws EdgeOutOfRangeException {
        if (n < 0 || n >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(n, this.getEdgeCount() - 1);
        }
        switch (n) {
            case 0: {
                return this.m_columnCount;
            }
            case 1: {
                return this.m_rowCount;
            }
            case 2: {
                return this.m_pageCount;
            }
        }
        return 0;
    }

    public int getLayerCount(int n) throws EdgeOutOfRangeException {
        if (n < 0 || n >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(n, this.getEdgeCount() - 1);
        }
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    public int getMemberExtent(int n, int n2, int n3) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (n < 0 || n >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(n, this.getEdgeCount() - 1);
        }
        if (n2 < 0 || n2 >= this.getLayerCount(n)) {
            throw new LayerOutOfRangeException(n2, this.getLayerCount(n) - 1);
        }
        if (n3 < 0 || n3 >= this.getEdgeExtent(n)) {
            throw new SliceOutOfRangeException(n3, this.getEdgeExtent(n) - 1);
        }
        switch (n) {
            case 0: 
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    public Object getMemberMetadata(int n, int n2, int n3, String string) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (n < 0 || n >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(n, this.getEdgeCount() - 1);
        }
        if (n2 < 0 || n2 >= this.getLayerCount(n)) {
            throw new LayerOutOfRangeException(n2, this.getLayerCount(n) - 1);
        }
        if (n3 < 0 || n3 >= this.getEdgeExtent(n)) {
            throw new SliceOutOfRangeException(n3, this.getEdgeExtent(n) - 1);
        }
        if (!(string.equals("shortName") || string.equals("mediumName") || string.equals("longName"))) {
            return null;
        }
        switch (n) {
            case 0: {
                return this.m_columnLabels[n3];
            }
            case 1: {
                return this.m_rowLabels[n3];
            }
        }
        return null;
    }

    public int getMemberStartSlice(int n, int n2, int n3) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (n < 0 || n >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(n, this.getEdgeCount() - 1);
        }
        if (n2 < 0 || n2 >= this.getLayerCount(n)) {
            throw new LayerOutOfRangeException(n2, this.getLayerCount(n) - 1);
        }
        if (n3 < 0 || n3 >= this.getEdgeExtent(n)) {
            throw new SliceOutOfRangeException(n3, this.getEdgeExtent(n) - 1);
        }
        switch (n) {
            case 0: {
                return n3;
            }
            case 1: {
                return n3;
            }
        }
        return 0;
    }

    public MetadataMap getMetadataMap(int n, int n2) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        if (this.m_metadataMap == null) {
            this.m_metadataMap = new MetadataMap(new String[]{"shortName", "mediumName", "longName"});
        }
        return this.m_metadataMap;
    }

    public Object getSliceLabel(int n, int n2, String string) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        if (n < 0 || n >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(n, this.getEdgeCount() - 1);
        }
        if (n2 < 0 || n2 >= this.getEdgeExtent(n)) {
            throw new SliceOutOfRangeException(n2, this.getEdgeExtent(n) - 1);
        }
        if (!(string.equals("shortName") || string.equals("mediumName") || string.equals("longName"))) {
            return null;
        }
        switch (n) {
            case 0: {
                return this.m_columnLabels[n2];
            }
            case 1: {
                return this.m_rowLabels[n2];
            }
        }
        return null;
    }

    public int getSliceMemberCount(int n, int n2) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        if (n < 0 || n >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(n, this.getEdgeCount() - 1);
        }
        if (n2 < 0 || n2 >= this.getEdgeExtent(n)) {
            throw new SliceOutOfRangeException(n2, this.getEdgeExtent(n) - 1);
        }
        switch (n) {
            case 0: 
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    public Object getValue(int n, int n2, String string) throws RowOutOfRangeException, ColumnOutOfRangeException {
        try {
            if (n < 0 || n >= this.getEdgeExtent(1)) {
                throw new RowOutOfRangeException((long)n, (long)(this.getEdgeExtent(1) - 1));
            }
            if (n2 < 0 || n2 >= this.getEdgeExtent(0)) {
                throw new ColumnOutOfRangeException((long)n2, (long)(this.getEdgeExtent(0) - 1));
            }
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            return null;
        }
        if (!string.equals("dataUnformatted")) {
            return null;
        }
        if (this.m_data == null || this.m_data[n2] == null) {
            return null;
        }
        return this.m_data[n2][n];
    }

    protected void fireDataAvailableEvent(DataAvailableEvent dataAvailableEvent) {
        Object[] objectArray = this.m_listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DataDirectorListener.class) continue;
            ((DataDirectorListener)objectArray[i + 1]).viewDataAvailable(dataAvailableEvent);
        }
    }

    public DataMap getSupportedDataMap() {
        String[] stringArray = new String[]{"dataUnformatted"};
        return new DataMap(stringArray);
    }

    public MetadataMap getSupportedMetadataMap() {
        String[] stringArray = new String[]{"longName", "mediumName", "shortName"};
        return new MetadataMap(stringArray);
    }

    public LayerMetadataMap getSupportedLayerMetadataMap() {
        String[] stringArray = new String[]{"dimLongName", "dimMediumName", "dimShortName"};
        return new LayerMetadataMap(stringArray);
    }
}

