/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;

public class DataChooserDialogPanel
extends GriddedPanel {
    private MultiLineLabel mlblStepDescription = new MultiLineLabel();
    private JLabel lblSchemaName = new JLabel();
    private JComboBox comboSchema = new JComboBox();
    private DefaultComboBoxModel schemaModel;
    private JLabel lblTableName = new JLabel();
    private JComboBox comboTable = new JComboBox();
    private DefaultComboBoxModel tableModel;
    private boolean m_ignoreSchemaComboEvent = false;
    private boolean m_ignoreTableComboEvent = false;
    private int m_sourceType = 0;
    private String m_preselectSchema = null;
    private String m_preselectTable = null;
    private String m_schemaName = null;
    private String m_tableName = null;
    private JLabel lblFiller = new JLabel();
    public static final int VIEWS_ONLY = 0;
    public static final int TABLES_ONLY = 1;
    public static final int TABLES_AND_VIEWS = 2;

    public DataChooserDialogPanel(String string, String string2, int n) throws Exception {
        this.m_preselectSchema = string;
        this.m_preselectTable = string2;
        this.m_sourceType = n;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        String string = null;
        string = 1 == this.m_sourceType ? DM4JResourceUtilities.getUIString("COPY_SOURCE_TABLE_NAME") : (2 == this.m_sourceType ? DM4JResourceUtilities.getUIString("COPY_SOURCE_VIEW_OR_TABLE_NAME") : DM4JResourceUtilities.getUIString("COPY_SOURCE_VIEW_NAME"));
        this.mlblStepDescription.setText(string);
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.lblSchemaName.setText(DM4JResourceUtilities.getUIString("COMMON_SCHEMA"));
        this.lblSchemaName.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_SCHEMA"));
        this.lblSchemaName.setLabelFor(this.comboSchema);
        this.comboSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataChooserDialogPanel.this.comboSchema_actionPerformed(actionEvent);
            }
        });
        if (0 == this.m_sourceType) {
            this.lblTableName.setText(DM4JResourceUtilities.getUIString("COMMON_VIEW_NAME"));
            this.lblTableName.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_VIEW_NAME"));
        } else if (1 == this.m_sourceType) {
            this.lblTableName.setText(DM4JResourceUtilities.getUIString("COMMON_TABLE_NAME"));
            this.lblTableName.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_TABLE_NAME"));
        } else if (2 == this.m_sourceType) {
            this.lblTableName.setText(DM4JResourceUtilities.getUIString("COMMON_TABLE_OR_VIEW"));
            this.lblTableName.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_TABLE_OR_VIEW"));
        }
        this.lblTableName.setLabelFor(this.comboTable);
        this.comboTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataChooserDialogPanel.this.comboTable_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent((JComponent)this.mlblStepDescription, TOPLABELITEMINSETS, n++, 0, 2, 1, 1);
        this.addFilledComponent(new JLabel(" "), TOPLABELITEMINSETS, n++, 0, 2, 1, 1);
        this.addComponent(this.lblSchemaName, MIDEDITLABELITEMINSETS, n, 0);
        this.addFilledComponent(this.comboSchema, MIDEDITVALUEITEMINSETS, n++, 1);
        this.addComponent(this.lblTableName, MIDEDITLABELITEMINSETS, n, 0);
        this.addFilledComponent(this.comboTable, MIDEDITVALUEITEMINSETS, n++, 1);
        this.addFilledComponent(this.lblFiller, COL1_LABEL, n, 0, 2, 2, 1);
        JComponent[] jComponentArray = new JComponent[]{this.comboSchema, this.comboTable};
        DataChooserDialogPanel.setPreferredSize(jComponentArray, 260, 20);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws Exception {
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            this.loadSchemaCombo(connection, this.getPreselectSchemaName());
            this.loadTableCombo(connection, this.getPreselectTableName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private void loadSchemaCombo(Connection connection, String string) {
        this.m_ignoreSchemaComboEvent = true;
        try {
            this.schemaModel = new DefaultComboBoxModel(DatabaseMetadata.getAccessibleSchemas(connection));
            this.comboSchema.setModel(this.schemaModel);
            if (null != string) {
                this.comboSchema.setSelectedItem(string);
                this.m_schemaName = string;
            } else {
                this.comboSchema.setSelectedIndex(0);
                this.m_schemaName = (String)this.comboSchema.getSelectedItem();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_ignoreSchemaComboEvent = false;
    }

    private void loadTableCombo(Connection connection, String string) {
        this.m_ignoreTableComboEvent = true;
        Vector vector = null;
        try {
            if (0 == this.m_sourceType) {
                vector = DatabaseMetadata.getAccessableViews(connection, this.getSchemaName());
            } else if (1 == this.m_sourceType) {
                vector = DatabaseMetadata.getAccessableTables(connection, this.getSchemaName());
            } else if (2 == this.m_sourceType) {
                vector = DatabaseMetadata.getAccessableTablesAndViews(connection, this.getSchemaName());
            }
            this.tableModel = new DefaultComboBoxModel(vector);
            this.comboTable.setModel(this.tableModel);
            if (vector.size() != 0) {
                if (null != string) {
                    this.comboTable.setSelectedItem(string);
                    this.m_tableName = string;
                    String string2 = (String)this.comboTable.getSelectedItem();
                    if (string.equals(string2)) {
                        this.m_tableName = string;
                    } else {
                        this.comboTable.setSelectedIndex(0);
                        this.m_tableName = (String)this.comboTable.getSelectedItem();
                    }
                } else {
                    this.comboTable.setSelectedIndex(0);
                    this.m_tableName = (String)this.comboTable.getSelectedItem();
                }
            } else {
                this.m_tableName = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_ignoreTableComboEvent = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void comboSchema_actionPerformed(ActionEvent actionEvent) {
        Connection connection = null;
        try {
            if (!this.m_ignoreSchemaComboEvent) {
                this.setCursor(new Cursor(3));
                connection = DM4JConnectionManager.getDbConnection();
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                this.m_schemaName = (String)jComboBox.getSelectedItem();
                this.loadTableCombo(connection, null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.setCursor(new Cursor(0));
        }
    }

    private void comboTable_actionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.m_ignoreTableComboEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                this.m_tableName = (String)jComboBox.getSelectedItem();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getPreselectSchemaName() {
        return this.m_preselectSchema;
    }

    private String getPreselectTableName() {
        return this.m_preselectTable;
    }

    public String getSchemaName() {
        return this.m_schemaName;
    }

    public String getTableName() {
        return this.m_tableName;
    }
}

