/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import javax.swing.JPanel;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JSimpleDialog;
import oracle.dmt.dm4j.browser.CopyTableDialogPanel;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class CopyTableDialog
extends DM4JSimpleDialog {
    public CopyTableDialog(Frame frame, JPanel jPanel, String string, String string2) {
        super(frame, jPanel, string, string2);
        this.setSize(new Dimension(350, 220));
    }

    protected void okActionPerformed(ActionEvent actionEvent) {
        CopyTableDialogPanel copyTableDialogPanel = (CopyTableDialogPanel)this.getDialogPanel();
        String string = copyTableDialogPanel.getOutputTableName();
        this.setCursor(new Cursor(3));
        boolean bl = this.validateTableName(string);
        this.setCursor(new Cursor(0));
        if (!bl) {
            return;
        }
        super.okActionPerformed(actionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateTableName(String string) {
        Connection connection = null;
        if (string.length() == 0) {
            String string2 = DM4JResourceUtilities.getUIString("COPY_ERROR_TABLE_EMPTY");
            this.showError(string2);
            return false;
        }
        if (!ValidationUtil.checkStringLength(string, 30)) {
            String string3 = DM4JResourceUtilities.getUIString("COPY_ERROR_TABLE_TOOLONG");
            this.showError(string3);
            return false;
        }
        if (ValidationUtil.containsDoubleQuote(string)) {
            String string4 = DM4JResourceUtilities.getUIString("COPY_ERROR_TABLE_HASDBLQUOTE");
            this.showError(string4);
            return false;
        }
        if (ValidationUtil.isEqualToROWID(string)) {
            String string5 = DM4JResourceUtilities.getUIString("COPY_ERROR_TABLE_NAME_RESERVED");
            this.showError(string5);
            return false;
        }
        try {
            connection = DM4JConnectionManager.getDbConnection();
            if (ValidationUtil.isGreater32BytesInDB(string, connection)) {
                String string6 = DM4JResourceUtilities.getUIString("COPY_ERROR_TABLE_32");
                this.showError(string6);
                boolean bl = false;
                return bl;
            }
            if (!ValidationUtil.isTableNameUnique(string, connection)) {
                String string7 = DM4JResourceUtilities.getUIString("COPY_ERROR_TABLE_EXISTS_IN_SOURCE");
                this.showError(string7);
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (null != connection) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return true;
    }
}

