/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Locale;
import javax.sql.DataSource;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import oracle.dmt.dm4j.ConnectionPersistence;
import oracle.dmt.dm4j.ConnectionPersistenceInfo;
import oracle.dmt.dm4j.DM4JCommonUtils;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GetSValueDialog;
import oracle.dmt.dm4j.browser.GetSValuePanel;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.resource.OraConnectionFactory;
import oracle.help.CSHManager;
import oracle.help.Help;
import oracle.help.common.util.LocaleUtils;
import oracle.help.library.Book;
import oracle.help.library.helpset.HelpSet;
import oracle.jdbc.pool.OracleDataSource;

public class ConnectionEditDialog
extends JDialog {
    public static int RET_OK = 0;
    public static int RET_CANCEL = 1;
    private ConnectionPersistenceInfo _connInfo = null;
    private ConnectionPersistenceInfo[] _connections = null;
    private JButton OK = new JButton();
    private JButton Cancel = new JButton();
    private JButton btnHelp = new JButton();
    private JLabel jLabelConnectionName = new JLabel();
    private JTextField jTextConectionName = new JTextField();
    private JLabel jLabelUser = new JLabel();
    private JTextField jTextUser = new JTextField();
    private JLabel jLabelPassword = new JLabel();
    private JPasswordField jTextPassword = new JPasswordField();
    private JCheckBox jSavePwd = new JCheckBox();
    private JLabel jLabelHost = new JLabel();
    private JTextField jTextHost = new JTextField();
    private JLabel jLabelPort = new JLabel();
    private JTextField jTextPort = new JTextField();
    private JRadioButton jChoiceSid = new JRadioButton();
    private JTextField jTextSid = new JTextField();
    private JRadioButton jChoiceSName = new JRadioButton();
    private JTextField jTextSName = new JTextField();
    private char[] _originalPd = "".toCharArray();
    private boolean creatingNewConnection = false;
    private int m_ret = RET_CANCEL;
    private Help m_help = null;
    private CSHManager m_helpCxtMgr = null;
    private static String validateErrorMsg;

    public ConnectionEditDialog(Dialog dialog, ConnectionPersistenceInfo connectionPersistenceInfo, ConnectionPersistenceInfo[] connectionPersistenceInfoArray) {
        super(dialog, true);
        try {
            this._connInfo = connectionPersistenceInfo;
            this._connections = connectionPersistenceInfoArray;
            this.jbInit();
            if (connectionPersistenceInfoArray == null) {
                throw new Exception("Connection array cannot be null");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (!keyEvent.isConsumed() && keyEvent.getKeyCode() == 27) {
                    ConnectionEditDialog.this.cancel_actionPerformed(null);
                    keyEvent.consume();
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
            }
        });
    }

    private void jbInit() throws Exception {
        Object object;
        Object object2;
        Serializable serializable;
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        try {
            serializable = this.getClass().getResource("/dm4j_help.hs");
            object2 = serializable.toString();
            object = ((String)object2).substring(0, ((String)object2).indexOf(".jar"));
            serializable = LocaleUtils.findLocalizedHelpSet((String)object, (String)".jar!/dm4j_help.hs", (Locale)Locale.getDefault());
            this.m_help = new Help(false, false, true);
            Help.registerClientWindow((Window)this);
            this.m_helpCxtMgr = new CSHManager(this.m_help);
            HelpSet helpSet = new HelpSet(serializable);
            this.m_helpCxtMgr.addBook((Book)helpSet, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_helpCxtMgr.addComponent((Component)this, "CONNECTION_DLG", true, false);
        serializable = KeyStroke.getKeyStroke(27, 0, true);
        this.getRootPane().getInputMap(1).put((KeyStroke)serializable, "CancelAction");
        this.getRootPane().getActionMap().put("CancelAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionEditDialog.this.cancel_actionPerformed(actionEvent);
            }
        });
        serializable = KeyStroke.getKeyStroke(10, 0, true);
        this.getRootPane().getInputMap(1).put((KeyStroke)serializable, "OKAction");
        this.getRootPane().getActionMap().put("OKAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionEditDialog.this.ok_actionPerformed(actionEvent);
            }
        });
        serializable = KeyStroke.getKeyStroke(112, 0, true);
        this.getRootPane().getInputMap(1).put((KeyStroke)serializable, "HelpAction");
        this.getRootPane().getActionMap().put("HelpAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionEditDialog.this.help_actionPerformed(actionEvent);
            }
        });
        this.setTitle(DM4JResourceUtilities.getUIString("CONN_EDIT_CONNECTION"));
        this.setSize(new Dimension(380, 340));
        object2 = new GriddedPanel();
        ((JComponent)object2).setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.getContentPane().add("Center", (Component)object2);
        this.OK.setText(DM4JResourceUtilities.getUIString("COMMON_OK"));
        this.OK.setActionCommand(DM4JResourceUtilities.getUIString("COMMON_OK"));
        this.OK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionEditDialog.this.ok_actionPerformed(actionEvent);
            }
        });
        this.Cancel.setText(DM4JResourceUtilities.getUIString("COMMON_CANCEL"));
        this.Cancel.setActionCommand(DM4JResourceUtilities.getUIString("COMMON_CANCEL"));
        this.Cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionEditDialog.this.cancel_actionPerformed(actionEvent);
            }
        });
        this.btnHelp.setText(DM4JResourceUtilities.getUIString("COMMON_HELP"));
        this.btnHelp.setActionCommand(DM4JResourceUtilities.getUIString("COMMON_HELP"));
        this.btnHelp.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "COMMON_HELP"));
        this.btnHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionEditDialog.this.help_actionPerformed(actionEvent);
            }
        });
        DM4JResourceUtilities.configureUILabel(this.jLabelConnectionName, "CONN_EDIT_NAME", this.jTextConectionName, dM4JListResourceBundle);
        DM4JResourceUtilities.configureUILabel(this.jLabelUser, "COMMON_USER", this.jTextUser, dM4JListResourceBundle);
        DM4JResourceUtilities.configureUILabel(this.jLabelPassword, "COMMON_PASSWORD", this.jTextPassword, dM4JListResourceBundle);
        DM4JResourceUtilities.configureUILabel(this.jLabelHost, "COMMON_HOST", this.jTextHost, dM4JListResourceBundle);
        DM4JResourceUtilities.configureUILabel(this.jLabelPort, "COMMON_PORT", this.jTextPort, dM4JListResourceBundle);
        object = new ButtonGroup();
        this.jChoiceSid.setText(dM4JListResourceBundle.getStringNoMnemonic("COMMON_SID"));
        this.jChoiceSid.setMnemonic(dM4JListResourceBundle.getMnemonic("COMMON_SID"));
        this.jChoiceSName.setText(dM4JListResourceBundle.getStringNoMnemonic("COMMON_SERVICE_NAME"));
        this.jChoiceSName.setMnemonic(dM4JListResourceBundle.getMnemonic("COMMON_SERVICE_NAME"));
        ((ButtonGroup)object).add(this.jChoiceSid);
        ((ButtonGroup)object).add(this.jChoiceSName);
        this.jChoiceSid.setSelected(true);
        this.jTextSName.setEnabled(false);
        this.jChoiceSid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionEditDialog.this.jTextSName.setEnabled(false);
                ConnectionEditDialog.this.jTextSid.setEnabled(true);
                ConnectionEditDialog.this.jTextSid.requestFocus();
            }
        });
        this.jChoiceSName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionEditDialog.this.jTextSName.setEnabled(true);
                ConnectionEditDialog.this.jTextSName.requestFocus();
                ConnectionEditDialog.this.jTextSid.setEnabled(false);
            }
        });
        this.jSavePwd.setText("Save Password");
        this.jSavePwd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            }
        });
        if (this._connInfo != null) {
            this.jTextConectionName.setText(this._connInfo.getConnectionName());
            this.jTextUser.setText(this._connInfo.getUser());
            try {
                boolean bl;
                this._originalPd = this._connInfo.retrievePassword();
                boolean bl2 = bl = this._originalPd != null && this._originalPd.length > 0;
                if (bl) {
                    this.jTextPassword.setText(new String(this._originalPd));
                }
                this.jSavePwd.setSelected(bl);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this._originalPd = "".toCharArray();
                this.jTextPassword.setText(new String(this._originalPd));
                this.jSavePwd.setSelected(false);
            }
            this.jTextHost.setText(this._connInfo.getHost());
            this.jTextPort.setText(this._connInfo.getPort());
            if (!this._connInfo.getSid().equalsIgnoreCase("")) {
                this.jChoiceSid.setSelected(true);
                this.jTextSid.setEnabled(true);
                this.jTextSName.setEnabled(false);
                this.jTextSid.setText(this._connInfo.getSid());
            } else {
                this.jChoiceSName.setSelected(true);
                this.jTextSName.setEnabled(true);
                this.jTextSid.setEnabled(false);
                this.jTextSName.setText(this._connInfo.getServiceName());
            }
        } else {
            this.jSavePwd.setSelected(false);
            this.creatingNewConnection = true;
            this._connInfo = new ConnectionPersistenceInfo();
        }
        GriddedPanel griddedPanel = new GriddedPanel();
        griddedPanel.setBorder(BorderFactory.createTitledBorder(DM4JResourceUtilities.getUIString("CONN_EDIT_SETTINGS")));
        int n = 0;
        int n2 = 0;
        ((GriddedPanel)object2).addFilledComponent(this.jLabelConnectionName, GriddedPanel.MIDEDITLABELITEMINSETS, n2, 1, 2, 1, 0);
        ((GriddedPanel)object2).addFilledComponent(this.jTextConectionName, GriddedPanel.MIDEDITVALUEITEMINSETS, n2++, 3, 3, 1, 2);
        ((GriddedPanel)object2).addFilledComponent(new JLabel(" "), GriddedPanel.MIDLABELITEMINSETS, n2++, 1, 5, 2, 2);
        griddedPanel.addFilledComponent(this.jLabelUser, GriddedPanel.MIDEDITLABELITEMINSETS, n, 1, 2, 1, 0);
        griddedPanel.addFilledComponent(this.jTextUser, GriddedPanel.MIDEDITVALUEITEMINSETS, n++, 3, 3, 1, 2);
        griddedPanel.addFilledComponent(this.jLabelPassword, GriddedPanel.MIDEDITLABELITEMINSETS, n, 1, 2, 1, 0);
        griddedPanel.addFilledComponent(this.jTextPassword, GriddedPanel.MIDEDITVALUEITEMINSETS, n++, 3, 3, 1, 2);
        griddedPanel.addFilledComponent(this.jSavePwd, GriddedPanel.MIDEDITVALUEITEMINSETS, n++, 3, 3, 1, 2);
        griddedPanel.addFilledComponent(this.jLabelHost, GriddedPanel.MIDEDITLABELITEMINSETS, n, 1, 2, 1, 0);
        griddedPanel.addFilledComponent(this.jTextHost, GriddedPanel.MIDEDITVALUEITEMINSETS, n++, 3, 3, 1, 2);
        griddedPanel.addFilledComponent(this.jLabelPort, GriddedPanel.MIDEDITLABELITEMINSETS, n, 1, 2, 1, 0);
        griddedPanel.addFilledComponent(this.jTextPort, GriddedPanel.MIDEDITVALUEITEMINSETS, n++, 3, 3, 1, 2);
        griddedPanel.addFilledComponent(this.jChoiceSid, GriddedPanel.MIDEDITLABELITEMINSETS, n, 1, 2, 1, 0);
        griddedPanel.addFilledComponent(this.jTextSid, GriddedPanel.MIDEDITVALUEITEMINSETS, n++, 3, 3, 1, 2);
        griddedPanel.addFilledComponent(this.jChoiceSName, GriddedPanel.MIDEDITLABELITEMINSETS, n, 1, 2, 1, 0);
        griddedPanel.addFilledComponent(this.jTextSName, GriddedPanel.MIDEDITVALUEITEMINSETS, n++, 3, 3, 1, 2);
        griddedPanel.addFilledComponent(new JLabel(" "), GriddedPanel.MIDEDITVALUEITEMINSETS, n++, 3, 3, 1, 1);
        ((GriddedPanel)object2).addFilledComponent(griddedPanel, new Insets(5, 5, 5, 5), n2++, 1, 5, 1, 2);
        ((GriddedPanel)object2).addFilledComponent(new JLabel(" "), GriddedPanel.MIDEDITVALUEITEMINSETS, n2++, 1, 5, 1, 1);
        ((GriddedPanel)object2).addFilledComponent(this.btnHelp, GriddedPanel.MIDVALUEITEMINSETS, n2, 1, 1, 1, 0);
        ((GriddedPanel)object2).addFilledComponent(new JLabel(), GriddedPanel.MIDLABELITEMINSETS, n2, 2, 2, 1, 1);
        ((GriddedPanel)object2).addFilledComponent(this.OK, GriddedPanel.MIDLABELITEMINSETS, n2, 4, 1, 1, 0);
        ((GriddedPanel)object2).addFilledComponent(this.Cancel, GriddedPanel.MIDVALUEITEMINSETS, n2, 5, 1, 1, 0);
        this.getRootPane().setDefaultButton(this.OK);
    }

    public int getUserAction() {
        return this.m_ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ok_actionPerformed(ActionEvent actionEvent) {
        String string;
        int n;
        String string2 = this.jTextConectionName.getText();
        String string3 = this.jTextUser.getText();
        String string4 = new String(this.jTextPassword.getPassword());
        String string5 = this.jTextHost.getText();
        String string6 = this.jTextPort.getText();
        String string7 = this.jTextSid.getText();
        String string8 = this.jTextSName.getText();
        this.setCursor(new Cursor(3));
        if (!this.validateFields()) {
            this.setCursor(new Cursor(0));
            return;
        }
        for (n = 0; n < this._connections.length; ++n) {
            if (!this._connections[n].getConnectionName().equalsIgnoreCase(string2) || this._connInfo == this._connections[n]) continue;
            this.setCursor(new Cursor(0));
            JOptionPane.showMessageDialog(this, DM4JResourceUtilities.getUIString("CONN_EDIT_NAME_INUSE"), DM4JVersion.getFullBrowserName(), 0);
            return;
        }
        n = this.isConnectionInfoDirty(string3, string4, string5, string6, string7, string8) ? 1 : 0;
        if (n != 0) {
            OraConnection oraConnection;
            Object object;
            string = string4;
            if (string4.length() == 0 && !this.jSavePwd.isSelected()) {
                object = this.promptForPwd();
                if (object == null || ((Object)object).length == 0) {
                    this.setCursor(new Cursor(0));
                    return;
                }
                string = new String((char[])object);
                this.jTextPassword.setText(string);
            }
            if (null == (oraConnection = this.getConnection(string3, string, string5, string6, (String)(object = this.jChoiceSid.isSelected() ? string7 : string8), this.jChoiceSid.isSelected()))) {
                this.setCursor(new Cursor(0));
                JOptionPane.showMessageDialog(this, DM4JResourceUtilities.getUIString("CONN_EDIT_FAIL_CONNECT"), DM4JVersion.getFullBrowserName(), 0);
                return;
            }
            try {
                this.validateConnection(oraConnection);
            }
            catch (Exception exception) {
                this.setCursor(new Cursor(0));
                JOptionPane.showMessageDialog(this, exception.getLocalizedMessage(), DM4JVersion.getFullBrowserName(), 0);
                return;
            }
            finally {
                try {
                    oraConnection.close();
                }
                catch (Exception exception) {}
            }
        }
        if (n != 0 || !this._connInfo.getConnectionName().equals(string2)) {
            if (!this.jSavePwd.isSelected()) {
                string4 = "";
            }
            try {
                string = null;
                if (!this._connInfo.getConnectionName().equals(string2) && !this.creatingNewConnection) {
                    string = this._connInfo.getConnectionName();
                    ConnectionPersistence.storeRenamedCredential(string, string2, string4.toCharArray());
                } else {
                    ConnectionPersistence.storeCredential(string2, string4.toCharArray());
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.getLocalizedMessage(), DM4JVersion.getFullBrowserName(), 0);
                return;
            }
        }
        this._connInfo.setUser(string3);
        this._connInfo.setConnectionName(string2);
        this._connInfo.setHost(string5);
        this._connInfo.setPort(string6);
        if (this.jChoiceSid.isSelected()) {
            this._connInfo.setSid(string7);
            this._connInfo.setServiceName("");
        } else {
            this._connInfo.setServiceName(string8);
            this._connInfo.setSid("");
        }
        this.m_ret = RET_OK;
        Help.unregisterClientWindow((Window)this);
        this.setVisible(false);
        this.dispose();
    }

    public char[] promptForPwd() {
        GetSValuePanel getSValuePanel = new GetSValuePanel();
        GetSValueDialog getSValueDialog = new GetSValueDialog(this, (JPanel)getSValuePanel, "Enter Connection Password.", null);
        getSValueDialog.setNoHelp();
        getSValueDialog.setVisible(true);
        return getSValuePanel.getSValue();
    }

    private boolean validateFields() {
        boolean bl = true;
        if (this.jTextConectionName.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, DM4JResourceUtilities.getUIString("CONN_NAME_EMPTY"), DM4JVersion.getFullBrowserName(), 0);
            this.jTextConectionName.requestFocus();
            bl = false;
        } else if (this.jTextUser.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, DM4JResourceUtilities.getUIString("CONN_USER_NAME_EMPTY"), DM4JVersion.getFullBrowserName(), 0);
            this.jTextUser.requestFocus();
            bl = false;
        } else if (this.jTextPassword.getPassword().length == 0 && this.jSavePwd.isSelected()) {
            JOptionPane.showMessageDialog(this, DM4JResourceUtilities.getUIString("CONN_PW_EMPTY"), DM4JVersion.getFullBrowserName(), 0);
            this.jTextPassword.requestFocus();
            bl = false;
        } else if (this.jTextHost.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, DM4JResourceUtilities.getUIString("CONN_HOST_NAME_EMPTY"), DM4JVersion.getFullBrowserName(), 0);
            this.jTextHost.requestFocus();
            bl = false;
        } else if (this.jTextPort.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, DM4JResourceUtilities.getUIString("CONN_PORT_EMPTY"), DM4JVersion.getFullBrowserName(), 0);
            this.jTextPort.requestFocus();
            bl = false;
        } else if (this.jChoiceSid.isSelected() && this.jTextSid.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, DM4JResourceUtilities.getUIString("CONN_SID_EMPTY"), DM4JVersion.getFullBrowserName(), 0);
            this.jTextSid.requestFocus();
            bl = false;
        } else if (this.jChoiceSName.isSelected() && this.jTextSName.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, DM4JResourceUtilities.getUIString("CONN_SERV_NAME_EMPTY"), DM4JVersion.getFullBrowserName(), 0);
            this.jTextSName.requestFocus();
            bl = false;
        }
        return bl;
    }

    private boolean isConnectionInfoDirty(String string, String string2, String string3, String string4, String string5, String string6) {
        if (null == this._connInfo) {
            return true;
        }
        if (this._originalPd != null && !new String(this._originalPd).equalsIgnoreCase(string2)) {
            return true;
        }
        if (this._originalPd == null && string2.length() != 0) {
            return true;
        }
        if (!this.jSavePwd.isSelected() && this._originalPd != null && this._originalPd.length != 0) {
            return true;
        }
        return !this._connInfo.getUser().equalsIgnoreCase(string) || !this._connInfo.getHost().equalsIgnoreCase(string3) || !this._connInfo.getPort().equalsIgnoreCase(string4) || !this._connInfo.getSid().equalsIgnoreCase(string5) || !this._connInfo.getServiceName().equalsIgnoreCase(string6);
    }

    private void validateConnection(final OraConnection oraConnection) throws Exception {
        validateErrorMsg = null;
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    DM4JCommonUtils.validateConnection(oraConnection);
                }
                catch (Exception exception) {
                    validateErrorMsg = exception.getLocalizedMessage();
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        thread.join();
        if (validateErrorMsg != null) {
            throw new Exception(validateErrorMsg);
        }
    }

    private void cancel_actionPerformed(ActionEvent actionEvent) {
        this.m_ret = RET_CANCEL;
        Help.unregisterClientWindow((Window)this);
        this.setVisible(false);
        this.dispose();
    }

    private void help_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        try {
            this.m_helpCxtMgr.showTopic("CONNECTION_DLG");
        }
        catch (Exception exception) {
            this.m_helpCxtMgr.showTopic("dm4j_introduction_html");
        }
        this.setCursor(new Cursor(0));
    }

    public ConnectionPersistenceInfo getConnectionInfo() {
        return this._connInfo;
    }

    private OraConnection getConnection(String string, String string2, String string3, String string4, String string5, boolean bl) {
        OraConnection oraConnection = null;
        OracleDataSource oracleDataSource = null;
        try {
            String string6 = bl ? "jdbc:oracle:thin:@" + string3 + ":" + string4 + ":" + string5 : "jdbc:oracle:thin:@//" + string3 + ":" + string4 + "/" + string5;
            oracleDataSource = new OracleDataSource();
            oracleDataSource.setURL(string6);
            oracleDataSource.setUser(string);
            oracleDataSource.setPassword(string2);
            OraConnectionFactory oraConnectionFactory = new OraConnectionFactory((DataSource)oracleDataSource);
            oraConnection = (OraConnection)oraConnectionFactory.getConnection();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return oraConnection;
    }
}

