/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.steps;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JOptionPane;
import oracle.bali.ewt.grid.hGrid.HArrayTwoDModel;
import oracle.bali.ewt.grid.hGrid.HDataObject;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.wizard.steps.ValidationException;
import oracle.dmt.dm4j.browser.BrowserFrame;

public class SupplementalsTableModel
extends HArrayTwoDModel {
    private Vector _tables;
    public static int NAME_COLUMN = 0;
    public static int ALIAS_COLUMN = 1;
    public static int INPUT_COLUMN = 2;
    public static int DATA_TYPE_COLUMN = 3;
    public static int COLUMN_COUNT = 4;
    private boolean _isDirty = false;
    private LinkedHashMap _uniqueAliases = new LinkedHashMap();
    private Integer _seq = new Integer(1);

    public SupplementalsTableModel(int n, Vector vector) {
        super(COLUMN_COUNT, n);
        this._tables = vector;
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    public void setDirty(boolean bl) {
        this._isDirty = bl;
    }

    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    public Object getObjectAtIndex(int n) {
        HDataObject hDataObject = (HDataObject)this.getExpandedData(0, n);
        Object object = hDataObject.getData();
        return object;
    }

    public void inputSelectionAll(boolean bl) {
        int n = this.getExpandedRowCount();
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            Column column = this.getColumnAtIndex(i);
            bl2 = false;
            if (column == null) continue;
            if (bl) {
                ValidationException validationException = this.validateInput(column);
                if (validationException != null) {
                    bl2 = true;
                }
                if (bl2) continue;
                this.setInputAtIndex(i, bl);
                this.setExpandedData(INPUT_COLUMN, i, bl);
                continue;
            }
            this.setInputAtIndex(i, bl);
            this.setExpandedData(INPUT_COLUMN, i, bl);
        }
    }

    public ValidationException validateInput(Column column) {
        String string = column.getDataType();
        if (ActivityUtils.isNestedDataType(string)) {
            return new ValidationException("Nested Data type is not valid for a supplemental attribute.", 0);
        }
        return null;
    }

    public Vector validateAlias(String string) {
        Vector<ValidationException> vector = new Vector<ValidationException>();
        if (string.length() > 30) {
            vector.add(new ValidationException(DM4JResourceUtilities.getActivityUIString("DATA_USAGE_ALIAS_TOOLONG") + 30, 0));
            return vector;
        }
        if (string.length() == 0) {
            vector.add(new ValidationException(DM4JResourceUtilities.getActivityUIString("DATA_USAGE_ALIAS_NULL"), 0));
            return vector;
        }
        return vector;
    }

    public Column getColumnAtIndex(int n) {
        HDataObject hDataObject = (HDataObject)this.getExpandedData(0, n);
        Object object = hDataObject.getData();
        if (object instanceof Column) {
            Column column = (Column)hDataObject.getData();
            return column;
        }
        return null;
    }

    public Table getTableAtIndex(int n) {
        HDataObject hDataObject = (HDataObject)this.getExpandedData(0, n);
        Table table = (Table)hDataObject.getData();
        return table;
    }

    public void load() throws Exception {
        this.populate(this._tables);
    }

    private void populate(Vector vector) throws Exception {
        Iterator iterator = vector.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            n = this.addTable(table, n);
        }
    }

    private int addTable(Table table, int n) throws Exception {
        this.addTableRowData(table, n);
        int n2 = n + 1;
        LinkedHashMap linkedHashMap = table.getColumns();
        if (!table.isTransactionalRelationship()) {
            Iterator iterator = linkedHashMap.entrySet().iterator();
            int n3 = n + 1;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Column column = (Column)entry.getValue();
                if (!column.getIsVisible()) continue;
                this.addColumnRowData(column, n3++, n);
            }
        }
        return n;
    }

    private void addTableRowData(Table table, int n) {
        this.addRootRows(n, 1);
        this.setExpandedData(NAME_COLUMN, n, table);
        this.setExpandedData(ALIAS_COLUMN, n, "");
        this.setExpandedData(INPUT_COLUMN, n, "");
        this.setExpandedData(DATA_TYPE_COLUMN, n, "");
        this.expandExpandedRow(n);
    }

    private void addColumnRowData(Column column, int n, int n2) {
        if (column.getIsVisible()) {
            this.addRowsAtDepth(n, 1, 1, n2);
            this.setExpandedData(NAME_COLUMN, n, column);
            this.setExpandedData(ALIAS_COLUMN, n, column.getAlias());
            this.setExpandedData(INPUT_COLUMN, n, column.getIsInput());
            this.setExpandedData(DATA_TYPE_COLUMN, n, column.getDataType());
        }
        this.expandExpandedRow(n2);
    }

    public String setAliasAtIndex(int n, String string) {
        Column column;
        Column column2 = (Column)this.getObjectAtIndex(n);
        if (column2 == (column = (Column)this._uniqueAliases.get(string))) {
            return column2.getAlias();
        }
        if (column == null) {
            this._uniqueAliases.remove(column2.getAlias());
            column2.setAlias(string);
            this._uniqueAliases.put(column2.getAlias(), column2);
            this._isDirty = true;
        } else {
            JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), "Specified alias is in use. Please enter a unique value", DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
        }
        return column2.getAlias();
    }

    public void setInputAtIndex(int n, Boolean bl) {
        Column column = (Column)this.getObjectAtIndex(n);
        column.setIsInput(bl);
    }

    private void generateUniqueAlias(Column column) {
        Column column2 = (Column)this._uniqueAliases.get(column.getAlias());
        if (column2 == null) {
            this._uniqueAliases.put(column.getAlias(), column);
        } else {
            boolean bl = false;
            String string = null;
            while (!bl) {
                string = column.getAlias() + "_" + this._seq.toString();
                if (string.length() >= 30) {
                    string = string.substring(0, 30 - this._seq.toString().length() - 1);
                    string = string + this._seq.toString();
                    string = string.substring(0, 30);
                }
                this._seq = new Integer(this._seq + 1);
                if (this._uniqueAliases.get(string) != null) continue;
                bl = true;
            }
            column.setAlias(string);
            this._uniqueAliases.put(column.getAlias(), column);
        }
    }

    public Vector getTables() {
        return this._tables;
    }
}

