/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.steps;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import oracle.bali.ewt.grid.BooleanInputHandler;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.CheckPainter;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.grid.NullInputHandler;
import oracle.bali.ewt.grid.ProxyInputHandler;
import oracle.bali.ewt.grid.ProxyPainter;
import oracle.bali.ewt.grid.RadioPainter;
import oracle.bali.ewt.grid.TextFieldInputHandler;
import oracle.bali.ewt.grid.hGrid.HCellHandler;
import oracle.bali.ewt.grid.hGrid.HDataObject;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.WrappingTextPainter;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.wizard.state.ApplyActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.state.ChooseBuildActivityState;
import oracle.dmt.dm4j.activity.wizard.state.SupplementalsState;
import oracle.dmt.dm4j.activity.wizard.steps.ActivityStepType;
import oracle.dmt.dm4j.activity.wizard.steps.SupplementalsTableModel;
import oracle.dmt.dm4j.activity.wizard.steps.ValidationException;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.table.DefaultDm4jSpreadTable;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;

public class SupplementalsPanel
extends DM4JStep {
    private SupplementalsState m_state;
    private String m_panelDescriptionResourceKey;
    private JLabel lblStepDescription = new JLabel();
    private JButton butSelectAll = new JButton();
    private JButton butExcludeAll = new JButton();
    private JScrollPane scroller = new JScrollPane();
    private DefaultDm4jSpreadTable m_table = new DefaultDm4jSpreadTable(null);
    private ArrayOneDModel m_colModel = null;

    public SupplementalsPanel(SupplementalsState supplementalsState, String string) throws Exception {
        super(supplementalsState);
        this.m_state = supplementalsState;
        this.m_panelDescriptionResourceKey = string;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getActivityBundleInstance();
        String string = DM4JResourceUtilities.wrapInHTML(DM4JResourceUtilities.getActivityUIString(this.m_panelDescriptionResourceKey));
        this.lblStepDescription.setText(string);
        this.addFilledComponent(this.lblStepDescription, TOP_DESC, n++, 0, 2, 1, 1);
        this.scroller.getViewport().add((Component)((Object)this.m_table));
        this.addWeightedComponent(this.scroller, new Insets(1, 1, 1, 1), n++, 0, 2, 1, 18, 1, 2.0, 2.0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2, 5, 0));
        this.addComponent(jPanel, BOTTOM_RELATED_CONTROL, n++, 0, 2, 1, 13, 0);
        this.butSelectAll.setText(dM4JListResourceBundle.getStringNoMnemonic("DATA_USAGE_SELECT_ALL"));
        this.butSelectAll.setMnemonic(dM4JListResourceBundle.getMnemonic("DATA_USAGE_SELECT_ALL"));
        this.butSelectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SupplementalsPanel.this.butSelectAll_actionPerformed(actionEvent);
            }
        });
        jPanel.add(this.butSelectAll);
        this.butExcludeAll.setText(dM4JListResourceBundle.getStringNoMnemonic("DATA_USAGE_UNSELECT_ALL"));
        this.butExcludeAll.setMnemonic(dM4JListResourceBundle.getMnemonic("DATA_USAGE_UNSELECT_ALL"));
        this.butExcludeAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SupplementalsPanel.this.butExcludeAll_actionPerformed(actionEvent);
            }
        });
        jPanel.add(this.butExcludeAll);
    }

    private boolean showValidations(Vector vector, Component component) {
        boolean bl = false;
        if (!vector.isEmpty()) {
            int n;
            ValidationException validationException = null;
            String string = "";
            for (n = 0; n < vector.size(); ++n) {
                validationException = (ValidationException)vector.get(n);
                string = string + validationException.getMessage();
                if (validationException.isError()) {
                    bl = true;
                }
                if (n == vector.size() - 1) continue;
                string = string + "\n";
            }
            n = bl ? 0 : 2;
            JOptionPane.showMessageDialog(component, string, DM4JVersion.getFullBrowserName(), n);
        }
        return bl;
    }

    protected void processUserInput() {
    }

    public void focusOnErrorField(Vector vector) {
    }

    public void init() throws Exception {
        this.setSpread();
    }

    public void refresh() throws Exception {
        this.reinit();
    }

    public void reinit() throws Exception {
        this.init();
    }

    public void clear() {
    }

    protected void setSpread() throws Exception {
        Object object;
        SupplementalsTableModel supplementalsTableModel = this.m_state.getSupplementalsTableModel();
        try {
            supplementalsTableModel.load();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Object[] objectArray = new String[SupplementalsTableModel.COLUMN_COUNT];
        objectArray[SupplementalsTableModel.NAME_COLUMN] = "Name";
        objectArray[SupplementalsTableModel.ALIAS_COLUMN] = "Alias";
        objectArray[SupplementalsTableModel.INPUT_COLUMN] = "Select";
        objectArray[SupplementalsTableModel.DATA_TYPE_COLUMN] = "Data Type";
        try {
            if (objectArray.length != supplementalsTableModel.getColumnCount()) {
                throw new Exception("Column count not in sync");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_colModel = new ArrayOneDModel(objectArray);
        this.m_table.setModels((TwoDModel)supplementalsTableModel, this.m_colModel, null);
        Grid grid = this.m_table.getGrid();
        Painter painter = grid.getColumnPainter(0);
        HCellHandler hCellHandler = new HCellHandler(painter);
        grid.setColumnPainter(SupplementalsTableModel.NAME_COLUMN, (Painter)hCellHandler);
        grid.setColumnPainter(SupplementalsTableModel.DATA_TYPE_COLUMN, painter);
        grid.setColumnCellInputHandler(SupplementalsTableModel.NAME_COLUMN, (CellInputHandler)hCellHandler);
        grid.setColumnCellInputHandler(SupplementalsTableModel.DATA_TYPE_COLUMN, (CellInputHandler)hCellHandler);
        CustomProxyPainter customProxyPainter = new CustomProxyPainter();
        grid.setColumnPainter(SupplementalsTableModel.ALIAS_COLUMN, (Painter)customProxyPainter);
        grid.setColumnPainter(SupplementalsTableModel.INPUT_COLUMN, (Painter)customProxyPainter);
        CustomProxyInputHandler customProxyInputHandler = new CustomProxyInputHandler();
        grid.setColumnCellInputHandler(SupplementalsTableModel.ALIAS_COLUMN, (CellInputHandler)customProxyInputHandler);
        grid.setColumnCellInputHandler(SupplementalsTableModel.INPUT_COLUMN, (CellInputHandler)customProxyInputHandler);
        ApplyActivityWizardState applyActivityWizardState = (ApplyActivityWizardState)this.getparentWizardState();
        ChooseBuildActivityState chooseBuildActivityState = (ChooseBuildActivityState)applyActivityWizardState.getStep(ActivityStepType.ACTIVITY_STEP);
        boolean bl = chooseBuildActivityState.getSourceIsActivity();
        if (!bl) {
            grid.setColumnVisible(SupplementalsTableModel.ALIAS_COLUMN, false);
        }
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 1, 0);
        grid.setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
        if (supplementalsTableModel.getRowCount() != 0) {
            object = new TwoDSelection(0, true);
            try {
                this.m_table.setSelection((TwoDSelection)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object = new int[SupplementalsTableModel.COLUMN_COUNT];
        object[SupplementalsTableModel.NAME_COLUMN] = bl ? 35 : 60;
        object[SupplementalsTableModel.ALIAS_COLUMN] = bl ? 25 : 0;
        object[SupplementalsTableModel.INPUT_COLUMN] = 15;
        object[SupplementalsTableModel.DATA_TYPE_COLUMN] = 25;
        try {
            this.m_table.setColumnWidths((int[])object, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void butSelectAll_actionPerformed(ActionEvent actionEvent) {
        try {
            SupplementalsTableModel supplementalsTableModel = this.m_state.getSupplementalsTableModel();
            supplementalsTableModel.inputSelectionAll(true);
        }
        catch (Exception exception) {
            this.m_state.getparentWizardState().doAbortCancel(exception);
        }
    }

    protected void butExcludeAll_actionPerformed(ActionEvent actionEvent) {
        try {
            SupplementalsTableModel supplementalsTableModel = this.m_state.getSupplementalsTableModel();
            supplementalsTableModel.inputSelectionAll(false);
        }
        catch (Exception exception) {
            this.m_state.getparentWizardState().doAbortCancel(exception);
        }
    }

    private class SelectColumnInputHandler
    extends BooleanInputHandler {
        private SelectColumnInputHandler() {
        }

        protected Object getNewValue(Grid grid, int n, int n2, Object object) {
            Boolean bl = (Boolean)object;
            SupplementalsTableModel supplementalsTableModel = SupplementalsPanel.this.m_state.getSupplementalsTableModel();
            boolean bl2 = false;
            Column column = supplementalsTableModel.getColumnAtIndex(n2);
            ValidationException validationException = supplementalsTableModel.validateInput(column);
            if (validationException != null) {
                if (validationException.isError()) {
                    bl2 = true;
                }
                int n3 = bl2 ? 0 : 2;
                JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), validationException.getMessage(), DM4JVersion.getFullBrowserName(), n3);
            }
            if (!bl2) {
                bl = (Boolean)super.getNewValue(grid, n, n2, object);
                supplementalsTableModel.setInputAtIndex(n2, bl);
            }
            return bl;
        }
    }

    private class AliasInputHandler
    extends TextFieldInputHandler {
        private AliasInputHandler() {
        }

        public Object commitEdit(Grid grid, int n, int n2) {
            Column column;
            JTextField jTextField = (JTextField)this.getEditControl(grid, n, n2);
            String string = jTextField.getText();
            SupplementalsTableModel supplementalsTableModel = SupplementalsPanel.this.m_state.getSupplementalsTableModel();
            Column column2 = supplementalsTableModel.getColumnAtIndex(n2);
            String string2 = column2.getAlias();
            Vector vector = supplementalsTableModel.validateAlias(string);
            boolean bl = false;
            LinkedHashMap linkedHashMap = SupplementalsPanel.this.m_state.getAliasMappings();
            Object v = linkedHashMap.get(string);
            if (v != null && string2.compareTo(string) != 0) {
                vector.add(new ValidationException(DM4JResourceUtilities.getActivityUIString("DATA_USAGE_ALIAS_DUPLICATE"), 0));
            }
            if (!vector.isEmpty()) {
                bl = SupplementalsPanel.this.showValidations(vector, BrowserFrame.getMainFrame());
            }
            if (bl) {
                return string2;
            }
            String string3 = supplementalsTableModel.setAliasAtIndex(n2, string);
            if (string3.compareTo(string) == 0 && (column = (Column)linkedHashMap.get(string2)) != null) {
                linkedHashMap.remove(string2);
                column.setAlias(string);
                linkedHashMap.put(string, column);
            }
            return string3;
        }
    }

    private class CustomProxyInputHandler
    extends ProxyInputHandler {
        private CellInputHandler _nullInputHandler = NullInputHandler.getCellInputHandler();
        private CellInputHandler _aliasInputHandler;
        private CellInputHandler _booleanInputHandler;
        private CellInputHandler _chooseInputHandler;

        public CustomProxyInputHandler() {
            this._aliasInputHandler = new AliasInputHandler();
            this._chooseInputHandler = new SelectColumnInputHandler();
            this._booleanInputHandler = BooleanInputHandler.getCellInputHandler();
        }

        public CellInputHandler getCellInputHandler(Grid grid, int n, int n2) {
            SupplementalsTableModel supplementalsTableModel = SupplementalsPanel.this.m_state.getSupplementalsTableModel();
            HDataObject hDataObject = (HDataObject)supplementalsTableModel.getExpandedData(0, n2);
            Object object = hDataObject.getData();
            if (object instanceof Table) {
                return this._nullInputHandler;
            }
            if (n == SupplementalsTableModel.ALIAS_COLUMN) {
                return this._aliasInputHandler;
            }
            if (n == SupplementalsTableModel.INPUT_COLUMN) {
                return this._chooseInputHandler;
            }
            if (object instanceof Column) {
                return this._nullInputHandler;
            }
            new Exception("Unexpected type encountered").printStackTrace();
            return this._nullInputHandler;
        }
    }

    private class CustomProxyPainter
    extends ProxyPainter {
        private Painter _textFieldPainter = new WrappingTextPainter();
        private Painter _radioPainter = RadioPainter.getPainter();
        private Painter _checkPainter = CheckPainter.getPainter();

        public Painter getPainter(Grid grid, int n, int n2) {
            SupplementalsTableModel supplementalsTableModel = SupplementalsPanel.this.m_state.getSupplementalsTableModel();
            HDataObject hDataObject = (HDataObject)supplementalsTableModel.getExpandedData(0, n2);
            Object object = hDataObject.getData();
            if (object instanceof Table) {
                return this._textFieldPainter;
            }
            if (n == SupplementalsTableModel.INPUT_COLUMN) {
                return this._checkPainter;
            }
            if (n == SupplementalsTableModel.ALIAS_COLUMN || n == SupplementalsTableModel.DATA_TYPE_COLUMN) {
                return this._textFieldPainter;
            }
            new Exception("Unexpected type encountered").printStackTrace();
            return this._textFieldPainter;
        }
    }
}

