/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.steps;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.wizard.state.BuildActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.state.DataSourceState;
import oracle.dmt.dm4j.activity.wizard.state.RelatedDataSourceState;
import oracle.dmt.dm4j.activity.wizard.steps.ActivityStepType;
import oracle.dmt.dm4j.activity.wizard.steps.EditRelationshipDialog;
import oracle.dmt.dm4j.activity.wizard.steps.EditRelationshipPanel;
import oracle.dmt.dm4j.activity.wizard.steps.RelatedSourceModel;
import oracle.dmt.dm4j.activity.wizard.steps.RelatedTableDescriptor;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.HyperlinkButton;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.steps.commonsteps.TableSorter;

public class RelatedSourceTable
extends JTable {
    private HyperlinkRenderer _renderer = new HyperlinkRenderer();
    private RelationshipEditor _editor = new RelationshipEditor();
    private BuildActivityWizardState _parentState;

    public RelatedSourceTable(TableModel tableModel, BuildActivityWizardState buildActivityWizardState) {
        super(tableModel);
        this._parentState = buildActivityWizardState;
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (n2 == 1) {
            return this._renderer;
        }
        return super.getCellRenderer(n, n2);
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        if (n2 == 1) {
            return this._editor;
        }
        return super.getCellEditor(n, n2);
    }

    public Vector getSelectedIndexes() {
        int[] nArray = this.getSelectedRows();
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < nArray.length; ++i) {
            vector.add(new Integer(nArray[i]));
        }
        return vector;
    }

    class HyperlinkRenderer
    extends DefaultTableCellRenderer {
        private HyperlinkButton renderer = new HyperlinkButton();
        private Color deselectedForeground = this.renderer.getForeground();

        public HyperlinkRenderer() {
            this.renderer.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            TableSorter tableSorter = (TableSorter)jTable.getModel();
            RelatedSourceModel relatedSourceModel = (RelatedSourceModel)tableSorter.getTableModel();
            Vector vector = relatedSourceModel.getTables();
            RelatedTableDescriptor relatedTableDescriptor = (RelatedTableDescriptor)vector.get(n);
            if (relatedTableDescriptor.isDefined()) {
                this.renderer.setText("Edit...");
            } else {
                this.renderer.setText("Define...");
            }
            if (bl) {
                this.renderer.setBackground(jTable.getSelectionBackground());
                this.renderer.setForeground(jTable.getSelectionForeground());
            } else {
                this.renderer.setBackground(jTable.getBackground());
                this.renderer.setForeground(this.deselectedForeground);
            }
            return this.renderer;
        }
    }

    class RelationshipEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private HyperlinkButton _button = new HyperlinkButton("Edit...");
        private EditRelationshipDialog _dialog;
        private EditRelationshipPanel _panel;
        private RelatedTableDescriptor _currentTableDesc = null;
        protected static final String EDIT = "edit";

        public RelationshipEditor() {
            this._button.setActionCommand(EDIT);
            this._button.addActionListener(this);
            this._button.setBorderPainted(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                this._dialog.setVisible(true);
                this.fireEditingStopped();
                if (this._dialog.isOk()) {
                    this._currentTableDesc.setDefined(true);
                    RelatedDataSourceState relatedDataSourceState = (RelatedDataSourceState)RelatedSourceTable.this._parentState.getStep(ActivityStepType.RELATED_TABLES_STEP);
                    relatedDataSourceState.setState(StepStateType.DIRTY);
                }
            }
        }

        public Object getCellEditorValue() {
            return this._currentTableDesc.isDefined();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            TableSorter tableSorter = (TableSorter)jTable.getModel();
            RelatedSourceModel relatedSourceModel = (RelatedSourceModel)tableSorter.getTableModel();
            Vector vector = relatedSourceModel.getTables();
            this._currentTableDesc = (RelatedTableDescriptor)vector.get(n);
            Table table = this._currentTableDesc.getTable();
            DataSourceState dataSourceState = (DataSourceState)RelatedSourceTable.this._parentState.getStep(ActivityStepType.DATA_STEP);
            this._panel = new EditRelationshipPanel(table, dataSourceState.getCaseTable(), RelatedSourceTable.this._parentState);
            this._dialog = new EditRelationshipDialog(BrowserFrame.getMainFrame(), (JPanel)this._panel, "Edit Relationship", "dm4j_mining_activity_define_relation_html");
            this._dialog.setModal(true);
            return this._button;
        }
    }
}

