/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.steps;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.activity.data.RelationshipType;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.wizard.state.BuildActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.state.DataSourceState;
import oracle.dmt.dm4j.activity.wizard.state.RelatedDataSourceState;
import oracle.dmt.dm4j.activity.wizard.steps.ActivityStepType;
import oracle.dmt.dm4j.activity.wizard.steps.DataSourceTree;
import oracle.dmt.dm4j.activity.wizard.steps.RelatedSourceModel;
import oracle.dmt.dm4j.activity.wizard.steps.RelatedSourceTable;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.TableColumnsDataSource;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;
import oracle.dmt.dm4j.wizard.steps.commonsteps.TableSorter;

public class RelatedDataSourcePanel
extends DM4JStep
implements ComponentListener {
    private RelatedDataSourceState m_state;
    private String m_panelDescriptionResourceKey;
    private MultiLineLabel mlblStepDescription = new MultiLineLabel();
    private DataSourceTree _dsTree = null;
    private JButton _select = new JButton();
    private JButton _deselect = new JButton();
    private RelatedSourceTable _table;
    private RelatedSourceModel _model;
    private JScrollPane _tableScroller = new JScrollPane();
    private JSplitPane _splitter = new JSplitPane(1);
    private ProgressBar _progress = null;
    private JLabel lblFiller = new JLabel();

    public RelatedDataSourcePanel(RelatedDataSourceState relatedDataSourceState, String string) throws Exception {
        super(relatedDataSourceState);
        this.m_state = relatedDataSourceState;
        this.m_panelDescriptionResourceKey = string;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        this._model = new RelatedSourceModel();
        TableSorter tableSorter = new TableSorter(this._model);
        this._table = new RelatedSourceTable((TableModel)tableSorter, (BuildActivityWizardState)this.getparentWizardState());
        tableSorter.setTableHeader(this._table.getTableHeader());
        this.m_state.setDataSource(this._model);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = RelatedDataSourcePanel.this._table.rowAtPoint(mouseEvent.getPoint());
                if (n != -1 && mouseEvent.getClickCount() == 2) {
                    RelatedDataSourcePanel.this.btnDeselect_actionPerformed();
                }
            }
        };
        this._table.addMouseListener(mouseAdapter);
        this.mlblStepDescription.setText(DM4JResourceUtilities.getActivityUIString(this.m_panelDescriptionResourceKey));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent((JComponent)this.mlblStepDescription, TOP_DESC, n++, 0, 2, 1, 1);
        GriddedPanel griddedPanel = new GriddedPanel();
        GriddedPanel griddedPanel2 = new GriddedPanel();
        this._dsTree = new DataSourceTree();
        final JTree jTree = this._dsTree.getTreeComponent();
        MouseAdapter mouseAdapter2 = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                Object object;
                int n = jTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1 && mouseEvent.getClickCount() == 2 && (object = (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof DataSourceTree.TableNode) {
                    RelatedDataSourcePanel.this.btnAdd_actionPerformed();
                }
            }
        };
        jTree.addMouseListener(mouseAdapter2);
        JLabel jLabel = new JLabel();
        jLabel.setText("Available Tables:");
        griddedPanel2.addComponent(jLabel, GriddedPanel.MIDLABELITEMINSETS, 0, 1);
        griddedPanel2.addFilledComponent(this._dsTree, new Insets(1, 1, 1, 1), 1, 1, 2, 2, 1);
        this._splitter.setLeftComponent(griddedPanel2);
        this._select.setIcon(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/ShuttleRight.gif"));
        this._select.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RelatedDataSourcePanel.this.btnAdd_actionPerformed();
            }
        });
        this._deselect.setIcon(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/ShuttleLeft.gif"));
        this._deselect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RelatedDataSourcePanel.this.btnDeselect_actionPerformed();
            }
        });
        griddedPanel.addFilledComponent(new JLabel(), new Insets(0, 0, 0, 0), 0, 0, 1, 9, 3);
        griddedPanel.addComponent(this._select, new Insets(0, 5, 0, 5), 9, 0, 1, 1, 13, 2);
        griddedPanel.addComponent(this._deselect, new Insets(4, 5, 0, 5), 10, 0, 1, 1, 13, 2);
        griddedPanel.addFilledComponent(new JLabel(), new Insets(0, 0, 0, 0), 11, 0, 1, 9, 3);
        this._tableScroller.getViewport().add(this._table);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Selected Tables:");
        griddedPanel.addComponent(jLabel2, GriddedPanel.MIDLABELITEMINSETS, 0, 1);
        griddedPanel.addFilledComponent(this._tableScroller, new Insets(1, 1, 1, 1), 1, 1, 2, 20, 1);
        this._splitter.setRightComponent(griddedPanel);
        this.addFilledComponent(this._splitter, new Insets(0, 0, 0, 0), n++, 0, 5, 5, 1);
        this.addComponentListener(this);
    }

    public void componentResized(ComponentEvent componentEvent) {
        this._splitter.setDividerLocation(0.45);
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void init() throws Exception {
        this.loadDefaultValues();
    }

    public void reinit() throws Exception {
        this.init();
    }

    private void loadDefaultValues() {
        BuildActivityWizardState buildActivityWizardState = (BuildActivityWizardState)this.getparentWizardState();
        DataSourceState dataSourceState = (DataSourceState)buildActivityWizardState.getStep(ActivityStepType.DATA_STEP);
        Table table = dataSourceState.getCaseTable();
        this._dsTree.setExcludeCaseTable(table.getSchema(), table.getName());
        try {
            this._dsTree.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._model = new RelatedSourceModel();
        TableSorter tableSorter = new TableSorter(this._model);
        this._table.setModel(tableSorter);
        tableSorter.setTableHeader(this._table.getTableHeader());
        this.m_state.setDataSource(this._model);
    }

    public void btnAdd_actionPerformed() {
        JTree jTree = this._dsTree.getTreeComponent();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        RelatedSourceModel relatedSourceModel = this.m_state.getDataSource();
        TreePath treePath = jTree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode3.getParent();
        if (!(defaultMutableTreeNode3.getUserObject() instanceof DataSourceTree.TableNode)) {
            return;
        }
        TreePath[] treePathArray = jTree.getSelectionPaths();
        final Vector<Table> vector = new Vector<Table>();
        Vector<DefaultMutableTreeNode> vector2 = new Vector<DefaultMutableTreeNode>();
        int n = treePathArray.length;
        for (int i = 0; i < n; ++i) {
            defaultMutableTreeNode3 = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            DataSourceTree.TableNode tableNode = (DataSourceTree.TableNode)defaultMutableTreeNode3.getUserObject();
            Table table = tableNode.getTable();
            vector.add(table);
            vector2.add(defaultMutableTreeNode3);
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                TableColumnsDataSource tableColumnsDataSource = null;
                Connection connection = null;
                try {
                    if (RelatedDataSourcePanel.this._progress.hasUserCancelled()) {
                        return;
                    }
                    connection = DM4JConnectionManager.getDbConnection();
                    for (int i = 0; i < vector.size(); ++i) {
                        if (RelatedDataSourcePanel.this._progress.hasUserCancelled()) {
                            break;
                        }
                        Table table = (Table)vector.get(i);
                        RelatedDataSourcePanel.this._progress.updateProgress("Geting Table Details", "Table: " + table.getFullName() + " (" + (i + 1) + " of " + vector.size() + ")");
                        LinkedHashMap linkedHashMap = table.getColumns();
                        if (linkedHashMap.size() != 0) continue;
                        BuildActivityWizardState buildActivityWizardState = (BuildActivityWizardState)RelatedDataSourcePanel.this.getparentWizardState();
                        DataSourceState dataSourceState = (DataSourceState)buildActivityWizardState.getStep(ActivityStepType.DATA_STEP);
                        Table table2 = dataSourceState.getCaseTable();
                        tableColumnsDataSource = new TableColumnsDataSource(connection, table, table2);
                        tableColumnsDataSource.setAutoclose(false);
                        tableColumnsDataSource.run();
                        table.setRelationship(RelationshipType.getRelationship(1));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                RelatedDataSourcePanel.this._progress.setDoneStatus();
            }
        };
        this._progress = new ProgressBar(this._table, "Getting Table Details", runnable, true);
        this._progress.start("Getting Table Details", "");
        if (!this._progress.hasUserCancelled()) {
            relatedSourceModel.addTables(vector);
            for (DefaultMutableTreeNode defaultMutableTreeNode3 : vector2) {
                defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode3);
            }
            this.m_state.invalidateDataUsageState();
            if (this.getState() == StepStateType.VALIDATED) {
                this.m_state.setState(StepStateType.DIRTY);
            }
        }
    }

    public void btnDeselect_actionPerformed() {
        Vector vector = this._table.getSelectedIndexes();
        RelatedSourceModel relatedSourceModel = this.m_state.getDataSource();
        if (vector.isEmpty()) {
            return;
        }
        Vector<Table> vector2 = new Vector<Table>();
        for (Integer n : vector) {
            Table table = relatedSourceModel.getTable(n);
            vector2.add(table);
        }
        try {
            this._dsTree.addItems(vector2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        relatedSourceModel.removeTables(vector);
        vector2.clear();
        vector.clear();
        this.m_state.invalidateDataUsageState();
        if (this.getState() == StepStateType.VALIDATED) {
            this.m_state.setState(StepStateType.DIRTY);
        }
    }
}

