/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.steps;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.wizard.state.ModelState;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;

public class ModelPanel
extends DM4JStep {
    ModelState m_state;
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    MultiLineLabel mlblAIDescription = new MultiLineLabel();
    MultiLineLabel mlblARDescription = new MultiLineLabel();
    MultiLineLabel mlblClassificationDescription = new MultiLineLabel();
    MultiLineLabel mlblRegressionDescription = new MultiLineLabel();
    MultiLineLabel mlblFeatureDescription = new MultiLineLabel();
    MultiLineLabel mlblClusteringDescription = new MultiLineLabel();
    private JLabel lblFunctionTypeChoice = new JLabel();
    private JComboBox cboFunctionTypeChoice = new JComboBox();
    private DefaultComboBoxModel functionTypeChoiceModel = null;
    private JLabel lblAlgorithmTypeChoice = new JLabel();
    private JComboBox cboAlgorithmTypeChoice = new JComboBox();
    private DefaultComboBoxModel algorithmTypeChoiceModel = null;
    private JLabel lblDescription = new JLabel();
    MultiLineLabel m_descTxt = new MultiLineLabel();
    String BUILD_MODEL_CLASS_DESC = "In a classification problem, you have a number of cases (examples) and wish to predict which of several classes each case belongs to. Each case has multiple attributes; each attribute takes on one of several possible values. The attributes consist of multiple predictor attributes (independent variables) and one target attribute (dependent variable). Each of the target attribute's possible values is a class to be predicted on the basis of that case's predictor attribute values.";
    String BUILD_MODEL_REGRESSION_DESC = "Regression models are predictive models. The difference between regression and classification is that regression has numerical or continuous target attributes, whereas classification deals with discrete or categorical target attributes.";
    String BUILD_MODEL_FEATURE_DESC = "Feature Extraction creates a new set of features by decomposing the original data. A feature is a combination of attributes in the data that is of special interest and captures important characteristics of the data. Feature extraction lets you describe the data with a number of features far smaller than the number of original dimensions (attributes).";
    String BUILD_MODEL_ANOMALY_DESC = "Standard binary supervised classification algorithms require the presence of both positive and negative examples (counterexamples) of a target class. Anomaly Detection requires only the presence of examples of a single target class. In outlier detection, typical examples in a distribution are separated from the atypical (outlier) examples.";
    String BUILD_MODEL_AR_DESC = "Association models are often used to perform \"market basket analysis\" to discover relationships or correlations among a set of items. Such models are widely used in data analysis for direct marketing, catalog design, and other business decision-making processes.";
    String BUILD_MODEL_CLUST_DESC = "Clustering models uncover natural groupings (clusters) in the data. Members of the same cluster are more like (\"closer to\") each other than they are like members of a different cluster. Clustering can be a useful data-preprocessing step to identify homogeneous groups on which to build predictive models.";
    String BUILD_MODEL_AI_DESC = "Attribute Importance ranks the predictive attributes by eliminating redundant, irrelevant, or uninformative attributes and identifying those predictor attributes that may have the most influence in making predictions.";
    private boolean m_ignoreFunctionTypeComboEvent = false;
    private boolean m_ignoreAlgorithmTypeComboEvent = false;
    private static String comboItemAI = null;
    private static String comboItemAR = null;
    private static String comboItemCls = null;
    private static String comboItemRegr = null;
    private static String comboItemFeature = null;
    private static String comboItemClust = null;
    private static String comboItemSVMOneClass = null;
    private static String comboItemAlgoOCluster = null;
    private static String comboItemAlgoKMeans = null;
    private static String comboItemAlgoNB = null;
    private static String comboItemAlgoABN = null;
    private static String comboItemAlgoDT = null;
    private static String comboItemAlgoClsSVM = null;
    private static String comboItemAlgoRegSVM = null;
    private static String comboItemAlgoClsGLM = null;
    private static String comboItemAlgoRegGLM = null;
    private static String comboItemAlgoOneSVM = null;
    private static String comboItemAlgoApriori = null;
    private static String comboItemAlgoNMF = null;
    private static String comboItemAlgoMDL = null;
    private Vector m_modelTypes = new Vector();
    private Vector m_modelAlgorithms = new Vector();

    public ModelPanel(ModelState modelState) throws Exception {
        super(modelState);
        this.m_state = modelState;
        this.setState();
        this.jbInit();
    }

    private void setState() throws Exception {
    }

    private void jbInit() throws Exception {
        int n = 0;
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getActivityBundleInstance();
        comboItemAI = DM4JResourceUtilities.getActivityUIString("BUILD_MODEL_AI");
        comboItemAR = DM4JResourceUtilities.getActivityUIString("BUILD_MODEL_AR");
        comboItemCls = DM4JResourceUtilities.getActivityUIString("BUILD_MODEL_CLASS");
        comboItemClust = DM4JResourceUtilities.getActivityUIString("BUILD_MODEL_CLUST");
        comboItemFeature = DM4JResourceUtilities.getActivityUIString("BUILD_MODEL_FEATURE");
        comboItemRegr = DM4JResourceUtilities.getActivityUIString("BUILD_MODEL_REGRESSION");
        comboItemSVMOneClass = DM4JResourceUtilities.getActivityUIString("BUILD_MODEL_ANOMALY");
        comboItemAlgoOCluster = DM4JResourceUtilities.getActivityUIString("BUILD_CLUST_OCLUSTER_ALGORITHM");
        comboItemAlgoKMeans = DM4JResourceUtilities.getActivityUIString("BUILD_CLUST_KMEANS_ALGORITHM");
        comboItemAlgoNB = DM4JResourceUtilities.getActivityUIString("BUILD_CLASS_NB_ALGORITHM");
        comboItemAlgoABN = DM4JResourceUtilities.getActivityUIString("BUILD_CLASS_ABN_ALGORITHM");
        comboItemAlgoDT = DM4JResourceUtilities.getActivityUIString("BUILD_CLASS_DT_ALGORITHM");
        comboItemAlgoRegSVM = DM4JResourceUtilities.getActivityUIString("BUILD_CLASS_SVM_ALGORITHM");
        comboItemAlgoClsSVM = DM4JResourceUtilities.getActivityUIString("BUILD_CLASS_SVM_ALGORITHM");
        comboItemAlgoRegGLM = DM4JResourceUtilities.getActivityUIString("BUILD_CLASS_GLMR_ALGORITHM");
        comboItemAlgoClsGLM = DM4JResourceUtilities.getActivityUIString("BUILD_CLASS_GLM_ALGORITHM");
        comboItemAlgoApriori = DM4JResourceUtilities.getActivityUIString("BUILD_MODEL_AR_ALGORITHM");
        comboItemAlgoNMF = DM4JResourceUtilities.getActivityUIString("BUILD_MODEL_FEATURE_ALGORITHM");
        comboItemAlgoMDL = DM4JResourceUtilities.getActivityUIString("BUILD_MODEL_AI_ALGORITHM");
        comboItemAlgoOneSVM = DM4JResourceUtilities.getActivityUIString("BUILD_MODEL_ANOMALY_ALGORITHM");
        this.mlblStepDescription.setText(DM4JResourceUtilities.getActivityUIString("BUILD_MODEL_CHOOSE_TYPE"));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent((JComponent)this.mlblStepDescription, TOP_DESC, n++, 0, 2, 1, 1);
        this.lblFunctionTypeChoice.setText("Function Type:");
        this.addComponent(this.lblFunctionTypeChoice, COL1_LABEL, n, 0);
        this.cboFunctionTypeChoice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ModelPanel.this.cboFunctionTypeChoice_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this.cboFunctionTypeChoice, COL_VALUE, n++, 1);
        this.lblAlgorithmTypeChoice.setText("Algorithm:");
        this.addComponent(this.lblAlgorithmTypeChoice, COL1_LABEL, n, 0);
        this.cboAlgorithmTypeChoice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ModelPanel.this.cboAlgorithmTypeChoice_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this.cboAlgorithmTypeChoice, COL_VALUE, n++, 1);
        this.lblDescription.setText("Description:");
        this.addComponent(this.lblDescription, COL1_LABEL, n, 0);
        JScrollPane jScrollPane = new JScrollPane();
        this.m_descTxt.setTextWrapper(WordWrapper.getTextWrapper());
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.m_descTxt.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        jScrollPane.getViewport().add((Component)this.m_descTxt, null);
        this.addFilledComponent(jScrollPane, COL_VALUE, n++, 1, 2, 2, 1);
    }

    protected void processUserInput() {
        if (this.m_state != null) {
            // empty if block
        }
    }

    public void init() throws Exception {
        this.loadDefaultValues();
    }

    public void reinit() throws Exception {
        this.init();
    }

    protected void loadDefaultValues() throws Exception {
        if (this.m_state != null) {
            this.loadFunctionTypeChoiceCombo();
            this.loadAlgorithmTypeChoiceCombo(comboItemCls);
            this.m_ignoreAlgorithmTypeComboEvent = true;
            this.cboAlgorithmTypeChoice.setSelectedItem(comboItemAlgoDT);
            this.m_ignoreAlgorithmTypeComboEvent = false;
        }
    }

    private String loadAlgorithmTypeChoiceCombo(String string) {
        this.m_ignoreAlgorithmTypeComboEvent = true;
        this.m_modelAlgorithms.clear();
        String string2 = null;
        if (string.equals(comboItemAI)) {
            this.m_modelAlgorithms.add(comboItemAlgoMDL);
            string2 = comboItemAlgoMDL;
        } else if (string.equals(comboItemAR)) {
            this.m_modelAlgorithms.add(comboItemAlgoApriori);
            string2 = comboItemAlgoApriori;
        } else if (string.equals(comboItemCls)) {
            if (!BrowserFrame.is11Server()) {
                this.m_modelAlgorithms.add(comboItemAlgoABN);
            }
            this.m_modelAlgorithms.add(comboItemAlgoDT);
            this.m_modelAlgorithms.add(comboItemAlgoNB);
            this.m_modelAlgorithms.add(comboItemAlgoClsSVM);
            if (BrowserFrame.is11Server()) {
                this.m_modelAlgorithms.add(comboItemAlgoClsGLM);
            }
            string2 = comboItemAlgoDT;
        } else if (string.equals(comboItemClust)) {
            this.m_modelAlgorithms.add(comboItemAlgoKMeans);
            this.m_modelAlgorithms.add(comboItemAlgoOCluster);
            string2 = comboItemAlgoKMeans;
        } else if (string.equals(comboItemFeature)) {
            this.m_modelAlgorithms.add(comboItemAlgoNMF);
            string2 = comboItemAlgoNMF;
        } else if (string.equals(comboItemRegr)) {
            this.m_modelAlgorithms.add(comboItemAlgoRegSVM);
            if (BrowserFrame.is11Server()) {
                this.m_modelAlgorithms.add(comboItemAlgoRegGLM);
            }
            string2 = comboItemAlgoRegSVM;
        } else if (string.equals(comboItemSVMOneClass)) {
            this.m_modelAlgorithms.add(comboItemAlgoOneSVM);
            string2 = comboItemAlgoOneSVM;
        }
        this.algorithmTypeChoiceModel = new DefaultComboBoxModel(this.m_modelAlgorithms);
        this.setActivityType(this.convertAlgorithmToActivityType(string, string2));
        this.cboAlgorithmTypeChoice.setModel(this.algorithmTypeChoiceModel);
        this.m_ignoreAlgorithmTypeComboEvent = false;
        return string2;
    }

    private void loadFunctionTypeChoiceCombo() {
        this.m_ignoreFunctionTypeComboEvent = true;
        this.m_modelTypes.add(comboItemSVMOneClass);
        this.m_modelTypes.add(comboItemAR);
        this.m_modelTypes.add(comboItemAI);
        this.m_modelTypes.add(comboItemCls);
        this.m_modelTypes.add(comboItemClust);
        this.m_modelTypes.add(comboItemFeature);
        this.m_modelTypes.add(comboItemRegr);
        this.functionTypeChoiceModel = new DefaultComboBoxModel(this.m_modelTypes);
        this.functionTypeChoiceModel.setSelectedItem(comboItemCls);
        this.cboFunctionTypeChoice.setModel(this.functionTypeChoiceModel);
        this.m_ignoreFunctionTypeComboEvent = false;
    }

    private void cboFunctionTypeChoice_actionPerformed(ActionEvent actionEvent) {
        if (this.m_ignoreFunctionTypeComboEvent) {
            return;
        }
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        String string = (String)jComboBox.getSelectedItem();
        String string2 = this.loadAlgorithmTypeChoiceCombo(string);
        this.cboAlgorithmTypeChoice.setSelectedItem(string2);
    }

    private void cboAlgorithmTypeChoice_actionPerformed(ActionEvent actionEvent) {
        if (this.m_ignoreAlgorithmTypeComboEvent) {
            return;
        }
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        String string = (String)jComboBox.getSelectedItem();
        String string2 = (String)this.cboFunctionTypeChoice.getSelectedItem();
        this.setActivityType(this.convertAlgorithmToActivityType(string2, string));
    }

    private ActivityType convertAlgorithmToActivityType(String string, String string2) {
        ActivityType activityType = null;
        if (string2.equals(comboItemAlgoMDL)) {
            activityType = ActivityType.ATTRIBUTE_IMPORTANCE;
        } else if (string2.equals(comboItemAlgoApriori)) {
            activityType = ActivityType.ASSOCIATION_RULES;
        } else if (string2.equals(comboItemAlgoABN)) {
            activityType = ActivityType.ADAPTIVE_NAIVE_BAYES;
        } else if (string2.equals(comboItemAlgoDT)) {
            activityType = ActivityType.DECISION_TREE;
        } else if (string2.equals(comboItemAlgoNB)) {
            activityType = ActivityType.NAIVE_BAYES;
        } else if (string2.equals(comboItemAlgoClsSVM) && string.equals(comboItemCls)) {
            activityType = ActivityType.SVM_CLASSIFICATION;
        } else if (string2.equals(comboItemAlgoClsGLM) && string.equals(comboItemCls)) {
            activityType = ActivityType.GLM_CLASSIFICATION;
        } else if (string2.equals(comboItemAlgoOCluster)) {
            activityType = ActivityType.O_CLUSTER;
        } else if (string2.equals(comboItemAlgoKMeans)) {
            activityType = ActivityType.K_MEANS_CLUSTER;
        } else if (string2.equals(comboItemAlgoNMF)) {
            activityType = ActivityType.NON_NEGATIVE_MATIX_FACTORIZATION;
        } else if (string2.equals(comboItemAlgoRegSVM) && string.equals(comboItemRegr)) {
            activityType = ActivityType.SVM_REGRESSION;
        } else if (string2.equals(comboItemAlgoRegGLM) && string.equals(comboItemRegr)) {
            activityType = ActivityType.GLM_REGRESSION;
        } else if (string2.equals(comboItemAlgoOneSVM)) {
            activityType = ActivityType.SVM_SINGLE_CLASS;
        }
        return activityType;
    }

    private void setActivityType(ActivityType activityType) {
        this.m_state.setActivityType(activityType);
        String string = this.getActivityDescription(activityType);
        this.m_descTxt.setText(string);
    }

    private String getActivityDescription(ActivityType activityType) {
        if (activityType == ActivityType.ATTRIBUTE_IMPORTANCE) {
            return "Attribute Importance function:\n\n  - Select most important attributes for classification\n\nMinimum Description Length Algorithm:\n\nUsage:\n\n" + this.BUILD_MODEL_AI_DESC + "\n";
        }
        if (activityType == ActivityType.ASSOCIATION_RULES) {
            return "Association Rules function:\n\n  - Discover relationships among items\n\nApriori algorithm:\n\n  - Supports sparse transactional data\n\nUsage:\n\n" + this.BUILD_MODEL_AR_DESC + "\n";
        }
        if (activityType == ActivityType.DECISION_TREE) {
            return "Classification function:\n\n  - Predict class membership for categorical target\n\nDecision Tree algorithm:\n\n  - Used when you need explicit rules explaining predictions\n\nUsage:\n\n" + this.BUILD_MODEL_CLASS_DESC + "\n";
        }
        if (activityType == ActivityType.NAIVE_BAYES) {
            return "Classification function:\n\n  - Predict class membership for categorical target\n\nNaive Bayes algorithm:\n\n  - Fast build using Bayes Theorem\n\nUsage:\n\n" + this.BUILD_MODEL_CLASS_DESC + "\n";
        }
        if (activityType == ActivityType.ADAPTIVE_NAIVE_BAYES) {
            return "Classification function:\n\n  - Predict class membership for categorical target\n\nAdaptive Bayes algorithm:\n\n  - Fast scalable build with optional rules\n\nUsage:\n\n" + this.BUILD_MODEL_CLASS_DESC + "\n";
        }
        if (activityType == ActivityType.SVM_CLASSIFICATION) {
            return "Classification function:\n\n  - Predict class membership for categorical target\n\nSupport Vector Machine algorithm:\n\n  - Maximum prediction accuracy that avoids overfit\n  - Supports sparse transactional data\n  - Supports text data\n\nUsage:\n\n" + this.BUILD_MODEL_CLASS_DESC + "\n";
        }
        if (activityType == ActivityType.GLM_CLASSIFICATION) {
            return "Classification function:\n\n  - Predict class membership for categorical target.\n\nLogistic Regression algorithm:\n\n  - A popular statistical technique for classification that provides many informative diagnostics\n  - Supports confidence bounds for probabilities\n  - Supports sparse transactional data\n\nUsage:\n\n" + this.BUILD_MODEL_CLASS_DESC + "\n";
        }
        if (activityType == ActivityType.SVM_REGRESSION) {
            return "Regression function:\n\n  - Predict value of numeric target.\n\nSupport Vector Machine algorithm:\n\n  - Maximum prediction accuracy that avoids overfit\n  - Supports sparse transactional data\n  - Supports text data\n\nUsage:\n\n" + this.BUILD_MODEL_REGRESSION_DESC + "\n";
        }
        if (activityType == ActivityType.GLM_REGRESSION) {
            return "Regression function:\n\n  - Predict value of numeric target\n\nMultivariate Linear Regression algorithm:\n\n  - A popular statistical technique for regression that provides many informative diagnostics\n  - Supports confidence bounds for predictions\n  - Supports sparse transactional data\n\nUsage:\n\n" + this.BUILD_MODEL_REGRESSION_DESC + "\n";
        }
        if (activityType == ActivityType.NON_NEGATIVE_MATIX_FACTORIZATION) {
            return "Feature Extraction function:\n\n  - Create features describing data\n\nNon-Negative Matrix Factorization algorithm:\n\n  - Supports sparse transactional data\n  - Supports text data\n\nUsage:\n\n" + this.BUILD_MODEL_FEATURE_DESC + "\n";
        }
        if (activityType == ActivityType.SVM_SINGLE_CLASS) {
            return "Anomaly Detection function:\n\n  - Identify a set of counter examples\n  - Detect outliers\n\nOne-Class Support Vector Machine algorithm:\n\n  - Maximum prediction accuracy that avoids overfit\n  - Supports sparse transactional data\n  - Supports text data\n\nUsage:\n\n" + this.BUILD_MODEL_ANOMALY_DESC + "\n";
        }
        if (activityType == ActivityType.O_CLUSTER) {
            return "Clustering function:\n\n  - Find natural groupings in the data\n\nOCluster algorithm:\n\n  - Hierarchical, grid-based clustering\n  - Handles large datasources\n\nUsage:\n\n" + this.BUILD_MODEL_CLUST_DESC + "\n";
        }
        if (activityType == ActivityType.K_MEANS_CLUSTER) {
            return "Clustering function:\n\n  - Find natural groupings in the data.\n\nKMeans algorithm:\n\n  - Distance based clustering with a specified number of clusters\n  - Supports sparse transactional data\n  - Supports text data\n  - Handles small datasources\n\nUsage:\n\n" + this.BUILD_MODEL_CLUST_DESC + "\n";
        }
        return null;
    }
}

