/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.steps;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JOptionPane;
import oracle.bali.ewt.grid.hGrid.HArrayTwoDModel;
import oracle.bali.ewt.grid.hGrid.HDataObject;
import oracle.bali.ewt.table.SpreadTable;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.Mapping;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.wizard.state.BuildActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.state.DataSourceState;
import oracle.dmt.dm4j.activity.wizard.state.DataUsageState;
import oracle.dmt.dm4j.activity.wizard.steps.ActivityStepType;
import oracle.dmt.dm4j.activity.wizard.steps.ValidationException;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.datasources.CDSStatsDataSource;
import oracle.dmt.dm4j.wizard.state.StepStateType;

public class DataUsageTableModel
extends HArrayTwoDModel {
    private Vector _tables;
    private ActivityType _activityType;
    private DataUsageState _dataUsagePageState;
    public static int NAME_COLUMN = 0;
    public static int ALIAS_COLUMN = 1;
    public static int TARGET_COLUMN = 2;
    public static int INPUT_COLUMN = 3;
    public static int DATA_TYPE_COLUMN = 4;
    public static int MINING_TYPE_COLUMN = 5;
    public static int SPARSITY_COLUMN = 6;
    public static int COLUMN_COUNT = 7;
    private int _targetRowIndex = -1;
    private Table _targetTable = null;
    private Column _targetColumn = null;
    private int _textRowIndex = -1;
    private Table _textTable = null;
    private Column _textColumn = null;
    private Column _uniqueIdentifier = null;
    private Table _caseTable = null;
    private CDSStatsDataSource _statsDs;
    private int _numCategoricalCutoff;
    private int _maxDistinctCategoricalCutoff;
    private int _maxCatBins;
    private float _percentUniqueThresholdCat;
    private float _percentUniqueCutoff;
    private double _sparsityCutoff;
    private boolean _isHistogramDataDirty = false;
    private int _sparseAttrCount = 0;
    private ArrayList _aliasCache;

    public DataUsageTableModel(int n, Vector vector, CDSStatsDataSource cDSStatsDataSource, ActivityType activityType, DataUsageState dataUsageState) {
        super(COLUMN_COUNT, n);
        this._tables = vector;
        this._aliasCache = new ArrayList();
        this._activityType = activityType;
        this._dataUsagePageState = dataUsageState;
        this._statsDs = cDSStatsDataSource;
        UserPreferences userPreferences = UserPreferences.getInstance();
        this._numCategoricalCutoff = userPreferences.getCutoffForNumberForCategorical();
        this._maxCatBins = userPreferences.getMaxCategoricalBin();
        this._percentUniqueThresholdCat = userPreferences.getPercentUniqueThresholdCategorical();
        this._sparsityCutoff = userPreferences.getSparsityCutoff();
        this._percentUniqueCutoff = userPreferences.getUniquePercentage();
        this._maxDistinctCategoricalCutoff = userPreferences.getMaxDistinctCategoricalCutoff();
        BuildActivityWizardState buildActivityWizardState = (BuildActivityWizardState)this._dataUsagePageState.getparentWizardState();
        DataSourceState dataSourceState = (DataSourceState)buildActivityWizardState.getStep(ActivityStepType.DATA_STEP);
        this._uniqueIdentifier = dataSourceState.getUniqueIdentifier();
        this._caseTable = dataSourceState.getCaseTable();
    }

    public boolean isHistogramDataDirty() {
        return this._isHistogramDataDirty;
    }

    public void setHistogramDataDirty(boolean bl) {
        this._isHistogramDataDirty = bl;
    }

    public boolean getSparseInputsExist() {
        return this._sparseAttrCount > 0;
    }

    public Column getTargetColumn() {
        return this._targetColumn;
    }

    public Table getTargetTable() {
        return this._targetTable;
    }

    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    public Column getColumnAtIndex(int n) {
        HDataObject hDataObject = (HDataObject)this.getExpandedData(0, n);
        Object object = hDataObject.getData();
        if (object instanceof Column) {
            Column column = (Column)hDataObject.getData();
            return column;
        }
        return null;
    }

    public boolean isOptionalCategoricalAtIndex(int n) {
        Column column = this.getColumnAtIndex(n);
        return ActivityUtils.isNumericDataType(column.getDataType());
    }

    public boolean isOptionalTextDataTypeAtIndex(int n, ActivityType activityType) {
        Column column = this.getColumnAtIndex(n);
        if (BrowserFrame.isDisabledTextMining()) {
            return false;
        }
        if (activityType.equals(ActivityType.ATTRIBUTE_IMPORTANCE) || activityType.equals(ActivityType.DECISION_TREE) || activityType.equals(ActivityType.NAIVE_BAYES) || activityType.equals(ActivityType.ADAPTIVE_NAIVE_BAYES) || activityType.equals(ActivityType.O_CLUSTER) || activityType.equals(ActivityType.GLM_CLASSIFICATION) || activityType.equals(ActivityType.GLM_REGRESSION)) {
            return false;
        }
        return column.getDataType().equals("CHAR") || column.getDataType().equals("VARCHAR2");
    }

    public Table getTableAtIndex(int n) {
        HDataObject hDataObject = (HDataObject)this.getExpandedData(0, n);
        Table table = (Table)hDataObject.getData();
        return table;
    }

    public void load() throws Exception {
        this.populate(this._tables);
    }

    private void populate(Vector vector) throws Exception {
        Iterator iterator = vector.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            n = this.addTable(table, n);
        }
    }

    public void updateStatistics(CDSStatsDataSource cDSStatsDataSource) {
        this._statsDs = cDSStatsDataSource;
        int n = this.getExpandedRowCount();
        for (int i = 0; i < n; ++i) {
            Column column = this.getColumnAtIndex(i);
            if (column == null) continue;
            this._aliasCache.set(i, column.getAlias());
        }
    }

    private int addTable(Table table, int n) throws Exception {
        Object object;
        Object object2;
        int n2;
        Object object3;
        this.addTableRowData(table, n);
        int n3 = n + 1;
        LinkedHashMap linkedHashMap = table.getColumns();
        if (table.isTransactionalRelationship()) {
            object3 = table.getTxnMappings();
            for (n2 = 0; n2 < ((ArrayList)object3).size(); ++n2) {
                object2 = (Mapping)((ArrayList)object3).get(n2);
                if (!((Column)object2).getIsVisible()) continue;
                this.addMappingRowData((Mapping)object2, n3++, n);
            }
        } else {
            object3 = linkedHashMap.entrySet().iterator();
            n2 = n + 1;
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                object = (Column)object2.getValue();
                if (!((Column)object).getIsVisible()) continue;
                this.addColumnRowData((Column)object, n2++, n);
            }
        }
        if (this._textColumn != null) {
            int n4 = this.getRowCount();
            for (n2 = 0; n2 < n4; ++n2) {
                Mapping mapping;
                object2 = (HDataObject)this.getExpandedData(NAME_COLUMN, n2);
                object = object2.getData();
                if (!(object instanceof Mapping) || (mapping = (Mapping)object) != this._textColumn) continue;
                this._textRowIndex = n2;
            }
        }
        return n;
    }

    private void addTableRowData(Table table, int n) {
        this.addRootRows(n, 1);
        this._aliasCache.add(new Boolean(true));
        this.setExpandedData(NAME_COLUMN, n, table);
        this.setExpandedData(ALIAS_COLUMN, n, "");
        this.setExpandedData(TARGET_COLUMN, n, "");
        this.setExpandedData(INPUT_COLUMN, n, "");
        this.setExpandedData(DATA_TYPE_COLUMN, n, "");
        this.setExpandedData(MINING_TYPE_COLUMN, n, "");
        this.setExpandedData(SPARSITY_COLUMN, n, "");
        this.expandExpandedRow(n);
    }

    private void addColumnRowData(Column column, int n, int n2) {
        Table table = this.getTableAtIndex(n2);
        this.applyHeuristics(column, table);
        if (column.getIsVisible()) {
            this.addRowsAtDepth(n, 1, 1, n2);
            this._aliasCache.add(column.getAlias());
            this.setExpandedData(NAME_COLUMN, n, column);
            this.setExpandedData(ALIAS_COLUMN, n, column.getAlias());
            this.setExpandedData(TARGET_COLUMN, n, column.getIsTarget());
            this.setExpandedData(INPUT_COLUMN, n, column.getIsInput());
            this.setExpandedData(DATA_TYPE_COLUMN, n, column.getDataType());
            this.setExpandedData(MINING_TYPE_COLUMN, n, column.getMiningType());
            this.setExpandedData(SPARSITY_COLUMN, n, column.getIsSparse());
            if (column.getIsSparse()) {
                ++this._sparseAttrCount;
            }
        }
        this.expandExpandedRow(n2);
    }

    private void addMappingRowData(Mapping mapping, int n, int n2) {
        Table table = this.getTableAtIndex(n2);
        this.applyHeuristics(mapping, table);
        if (mapping.getIsVisible()) {
            this.addRowsAtDepth(n, 1, 1, n2);
            this._aliasCache.add(mapping.getAlias());
            this.setExpandedData(NAME_COLUMN, n, mapping);
            this.setExpandedData(ALIAS_COLUMN, n, mapping.getAlias());
            this.setExpandedData(TARGET_COLUMN, n, "");
            this.setExpandedData(INPUT_COLUMN, n, mapping.getIsInput());
            this.setExpandedData(DATA_TYPE_COLUMN, n, mapping.getValueColumn().getDataType());
            this.setExpandedData(MINING_TYPE_COLUMN, n, mapping.getValueColumn().getMiningType());
            this.setExpandedData(SPARSITY_COLUMN, n, mapping.getIsSparse());
            if (mapping.getMiningType().equals("text") && mapping.getIsInput()) {
                this._textColumn = mapping;
                this._textTable = table;
            }
            if (mapping.getIsSparse()) {
                ++this._sparseAttrCount;
            }
        }
        this.expandExpandedRow(n2);
    }

    private void applyHeuristics(Column column, Table table) {
        try {
            String string = column.getAlias();
            if (column instanceof Mapping) {
                return;
            }
            if (column.getMiningType().equals("text")) {
                column.setIsSparse(true);
                column.setIsInput(false);
                return;
            }
            if (column.getDataType().equals("DM_NESTED_CATEGORICALS") || column.getDataType().equals("DM_NESTED_NUMERICALS")) {
                column.setIsInput(false);
                column.setIsSparse(true);
                return;
            }
            if (column.getDataType().equals("DATE")) {
                column.setIsInput(false);
                column.setIsSparse(false);
                return;
            }
            if (this._uniqueIdentifier != null && column.getName().equals(this._uniqueIdentifier.getName()) && table.equals(this._caseTable)) {
                column.setIsInput(false);
                return;
            }
            int n = this._statsDs.getAttributeTotalCount(string);
            int n2 = this._statsDs.getAttributeDistinctCount(string);
            int n3 = this._statsDs.getAttributeNullCount(string);
            boolean bl = this._statsDs.isFloat(string);
            if (n == 0) {
                column.setIsInput(false);
                if (n3 > 1) {
                    column.setIsSparse(true);
                }
            } else {
                boolean bl2;
                float f = n != 0 ? (float)n3 / (float)n : 0.0f;
                boolean bl3 = (double)f > this._sparsityCutoff;
                boolean bl4 = n3 == n;
                boolean bl5 = n2 == 1;
                float f2 = n != 0 ? (float)n2 / (float)n : 0.0f;
                boolean bl6 = f2 > this._percentUniqueCutoff && !bl;
                column.setIsSparse(bl3);
                boolean bl7 = true;
                if (bl4 || bl5 || bl6) {
                    bl7 = false;
                }
                if (ActivityUtils.isDecisionTree(this._activityType) && ActivityUtils.isNestedDataType(column.getDataType())) {
                    bl7 = false;
                }
                if ((this._activityType.equals(ActivityType.ADAPTIVE_NAIVE_BAYES) || this._activityType.equals(ActivityType.NAIVE_BAYES) || this._activityType.equals(ActivityType.ATTRIBUTE_IMPORTANCE) || this._activityType.equals(ActivityType.O_CLUSTER) || this._activityType.equals(ActivityType.DECISION_TREE)) && bl3) {
                    bl7 = false;
                }
                if (column.getDataType().equals("notApplicable")) {
                    bl7 = false;
                }
                if ((bl2 = ActivityUtils.isNumericDataType(column.getDataType())) && n2 <= this._numCategoricalCutoff && !bl) {
                    column.setMiningType("categorical");
                }
                if (column.getMiningType().equals("categorical")) {
                    if (n2 > this._maxDistinctCategoricalCutoff) {
                        bl7 = false;
                    } else if (f2 > this._percentUniqueThresholdCat) {
                        bl7 = false;
                    }
                }
                column.setIsInput(bl7);
            }
            if (column.getIsInput() && column.getIsSparse()) {
                ++this._sparseAttrCount;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String setAliasAtIndex(int n, String string) {
        boolean bl = false;
        Column column = this.getColumnAtIndex(n);
        int n2 = this.getRowCount();
        for (int i = 0; i < n2; ++i) {
            Column column2 = this.getColumnAtIndex(i);
            if (column2 == null || column2 == column || !column2.getAlias().equals(string)) continue;
            bl = true;
        }
        if (!bl) {
            column.setAlias(string);
        } else {
            JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getActivityUIString("DATA_USAGE_ALIAS_CONFLICT"), DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
        }
        return column.getAlias();
    }

    public void setMiningTypeAtIndex(int n, String string) {
        int n2;
        boolean bl = false;
        Column column = this.getColumnAtIndex(n);
        Table table = this.getTableAtIndex(this.getParentRow(n));
        if (column.getMiningType().equals(string)) {
            return;
        }
        this.setHistogramDataDirty(true);
        if (column.getIsInput()) {
            if ((column.getMiningType().equals("text") || string.equals("text")) && !string.equals(column.getMiningType())) {
                bl = true;
            }
            if (column.getMiningType().equals("text") && !string.equals("text")) {
                this.setTextColumn(null, n);
            }
            if (string.equals("text")) {
                if (this.getTextColumn() != null) {
                    JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getActivityUIString("DATA_USAGE_ONLY_1TEXT"), DM4JVersion.getFullBrowserName(), -1, 2, null, null, null);
                    n2 = this.getTextIndex();
                    Column column2 = this.getColumnAtIndex(n2);
                    column2.setIsInput(false);
                    this.setExpandedData(INPUT_COLUMN, n2, false);
                }
                this.setTextColumn(column, n);
            }
        }
        if (string.equals("text")) {
            column.setIsSparse(true);
            this.setExpandedData(SPARSITY_COLUMN, n, true);
        } else if (column.getMiningType().equals("text")) {
            column.setMiningType(string);
            n2 = column.getIsInput();
            this.applyHeuristics(column, table);
            this.setExpandedData(SPARSITY_COLUMN, n, column.getIsSparse());
            column.setIsInput(n2 != 0);
        }
        column.setMiningType(string);
        if (bl) {
            this._dataUsagePageState.setState(StepStateType.DIRTY);
        }
    }

    public void setTargetAtIndex(int n) {
        Column column = this.getColumnAtIndex(n);
        if (this.getTargetIndex() != -1) {
            this.clearTargetSelectionAtIndex(this.getTargetIndex());
        }
        this.setTargetColumn(column, n);
        if ((column.getMiningType().equals("text") || column.getIsSparse()) && !column.getIsInput()) {
            this._dataUsagePageState.setState(StepStateType.DIRTY);
        }
    }

    public boolean setSparseAtIndex(int n, Boolean bl) {
        boolean bl2 = false;
        Column column = this.getColumnAtIndex(n);
        if (column instanceof Mapping) {
            if (!ActivityUtils.isHandlesSparse(this._activityType) && bl.booleanValue()) {
                JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getActivityUIString("RELATED_TABLES_NO_SPARSE_ALLOWED"), DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
            } else {
                column.setIsSparse(bl);
            }
        } else if (column instanceof Column) {
            if (column.getMiningType().equals("text") && column.getIsSparse()) {
                JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getActivityUIString("DATA_USAGE_TEXT_ALWAYS_SPARSE"), DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
            } else {
                column.setIsSparse(bl);
            }
        }
        if (column.getIsInput() || column.getIsTarget()) {
            this._sparseAttrCount = column.getIsSparse() ? ++this._sparseAttrCount : --this._sparseAttrCount;
            bl2 = true;
        }
        if (bl2) {
            this._dataUsagePageState.setState(StepStateType.DIRTY);
        }
        return column.getIsSparse();
    }

    public void setInputAtIndex(int n, Boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        Column column = this.getColumnAtIndex(n);
        column.setIsInput(bl);
        if (column.getMiningType().equals("text")) {
            if (column.getIsInput()) {
                if (this.getTextColumn() == null) {
                    this.setTextColumn(column, n);
                } else {
                    int n2 = this.getTextIndex();
                    Column column2 = this.getColumnAtIndex(n2);
                    if (column2 != column) {
                        column2.setIsInput(false);
                        this.setExpandedData(INPUT_COLUMN, n2, false);
                    }
                    this.setTextColumn(column, n);
                }
            } else {
                this.setTextColumn(null, -1);
            }
            bl3 = true;
        }
        if (column.getIsSparse()) {
            this._sparseAttrCount = column.getIsInput() ? ++this._sparseAttrCount : --this._sparseAttrCount;
            bl2 = true;
        }
        if (bl3 || bl2) {
            this._dataUsagePageState.setState(StepStateType.DIRTY);
        }
    }

    private void setTextColumn(Column column, int n) {
        this._textColumn = column;
        this._textRowIndex = n;
        if (n > 0) {
            int n2 = this.getParentRow(n);
            this._textTable = this.getTableAtIndex(n2);
        }
    }

    public void clearTargetSelectionAtIndex(int n) {
        Boolean bl = (Boolean)this.getExpandedData(INPUT_COLUMN, n);
        if (bl.booleanValue()) {
            this._targetColumn.setIsInput(bl);
        }
        this._targetColumn.setIsTarget(false);
        this._targetTable = null;
        this._targetColumn = null;
        this._targetRowIndex = -1;
        this.setExpandedData(TARGET_COLUMN, n, false);
    }

    private void setTargetColumn(Column column, int n) {
        int n2 = this.getParentRow(n);
        this._targetTable = this.getTableAtIndex(n2);
        this._targetColumn = column;
        this._targetRowIndex = n;
        this._targetColumn.setIsTarget(true);
        this.setExpandedData(TARGET_COLUMN, n, true);
    }

    public Vector validateTarget(int n) {
        Table table = this.getTableAtIndex(this.getParentRow(n));
        Column column = this.getColumnAtIndex(n);
        Vector<ValidationException> vector = new Vector<ValidationException>();
        ValidationException validationException = this.validateTargetDataType(this._activityType, column, table);
        if (validationException != null) {
            vector.add(validationException);
            return vector;
        }
        validationException = null;
        try {
            validationException = this.validateTargetStats(column, this._activityType);
            if (validationException != null) {
                vector.add(validationException);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return vector;
    }

    private ValidationException validateTargetStats(Column column, ActivityType activityType) throws Exception {
        boolean bl;
        String string = column.getAlias();
        int n = this._statsDs.getAttributeTotalCount(string);
        int n2 = this._statsDs.getAttributeDistinctCount(string);
        int n3 = this._statsDs.getAttributeNullCount(string);
        boolean bl2 = this._statsDs.isFloat(string);
        boolean bl3 = n3 == n;
        float f = n != 0 ? (float)n2 / (float)n : 0.0f;
        boolean bl4 = bl = (double)f > 0.99 && !bl2;
        if (activityType == ActivityType.SVM_SINGLE_CLASS && n2 != 1) {
            return new ValidationException(DM4JResourceUtilities.getActivityUIString("DATA_USAGE_TARGET_NOT_SINGLE_VALUE"), 0);
        }
        if (activityType == ActivityType.GLM_CLASSIFICATION && n2 > 2) {
            return new ValidationException(DM4JResourceUtilities.getActivityUIString("DATA_USAGE_TARGET_NOT_BINARY"), 0);
        }
        if (bl3) {
            return new ValidationException(DM4JResourceUtilities.getActivityUIString("DATA_USAGE_TARGET_IS_NULL"), 0);
        }
        if (activityType != ActivityType.SVM_SINGLE_CLASS && n2 < 2) {
            return new ValidationException(DM4JResourceUtilities.getActivityUIString("DATA_USAGE_TARGET_POSSIBLE_FEW_VALUES"), 1);
        }
        if (ActivityUtils.isClassificationType(activityType) && bl) {
            return new ValidationException(DM4JResourceUtilities.getActivityUIString("DATA_USAGE_TARGET_IS_UNIQUE"), 1);
        }
        return null;
    }

    private ValidationException validateTargetDataType(ActivityType activityType, Column column, Table table) {
        String string = column.getDataType();
        String string2 = column.getMiningType();
        if (this._uniqueIdentifier != null && column.getName().equals(this._uniqueIdentifier.getName()) && table.equals(this._caseTable)) {
            return new ValidationException(DM4JResourceUtilities.getActivityUIString("DATA_USAGE_TARGET_IS_UNIQUE_ID"), 0);
        }
        if (ActivityUtils.isRegressionType(activityType)) {
            if (!ActivityUtils.isNumericDataType(string)) {
                return new ValidationException(DM4JResourceUtilities.getActivityUIString("DATA_USAGE_RTARGET_NOT_NUMBER"), 0);
            }
            if (!string2.equals("numerical")) {
                return new ValidationException(DM4JResourceUtilities.getActivityUIString("DATA_USAGE_RTARGET_NOT_NUMERICAL"), 0);
            }
        } else if (ActivityUtils.isClassificationType(activityType)) {
            if (!(string.equals("VARCHAR2") || string.equals("CHAR") || ActivityUtils.isNumericDataType(string))) {
                return new ValidationException(DM4JResourceUtilities.getActivityUIString("DATA_USAGE_CTARGET_BAD_DATATYPE"), 0);
            }
            if (!string2.equals("categorical")) {
                return new ValidationException(DM4JResourceUtilities.getActivityUIString("DATA_USAGE_CTARGET_NOT_CATEGORICAL"), 0);
            }
        } else if (ActivityUtils.isAttributeImportance(activityType) && !ActivityUtils.isStandardTargetDataType(string)) {
            return new ValidationException(DM4JResourceUtilities.getActivityUIString("DATA_USAGE_AITARGET_BAD_DATATYPE"), 0);
        }
        return null;
    }

    public void inputSelectionAll(boolean bl, SpreadTable spreadTable) {
        Vector vector = new Vector();
        int n = this.getExpandedRowCount();
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            Column column = this.getColumnAtIndex(i);
            bl2 = false;
            if (column == null) continue;
            if (bl) {
                vector = this.validateInput(i);
                if (!vector.isEmpty()) {
                    vector.clear();
                    bl2 = true;
                }
                if (bl2) continue;
                this.setInputAtIndex(i, bl);
                this.setExpandedData(INPUT_COLUMN, i, bl);
                continue;
            }
            this.setInputAtIndex(i, bl);
            this.setExpandedData(INPUT_COLUMN, i, bl);
        }
    }

    public Vector validateAlias(String string) {
        Vector<ValidationException> vector = new Vector<ValidationException>();
        if (string.length() > 30) {
            vector.add(new ValidationException(DM4JResourceUtilities.getActivityUIString("DATA_USAGE_ALIAS_TOOLONG") + 30, 0));
            return vector;
        }
        if (string.length() == 0) {
            vector.add(new ValidationException(DM4JResourceUtilities.getActivityUIString("DATA_USAGE_ALIAS_NULL"), 0));
            return vector;
        }
        return vector;
    }

    public Vector validateInput(int n) {
        int n2 = this.getParentRow(n);
        Table table = this.getTableAtIndex(n2);
        Column column = this.getColumnAtIndex(n);
        Vector<ValidationException> vector = new Vector<ValidationException>();
        ValidationException validationException = this.validateInput(column, table, this._activityType);
        if (validationException != null) {
            vector.add(validationException);
        }
        return vector;
    }

    private ValidationException validateInput(Column column, Table table, ActivityType activityType) {
        String string = column.getDataType();
        if (this._uniqueIdentifier != null && column.getName().equals(this._uniqueIdentifier.getName()) && table.equals(this._caseTable)) {
            return new ValidationException(DM4JResourceUtilities.getActivityUIString("DATA_USAGE_INPUT_IS_UNIQUE"), 0);
        }
        if (ActivityUtils.isNestedDataType(string)) {
            return new ValidationException(DM4JResourceUtilities.getActivityUIString("DATA_USAGE_INPUT_IS_NESTED"), 0);
        }
        if (!ActivityUtils.isStandardInputDataType(string) && !ActivityUtils.isTextDataType(string)) {
            return new ValidationException(DM4JResourceUtilities.getActivityUIString("DATA_USAGE_INPUT_BAD_DATATYPE"), 0);
        }
        if (ActivityUtils.isDecisionTree(activityType) && column.getMiningType().equals("text")) {
            return new ValidationException(DM4JResourceUtilities.getActivityUIString("DATA_USAGE_DTINPUT_IS_TEXT"), 0);
        }
        if (column.getMiningType().equals("text") && this._uniqueIdentifier != null && !ActivityUtils.isIntegerDataType(this._uniqueIdentifier.getDataType())) {
            return new ValidationException(DM4JResourceUtilities.getActivityUIString("DATA_USAGE_UID_NOT_NUMBER") + DM4JResourceUtilities.getActivityUIString("CASE_TABLE_UID") + this._uniqueIdentifier.getName() + "\n" + DM4JResourceUtilities.getActivityUIString("CASE_TABLE_UID_DATATYPE") + this._uniqueIdentifier.getDataType(), 0);
        }
        try {
            if (this._statsDs.getAttributeDistinctCount(column.getAlias()) < 1) {
                return new ValidationException(DM4JResourceUtilities.getActivityUIString("DATA_USAGE_INPUT_IS_ALL_NULL"), 1);
            }
            if (this._statsDs.getAttributeDistinctCount(column.getAlias()) == 1) {
                return new ValidationException(DM4JResourceUtilities.getActivityUIString("DATA_USAGE_INPUT_IS_CONSTANT"), 1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private int getTextIndex() {
        return this._textRowIndex;
    }

    public Column getTextColumn() {
        return this._textColumn;
    }

    public Table getTextTable() {
        return this._textTable;
    }

    public int getTargetIndex() {
        return this._targetRowIndex;
    }

    public Vector getTables() {
        return this._tables;
    }
}

