/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.steps;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JSimpleDialogPanel;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.activity.resource.ActivityBundle;
import oracle.dmt.dm4j.activity.wizard.state.DataSourceState;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.UserPreferences;

public class DataSourceSamplingPanel
extends GriddedPanel
implements DM4JSimpleDialogPanel {
    private NumberTextField _edtSampleSize = new NumberTextField();
    private JRadioButton _btnRandom = new JRadioButton();
    private JRadioButton _btnTopN = new JRadioButton();
    private int _samplingType;
    private int _samplingSize;

    public DataSourceSamplingPanel(int n, int n2) {
        try {
            this._samplingSize = n2;
            this._samplingType = n;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        ActivityBundle activityBundle = (ActivityBundle)BrowserUtils.getActivityBundleInstance();
        int n = 0;
        JLabel jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.wrapInHTML(DM4JResourceUtilities.getActivityUIString("CASE_SAMPLE_SETNGS_INTRO")));
        this.addFilledComponent(jLabel, INSTRUCTIONALLABELITEMINSETS, n++, 0, 3, 1, 2);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(DM4JResourceUtilities.wrapInHTML(DM4JResourceUtilities.getActivityUIString("CASE_SAMPLE_TYPE")));
        this.addFilledComponent(jLabel2, TOPLABELITEMINSETS, n++, 0, 3, 1, 2);
        this._btnRandom.setText(DM4JResourceUtilities.getActivityUIString("CASE_SAMPLE_RANDOM"));
        this._btnRandom.setMnemonic(DM4JResourceUtilities.getUIMnemonic(activityBundle, "CASE_SAMPLE_RANDOM"));
        if (DataSourceState.isRandomSampling(this._samplingType)) {
            this._btnRandom.setSelected(true);
        }
        this._btnRandom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataSourceSamplingPanel.this._samplingType = 0;
            }
        });
        this.addFilledComponent(this._btnRandom, MIDINDENTEDLABELITEMINSETS, n++, 0, 3, 1, 0);
        this._btnTopN.setText(DM4JResourceUtilities.getActivityUIString("CASE_SAMPLE_TOPN"));
        this._btnTopN.setMnemonic(DM4JResourceUtilities.getUIMnemonic(activityBundle, "CASE_SAMPLE_TOPN"));
        if (!DataSourceState.isRandomSampling(this._samplingType)) {
            this._btnTopN.setSelected(true);
        }
        this._btnTopN.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataSourceSamplingPanel.this._samplingType = 1;
            }
        });
        this.addFilledComponent(this._btnTopN, MIDINDENTEDLABELITEMINSETS, n++, 0, 3, 1, 0);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._btnRandom);
        buttonGroup.add(this._btnTopN);
        this._edtSampleSize.setDataType(Integer.TYPE);
        this._edtSampleSize.setSigned(false);
        this._edtSampleSize.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_TIP_POSITIVE_INTEGER"));
        this._edtSampleSize.setMinimumSize(new Dimension(100, (int)this._edtSampleSize.getPreferredSize().getHeight()));
        JLabel jLabel3 = new JLabel();
        DM4JResourceUtilities.configureUILabel(jLabel3, "CASE_SAMPLE_SIZE", (Component)this._edtSampleSize, activityBundle);
        this.addFilledComponent(jLabel3, MIDEDITLABELITEMINSETS, n, 0, 1, 1, 1);
        this.addFilledComponent((JComponent)this._edtSampleSize, MIDEDITVALUEITEMINSETS, n++, 1, 1, 1, 2);
        this.addFilledComponent(new JLabel(""), TOPLABELITEMINSETS, n++, 0, 3, 2, 1);
        this._edtSampleSize.setNumber((Number)new Integer(this._samplingSize));
        this._edtSampleSize.setColumns(7);
    }

    public boolean doValidation() {
        Object object;
        int n = -1;
        try {
            object = (Integer)this._edtSampleSize.getNumber();
            if (object != null) {
                n = (Integer)object;
            }
            if (n < 0) {
                throw new Exception("Negative, or blank values not allowed");
            }
            this._samplingSize = n;
        }
        catch (Exception exception) {
            String string = DM4JResourceUtilities.getUIString("PREF_ERROR_NUM_VAL_REQ");
            JOptionPane.showMessageDialog(this, string, DM4JVersion.getFullBrowserName(), 0);
            this._edtSampleSize.setNumber((Number)new Integer(this._samplingSize));
            return false;
        }
        if (n < UserPreferences.getMinimumSampleSize()) {
            object = DM4JResourceUtilities.getUIString("PREF_ERROR_SAMPLE_TOOSMALL") + " " + UserPreferences.getMinimumSampleSize();
            JOptionPane.showMessageDialog(this, object, DM4JVersion.getFullBrowserName(), 0);
            this._edtSampleSize.setNumber((Number)new Integer(this._samplingSize));
            return false;
        }
        return true;
    }

    public void setSamplingType(int n) {
        this._samplingType = n;
    }

    public int getSamplingType() {
        return this._samplingType;
    }

    public void setSamplingSize(int n) {
        this._samplingSize = n;
    }

    public int getSamplingSize() {
        return this._samplingSize;
    }
}

