/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.steps;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import oracle.bali.ewt.grid.BooleanInputHandler;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.CheckPainter;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.header.HeaderKeyHandler;
import oracle.bali.ewt.header.StandardHeaderKeyHandler;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.StringComparator;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JSimpleDialog;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.resource.ActivityBundle;
import oracle.dmt.dm4j.activity.wizard.BuildActivityWizard;
import oracle.dmt.dm4j.activity.wizard.state.BuildActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.state.DataSourceState;
import oracle.dmt.dm4j.activity.wizard.steps.DataSourceSamplingPanel;
import oracle.dmt.dm4j.activity.wizard.steps.RelatedDataSourcePage;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.HyperlinkButton;
import oracle.dmt.dm4j.datasources.TableColumnsDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.commonsteps.MultiRecordCaseData;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;
import oracle.dmt.dm4j.wizard.table.ComponentSpreadTable;
import oracle.dmt.dm4j.wizard.table.SortInputHandler;

public class DataSourcePanel
extends DM4JStep {
    DataSourceState m_state;
    MultiRecordCaseData m_mrcState;
    String m_panelDescriptionResourceKey;
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblSchemaName = new JLabel();
    JLabel lblSchemaNameValue = new JLabel();
    JLabel lblTableName = new JLabel();
    JLabel lblCaseId = new JLabel();
    JLabel lblTableNameValue = new JLabel();
    JComboBox _comboSchema = new JComboBox();
    DefaultComboBoxModel _schemaModel;
    JComboBox _comboTable = new JComboBox();
    JComboBox _comboCaseId = new JComboBox();
    JRadioButton _btnCaseId = new JRadioButton();
    JRadioButton _btnAutoCaseId = new JRadioButton();
    JCheckBox _relatedTables = new JCheckBox();
    DefaultComboBoxModel _tableModel;
    JLabel lblTableTitle = new JLabel();
    JScrollPane spreadScroll = new JScrollPane();
    ComponentSpreadTable spreadTable = new ComponentSpreadTable(null);
    MultiLineLabel mlblFormatDescription = new MultiLineLabel();
    JRadioButton optMRCFormatYes = new JRadioButton();
    JRadioButton optMRCFormatNo = new JRadioButton();
    ButtonGroup groupMRCFormat = new ButtonGroup();
    JButton butFormatDetails = new JButton();
    private JButton butSelectAll = new JButton();
    private JButton butExcludeAll = new JButton();
    boolean m_ignoreSchemaComboEvent = false;
    boolean m_ignoreTableComboEvent = false;

    public DataSourcePanel(DataSourceState dataSourceState, String string) throws Exception {
        super(dataSourceState);
        this.m_state = dataSourceState;
        this.m_panelDescriptionResourceKey = string;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        if (this.m_panelDescriptionResourceKey != null) {
            this.mlblStepDescription.setText(ResourceUtilities.getUILabel(this.m_panelDescriptionResourceKey));
            this.mlblStepDescription.setPreferredRows(3);
            this.mlblStepDescription.setMinimumRows(3);
            this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
            this.addFilledComponent((JComponent)this.mlblStepDescription, TOP_DESC, n++, 0, 4, 1, 1);
        }
        this.lblSchemaName.setText(ResourceUtilities.getUILabel("SCHEMA_NAME"));
        this.lblSchemaName.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("SCHEMA_NAME"));
        this.lblSchemaName.setLabelFor(this._comboSchema);
        this.addComponent(this.lblSchemaName, COL1_LABEL, n, 0, 1, 1);
        this._comboSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataSourcePanel.this.comboSchema_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this._comboSchema, COL_VALUE, n++, 1, 3, 1, 2);
        this.lblTableName.setText(ResourceUtilities.getUILabel("TABLE_NAME"));
        this.lblTableName.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("TABLE_NAME"));
        this.lblTableName.setLabelFor(this._comboTable);
        this.addComponent(this.lblTableName, COL1_LABEL, n, 0, 1, 1);
        this._comboTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataSourcePanel.this.comboTable_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this._comboTable, COL_VALUE, n++, 1, 3, 1, 2);
        ActivityBundle activityBundle = (ActivityBundle)BrowserUtils.getActivityBundleInstance();
        if (this.m_state.getparentWizardState() instanceof BuildActivityWizardState) {
            this._relatedTables.setText(DM4JResourceUtilities.getActivityUIString("CASE_TABLE_JOIN"));
            this._relatedTables.setMnemonic(DM4JResourceUtilities.getUIMnemonic(activityBundle, "CASE_TABLE_JOIN"));
            this._relatedTables.setSelected(false);
            this._relatedTables.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    BuildActivityWizard buildActivityWizard = (BuildActivityWizard)DataSourcePanel.this.m_state.getparentWizardState().getWizard();
                    RelatedDataSourcePage relatedDataSourcePage = buildActivityWizard.getRelatedDataSourcePage();
                    relatedDataSourcePage.setVisible(jCheckBox.isSelected());
                    relatedDataSourcePage.setEnabled(jCheckBox.isSelected());
                    DataSourcePanel.this.m_state.setState(StepStateType.DIRTY);
                }
            });
            this.addFilledComponent(this._relatedTables, COL_VALUE, n++, 1, 3, 1, 2);
        }
        if (this.m_state.getparentWizardState() instanceof BuildActivityWizardState) {
            DM4JResourceUtilities.configureUILabel(this.lblCaseId, "CASE_TABLE_UID", this._btnCaseId, activityBundle);
            this._btnCaseId.setText(DM4JResourceUtilities.getActivityUIString("CASE_TABLE_SINGLE_KEY"));
            this._btnCaseId.setMnemonic(DM4JResourceUtilities.getUIMnemonic(activityBundle, "CASE_TABLE_SINGLE_KEY"));
            this._btnAutoCaseId.setText(DM4JResourceUtilities.getActivityUIString("CASE_TABLE_NO_KEY"));
            this._btnAutoCaseId.setMnemonic(DM4JResourceUtilities.getUIMnemonic(activityBundle, "CASE_TABLE_NO_KEY"));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this._btnCaseId);
            buttonGroup.add(this._btnAutoCaseId);
            this._btnCaseId.setSelected(true);
            this._btnCaseId.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataSourcePanel.this._comboCaseId.setEnabled(true);
                    Object object = DataSourcePanel.this._comboCaseId.getSelectedItem();
                    if (object instanceof Column) {
                        DataSourcePanel.this.m_state.setUniqueIdentifier((Column)object);
                    }
                    DataSourcePanel.this.m_state.setUsingUniqueIdentifier(true);
                    DataSourcePanel.this.m_state.setState(StepStateType.DIRTY);
                }
            });
            this._btnAutoCaseId.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataSourcePanel.this._comboCaseId.setEnabled(false);
                    DataSourcePanel.this.m_state.setUniqueIdentifier(null);
                    DataSourcePanel.this.m_state.setUsingUniqueIdentifier(false);
                    DataSourcePanel.this.m_state.setState(StepStateType.DIRTY);
                }
            });
            this._comboCaseId.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataSourcePanel.this.comboCaseId_actionPerformed(actionEvent);
                    DataSourcePanel.this.m_state.setState(StepStateType.DIRTY);
                }
            });
            this.addComponent(this.lblCaseId, COL1_LABEL, n, 0, 1, 1);
            this.addComponent(this._btnCaseId, COL_VALUE, n, 1, 1, 1, 17, 0);
            this.addWeightedComponent(this._comboCaseId, COL_VALUE, n++, 2, 2, 1, 17, 2, 100.0, 0.1);
            this.addFilledComponent(this._btnAutoCaseId, new Insets(1, 12, 0, 0), n++, 1);
            JLabel jLabel = new JLabel();
            jLabel.setText(DM4JResourceUtilities.wrapInHTML(DM4JResourceUtilities.getActivityUIString("CASE_TABLE_NO_KEY_COMMENT")));
            this.addFilledComponent(jLabel, new Insets(0, 30, 10, 0), n++, 1, 3, 1, 2);
            DM4JResourceUtilities.configureUILabel(this.lblTableTitle, "CASE_TABLE_SELECT_COLUMNS", (Component)((Object)this.spreadTable), activityBundle);
            this.addFilledComponent(this.lblTableTitle, COL1_LABEL, n, 0);
            this.spreadScroll.getViewport().add((Component)((Object)this.spreadTable), null);
            this.addFilledComponent(this.spreadScroll, COL_VALUE, n, 1, 3, 5, 1);
            n += 5;
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(2, 5, 0));
            this.addComponent(jPanel, BOTTOM_RELATED_CONTROL, n++, 1, 3, 1, 13, 0);
            HyperlinkButton hyperlinkButton = new HyperlinkButton();
            hyperlinkButton.setText(DM4JResourceUtilities.getActivityUIString("CASE_TABLE_SAMPLE_SETTINGS"));
            jPanel.add(hyperlinkButton);
            hyperlinkButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataSourcePanel.this.sampleSettings_actionPeformed();
                }
            });
            this.butSelectAll.setText(activityBundle.getStringNoMnemonic("DATA_USAGE_SELECT_ALL"));
            this.butSelectAll.setMnemonic(activityBundle.getMnemonic("DATA_USAGE_SELECT_ALL"));
            this.butSelectAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataSourcePanel.this.butSelectAll_actionPerformed(actionEvent);
                }
            });
            jPanel.add(this.butSelectAll);
            this.butExcludeAll.setText(activityBundle.getStringNoMnemonic("DATA_USAGE_UNSELECT_ALL"));
            this.butExcludeAll.setMnemonic(activityBundle.getMnemonic("DATA_USAGE_UNSELECT_ALL"));
            this.butExcludeAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataSourcePanel.this.butExcludeAll_actionPerformed(actionEvent);
                }
            });
            jPanel.add(this.butExcludeAll);
        }
        if (!(this.getparentWizardState() instanceof BuildActivityWizardState)) {
            this.addFilledComponent(new JLabel(""), MIDLABELITEMINSETS, n, 0, 3, 3, 1);
        }
    }

    private void setInputAllOLD(boolean bl) {
        TableColumnsDataSource tableColumnsDataSource = this.m_state.getTableColumnsDataSource();
        int n = tableColumnsDataSource.getRowCount();
        for (int i = 0; i < n; ++i) {
            Column column = tableColumnsDataSource.getColumnAt(i);
            if (ActivityUtils.isNestedDataType(column.getDataType())) continue;
            tableColumnsDataSource.setColumnVisible(i, bl);
        }
        this.m_state.setState(StepStateType.DIRTY);
        this.spreadTable.repaint();
    }

    private void setInputAll(boolean bl) {
        TwoDModel twoDModel = this.spreadTable.getGrid().getModel();
        TableColumnsDataSource tableColumnsDataSource = this.m_state.getTableColumnsDataSource();
        int n = twoDModel.getRowCount();
        Column column = this.m_state.getUniqueIdentifier();
        for (int i = 0; i < n; ++i) {
            Column column2 = tableColumnsDataSource.getColumnAt(i);
            if (ActivityUtils.isNestedDataType(column2.getDataType())) continue;
            if (bl) {
                twoDModel.setData(0, i, (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
                continue;
            }
            if (column != null) {
                if (column.getName().equals(((Column)twoDModel.getData(1, i)).getName())) continue;
                twoDModel.setData(0, i, (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
                continue;
            }
            twoDModel.setData(0, i, (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        this.m_state.setState(StepStateType.DIRTY);
        this.spreadTable.repaint();
    }

    protected void setSpread() throws Exception {
        this.spreadTable.setModels2((TwoDModel)this.m_state.getTableColumnsDataSource(), this.m_state.getTableColumnsDataSource().getColumnDataSource(), null);
        Grid grid = this.spreadTable.getGrid();
        grid.setColumnPainter(0, CheckPainter.getPainter());
        grid.setColumnCellInputHandler(0, (CellInputHandler)new SelectColumnInputHandler());
        Header header = this.spreadTable.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setCanMoveItems(false);
        TableColumnsDataSource tableColumnsDataSource = this.m_state.getTableColumnsDataSource();
        header.setItemInputHandler((HeaderItemInputHandler)new MySortInputHandler(tableColumnsDataSource));
        tableColumnsDataSource.setColumnComparator(0, (Comparator)new StringComparator(Collator.getInstance()));
        tableColumnsDataSource.setColumnComparator(1, (Comparator)new StringComparator(Collator.getInstance()));
        header.setHeaderKeyHandler((HeaderKeyHandler)new KeyHandler());
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
        this.spreadTable.getGrid().setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
        int[] nArray = new int[this.m_state.getTableColumnsDataSource().getColumnCount()];
        nArray[0] = 10;
        nArray[1] = 65;
        nArray[2] = 25;
        this.spreadTable.setColumnWidths(nArray, true);
    }

    protected void butSelectAll_actionPerformed(ActionEvent actionEvent) {
        this.setInputAll(true);
    }

    protected void butExcludeAll_actionPerformed(ActionEvent actionEvent) {
        this.setInputAll(false);
    }

    private void comboSchema_actionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.m_ignoreSchemaComboEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                String string2 = this.m_state.getSelectedSchemaName();
                if (!string2.equals(string)) {
                    this.m_state.setSelectedSchemaName(string);
                    this.loadTableCombo(this);
                    this.m_state.setState(StepStateType.DIRTY);
                }
            }
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
    }

    private void comboCaseId_actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JComboBox) {
            Object object2 = this._comboCaseId.getSelectedItem();
            if (object2 instanceof Column) {
                Column column = (Column)this._comboCaseId.getSelectedItem();
                this.m_state.setUniqueIdentifier(column);
            } else {
                this.m_state.setUniqueIdentifier(null);
            }
            this.m_state.setState(StepStateType.DIRTY);
        }
    }

    private void comboTable_actionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.m_ignoreTableComboEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                String string2 = this.m_state.getSelectedTableName();
                if (!string2.equals(string)) {
                    this.m_state.setSelectedTableName(string);
                    this.m_state.setUniqueIdentifier(null);
                    this.m_state.setState(StepStateType.DIRTY);
                    this.m_state.loadColumnsDataSource(this);
                    this.loadCaseIdCombo();
                    if (this.m_state.getparentWizardState() instanceof BuildActivityWizardState) {
                        this.setSpread();
                    }
                }
            }
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
    }

    public void init() throws Exception {
        this.loadSchemaCombo();
        this.loadTableCombo(null);
        this.loadDefaultValues();
    }

    public void reinit() throws Exception {
        this.init();
    }

    private void loadSchemaCombo() {
        this.m_ignoreSchemaComboEvent = true;
        this._schemaModel = new DefaultComboBoxModel(this.m_state.getSchemaNames());
        this._schemaModel.setSelectedItem(this.m_state.getSelectedSchemaName());
        this._comboSchema.setModel(this._schemaModel);
        this._comboSchema.setSelectedItem(this.m_state.getSelectedSchemaName());
        this.m_ignoreSchemaComboEvent = false;
    }

    private void loadTableCombo(Component component) throws Exception {
        this.m_ignoreTableComboEvent = true;
        this._tableModel = new DefaultComboBoxModel(this.m_state.getTableNames());
        this._tableModel.setSelectedItem(this.m_state.getSelectedTableName());
        this._comboTable.setModel(this._tableModel);
        this._comboTable.setSelectedItem(this.m_state.getSelectedTableName());
        this.m_state.loadColumnsDataSource(component);
        if (this.m_state.getparentWizardState() instanceof BuildActivityWizardState) {
            this.setSpread();
        }
        this.loadCaseIdCombo();
        this.m_ignoreTableComboEvent = false;
    }

    private void loadCaseIdCombo() {
        this._comboCaseId.removeAllItems();
        TableColumnsDataSource tableColumnsDataSource = this.m_state.getTableColumnsDataSource();
        Column column = tableColumnsDataSource.getPrimaryKey();
        if (column == null) {
            this._comboCaseId.addItem(DM4JResourceUtilities.getActivityUIString("COMMON_COMBOSELECT"));
        }
        Table table = tableColumnsDataSource.getTable();
        LinkedHashMap linkedHashMap = table.getColumns();
        Set set = linkedHashMap.entrySet();
        for (Map.Entry entry : set) {
            Column column2 = (Column)entry.getValue();
            this._comboCaseId.addItem(column2);
        }
        if (column != null) {
            this._comboCaseId.setSelectedItem(column);
        }
        this._btnCaseId.setSelected(true);
        this._comboCaseId.setEnabled(true);
    }

    private void loadDefaultValues() {
    }

    private void sampleSettings_actionPeformed() {
        DataSourceSamplingPanel dataSourceSamplingPanel = new DataSourceSamplingPanel(this.m_state.getSamplingType(), this.m_state.getSamplingSize());
        DM4JSimpleDialog dM4JSimpleDialog = new DM4JSimpleDialog((Frame)BrowserFrame.getMainFrame(), (JPanel)dataSourceSamplingPanel, DM4JResourceUtilities.getActivityUIString("CASE_TABLE_SAMPLE_SETTINGS_TITLE"), "dm4j_mining_activity_case_sample_settings_html");
        dM4JSimpleDialog.setVisible(true);
        if (dM4JSimpleDialog.isOk()) {
            if (this.m_state.getSamplingSize() != dataSourceSamplingPanel.getSamplingSize() || this.m_state.getSamplingType() != dataSourceSamplingPanel.getSamplingType()) {
                this.m_state.setState(StepStateType.DIRTY);
            }
            this.m_state.setSamplingSize(dataSourceSamplingPanel.getSamplingSize());
            this.m_state.setSamplingType(dataSourceSamplingPanel.getSamplingType());
        }
    }

    private class MySortInputHandler
    extends SortInputHandler {
        public MySortInputHandler(SortableTwoDModel sortableTwoDModel) {
            super(sortableTwoDModel);
        }

        public void mouseReleased(MouseEvent mouseEvent, Header header, int n) {
            super.mouseReleased(mouseEvent, header, n);
        }
    }

    private class KeyHandler
    extends StandardHeaderKeyHandler {
        private KeyHandler() {
        }

        public void handleKeyEvent(Header header, KeyEvent keyEvent) {
            if (keyEvent.getID() == 402 && keyEvent.getKeyCode() == 32) {
                SortInputHandler sortInputHandler = (SortInputHandler)header.getItemInputHandler();
                sortInputHandler.sort(header.getFocusItem());
            }
            super.handleKeyEvent(header, keyEvent);
        }
    }

    private class SelectColumnInputHandler
    extends BooleanInputHandler {
        private SelectColumnInputHandler() {
        }

        protected Object getNewValue(Grid grid, int n, int n2, Object object) {
            Object object2 = super.getNewValue(grid, n, n2, object);
            Boolean bl = (Boolean)object2;
            TableColumnsDataSource tableColumnsDataSource = DataSourcePanel.this.m_state.getTableColumnsDataSource();
            Column column = tableColumnsDataSource.getColumnAt(n2);
            if (ActivityUtils.isNestedDataType(column.getDataType())) {
                JOptionPane.showOptionDialog(DataSourcePanel.this.getParent(), "Nested Columns are not supported as input data.", DM4JVersion.getFullBrowserName(), -1, 2, null, null, null);
                return object;
            }
            Column column2 = DataSourcePanel.this.m_state.getUniqueIdentifier();
            if (!bl.booleanValue() && column2 != null && column.getName().equals(column2.getName())) {
                JOptionPane.showOptionDialog(DataSourcePanel.this.getParent(), "Case Id Column can not be unselected as input. ", DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
                return object;
            }
            tableColumnsDataSource.setColumnVisible(n2, bl);
            DataSourcePanel.this.m_state.setState(StepStateType.DIRTY);
            return object2;
        }
    }
}

